/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.translator;

import java.math.BigDecimal;
import java.util.stream.Collectors;
import org.apache.calcite.adapter.druid.DruidQuery;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.DateString;
import org.apache.calcite.util.TimeString;
import org.apache.calcite.util.TimestampString;
import org.apache.hadoop.hive.common.type.HiveIntervalDayTime;
import org.apache.hadoop.hive.common.type.HiveIntervalYearMonth;
import org.apache.hadoop.hive.ql.optimizer.calcite.RelOptHiveTable;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveTableScan;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.jdbc.HiveJdbcConverter;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.TypeConverter;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ParseDriver;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ASTBuilder {
    public static final Logger LOGGER = LoggerFactory.getLogger(ASTBuilder.class);
    ASTNode curr;

    public static ASTBuilder construct(int tokenType, String text) {
        ASTBuilder b = new ASTBuilder();
        b.curr = ASTBuilder.createAST(tokenType, text);
        return b;
    }

    public static ASTNode createAST(int tokenType, String text) {
        return (ASTNode)ParseDriver.adaptor.create(tokenType, text);
    }

    public static ASTNode destNode() {
        return ASTBuilder.construct(874, "TOK_DESTINATION").add(ASTBuilder.construct(876, "TOK_DIR").add(1148, "TOK_TMP_FILE")).node();
    }

    public static ASTNode table(RelNode scan) {
        HiveTableScan hts = null;
        hts = scan instanceof HiveJdbcConverter ? ((HiveJdbcConverter)scan).getTableScan().getHiveTableScan() : (scan instanceof DruidQuery ? (HiveTableScan)((DruidQuery)scan).getTableScan() : (HiveTableScan)scan);
        assert (hts != null);
        RelOptHiveTable hTbl = (RelOptHiveTable)hts.getTable();
        ASTBuilder b = ASTBuilder.construct(1137, "TOK_TABREF").add(ASTBuilder.construct(1136, "TOK_TABNAME").add(24, hTbl.getHiveTableMD().getDbName()).add(24, hTbl.getHiveTableMD().getTableName()));
        ASTBuilder propList = ASTBuilder.construct(1123, "TOK_TABLEPROPLIST");
        if (scan instanceof DruidQuery) {
            DruidQuery dq = (DruidQuery)scan;
            propList.add(ASTBuilder.construct(1122, "TOK_TABLEPROPERTY").add(396, "\"druid.query.json\"").add(396, "\"" + SemanticAnalyzer.escapeSQLString(dq.getQueryString()) + "\""));
            propList.add(ASTBuilder.construct(1122, "TOK_TABLEPROPERTY").add(396, "\"druid.fieldNames\"").add(396, "\"" + dq.getRowType().getFieldNames().stream().map(Object::toString).collect(Collectors.joining(",")) + "\""));
            propList.add(ASTBuilder.construct(1122, "TOK_TABLEPROPERTY").add(396, "\"druid.fieldTypes\"").add(396, "\"" + dq.getRowType().getFieldList().stream().map(e -> TypeConverter.convert(e.getType()).getTypeName()).collect(Collectors.joining(",")) + "\""));
            propList.add(ASTBuilder.construct(1122, "TOK_TABLEPROPERTY").add(396, "\"druid.query.type\"").add(396, "\"" + dq.getQueryType().getQueryName() + "\""));
        } else if (scan instanceof HiveJdbcConverter) {
            HiveJdbcConverter jdbcConverter = (HiveJdbcConverter)scan;
            String query = jdbcConverter.generateSql();
            LOGGER.debug("Generated SQL query: " + System.lineSeparator() + query);
            propList.add(ASTBuilder.construct(1122, "TOK_TABLEPROPERTY").add(396, "\"hive.sql.query\"").add(396, "\"" + SemanticAnalyzer.escapeSQLString(query) + "\""));
            propList.add(ASTBuilder.construct(1122, "TOK_TABLEPROPERTY").add(396, "\"hive.sql.query.split\"").add(396, "\"" + jdbcConverter.splittingAllowed() + "\""));
            propList.add(ASTBuilder.construct(1122, "TOK_TABLEPROPERTY").add(396, "\"hive.sql.query.fieldNames\"").add(396, "\"" + scan.getRowType().getFieldNames().stream().map(Object::toString).collect(Collectors.joining(",")) + "\""));
            propList.add(ASTBuilder.construct(1122, "TOK_TABLEPROPERTY").add(396, "\"hive.sql.query.fieldTypes\"").add(396, "\"" + scan.getRowType().getFieldList().stream().map(e -> TypeConverter.convert(e.getType()).getTypeName()).collect(Collectors.joining(",")) + "\""));
        }
        if (hts.isInsideView()) {
            propList.add(ASTBuilder.construct(1122, "TOK_TABLEPROPERTY").add(396, "\"insideView\"").add(396, "\"TRUE\""));
        }
        b.add(ASTBuilder.construct(1121, "TOK_TABLEPROPERTIES").add(propList));
        b.add(24, hts.getTableAlias());
        return b.node();
    }

    public static ASTNode join(ASTNode left, ASTNode right, JoinRelType joinType, ASTNode cond, boolean semiJoin) {
        ASTBuilder b = null;
        switch (joinType) {
            case INNER: {
                if (semiJoin) {
                    b = ASTBuilder.construct(951, "TOK_LEFTSEMIJOIN");
                    break;
                }
                b = ASTBuilder.construct(946, "TOK_JOIN");
                break;
            }
            case LEFT: {
                b = ASTBuilder.construct(950, "TOK_LEFTOUTERJOIN");
                break;
            }
            case RIGHT: {
                b = ASTBuilder.construct(1049, "TOK_RIGHTOUTERJOIN");
                break;
            }
            case FULL: {
                b = ASTBuilder.construct(910, "TOK_FULLOUTERJOIN");
            }
        }
        b.add(left).add(right).add(cond);
        return b.node();
    }

    public static ASTNode subQuery(ASTNode qry, String alias) {
        return ASTBuilder.construct(1100, "TOK_SUBQUERY").add(qry).add(24, alias).node();
    }

    public static ASTNode qualifiedName(String tableName, String colName) {
        ASTBuilder b = ASTBuilder.construct(16, ".").add(ASTBuilder.construct(1133, "TOK_TABLE_OR_COL").add(24, tableName)).add(24, colName);
        return b.node();
    }

    public static ASTNode unqualifiedName(String colName) {
        ASTBuilder b = ASTBuilder.construct(1133, "TOK_TABLE_OR_COL").add(24, colName);
        return b.node();
    }

    public static ASTNode where(ASTNode cond) {
        return ASTBuilder.construct(1177, "TOK_WHERE").add(cond).node();
    }

    public static ASTNode having(ASTNode cond) {
        return ASTBuilder.construct(923, "TOK_HAVING").add(cond).node();
    }

    public static ASTNode limit(Object offset, Object limit) {
        return ASTBuilder.construct(955, "TOK_LIMIT").add(384, offset.toString()).add(384, limit.toString()).node();
    }

    public static ASTNode selectExpr(ASTNode expr, String alias) {
        return ASTBuilder.construct(1058, "TOK_SELEXPR").add(expr).add(24, alias).node();
    }

    public static ASTNode literal(RexLiteral literal) {
        Object val = null;
        int type = 0;
        SqlTypeName sqlType = literal.getType().getSqlTypeName();
        switch (sqlType) {
            case BINARY: 
            case DATE: 
            case TIME: 
            case TIMESTAMP: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: 
            case INTERVAL_DAY: 
            case INTERVAL_DAY_HOUR: 
            case INTERVAL_DAY_MINUTE: 
            case INTERVAL_DAY_SECOND: 
            case INTERVAL_HOUR: 
            case INTERVAL_HOUR_MINUTE: 
            case INTERVAL_HOUR_SECOND: 
            case INTERVAL_MINUTE: 
            case INTERVAL_MINUTE_SECOND: 
            case INTERVAL_MONTH: 
            case INTERVAL_SECOND: 
            case INTERVAL_YEAR: 
            case INTERVAL_YEAR_MONTH: 
            case ROW: 
            case MAP: 
            case ARRAY: {
                if (literal.getValue() != null) break;
                return ASTBuilder.construct(972, "TOK_NULL").node();
            }
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: 
            case DOUBLE: 
            case DECIMAL: 
            case FLOAT: 
            case REAL: 
            case VARCHAR: 
            case CHAR: 
            case BOOLEAN: {
                if (literal.getValue3() != null) break;
                return ASTBuilder.construct(972, "TOK_NULL").node();
            }
        }
        switch (sqlType) {
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: {
                val = literal.getValue3();
                if (val instanceof BigDecimal) {
                    val = ((BigDecimal)val).longValue();
                }
                switch (sqlType) {
                    case TINYINT: {
                        val = val + "Y";
                        break;
                    }
                    case SMALLINT: {
                        val = val + "S";
                        break;
                    }
                    case INTEGER: {
                        val = val + "";
                        break;
                    }
                    case BIGINT: {
                        val = val + "L";
                    }
                }
                type = 25;
                break;
            }
            case DOUBLE: {
                val = literal.getValue3() + "D";
                type = 385;
                break;
            }
            case DECIMAL: {
                val = literal.getValue3() + "BD";
                type = 385;
                break;
            }
            case FLOAT: 
            case REAL: {
                val = literal.getValue3() + "F";
                type = 384;
                break;
            }
            case VARCHAR: 
            case CHAR: {
                val = literal.getValue3();
                String escapedVal = BaseSemanticAnalyzer.escapeSQLString(String.valueOf(val));
                type = 396;
                val = "'" + escapedVal + "'";
                break;
            }
            case BOOLEAN: {
                val = literal.getValue3();
                type = (Boolean)val != false ? 335 : 136;
                break;
            }
            case DATE: {
                val = "'" + ((DateString)literal.getValueAs(DateString.class)).toString() + "'";
                type = 860;
                break;
            }
            case TIME: {
                val = "'" + ((TimeString)literal.getValueAs(TimeString.class)).toString() + "'";
                type = 1144;
                break;
            }
            case TIMESTAMP: {
                val = "'" + ((TimestampString)literal.getValueAs(TimestampString.class)).toString() + "'";
                type = 1144;
                break;
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                val = "'" + ((TimestampString)literal.getValueAs(TimestampString.class)).toString() + " UTC'";
                type = 1146;
                break;
            }
            case INTERVAL_MONTH: 
            case INTERVAL_YEAR: 
            case INTERVAL_YEAR_MONTH: {
                type = 942;
                BigDecimal monthsBd = (BigDecimal)literal.getValue();
                HiveIntervalYearMonth intervalYearMonth = new HiveIntervalYearMonth(monthsBd.intValue());
                val = "'" + intervalYearMonth.toString() + "'";
                break;
            }
            case INTERVAL_DAY: 
            case INTERVAL_DAY_HOUR: 
            case INTERVAL_DAY_MINUTE: 
            case INTERVAL_DAY_SECOND: 
            case INTERVAL_HOUR: 
            case INTERVAL_HOUR_MINUTE: 
            case INTERVAL_HOUR_SECOND: 
            case INTERVAL_MINUTE: 
            case INTERVAL_MINUTE_SECOND: 
            case INTERVAL_SECOND: {
                type = 935;
                BigDecimal millisBd = (BigDecimal)literal.getValue();
                BigDecimal secsBd = millisBd.divide(BigDecimal.valueOf(1000L));
                HiveIntervalDayTime intervalDayTime = new HiveIntervalDayTime(secsBd);
                val = "'" + intervalDayTime.toString() + "'";
                break;
            }
            case NULL: {
                type = 972;
                break;
            }
            default: {
                throw new RuntimeException("Unsupported Type: " + sqlType);
            }
        }
        return (ASTNode)ParseDriver.adaptor.create(type, String.valueOf(val));
    }

    public ASTNode node() {
        return this.curr;
    }

    public ASTBuilder add(int tokenType, String text) {
        ParseDriver.adaptor.addChild((Object)this.curr, (Object)ASTBuilder.createAST(tokenType, text));
        return this;
    }

    public ASTBuilder add(ASTBuilder b) {
        ParseDriver.adaptor.addChild((Object)this.curr, (Object)b.curr);
        return this;
    }

    public ASTBuilder add(ASTNode n) {
        if (n != null) {
            ParseDriver.adaptor.addChild((Object)this.curr, (Object)n);
        }
        return this;
    }
}

