/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.translator;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.Pair;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.optimizer.calcite.CalciteSemanticException;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveCalciteUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveProject;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveValues;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.PlanModifierUtil;

public class PlanModifierForReturnPath {
    public static RelNode convertOpTree(RelNode rel, List<FieldSchema> resultSchema, boolean isCTAS) throws CalciteSemanticException {
        if (rel instanceof HiveValues) {
            return rel;
        }
        if (isCTAS) {
            rel = PlanModifierForReturnPath.introduceProjectIfNeeded(rel, resultSchema);
        }
        RelNode newTopNode = rel;
        Pair<RelNode, RelNode> topSelparentPair = HiveCalciteUtil.getTopLevelSelect(newTopNode);
        PlanModifierUtil.fixTopOBSchema(newTopNode, topSelparentPair, resultSchema, false);
        return newTopNode;
    }

    private static RelNode introduceProjectIfNeeded(RelNode optimizedOptiqPlan, List<FieldSchema> resultSchema) throws CalciteSemanticException {
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (FieldSchema fieldSchema : resultSchema) {
            fieldNames.add(fieldSchema.getName());
        }
        HiveProject newRoot = null;
        List<RexNode> projectList = null;
        if (!(optimizedOptiqPlan instanceof Project)) {
            projectList = HiveCalciteUtil.getProjsFromBelowAsInputRef(optimizedOptiqPlan);
            newRoot = HiveProject.create(optimizedOptiqPlan, projectList, fieldNames);
        } else {
            HiveProject project = (HiveProject)optimizedOptiqPlan;
            newRoot = HiveProject.create(project.getInput(0), project.getChildExps(), fieldNames);
        }
        return newRoot;
    }
}

