/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.translator;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.apache.calcite.avatica.util.TimeUnit;
import org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlBinaryOperator;
import org.apache.calcite.sql.SqlCollation;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlCastFunction;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.util.ConversionUtil;
import org.apache.calcite.util.DateString;
import org.apache.calcite.util.NlsString;
import org.apache.calcite.util.TimestampString;
import org.apache.hadoop.hive.common.type.Date;
import org.apache.hadoop.hive.common.type.Decimal128;
import org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.HiveIntervalDayTime;
import org.apache.hadoop.hive.common.type.HiveIntervalYearMonth;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.common.type.TimestampTZ;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.optimizer.calcite.CalciteSemanticException;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveCalciteUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveExtractDate;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveFloorDate;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveToDateSqlOperator;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.SqlFunctionConverter;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.TypeConverter;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.type.ExprNodeTypeCheck;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDescUtils;
import org.apache.hadoop.hive.ql.plan.ExprNodeFieldDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBaseBinary;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBaseCompare;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBetween;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBridge;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFCase;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFIn;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFTimestamp;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToBinary;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToChar;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToDate;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToDecimal;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToString;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToTimestampLocalTZ;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToUnixTimeStamp;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToVarchar;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFUnixTimeStamp;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFWhen;
import org.apache.hadoop.hive.serde2.objectinspector.ConstantObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;

public class RexNodeConverter {
    private final RexBuilder rexBuilder;
    private final RelDataTypeFactory typeFactory;

    public RexNodeConverter(RexBuilder rexBuilder, RelDataTypeFactory typeFactory) {
        this.rexBuilder = rexBuilder;
        this.typeFactory = typeFactory;
    }

    public RexNode convert(ExprNodeDesc expr) throws SemanticException {
        if (expr instanceof ExprNodeGenericFuncDesc) {
            return this.convert((ExprNodeGenericFuncDesc)expr);
        }
        if (expr instanceof ExprNodeConstantDesc) {
            return this.convert((ExprNodeConstantDesc)expr);
        }
        if (expr instanceof ExprNodeFieldDesc) {
            return this.convert((ExprNodeFieldDesc)expr);
        }
        throw new RuntimeException("Unsupported Expression");
    }

    private RexNode convert(ExprNodeFieldDesc fieldDesc) throws SemanticException {
        RexNode rexNode = this.convert(fieldDesc.getDesc());
        if (rexNode.getType().isStruct()) {
            return this.rexBuilder.makeFieldAccess(rexNode, fieldDesc.getFieldName(), true);
        }
        throw new CalciteSemanticException("Unexpected rexnode : " + rexNode.getClass().getCanonicalName(), CalciteSemanticException.UnsupportedFeature.Schema_less_table);
    }

    private RexNode convert(ExprNodeGenericFuncDesc func) throws SemanticException {
        List<RexNode> childRexNodeLst = new ArrayList<RexNode>();
        ImmutableList.Builder argTypeBldr = ImmutableList.builder();
        TypeInfo tgtDT = null;
        GenericUDF tgtUdf = func.getGenericUDF();
        boolean isNumeric = tgtUdf instanceof GenericUDFBaseBinary && func.getTypeInfo().getCategory() == ObjectInspector.Category.PRIMITIVE && PrimitiveObjectInspectorUtils.PrimitiveGrouping.NUMERIC_GROUP == PrimitiveObjectInspectorUtils.getPrimitiveGrouping(((PrimitiveTypeInfo)func.getTypeInfo()).getPrimitiveCategory());
        boolean isCompare = !isNumeric && tgtUdf instanceof GenericUDFBaseCompare;
        boolean isWhenCase = tgtUdf instanceof GenericUDFWhen || tgtUdf instanceof GenericUDFCase;
        boolean isTransformableTimeStamp = func.getGenericUDF() instanceof GenericUDFUnixTimeStamp && !func.getChildren().isEmpty();
        boolean isBetween = !isNumeric && tgtUdf instanceof GenericUDFBetween;
        boolean isIN = !isNumeric && tgtUdf instanceof GenericUDFIn;
        boolean isAllPrimitive = true;
        if (isNumeric) {
            tgtDT = func.getTypeInfo();
            assert (func.getChildren().size() == 2);
        } else if (isCompare && func.getChildren().size() == 2) {
            tgtDT = FunctionRegistry.getCommonClassForComparison(func.getChildren().get(0).getTypeInfo(), func.getChildren().get(1).getTypeInfo());
        } else if (isWhenCase) {
            if (RexNodeConverter.checkForStatefulFunctions(func.getChildren())) {
                throw new SemanticException("Stateful expressions cannot be used inside of CASE");
            }
        } else if (isTransformableTimeStamp) {
            func = ExprNodeGenericFuncDesc.newInstance(new GenericUDFToUnixTimeStamp(), func.getChildren());
        } else if (isBetween) {
            assert (func.getChildren().size() == 4);
            tgtDT = FunctionRegistry.getCommonClassForComparison(func.getChildren().get(1).getTypeInfo(), FunctionRegistry.getCommonClassForComparison(func.getChildren().get(2).getTypeInfo(), func.getChildren().get(3).getTypeInfo()));
        } else if (isIN) {
            assert (func.getChildren().size() > 1);
            tgtDT = FunctionRegistry.getCommonClassForComparison(func.getChildren().get(0).getTypeInfo(), func.getChildren().get(1).getTypeInfo());
        }
        for (int i = 0; i < func.getChildren().size(); ++i) {
            ExprNodeDesc childExpr;
            ExprNodeDesc tmpExprNode = childExpr = func.getChildren().get(i);
            if (tgtDT != null && tgtDT.getCategory() == ObjectInspector.Category.PRIMITIVE && TypeInfoUtils.isConversionRequiredForComparison(tgtDT, childExpr.getTypeInfo())) {
                if (isCompare || isBetween || isIN) {
                    if (!isBetween || i > 0) {
                        tmpExprNode = (ExprNodeDesc)ExprNodeTypeCheck.getExprNodeDefaultExprProcessor().createConversionCast(childExpr, (PrimitiveTypeInfo)tgtDT);
                    }
                } else if (isNumeric) {
                    PrimitiveTypeInfo minArgType = ExprNodeDescUtils.deriveMinArgumentCast(childExpr, tgtDT);
                    tmpExprNode = (ExprNodeDesc)ExprNodeTypeCheck.getExprNodeDefaultExprProcessor().createConversionCast(childExpr, minArgType);
                } else {
                    throw new AssertionError((Object)("Unexpected " + tgtDT + " - not a numeric op or compare"));
                }
            }
            isAllPrimitive = isAllPrimitive && tmpExprNode.getTypeInfo().getCategory() == ObjectInspector.Category.PRIMITIVE;
            argTypeBldr.add(TypeConverter.convert(tmpExprNode.getTypeInfo(), this.typeFactory));
            RexNode tmpRN = this.convert(tmpExprNode);
            childRexNodeLst.add(tmpRN);
        }
        RelDataType retType = TypeConverter.convert(func.getTypeInfo(), this.typeFactory);
        RexNode expr = RexNodeConverter.handleExplicitCast(func.getGenericUDF(), retType, childRexNodeLst, this.rexBuilder);
        if (expr == null) {
            SqlOperator calciteOp = SqlFunctionConverter.getCalciteOperator(func.getFuncText(), func.getGenericUDF(), (ImmutableList<RelDataType>)argTypeBldr.build(), retType);
            if (calciteOp.getKind() == SqlKind.CASE) {
                childRexNodeLst = RexNodeConverter.rewriteCaseChildren(func.getFuncText(), childRexNodeLst, this.rexBuilder);
                childRexNodeLst = RexNodeConverter.adjustCaseBranchTypes(childRexNodeLst, retType, this.rexBuilder);
            } else if (HiveExtractDate.ALL_FUNCTIONS.contains(calciteOp)) {
                childRexNodeLst = RexNodeConverter.rewriteExtractDateChildren(calciteOp, childRexNodeLst, this.rexBuilder);
            } else if (HiveFloorDate.ALL_FUNCTIONS.contains(calciteOp)) {
                childRexNodeLst = RexNodeConverter.rewriteFloorDateChildren(calciteOp, childRexNodeLst, this.rexBuilder);
            } else if (calciteOp.getKind() == SqlKind.IN && isAllPrimitive) {
                if (childRexNodeLst.size() == 2) {
                    calciteOp = SqlStdOperatorTable.EQUALS;
                } else if (RexUtil.isReferenceOrAccess((RexNode)childRexNodeLst.get(0), (boolean)true)) {
                    childRexNodeLst = RexNodeConverter.rewriteInClauseChildren(calciteOp, childRexNodeLst, this.rexBuilder);
                    calciteOp = SqlStdOperatorTable.OR;
                }
            } else if (calciteOp.getKind() == SqlKind.COALESCE && childRexNodeLst.size() > 1) {
                calciteOp = SqlStdOperatorTable.CASE;
                childRexNodeLst = RexNodeConverter.rewriteCoalesceChildren(childRexNodeLst, this.rexBuilder);
                childRexNodeLst = RexNodeConverter.adjustCaseBranchTypes(childRexNodeLst, retType, this.rexBuilder);
            } else if (calciteOp == HiveToDateSqlOperator.INSTANCE) {
                childRexNodeLst = RexNodeConverter.rewriteToDateChildren(childRexNodeLst, this.rexBuilder);
            } else if (calciteOp.getKind() == SqlKind.BETWEEN) {
                assert (childRexNodeLst.get(0).isAlwaysTrue() || childRexNodeLst.get(0).isAlwaysFalse());
                calciteOp = (childRexNodeLst = RexNodeConverter.rewriteBetweenChildren(childRexNodeLst, this.rexBuilder)).get(0).isAlwaysTrue() ? SqlStdOperatorTable.OR : SqlStdOperatorTable.AND;
            }
            expr = this.rexBuilder.makeCall(retType, calciteOp, childRexNodeLst);
        } else {
            retType = expr.getType();
        }
        if (expr instanceof RexCall && !(((RexCall)expr).getOperator() instanceof SqlCastFunction)) {
            RexCall call = (RexCall)expr;
            expr = this.rexBuilder.makeCall(retType, call.getOperator(), RexUtil.flatten((List)call.getOperands(), (SqlOperator)call.getOperator()));
        }
        return expr;
    }

    private static boolean castExprUsingUDFBridge(GenericUDF gUDF) {
        int sp;
        String udfClassName;
        boolean castExpr = false;
        if (gUDF instanceof GenericUDFBridge && (udfClassName = ((GenericUDFBridge)gUDF).getUdfClassName()) != null && (sp = udfClassName.lastIndexOf(46)) >= 0 & sp + 1 < udfClassName.length() && ((udfClassName = udfClassName.substring(sp + 1)).equals("UDFToBoolean") || udfClassName.equals("UDFToByte") || udfClassName.equals("UDFToDouble") || udfClassName.equals("UDFToInteger") || udfClassName.equals("UDFToLong") || udfClassName.equals("UDFToShort") || udfClassName.equals("UDFToFloat"))) {
            castExpr = true;
        }
        return castExpr;
    }

    public static RexNode handleExplicitCast(GenericUDF udf, RelDataType returnType, List<RexNode> childRexNodeLst, RexBuilder rexBuilder) {
        RexNode castExpr = null;
        if (childRexNodeLst != null && childRexNodeLst.size() == 1 && (udf instanceof GenericUDFToChar || udf instanceof GenericUDFToVarchar || udf instanceof GenericUDFToString || udf instanceof GenericUDFToDecimal || udf instanceof GenericUDFToDate || udf instanceof GenericUDFTimestamp || udf instanceof GenericUDFToTimestampLocalTZ || udf instanceof GenericUDFToBinary || RexNodeConverter.castExprUsingUDFBridge(udf))) {
            castExpr = rexBuilder.makeAbstractCast(returnType, childRexNodeLst.get(0));
        }
        return castExpr;
    }

    public static List<RexNode> rewriteCaseChildren(String funcText, List<RexNode> childRexNodeLst, RexBuilder rexBuilder) throws SemanticException {
        ArrayList<RexNode> newChildRexNodeLst = new ArrayList<RexNode>();
        if (FunctionRegistry.getNormalizedFunctionName(funcText).equals("case")) {
            RexNode firstPred = childRexNodeLst.get(0);
            int length = childRexNodeLst.size() % 2 == 1 ? childRexNodeLst.size() : childRexNodeLst.size() - 1;
            for (int i = 1; i < length; ++i) {
                if (i % 2 == 1) {
                    RexNode node = childRexNodeLst.get(i);
                    if (node.isA(SqlKind.LITERAL) && !node.getType().equals(firstPred.getType())) {
                        node = rexBuilder.makeCast(firstPred.getType(), node);
                    }
                    newChildRexNodeLst.add(rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{firstPred, node}));
                    continue;
                }
                newChildRexNodeLst.add(childRexNodeLst.get(i));
            }
            if (length != childRexNodeLst.size()) {
                newChildRexNodeLst.add(childRexNodeLst.get(childRexNodeLst.size() - 1));
            }
        } else {
            for (int i = 0; i < childRexNodeLst.size(); ++i) {
                RexNode child = childRexNodeLst.get(i);
                if (RexUtil.isNull((RexNode)child)) {
                    if (i % 2 == 0 && i != childRexNodeLst.size() - 1) {
                        if (SqlTypeName.NULL.equals((Object)child.getType().getSqlTypeName())) {
                            child = rexBuilder.makeNullLiteral(rexBuilder.getTypeFactory().createSqlType(SqlTypeName.BOOLEAN));
                        }
                    } else if (!RexUtil.isNull((RexNode)childRexNodeLst.get(1))) {
                        child = rexBuilder.makeCast(childRexNodeLst.get(1).getType(), child);
                    }
                }
                newChildRexNodeLst.add(child);
            }
        }
        if (newChildRexNodeLst.size() % 2 == 0) {
            newChildRexNodeLst.add((RexNode)rexBuilder.makeNullLiteral(((RexNode)newChildRexNodeLst.get(newChildRexNodeLst.size() - 1)).getType()));
        }
        return newChildRexNodeLst;
    }

    public static List<RexNode> adjustCaseBranchTypes(List<RexNode> nodes, RelDataType retType, RexBuilder rexBuilder) {
        ArrayList<RexNode> newNodes = new ArrayList<RexNode>();
        for (int i = 0; i < nodes.size(); ++i) {
            RexNode node = nodes.get(i);
            if (!(i % 2 != 1 && i != nodes.size() - 1 || node.getType().getSqlTypeName().equals((Object)retType.getSqlTypeName()))) {
                newNodes.add(rexBuilder.makeCast(retType, node));
                continue;
            }
            newNodes.add(node);
        }
        return newNodes;
    }

    public static List<RexNode> rewriteExtractDateChildren(SqlOperator op, List<RexNode> childRexNodeLst, RexBuilder rexBuilder) {
        boolean isTimestampLevel;
        ArrayList<RexNode> newChildRexNodeLst = new ArrayList<RexNode>(2);
        if (op == HiveExtractDate.YEAR) {
            newChildRexNodeLst.add((RexNode)rexBuilder.makeFlag((Enum)TimeUnitRange.YEAR));
            isTimestampLevel = false;
        } else if (op == HiveExtractDate.QUARTER) {
            newChildRexNodeLst.add((RexNode)rexBuilder.makeFlag((Enum)TimeUnitRange.QUARTER));
            isTimestampLevel = false;
        } else if (op == HiveExtractDate.MONTH) {
            newChildRexNodeLst.add((RexNode)rexBuilder.makeFlag((Enum)TimeUnitRange.MONTH));
            isTimestampLevel = false;
        } else if (op == HiveExtractDate.WEEK) {
            newChildRexNodeLst.add((RexNode)rexBuilder.makeFlag((Enum)TimeUnitRange.WEEK));
            isTimestampLevel = false;
        } else if (op == HiveExtractDate.DAY) {
            newChildRexNodeLst.add((RexNode)rexBuilder.makeFlag((Enum)TimeUnitRange.DAY));
            isTimestampLevel = false;
        } else if (op == HiveExtractDate.HOUR) {
            newChildRexNodeLst.add((RexNode)rexBuilder.makeFlag((Enum)TimeUnitRange.HOUR));
            isTimestampLevel = true;
        } else if (op == HiveExtractDate.MINUTE) {
            newChildRexNodeLst.add((RexNode)rexBuilder.makeFlag((Enum)TimeUnitRange.MINUTE));
            isTimestampLevel = true;
        } else if (op == HiveExtractDate.SECOND) {
            newChildRexNodeLst.add((RexNode)rexBuilder.makeFlag((Enum)TimeUnitRange.SECOND));
            isTimestampLevel = true;
        } else {
            isTimestampLevel = false;
        }
        RexNode child = Iterables.getOnlyElement(childRexNodeLst);
        if (SqlTypeUtil.isDatetime((RelDataType)child.getType()) || SqlTypeUtil.isInterval((RelDataType)child.getType())) {
            newChildRexNodeLst.add(child);
        } else if (isTimestampLevel) {
            newChildRexNodeLst.add(RexNodeConverter.makeCast(SqlTypeName.TIMESTAMP, child, rexBuilder));
        } else {
            newChildRexNodeLst.add(RexNodeConverter.makeCast(SqlTypeName.DATE, child, rexBuilder));
        }
        return newChildRexNodeLst;
    }

    private static RexNode makeCast(SqlTypeName typeName, RexNode child, RexBuilder rexBuilder) {
        RelDataType sqlType = rexBuilder.getTypeFactory().createSqlType(typeName);
        RelDataType nullableType = rexBuilder.getTypeFactory().createTypeWithNullability(sqlType, true);
        return rexBuilder.makeCast(nullableType, child);
    }

    public static List<RexNode> rewriteFloorDateChildren(SqlOperator op, List<RexNode> childRexNodeLst, RexBuilder rexBuilder) {
        ArrayList<RexNode> newChildRexNodeLst = new ArrayList<RexNode>();
        assert (childRexNodeLst.size() == 1);
        newChildRexNodeLst.add(childRexNodeLst.get(0));
        if (op == HiveFloorDate.YEAR) {
            newChildRexNodeLst.add((RexNode)rexBuilder.makeFlag((Enum)TimeUnitRange.YEAR));
        } else if (op == HiveFloorDate.QUARTER) {
            newChildRexNodeLst.add((RexNode)rexBuilder.makeFlag((Enum)TimeUnitRange.QUARTER));
        } else if (op == HiveFloorDate.MONTH) {
            newChildRexNodeLst.add((RexNode)rexBuilder.makeFlag((Enum)TimeUnitRange.MONTH));
        } else if (op == HiveFloorDate.WEEK) {
            newChildRexNodeLst.add((RexNode)rexBuilder.makeFlag((Enum)TimeUnitRange.WEEK));
        } else if (op == HiveFloorDate.DAY) {
            newChildRexNodeLst.add((RexNode)rexBuilder.makeFlag((Enum)TimeUnitRange.DAY));
        } else if (op == HiveFloorDate.HOUR) {
            newChildRexNodeLst.add((RexNode)rexBuilder.makeFlag((Enum)TimeUnitRange.HOUR));
        } else if (op == HiveFloorDate.MINUTE) {
            newChildRexNodeLst.add((RexNode)rexBuilder.makeFlag((Enum)TimeUnitRange.MINUTE));
        } else if (op == HiveFloorDate.SECOND) {
            newChildRexNodeLst.add((RexNode)rexBuilder.makeFlag((Enum)TimeUnitRange.SECOND));
        }
        return newChildRexNodeLst;
    }

    public static List<RexNode> rewriteToDateChildren(List<RexNode> childRexNodeLst, RexBuilder rexBuilder) {
        ArrayList<RexNode> newChildRexNodeLst = new ArrayList<RexNode>();
        assert (childRexNodeLst.size() == 1);
        RexNode child = childRexNodeLst.get(0);
        if (SqlTypeUtil.isDatetime((RelDataType)child.getType()) || SqlTypeUtil.isInterval((RelDataType)child.getType())) {
            newChildRexNodeLst.add(child);
        } else {
            newChildRexNodeLst.add(RexNodeConverter.makeCast(SqlTypeName.TIMESTAMP, child, rexBuilder));
        }
        return newChildRexNodeLst;
    }

    public static List<RexNode> rewriteInClauseChildren(SqlOperator op, List<RexNode> childRexNodeLst, RexBuilder rexBuilder) throws SemanticException {
        assert (op.getKind() == SqlKind.IN);
        RexNode firstPred = childRexNodeLst.get(0);
        ArrayList<RexNode> newChildRexNodeLst = new ArrayList<RexNode>();
        for (int i = 1; i < childRexNodeLst.size(); ++i) {
            newChildRexNodeLst.add(rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{firstPred, childRexNodeLst.get(i)}));
        }
        return newChildRexNodeLst;
    }

    public static List<RexNode> rewriteCoalesceChildren(List<RexNode> childRexNodeLst, RexBuilder rexBuilder) {
        int i;
        ArrayList<RexNode> convertedChildList = Lists.newArrayList();
        assert (childRexNodeLst.size() > 0);
        for (i = 0; i < childRexNodeLst.size() - 1; ++i) {
            RexNode child = childRexNodeLst.get(i);
            RexNode childCond = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, new RexNode[]{child});
            convertedChildList.add(childCond);
            convertedChildList.add(child);
        }
        convertedChildList.add(childRexNodeLst.get(i));
        return convertedChildList;
    }

    public static List<RexNode> rewriteBetweenChildren(List<RexNode> childRexNodeLst, RexBuilder rexBuilder) {
        ArrayList<RexNode> convertedChildList = Lists.newArrayList();
        SqlBinaryOperator cmpOp = childRexNodeLst.get(0).isAlwaysTrue() ? SqlStdOperatorTable.GREATER_THAN : SqlStdOperatorTable.LESS_THAN_OR_EQUAL;
        RexNode op = childRexNodeLst.get(1);
        RexNode rangeL = childRexNodeLst.get(2);
        RexNode rangeH = childRexNodeLst.get(3);
        convertedChildList.add(rexBuilder.makeCall((SqlOperator)cmpOp, new RexNode[]{rangeL, op}));
        convertedChildList.add(rexBuilder.makeCall((SqlOperator)cmpOp, new RexNode[]{op, rangeH}));
        return convertedChildList;
    }

    private static boolean checkForStatefulFunctions(List<ExprNodeDesc> list) {
        for (ExprNodeDesc node : list) {
            if (!(node instanceof ExprNodeGenericFuncDesc)) continue;
            GenericUDF nodeUDF = ((ExprNodeGenericFuncDesc)node).getGenericUDF();
            if (FunctionRegistry.isStateful(nodeUDF)) {
                return true;
            }
            if (node.getChildren() == null || node.getChildren().isEmpty() || !RexNodeConverter.checkForStatefulFunctions(node.getChildren())) continue;
            return true;
        }
        return false;
    }

    private static NlsString asUnicodeString(String text) {
        return new NlsString(text, ConversionUtil.NATIVE_UTF16_CHARSET_NAME, SqlCollation.IMPLICIT);
    }

    protected RexNode convert(ExprNodeConstantDesc literal) throws CalciteSemanticException {
        RelDataTypeFactory dtFactory = this.rexBuilder.getTypeFactory();
        PrimitiveTypeInfo hiveType = (PrimitiveTypeInfo)literal.getTypeInfo();
        RelDataType calciteDataType = TypeConverter.convert(hiveType, dtFactory);
        PrimitiveObjectInspector.PrimitiveCategory hiveTypeCategory = hiveType.getPrimitiveCategory();
        ConstantObjectInspector coi = literal.getWritableObjectInspector();
        Object value = ObjectInspectorUtils.copyToStandardJavaObject(coi.getWritableConstantValue(), coi);
        RexLiteral calciteLiteral = null;
        if (value == null) {
            hiveTypeCategory = PrimitiveObjectInspector.PrimitiveCategory.VOID;
        }
        switch (hiveTypeCategory) {
            case BOOLEAN: {
                calciteLiteral = this.rexBuilder.makeLiteral(((Boolean)value).booleanValue());
                break;
            }
            case BYTE: {
                calciteLiteral = this.rexBuilder.makeExactLiteral(new BigDecimal(((Byte)value).byteValue()), calciteDataType);
                break;
            }
            case SHORT: {
                calciteLiteral = this.rexBuilder.makeExactLiteral(new BigDecimal(((Short)value).shortValue()), calciteDataType);
                break;
            }
            case INT: {
                calciteLiteral = this.rexBuilder.makeExactLiteral(new BigDecimal((Integer)value));
                break;
            }
            case LONG: {
                calciteLiteral = this.rexBuilder.makeBigintLiteral(new BigDecimal((Long)value));
                break;
            }
            case DECIMAL: {
                if (value instanceof HiveDecimal) {
                    value = ((HiveDecimal)value).bigDecimalValue();
                } else if (value instanceof Decimal128) {
                    value = ((Decimal128)value).toBigDecimal();
                }
                if (value == null) {
                    throw new CalciteSemanticException("Expression " + literal.getExprString() + " is not a valid decimal", CalciteSemanticException.UnsupportedFeature.Invalid_decimal);
                }
                calciteLiteral = this.rexBuilder.makeExactLiteral((BigDecimal)value, calciteDataType);
                break;
            }
            case FLOAT: {
                calciteLiteral = this.rexBuilder.makeApproxLiteral(new BigDecimal(Float.toString(((Float)value).floatValue())), calciteDataType);
                break;
            }
            case DOUBLE: {
                if (Double.isNaN((Double)value)) {
                    throw new CalciteSemanticException("NaN", CalciteSemanticException.UnsupportedFeature.Invalid_decimal);
                }
                calciteLiteral = this.rexBuilder.makeApproxLiteral(new BigDecimal(Double.toString((Double)value)), calciteDataType);
                break;
            }
            case CHAR: {
                if (value instanceof HiveChar) {
                    value = ((HiveChar)value).getValue();
                }
                int lengthChar = TypeInfoUtils.getCharacterLengthForType(hiveType);
                RelDataType charType = this.rexBuilder.getTypeFactory().createTypeWithCharsetAndCollation(this.rexBuilder.getTypeFactory().createSqlType(SqlTypeName.CHAR, lengthChar), Charset.forName(ConversionUtil.NATIVE_UTF16_CHARSET_NAME), SqlCollation.IMPLICIT);
                calciteLiteral = this.rexBuilder.makeLiteral((Object)RexNodeConverter.asUnicodeString((String)value), charType, false);
                break;
            }
            case VARCHAR: {
                if (value instanceof HiveVarchar) {
                    value = ((HiveVarchar)value).getValue();
                }
                int lengthVarchar = TypeInfoUtils.getCharacterLengthForType(hiveType);
                RelDataType varcharType = this.rexBuilder.getTypeFactory().createTypeWithCharsetAndCollation(this.rexBuilder.getTypeFactory().createSqlType(SqlTypeName.VARCHAR, lengthVarchar), Charset.forName(ConversionUtil.NATIVE_UTF16_CHARSET_NAME), SqlCollation.IMPLICIT);
                calciteLiteral = this.rexBuilder.makeLiteral((Object)RexNodeConverter.asUnicodeString((String)value), varcharType, true);
                break;
            }
            case STRING: {
                RelDataType stringType = this.rexBuilder.getTypeFactory().createTypeWithCharsetAndCollation(this.rexBuilder.getTypeFactory().createSqlType(SqlTypeName.VARCHAR, Integer.MAX_VALUE), Charset.forName(ConversionUtil.NATIVE_UTF16_CHARSET_NAME), SqlCollation.IMPLICIT);
                calciteLiteral = this.rexBuilder.makeLiteral((Object)RexNodeConverter.asUnicodeString((String)value), stringType, true);
                break;
            }
            case DATE: {
                Date date = (Date)value;
                calciteLiteral = this.rexBuilder.makeDateLiteral(DateString.fromDaysSinceEpoch((int)date.toEpochDay()));
                break;
            }
            case TIMESTAMP: {
                TimestampString tsString;
                if (value instanceof Calendar) {
                    tsString = TimestampString.fromCalendarFields((Calendar)((Calendar)value));
                } else {
                    Timestamp ts = (Timestamp)value;
                    tsString = TimestampString.fromMillisSinceEpoch((long)ts.toEpochMilli()).withNanos(ts.getNanos());
                }
                calciteLiteral = this.rexBuilder.makeLiteral((Object)tsString, this.rexBuilder.getTypeFactory().createSqlType(SqlTypeName.TIMESTAMP, this.rexBuilder.getTypeFactory().getTypeSystem().getDefaultPrecision(SqlTypeName.TIMESTAMP)), false);
                break;
            }
            case TIMESTAMPLOCALTZ: {
                Instant i = ((TimestampTZ)value).getZonedDateTime().toInstant();
                TimestampString tsLocalTZString = TimestampString.fromMillisSinceEpoch((long)i.toEpochMilli()).withNanos(i.getNano());
                calciteLiteral = this.rexBuilder.makeTimestampWithLocalTimeZoneLiteral(tsLocalTZString, this.rexBuilder.getTypeFactory().getTypeSystem().getDefaultPrecision(SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE));
                break;
            }
            case INTERVAL_YEAR_MONTH: {
                BigDecimal totalMonths = BigDecimal.valueOf(((HiveIntervalYearMonth)value).getTotalMonths());
                calciteLiteral = this.rexBuilder.makeIntervalLiteral(totalMonths, new SqlIntervalQualifier(TimeUnit.YEAR, TimeUnit.MONTH, new SqlParserPos(1, 1)));
                break;
            }
            case INTERVAL_DAY_TIME: {
                BigDecimal secsValueBd = BigDecimal.valueOf(((HiveIntervalDayTime)value).getTotalSeconds() * 1000L);
                BigDecimal nanosValueBd = BigDecimal.valueOf(((HiveIntervalDayTime)value).getNanos(), 6);
                calciteLiteral = this.rexBuilder.makeIntervalLiteral(secsValueBd.add(nanosValueBd), new SqlIntervalQualifier(TimeUnit.MILLISECOND, null, new SqlParserPos(1, 1)));
                break;
            }
            case VOID: {
                calciteLiteral = this.rexBuilder.makeLiteral(null, calciteDataType, true);
                break;
            }
            default: {
                throw new RuntimeException("Unsupported Literal");
            }
        }
        return calciteLiteral;
    }

    public static List<RexNode> transformInToOrOperands(List<RexNode> operands, RexBuilder rexBuilder) {
        ArrayList<RexNode> disjuncts = new ArrayList<RexNode>(operands.size() - 2);
        if (operands.get(0).getKind() != SqlKind.ROW) {
            RexNode columnExpression = operands.get(0);
            if (!HiveCalciteUtil.isDeterministic(columnExpression)) {
                return null;
            }
            for (int i = 1; i < operands.size(); ++i) {
                RexNode valueExpression = operands.get(i);
                if (!HiveCalciteUtil.isDeterministic(valueExpression)) {
                    return null;
                }
                disjuncts.add(rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{columnExpression, valueExpression}));
            }
        } else {
            RexCall columnExpressions = (RexCall)operands.get(0);
            if (!HiveCalciteUtil.isDeterministic((RexNode)columnExpressions)) {
                return null;
            }
            for (int i = 1; i < operands.size(); ++i) {
                ArrayList<RexNode> conjuncts = new ArrayList<RexNode>(columnExpressions.getOperands().size() - 1);
                RexCall valueExpressions = (RexCall)operands.get(i);
                if (!HiveCalciteUtil.isDeterministic((RexNode)valueExpressions)) {
                    return null;
                }
                for (int j = 0; j < columnExpressions.getOperands().size(); ++j) {
                    conjuncts.add(rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{(RexNode)columnExpressions.getOperands().get(j), (RexNode)valueExpressions.getOperands().get(j)}));
                }
                if (conjuncts.size() > 1) {
                    disjuncts.add(rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, conjuncts));
                    continue;
                }
                disjuncts.add((RexNode)conjuncts.get(0));
            }
        }
        return disjuncts;
    }
}

