/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.translator.opconventer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.calcite.rel.core.Values;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorFactory;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveValues;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.TypeConverter;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.opconventer.HiveOpConverter;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.opconventer.HiveRelNodeVisitor;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.LimitDesc;
import org.apache.hadoop.hive.ql.plan.SelectDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;

class HiveValuesVisitor
extends HiveRelNodeVisitor<HiveValues> {
    HiveValuesVisitor(HiveOpConverter hiveOpConverter) {
        super(hiveOpConverter);
    }

    @Override
    HiveOpConverter.OpAttr visit(HiveValues valuesRel) throws SemanticException {
        LOG.debug("Translating operator rel#{}:{} with row type: [{}]", new Object[]{valuesRel.getId(), valuesRel.getRelTypeName(), valuesRel.getRowType()});
        if (!Values.isEmpty((Values)valuesRel)) {
            LOG.error("Empty {} operator translation not supported yet in return path.", (Object)valuesRel.getClass().getCanonicalName());
            return null;
        }
        Operator<?> ts = this.createDummyScan();
        this.hiveOpConverter.getTopOps().put("_dummy_table", (TableScanOperator)ts);
        Operator<?> selOp = HiveValuesVisitor.createSelect(valuesRel.getRowType(), ts);
        Operator<?> resultOp = HiveValuesVisitor.createLimit0(selOp.getSchema().getSignature(), selOp);
        LOG.debug("Generated {} with row schema: [{}]", resultOp, (Object)resultOp.getSchema());
        return new HiveOpConverter.OpAttr("_dummy_table", Collections.emptySet(), selOp).clone(resultOp);
    }

    private Operator<?> createDummyScan() throws SemanticException {
        Table metadata = this.hiveOpConverter.getSemanticAnalyzer().getDummyTable();
        TableScanDesc tsd = new TableScanDesc("_dummy_table", Collections.emptyList(), metadata);
        return OperatorFactory.get(this.hiveOpConverter.getSemanticAnalyzer().getOpContext(), tsd, new RowSchema(Collections.emptyList()));
    }

    private static Operator<?> createSelect(RelDataType relDataType, Operator<?> parentOp) {
        ArrayList<String> columnNames = new ArrayList<String>();
        ArrayList<ExprNodeDesc> exprNodeDescList = new ArrayList<ExprNodeDesc>();
        HashMap<String, ExprNodeDesc> colExprMap = new HashMap<String, ExprNodeDesc>();
        ArrayList<ColumnInfo> colInfoList = new ArrayList<ColumnInfo>();
        for (int i = 0; i < relDataType.getFieldList().size(); ++i) {
            RelDataTypeField typeField = (RelDataTypeField)relDataType.getFieldList().get(i);
            ColumnInfo ci = new ColumnInfo(typeField.getName(), TypeConverter.convert(typeField.getType()), "_dummy_table", false);
            colInfoList.add(ci);
            columnNames.add(typeField.getName());
            ExprNodeConstantDesc exprNodeDesc = new ExprNodeConstantDesc(TypeConverter.convert(typeField.getType()), null);
            colExprMap.put(typeField.getName(), exprNodeDesc);
            exprNodeDescList.add(exprNodeDesc);
        }
        SelectDesc sd = new SelectDesc(exprNodeDescList, columnNames);
        Operator<SelectDesc> selOp = OperatorFactory.getAndMakeChild(sd, new RowSchema(colInfoList), parentOp, new Operator[0]);
        selOp.setColumnExprMap(colExprMap);
        return selOp;
    }

    private static Operator<?> createLimit0(List<ColumnInfo> colInfoList, Operator<?> parentOp) {
        LimitDesc limitDesc = new LimitDesc(0, 0);
        return OperatorFactory.getAndMakeChild(limitDesc, new RowSchema(colInfoList), parentOp, new Operator[0]);
    }
}

