/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.SetMultimap;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.hadoop.hive.ql.metadata.VirtualColumn;

public class ColumnAccessInfo {
    private final SetMultimap<String, ColumnAccess> tableToColumnAccessMap = LinkedHashMultimap.create();

    public void add(String table, String col) {
        this.tableToColumnAccessMap.put(table, new ColumnAccess(col, Access.DIRECT));
    }

    public void addIndirect(String table, String col) {
        this.tableToColumnAccessMap.put(table, new ColumnAccess(col, Access.INDIRECT));
    }

    public Map<String, List<String>> getTableToColumnAccessMap() {
        LinkedHashMap<String, List<String>> mapping = new LinkedHashMap<String, List<String>>();
        for (Map.Entry<String, Collection<ColumnAccess>> entry : this.tableToColumnAccessMap.asMap().entrySet()) {
            List sortedCols = entry.getValue().stream().filter(ca -> ((ColumnAccess)ca).access == Access.DIRECT).map(ca -> ((ColumnAccess)ca).columnName).sorted().collect(Collectors.toList());
            if (sortedCols.isEmpty()) continue;
            mapping.put(entry.getKey(), sortedCols);
        }
        return mapping;
    }

    public Map<String, List<String>> getTableToColumnAllAccessMap() {
        LinkedHashMap<String, List<String>> mapping = new LinkedHashMap<String, List<String>>();
        for (Map.Entry<String, Collection<ColumnAccess>> entry : this.tableToColumnAccessMap.asMap().entrySet()) {
            mapping.put(entry.getKey(), entry.getValue().stream().map(ca -> ((ColumnAccess)ca).columnName).distinct().sorted().collect(Collectors.toList()));
        }
        return mapping;
    }

    public void stripVirtualColumn(VirtualColumn vc) {
        block0: for (Map.Entry<String, Collection<ColumnAccess>> e : this.tableToColumnAccessMap.asMap().entrySet()) {
            for (ColumnAccess columnAccess : e.getValue()) {
                if (!vc.getName().equalsIgnoreCase(columnAccess.columnName)) continue;
                e.getValue().remove(columnAccess);
                continue block0;
            }
        }
    }

    private static enum Access {
        DIRECT,
        INDIRECT;

    }

    private static class ColumnAccess {
        private final String columnName;
        private final Access access;

        private ColumnAccess(String columnName, Access access) {
            this.columnName = Objects.requireNonNull(columnName);
            this.access = Objects.requireNonNull(access);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof ColumnAccess) {
                ColumnAccess other = (ColumnAccess)o;
                return this.columnName.equals(other.columnName) && this.access == other.access;
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.columnName, this.access});
        }
    }
}

