/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.common.HiveStatsUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.conf.HiveVariableSource;
import org.apache.hadoop.hive.conf.VariableSubstitution;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveUtils;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.AnalyzeCommandUtils;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ColumnStatsAutoGatherContext;
import org.apache.hadoop.hive.ql.parse.ParseException;
import org.apache.hadoop.hive.ql.parse.ParseUtils;
import org.apache.hadoop.hive.ql.parse.QB;
import org.apache.hadoop.hive.ql.parse.QBParseInfo;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.HiveOperation;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnStatsSemanticAnalyzer
extends SemanticAnalyzer {
    private static final Logger LOG = LoggerFactory.getLogger(ColumnStatsSemanticAnalyzer.class);
    private static final SessionState.LogHelper CONSOLE = new SessionState.LogHelper(LOG);
    private ASTNode originalTree;
    private ASTNode rewrittenTree;
    private String rewrittenQuery;
    private Context ctx;
    private boolean isRewritten;
    private boolean isTableLevel;
    private List<String> colNames;
    private List<String> colType;
    private Table tbl;

    public ColumnStatsSemanticAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    public static String getQuote(HiveConf conf) {
        String qIdSupport = conf.getVar(HiveConf.ConfVars.HIVE_QUOTEDID_SUPPORT);
        if ("column".equals(qIdSupport)) {
            return "`";
        }
        if ("standard".equals(qIdSupport)) {
            return "\"";
        }
        return "";
    }

    private boolean shouldRewrite(ASTNode tree) {
        ASTNode child1;
        ASTNode child0;
        boolean rwt = false;
        if (tree.getChildCount() > 1 && (child0 = (ASTNode)tree.getChild(0)).getToken().getType() == 1107 && (child0 = (ASTNode)child0.getChild(0)).getToken().getType() == 1136 && (child1 = (ASTNode)tree.getChild(1)).getToken().getType() == 68) {
            rwt = true;
        }
        return rwt;
    }

    private List<String> getColumnName(ASTNode tree) throws SemanticException {
        switch (tree.getChildCount()) {
            case 2: {
                return Utilities.getColumnNamesFromFieldSchema(this.tbl.getCols());
            }
            case 3: {
                int numCols = tree.getChild(2).getChildCount();
                ArrayList<String> colName = new ArrayList<String>(numCols);
                for (int i = 0; i < numCols; ++i) {
                    colName.add(ColumnStatsSemanticAnalyzer.getUnescapedName((ASTNode)tree.getChild(2).getChild(i)));
                }
                return colName;
            }
        }
        throw new SemanticException("Internal error. Expected number of children of ASTNode to be either 2 or 3. Found : " + tree.getChildCount());
    }

    private void handlePartialPartitionSpec(Map<String, String> partSpec, ColumnStatsAutoGatherContext context) throws SemanticException {
        int partValsSpecified = 0;
        for (String partKey : partSpec.keySet()) {
            partValsSpecified += partSpec.get(partKey) == null ? 0 : 1;
        }
        try {
            if (context == null && partValsSpecified == this.tbl.getPartitionKeys().size() && this.db.getPartition(this.tbl, partSpec, false, null, false) == null) {
                throw new SemanticException(ErrorMsg.COLUMNSTATSCOLLECTOR_INVALID_PARTITION.getMsg() + " : " + partSpec);
            }
        }
        catch (HiveException he) {
            throw new SemanticException(ErrorMsg.COLUMNSTATSCOLLECTOR_INVALID_PARTITION.getMsg() + " : " + partSpec);
        }
        List<String> partKeys = Utilities.getColumnNamesFromFieldSchema(this.tbl.getPartitionKeys());
        for (String partKey : partKeys) {
            if (partSpec.containsKey(partKey)) continue;
            partSpec.put(partKey, null);
        }
        for (String partKey : partSpec.keySet()) {
            if (partKeys.contains(partKey)) continue;
            throw new SemanticException(ErrorMsg.COLUMNSTATSCOLLECTOR_INVALID_PART_KEY.getMsg() + " : " + partKey);
        }
    }

    private static StringBuilder genPartitionClause(Table tbl, Map<String, String> partSpec, HiveConf conf) throws SemanticException {
        StringBuilder whereClause = new StringBuilder(" where ");
        boolean predPresent = false;
        StringBuilder groupByClause = new StringBuilder(" group by ");
        boolean aggPresent = false;
        for (Map.Entry<String, String> part : partSpec.entrySet()) {
            String value = part.getValue();
            if (value == null) continue;
            if (!predPresent) {
                predPresent = true;
            } else {
                whereClause.append(" and ");
            }
            whereClause.append(HiveUtils.unparseIdentifier(part.getKey(), conf)).append(" = ").append(ColumnStatsSemanticAnalyzer.genPartValueString(ColumnStatsSemanticAnalyzer.getColTypeOf(tbl, part.getKey()), value));
        }
        for (FieldSchema fs : tbl.getPartitionKeys()) {
            if (!aggPresent) {
                aggPresent = true;
            } else {
                groupByClause.append(',');
            }
            groupByClause.append(HiveUtils.unparseIdentifier(fs.getName(), conf));
        }
        return predPresent ? whereClause.append((CharSequence)groupByClause) : groupByClause;
    }

    private static String getColTypeOf(Table tbl, String partKey) throws SemanticException {
        for (FieldSchema fs : tbl.getPartitionKeys()) {
            if (!partKey.equalsIgnoreCase(fs.getName())) continue;
            return fs.getType().toLowerCase();
        }
        throw new SemanticException("Unknown partition key : " + partKey);
    }

    private static List<String> getColumnTypes(Table tbl, List<String> colNames) {
        ArrayList<String> colTypes = new ArrayList<String>();
        List<FieldSchema> cols = tbl.getCols();
        ArrayList<String> copyColNames = new ArrayList<String>(colNames);
        for (String colName : copyColNames) {
            for (FieldSchema col : cols) {
                if (!colName.equalsIgnoreCase(col.getName())) continue;
                String type = col.getType();
                TypeInfo typeInfo = TypeInfoUtils.getTypeInfoFromTypeString(type);
                if (typeInfo.getCategory() != ObjectInspector.Category.PRIMITIVE) {
                    ColumnStatsSemanticAnalyzer.logTypeWarning(colName, type);
                    colNames.remove(colName);
                    continue;
                }
                colTypes.add(type);
            }
        }
        return colTypes;
    }

    private String genRewrittenQuery(List<String> colNames, HiveConf conf, Map<String, String> partSpec, boolean isPartitionStats) throws SemanticException {
        String rewritten = ColumnStatsSemanticAnalyzer.genRewrittenQuery(this.tbl, colNames, conf, partSpec, isPartitionStats, false);
        this.isRewritten = true;
        return rewritten;
    }

    public static String genRewrittenQuery(Table tbl, List<String> colNames, HiveConf conf, Map<String, String> partSpec, boolean isPartitionStats, boolean useTableValues) throws SemanticException {
        StringBuilder rewrittenQueryBuilder = new StringBuilder("select ");
        StringBuilder columnNamesBuilder = new StringBuilder();
        StringBuilder columnDummyValuesBuilder = new StringBuilder();
        for (int i = 0; i < colNames.size(); ++i) {
            if (i > 0) {
                rewrittenQueryBuilder.append(" , ");
                columnNamesBuilder.append(" , ");
                columnDummyValuesBuilder.append(" , ");
            }
            String func = HiveConf.getVar(conf, HiveConf.ConfVars.HIVE_STATS_NDV_ALGO).toLowerCase();
            rewrittenQueryBuilder.append("compute_stats(");
            String columnName = HiveUtils.unparseIdentifier(colNames.get(i), conf);
            rewrittenQueryBuilder.append(columnName);
            rewrittenQueryBuilder.append(", '" + func + "'");
            if ("fm".equals(func)) {
                int numBitVectors = 0;
                try {
                    numBitVectors = HiveStatsUtils.getNumBitVectorsForNDVEstimation(conf);
                }
                catch (Exception e) {
                    throw new SemanticException(e.getMessage());
                }
                rewrittenQueryBuilder.append(", " + numBitVectors);
            }
            rewrittenQueryBuilder.append(')');
            columnNamesBuilder.append(columnName);
            columnDummyValuesBuilder.append("cast(null as " + TypeInfoUtils.getTypeInfoFromTypeString(tbl.getCols().get(i).getType()).toString() + ")");
        }
        if (isPartitionStats) {
            for (FieldSchema fs : tbl.getPartCols()) {
                String identifier = HiveUtils.unparseIdentifier(fs.getName(), conf);
                rewrittenQueryBuilder.append(" , ").append(identifier);
                columnNamesBuilder.append(" , ").append(identifier);
                columnDummyValuesBuilder.append(" , cast(null as ").append(TypeInfoUtils.getTypeInfoFromTypeString(fs.getType()).toString()).append(")");
            }
        }
        rewrittenQueryBuilder.append(" from ");
        if (useTableValues) {
            rewrittenQueryBuilder.append("table(values(");
            rewrittenQueryBuilder.append(columnDummyValuesBuilder.toString());
            rewrittenQueryBuilder.append(")) as ");
            rewrittenQueryBuilder.append(HiveUtils.unparseIdentifier(tbl.getTableName(), conf));
            rewrittenQueryBuilder.append("(");
            rewrittenQueryBuilder.append(columnNamesBuilder.toString());
            rewrittenQueryBuilder.append(")");
        } else {
            rewrittenQueryBuilder.append(HiveUtils.unparseIdentifier(tbl.getDbName(), conf));
            rewrittenQueryBuilder.append(".");
            rewrittenQueryBuilder.append(HiveUtils.unparseIdentifier(tbl.getTableName(), conf));
        }
        if (isPartitionStats) {
            rewrittenQueryBuilder.append((CharSequence)ColumnStatsSemanticAnalyzer.genPartitionClause(tbl, partSpec, conf));
        }
        String rewrittenQuery = rewrittenQueryBuilder.toString();
        rewrittenQuery = new VariableSubstitution(new HiveVariableSource(){

            @Override
            public Map<String, String> getHiveVariable() {
                return SessionState.get().getHiveVariables();
            }
        }).substitute(conf, rewrittenQuery);
        return rewrittenQuery;
    }

    private ASTNode genRewrittenTree(String rewrittenQuery) throws SemanticException {
        try {
            this.ctx = new Context(this.conf);
        }
        catch (IOException e) {
            throw new SemanticException(ErrorMsg.COLUMNSTATSCOLLECTOR_IO_ERROR.getMsg());
        }
        this.ctx.setCmd(rewrittenQuery);
        this.ctx.setHDFSCleanup(true);
        try {
            return ParseUtils.parse(rewrittenQuery, this.ctx);
        }
        catch (ParseException e) {
            throw new SemanticException(ErrorMsg.COLUMNSTATSCOLLECTOR_PARSE_ERROR.getMsg());
        }
    }

    private void validateSpecifiedColumnNames(List<String> specifiedCols) throws SemanticException {
        List<String> tableCols = Utilities.getColumnNamesFromFieldSchema(this.tbl.getCols());
        for (String sc : specifiedCols) {
            if (tableCols.contains(sc.toLowerCase())) continue;
            String msg = "'" + sc + "' (possible columns are " + tableCols.toString() + ")";
            throw new SemanticException(ErrorMsg.INVALID_COLUMN.getMsg(msg));
        }
    }

    private void checkForPartitionColumns(List<String> specifiedCols, List<String> partCols) throws SemanticException {
        for (String pc : partCols) {
            for (String sc : specifiedCols) {
                if (!pc.equalsIgnoreCase(sc)) continue;
                throw new SemanticException(ErrorMsg.COLUMNSTATSCOLLECTOR_INVALID_COLUMN.getMsg() + " [Try removing column '" + sc + "' from column list]");
            }
        }
    }

    private static void logTypeWarning(String colName, String colType) {
        String warning = "Only primitive type arguments are accepted but " + colType + " is passed for " + colName + ".";
        warning = "WARNING: " + warning;
        CONSOLE.printInfo(warning);
    }

    @Override
    public void analyze(ASTNode ast, Context origCtx) throws SemanticException {
        this.init(true);
        super.processNoScanCommand(ast);
        if (this.shouldRewrite(ast)) {
            this.tbl = AnalyzeCommandUtils.getTable(ast, this);
            this.colNames = this.getColumnName(ast);
            this.originalTree = ast;
            boolean isPartitionStats = AnalyzeCommandUtils.isPartitionLevelStats(ast);
            Map<String, String> partSpec = null;
            this.checkForPartitionColumns(this.colNames, Utilities.getColumnNamesFromFieldSchema(this.tbl.getPartitionKeys()));
            this.validateSpecifiedColumnNames(this.colNames);
            if (this.conf.getBoolVar(HiveConf.ConfVars.HIVE_STATS_COLLECT_PART_LEVEL_STATS) && this.tbl.isPartitioned()) {
                isPartitionStats = true;
            }
            if (isPartitionStats) {
                this.isTableLevel = false;
                partSpec = AnalyzeCommandUtils.getPartKeyValuePairsFromAST(this.tbl, ast, this.conf);
                this.handlePartialPartitionSpec(partSpec, null);
            } else {
                this.isTableLevel = true;
            }
            this.colType = ColumnStatsSemanticAnalyzer.getColumnTypes(this.tbl, this.colNames);
            this.rewrittenQuery = this.genRewrittenQuery(this.colNames, this.conf, partSpec, isPartitionStats);
            this.rewrittenTree = this.genRewrittenTree(this.rewrittenQuery);
        } else {
            this.originalTree = this.rewrittenTree = ast;
            this.rewrittenQuery = null;
            this.isRewritten = false;
        }
        if (this.isRewritten) {
            QB qb = this.getQB();
            qb.setAnalyzeRewrite(true);
            QBParseInfo qbp = qb.getParseInfo();
            this.analyzeRewrite = new BaseSemanticAnalyzer.AnalyzeRewriteContext();
            this.analyzeRewrite.setTableName(this.tbl.getFullyQualifiedName());
            this.analyzeRewrite.setTblLvl(this.isTableLevel);
            this.analyzeRewrite.setColName(this.colNames);
            this.analyzeRewrite.setColType(this.colType);
            qbp.setAnalyzeRewrite(this.analyzeRewrite);
            origCtx.addSubContext(this.ctx);
            this.initCtx(this.ctx);
            this.ctx.setExplainConfig(origCtx.getExplainConfig());
            LOG.info("Invoking analyze on rewritten query");
            this.analyzeInternal(this.rewrittenTree);
            this.queryState.setCommandType(HiveOperation.ANALYZE_TABLE);
        } else {
            this.initCtx(origCtx);
            LOG.info("Invoking analyze on original query");
            this.analyzeInternal(this.originalTree);
        }
    }

    public ASTNode rewriteAST(ASTNode ast, ColumnStatsAutoGatherContext context) throws SemanticException {
        this.originalTree = ast;
        this.tbl = AnalyzeCommandUtils.getTable(ast, this);
        this.colNames = this.getColumnName(ast);
        boolean isPartitionStats = AnalyzeCommandUtils.isPartitionLevelStats(ast);
        Map<String, String> partSpec = null;
        this.checkForPartitionColumns(this.colNames, Utilities.getColumnNamesFromFieldSchema(this.tbl.getPartitionKeys()));
        this.validateSpecifiedColumnNames(this.colNames);
        if (this.conf.getBoolVar(HiveConf.ConfVars.HIVE_STATS_COLLECT_PART_LEVEL_STATS) && this.tbl.isPartitioned()) {
            isPartitionStats = true;
        }
        if (isPartitionStats) {
            partSpec = AnalyzeCommandUtils.getPartKeyValuePairsFromAST(this.tbl, ast, this.conf);
            this.handlePartialPartitionSpec(partSpec, context);
        }
        this.colType = ColumnStatsSemanticAnalyzer.getColumnTypes(this.tbl, this.colNames);
        this.isTableLevel = !isPartitionStats;
        this.rewrittenQuery = this.genRewrittenQuery(this.colNames, this.conf, partSpec, isPartitionStats);
        this.rewrittenTree = this.genRewrittenTree(this.rewrittenQuery);
        return this.rewrittenTree;
    }

    BaseSemanticAnalyzer.AnalyzeRewriteContext getAnalyzeRewriteContext() {
        BaseSemanticAnalyzer.AnalyzeRewriteContext analyzeRewrite = new BaseSemanticAnalyzer.AnalyzeRewriteContext();
        analyzeRewrite.setTableName(this.tbl.getFullyQualifiedName());
        analyzeRewrite.setTblLvl(this.isTableLevel);
        analyzeRewrite.setColName(this.colNames);
        analyzeRewrite.setColType(this.colType);
        return analyzeRewrite;
    }

    static BaseSemanticAnalyzer.AnalyzeRewriteContext genAnalyzeRewriteContext(HiveConf conf, Table tbl) {
        BaseSemanticAnalyzer.AnalyzeRewriteContext analyzeRewrite = new BaseSemanticAnalyzer.AnalyzeRewriteContext();
        analyzeRewrite.setTableName(tbl.getFullyQualifiedName());
        analyzeRewrite.setTblLvl(!conf.getBoolVar(HiveConf.ConfVars.HIVE_STATS_COLLECT_PART_LEVEL_STATS) || !tbl.isPartitioned());
        List<String> colNames = Utilities.getColumnNamesFromFieldSchema(tbl.getCols());
        List<String> colTypes = ColumnStatsSemanticAnalyzer.getColumnTypes(tbl, colNames);
        analyzeRewrite.setColName(colNames);
        analyzeRewrite.setColType(colTypes);
        return analyzeRewrite;
    }
}

