/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveUtils;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.RewriteSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.StorageFormat;
import org.apache.hadoop.hive.ql.parse.UnparseTranslator;
import org.apache.hadoop.hive.ql.session.SessionState;

public class MergeSemanticAnalyzer
extends RewriteSemanticAnalyzer {
    private int numWhenMatchedUpdateClauses;
    private int numWhenMatchedDeleteClauses;

    MergeSemanticAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    protected ASTNode getTargetTableNode(ASTNode tree) {
        return (ASTNode)tree.getChild(0);
    }

    @Override
    public void analyze(ASTNode tree, Table targetTable, ASTNode tableNameNode) throws SemanticException {
        if (tree.getToken().getType() != 962) {
            throw new RuntimeException("Asked to parse token " + tree.getName() + " in MergeSemanticAnalyzer");
        }
        this.ctx.setOperation(Context.Operation.MERGE);
        this.analyzeMerge(tree, targetTable, tableNameNode);
    }

    private void analyzeMerge(ASTNode tree, Table targetTable, ASTNode targetNameNode) throws SemanticException {
        ASTNode source = (ASTNode)tree.getChild(1);
        String targetName = this.getSimpleTableName(targetNameNode);
        String sourceName = this.getSimpleTableName(source);
        ASTNode onClause = (ASTNode)tree.getChild(2);
        String onClauseAsText = this.getMatchedText(onClause);
        int whenClauseBegins = 3;
        boolean hasHint = false;
        ASTNode qHint = (ASTNode)tree.getChild(3);
        if (qHint.getType() == 387) {
            hasHint = true;
            ++whenClauseBegins;
        }
        List<ASTNode> whenClauses = this.findWhenClauses(tree, whenClauseBegins);
        StringBuilder rewrittenQueryStr = this.createRewrittenQueryStrBuilder();
        this.appendTarget(rewrittenQueryStr, targetNameNode, targetName);
        rewrittenQueryStr.append("  ").append(this.chooseJoinType(whenClauses)).append("\n");
        if (source.getType() == 1100) {
            rewrittenQueryStr.append("  ").append(this.getMatchedText(source));
        } else {
            rewrittenQueryStr.append("  ").append(this.getFullTableNameForSQL(source));
            if (this.isAliased(source)) {
                rewrittenQueryStr.append(" ").append(sourceName);
            }
        }
        rewrittenQueryStr.append('\n');
        rewrittenQueryStr.append("  ").append("ON ").append(onClauseAsText).append('\n');
        String hintStr = null;
        if (hasHint) {
            hintStr = " /*+ " + qHint.getText() + " */ ";
        }
        boolean splitUpdateEarly = HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.SPLIT_UPDATE) || HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.MERGE_SPLIT_UPDATE);
        String extraPredicate = null;
        int numInsertClauses = 0;
        this.numWhenMatchedUpdateClauses = 0;
        this.numWhenMatchedDeleteClauses = 0;
        boolean hintProcessed = false;
        for (ASTNode whenClause : whenClauses) {
            switch (this.getWhenClauseOperation(whenClause).getType()) {
                case 928: {
                    ++numInsertClauses;
                    this.handleInsert(whenClause, rewrittenQueryStr, targetNameNode, onClause, targetTable, targetName, onClauseAsText, hintProcessed ? null : hintStr);
                    hintProcessed = true;
                    break;
                }
                case 1165: {
                    ++this.numWhenMatchedUpdateClauses;
                    String s = this.handleUpdate(whenClause, rewrittenQueryStr, targetNameNode, onClauseAsText, targetTable, extraPredicate, hintProcessed ? null : hintStr, splitUpdateEarly);
                    hintProcessed = true;
                    if (this.numWhenMatchedUpdateClauses + this.numWhenMatchedDeleteClauses != 1) break;
                    extraPredicate = s;
                    break;
                }
                case 869: {
                    ++this.numWhenMatchedDeleteClauses;
                    String s1 = this.handleDelete(whenClause, rewrittenQueryStr, targetNameNode, onClauseAsText, extraPredicate, hintProcessed ? null : hintStr, false);
                    hintProcessed = true;
                    if (this.numWhenMatchedUpdateClauses + this.numWhenMatchedDeleteClauses != 1) break;
                    extraPredicate = s1;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected WHEN clause type: " + whenClause.getType() + MergeSemanticAnalyzer.addParseInfo(whenClause));
                }
            }
            if (this.numWhenMatchedDeleteClauses > 1) {
                throw new SemanticException(ErrorMsg.MERGE_TOO_MANY_DELETE, this.ctx.getCmd());
            }
            if (this.numWhenMatchedUpdateClauses > 1) {
                throw new SemanticException(ErrorMsg.MERGE_TOO_MANY_UPDATE, this.ctx.getCmd());
            }
            assert (numInsertClauses < 2) : "too many Insert clauses";
        }
        if (this.numWhenMatchedDeleteClauses + this.numWhenMatchedUpdateClauses == 2 && extraPredicate == null) {
            throw new SemanticException(ErrorMsg.MERGE_PREDIACTE_REQUIRED, this.ctx.getCmd());
        }
        boolean validating = this.handleCardinalityViolation(rewrittenQueryStr, targetNameNode, onClauseAsText, targetTable, this.numWhenMatchedDeleteClauses == 0 && this.numWhenMatchedUpdateClauses == 0);
        RewriteSemanticAnalyzer.ReparseResult rr = this.parseRewrittenQuery(rewrittenQueryStr, this.ctx.getCmd());
        Context rewrittenCtx = rr.rewrittenCtx;
        ASTNode rewrittenTree = rr.rewrittenTree;
        rewrittenCtx.setOperation(Context.Operation.MERGE);
        int insClauseIdx = 1;
        int whenClauseIdx = 0;
        while (insClauseIdx < rewrittenTree.getChildCount() - (validating ? 1 : 0)) {
            switch (this.getWhenClauseOperation(whenClauses.get(whenClauseIdx)).getType()) {
                case 928: {
                    rewrittenCtx.addDestNamePrefix(insClauseIdx, Context.DestClausePrefix.INSERT);
                    break;
                }
                case 1165: {
                    if (!splitUpdateEarly) {
                        rewrittenCtx.addDestNamePrefix(insClauseIdx, Context.DestClausePrefix.UPDATE);
                        break;
                    }
                    rewrittenCtx.addDestNamePrefix(insClauseIdx, Context.DestClausePrefix.INSERT);
                    rewrittenCtx.addDeleteOfUpdateDestNamePrefix(++insClauseIdx, Context.DestClausePrefix.DELETE);
                    break;
                }
                case 869: {
                    rewrittenCtx.addDestNamePrefix(insClauseIdx, Context.DestClausePrefix.DELETE);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            ++insClauseIdx;
            ++whenClauseIdx;
        }
        if (validating) {
            rewrittenCtx.addDestNamePrefix(rewrittenTree.getChildCount() - 1, Context.DestClausePrefix.INSERT);
        }
        this.analyzeRewrittenTree(rewrittenTree, rewrittenCtx);
        this.updateOutputs(targetTable);
    }

    private String chooseJoinType(List<ASTNode> whenClauses) {
        for (ASTNode whenClause : whenClauses) {
            if (this.getWhenClauseOperation(whenClause).getType() != 928) continue;
            return "RIGHT OUTER JOIN";
        }
        return "INNER JOIN";
    }

    private boolean handleCardinalityViolation(StringBuilder rewrittenQueryStr, ASTNode target, String onClauseAsString, Table targetTable, boolean onlyHaveWhenNotMatchedClause) throws SemanticException {
        if (!this.conf.getBoolVar(HiveConf.ConfVars.MERGE_CARDINALITY_VIOLATION_CHECK)) {
            LOG.info("Merge statement cardinality violation check is disabled: " + HiveConf.ConfVars.MERGE_CARDINALITY_VIOLATION_CHECK.varname);
            return false;
        }
        if (onlyHaveWhenNotMatchedClause) {
            return false;
        }
        String tableName = "merge_tmp_table";
        rewrittenQueryStr.append("INSERT INTO ").append(tableName).append("\n  SELECT cardinality_violation(").append(this.getSimpleTableName(target)).append(".ROW__ID");
        this.addPartitionColsToSelect(targetTable.getPartCols(), rewrittenQueryStr, target);
        rewrittenQueryStr.append(")\n WHERE ").append(onClauseAsString).append(" GROUP BY ").append(this.getSimpleTableName(target)).append(".ROW__ID");
        this.addPartitionColsToSelect(targetTable.getPartCols(), rewrittenQueryStr, target);
        rewrittenQueryStr.append(" HAVING count(*) > 1");
        try {
            if (null == this.db.getTable(tableName, false)) {
                StorageFormat format = new StorageFormat(this.conf);
                format.processStorageFormat("TextFile");
                Table table = this.db.newTable(tableName);
                table.setSerializationLib(format.getSerde());
                ArrayList<FieldSchema> fields = new ArrayList<FieldSchema>();
                fields.add(new FieldSchema("val", "int", null));
                table.setFields(fields);
                table.setDataLocation(Warehouse.getDnsPath(new Path(SessionState.get().getTempTableSpace(), tableName), this.conf));
                table.getTTable().setTemporary(true);
                table.setStoredAsSubDirectories(false);
                table.setInputFormatClass(format.getInputFormat());
                table.setOutputFormatClass(format.getOutputFormat());
                this.db.createTable(table, true);
            }
        }
        catch (MetaException | HiveException e) {
            throw new SemanticException(e.getMessage(), e);
        }
        return true;
    }

    private String handleUpdate(ASTNode whenMatchedUpdateClause, StringBuilder rewrittenQueryStr, ASTNode target, String onClauseAsString, Table targetTable, String deleteExtraPredicate, String hintStr, boolean splitUpdateEarly) throws SemanticException {
        assert (whenMatchedUpdateClause.getType() == 961);
        assert (this.getWhenClauseOperation(whenMatchedUpdateClause).getType() == 1165);
        String targetName = this.getSimpleTableName(target);
        ArrayList<String> values = new ArrayList<String>(targetTable.getCols().size() + (splitUpdateEarly ? 1 : 0));
        if (!splitUpdateEarly) {
            values.add(targetName + ".ROW__ID");
        }
        ASTNode setClause = (ASTNode)this.getWhenClauseOperation(whenMatchedUpdateClause).getChild(0);
        Map<String, ASTNode> setColsExprs = this.collectSetColumnsAndExpressions(setClause, null, targetTable);
        List<FieldSchema> nonPartCols = targetTable.getCols();
        Map<String, String> colNameToDefaultConstraint = MergeSemanticAnalyzer.getColNameToDefaultValueMap(targetTable);
        for (FieldSchema fs : nonPartCols) {
            String name = fs.getName();
            if (setColsExprs.containsKey(name)) {
                ASTNode setColExpr = setColsExprs.get(name);
                if (setColExpr.getType() == 1133 && setColExpr.getChildCount() == 1 && setColExpr.getChild(0).getType() == 868) {
                    UnparseTranslator defaultValueTranslator = new UnparseTranslator(this.conf);
                    defaultValueTranslator.enable();
                    defaultValueTranslator.addDefaultValueTranslation(setColsExprs.get(name), colNameToDefaultConstraint.get(name));
                    defaultValueTranslator.applyTranslations(this.ctx.getTokenRewriteStream());
                }
                String rhsExp = this.getMatchedText(setColsExprs.get(name));
                switch (rhsExp.charAt(rhsExp.length() - 1)) {
                    case '\n': 
                    case ',': {
                        rhsExp = rhsExp.substring(0, rhsExp.length() - 1);
                        break;
                    }
                }
                values.add(rhsExp);
                continue;
            }
            values.add(targetName + "." + HiveUtils.unparseIdentifier(name, this.conf));
        }
        this.addPartitionColsAsValues(targetTable.getPartCols(), targetName, values);
        rewrittenQueryStr.append("    -- update clause").append(splitUpdateEarly ? " (insert part)" : "").append("\n");
        this.appendInsertBranch(rewrittenQueryStr, hintStr, values);
        rewrittenQueryStr.append("  ").append("WHERE ").append(onClauseAsString);
        String extraPredicate = this.getWhenClausePredicate(whenMatchedUpdateClause);
        if (extraPredicate != null) {
            rewrittenQueryStr.append(" AND ").append(extraPredicate);
        }
        if (deleteExtraPredicate != null) {
            rewrittenQueryStr.append(" AND NOT(").append(deleteExtraPredicate).append(")");
        }
        if (!splitUpdateEarly) {
            this.appendSortBy(rewrittenQueryStr, Collections.singletonList(targetName + ".ROW__ID "));
        }
        rewrittenQueryStr.append("\n");
        this.setUpAccessControlInfoForUpdate(targetTable, setColsExprs);
        if (splitUpdateEarly) {
            rewrittenQueryStr.append("    -- update clause (delete part)\n");
            this.handleDelete(whenMatchedUpdateClause, rewrittenQueryStr, target, onClauseAsString, deleteExtraPredicate, hintStr, true);
        }
        return extraPredicate;
    }

    private String handleDelete(ASTNode whenMatchedDeleteClause, StringBuilder rewrittenQueryStr, ASTNode target, String onClauseAsString, String updateExtraPredicate, String hintStr, boolean splitUpdateEarly) throws SemanticException {
        assert (whenMatchedDeleteClause.getType() == 961);
        assert (splitUpdateEarly && this.getWhenClauseOperation(whenMatchedDeleteClause).getType() == 1165 || this.getWhenClauseOperation(whenMatchedDeleteClause).getType() == 869);
        String targetName = this.getSimpleTableName(target);
        this.appendDeleteBranch(rewrittenQueryStr, hintStr, targetName, Collections.singletonList(targetName + ".ROW__ID"));
        rewrittenQueryStr.append("  ").append("WHERE ").append(onClauseAsString);
        String extraPredicate = this.getWhenClausePredicate(whenMatchedDeleteClause);
        if (extraPredicate != null) {
            rewrittenQueryStr.append(" AND ").append(extraPredicate);
        }
        if (updateExtraPredicate != null) {
            rewrittenQueryStr.append(" AND NOT(").append(updateExtraPredicate).append(")");
        }
        this.appendSortBy(rewrittenQueryStr, Collections.singletonList(targetName + ".ROW__ID "));
        return extraPredicate;
    }

    private static String addParseInfo(ASTNode n) {
        return " at " + ErrorMsg.renderPosition(n);
    }

    private List<ASTNode> findWhenClauses(ASTNode tree, int start) throws SemanticException {
        assert (tree.getType() == 962);
        ArrayList<ASTNode> whenClauses = new ArrayList<ASTNode>();
        for (int idx = start; idx < tree.getChildCount(); ++idx) {
            ASTNode whenClause = (ASTNode)tree.getChild(idx);
            assert (whenClause.getType() == 961 || whenClause.getType() == 967) : "Unexpected node type found: " + whenClause.getType() + MergeSemanticAnalyzer.addParseInfo(whenClause);
            whenClauses.add(whenClause);
        }
        if (whenClauses.size() <= 0) {
            throw new SemanticException("Must have at least 1 WHEN clause in MERGE statement");
        }
        return whenClauses;
    }

    private ASTNode getWhenClauseOperation(ASTNode whenClause) {
        if (whenClause.getType() != 961 && whenClause.getType() != 967) {
            throw MergeSemanticAnalyzer.raiseWrongType("Expected TOK_MATCHED|TOK_NOT_MATCHED", whenClause);
        }
        return (ASTNode)whenClause.getChild(0);
    }

    private String getWhenClausePredicate(ASTNode whenClause) {
        if (whenClause.getType() != 961 && whenClause.getType() != 967) {
            throw MergeSemanticAnalyzer.raiseWrongType("Expected TOK_MATCHED|TOK_NOT_MATCHED", whenClause);
        }
        if (whenClause.getChildCount() == 2) {
            return this.getMatchedText((ASTNode)whenClause.getChild(1));
        }
        return null;
    }

    private void handleInsert(ASTNode whenNotMatchedClause, StringBuilder rewrittenQueryStr, ASTNode target, ASTNode onClause, Table targetTable, String targetTableNameInSourceQuery, String onClauseAsString, String hintStr) throws SemanticException {
        ASTNode whenClauseOperation = this.getWhenClauseOperation(whenNotMatchedClause);
        assert (whenNotMatchedClause.getType() == 967);
        assert (whenClauseOperation.getType() == 928);
        List<Node> children = whenClauseOperation.getChildren();
        ASTNode valuesNode = (ASTNode)children.stream().filter(n -> ((ASTNode)n).getType() == 911).findFirst().get();
        ASTNode columnListNode = children.stream().filter(n -> ((ASTNode)n).getType() == 1111).findFirst().orElse(null);
        if (columnListNode != null && columnListNode.getChildCount() != valuesNode.getChildCount() - 1) {
            throw new SemanticException(String.format("Column schema must have the same length as values (%d vs %d)", columnListNode.getChildCount(), valuesNode.getChildCount() - 1));
        }
        rewrittenQueryStr.append("INSERT INTO ").append(this.getFullTableNameForSQL(target));
        if (columnListNode != null) {
            rewrittenQueryStr.append(' ').append(this.getMatchedText(columnListNode));
        }
        rewrittenQueryStr.append("    -- insert clause\n  SELECT ");
        if (hintStr != null) {
            rewrittenQueryStr.append(hintStr);
        }
        OnClauseAnalyzer oca = new OnClauseAnalyzer(onClause, targetTable, targetTableNameInSourceQuery, this.conf, onClauseAsString);
        oca.analyze();
        UnparseTranslator defaultValuesTranslator = new UnparseTranslator(this.conf);
        defaultValuesTranslator.enable();
        List<String> targetSchema = this.processTableColumnNames(columnListNode, targetTable.getFullyQualifiedName());
        this.collectDefaultValues(valuesNode, targetTable, targetSchema, defaultValuesTranslator);
        defaultValuesTranslator.applyTranslations(this.ctx.getTokenRewriteStream());
        String valuesClause = this.getMatchedText(valuesNode);
        valuesClause = valuesClause.substring(1, valuesClause.length() - 1);
        rewrittenQueryStr.append(valuesClause).append("\n   WHERE ").append(oca.getPredicate());
        String extraPredicate = this.getWhenClausePredicate(whenNotMatchedClause);
        if (extraPredicate != null) {
            rewrittenQueryStr.append(" AND ").append(this.getMatchedText((ASTNode)whenNotMatchedClause.getChild(1)));
        }
        rewrittenQueryStr.append('\n');
    }

    private void collectDefaultValues(ASTNode valueClause, Table targetTable, List<String> targetSchema, UnparseTranslator unparseTranslator) throws SemanticException {
        List<String> defaultConstraints = MergeSemanticAnalyzer.getDefaultConstraints(targetTable, targetSchema);
        for (int j = 0; j < defaultConstraints.size(); ++j) {
            unparseTranslator.addDefaultValueTranslation((ASTNode)valueClause.getChild(j + 1), defaultConstraints.get(j));
        }
    }

    @Override
    protected boolean allowOutputMultipleTimes() {
        return this.conf.getBoolVar(HiveConf.ConfVars.SPLIT_UPDATE) || this.conf.getBoolVar(HiveConf.ConfVars.MERGE_SPLIT_UPDATE);
    }

    @Override
    protected boolean enableColumnStatsCollecting() {
        return this.numWhenMatchedUpdateClauses == 0 && this.numWhenMatchedDeleteClauses == 0;
    }

    private static final class OnClauseAnalyzer {
        private final ASTNode onClause;
        private final Map<String, List<String>> table2column = new HashMap<String, List<String>>();
        private final List<String> unresolvedColumns = new ArrayList<String>();
        private final List<FieldSchema> allTargetTableColumns = new ArrayList<FieldSchema>();
        private final Set<String> tableNamesFound = new HashSet<String>();
        private final String targetTableNameInSourceQuery;
        private final HiveConf conf;
        private final String onClauseAsString;

        OnClauseAnalyzer(ASTNode onClause, Table targetTable, String targetTableNameInSourceQuery, HiveConf conf, String onClauseAsString) {
            this.onClause = onClause;
            this.allTargetTableColumns.addAll(targetTable.getCols());
            this.allTargetTableColumns.addAll(targetTable.getPartCols());
            this.targetTableNameInSourceQuery = BaseSemanticAnalyzer.unescapeIdentifier(targetTableNameInSourceQuery);
            this.conf = conf;
            this.onClauseAsString = onClauseAsString;
        }

        private void visit(ASTNode n) {
            if (n.getType() == 1133) {
                ASTNode parent = (ASTNode)n.getParent();
                if (parent != null && parent.getType() == 16) {
                    if (parent.getParent() != null && parent.getParent().getType() == 16) {
                        throw new IllegalArgumentException("Found unexpected db.table.col reference in " + this.onClauseAsString);
                    }
                    this.addColumn2Table(n.getChild(0).getText(), parent.getChild(1).getText());
                } else {
                    this.unresolvedColumns.add(n.getChild(0).getText());
                }
            }
            if (n.getChildCount() == 0) {
                return;
            }
            for (Node child : n.getChildren()) {
                this.visit((ASTNode)child);
            }
        }

        private void analyze() {
            this.visit(this.onClause);
            if (this.tableNamesFound.size() > 2) {
                throw new IllegalArgumentException("Found > 2 table refs in ON clause.  Found " + this.tableNamesFound + " in " + this.onClauseAsString);
            }
            this.handleUnresolvedColumns();
            if (this.tableNamesFound.size() > 2) {
                throw new IllegalArgumentException("Found > 2 table refs in ON clause (incl unresolved).  Found " + this.tableNamesFound + " in " + this.onClauseAsString);
            }
        }

        private void handleUnresolvedColumns() {
            if (this.unresolvedColumns.isEmpty()) {
                return;
            }
            block0: for (String c : this.unresolvedColumns) {
                for (FieldSchema fs : this.allTargetTableColumns) {
                    if (!c.equalsIgnoreCase(fs.getName())) continue;
                    this.addColumn2Table(this.targetTableNameInSourceQuery.toLowerCase(), c);
                    continue block0;
                }
            }
        }

        private void addColumn2Table(String tableName, String columnName) {
            tableName = tableName.toLowerCase();
            this.tableNamesFound.add(tableName);
            List<String> cols = this.table2column.get(tableName);
            if (cols == null) {
                cols = new ArrayList<String>();
                this.table2column.put(tableName, cols);
            }
            cols.add(columnName);
        }

        private String getPredicate() {
            List<String> targetCols = this.table2column.get(this.targetTableNameInSourceQuery.toLowerCase());
            if (targetCols == null) {
                throw new IllegalArgumentException(ErrorMsg.INVALID_TABLE_IN_ON_CLAUSE_OF_MERGE.format(this.targetTableNameInSourceQuery, this.onClauseAsString));
            }
            StringBuilder sb = new StringBuilder();
            for (String col : targetCols) {
                if (sb.length() > 0) {
                    sb.append(" AND ");
                }
                sb.append(HiveUtils.unparseIdentifier(this.targetTableNameInSourceQuery, this.conf)).append(".").append(HiveUtils.unparseIdentifier(col, this.conf)).append(" IS NULL");
            }
            return sb.toString();
        }
    }
}

