/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import org.antlr.runtime.CommonToken;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenRewriteStream;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.CommonTreeAdaptor;
import org.antlr.runtime.tree.TreeAdaptor;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.parse.ASTErrorNode;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.GenericHiveLexer;
import org.apache.hadoop.hive.ql.parse.HintParser;
import org.apache.hadoop.hive.ql.parse.HiveParser;
import org.apache.hadoop.hive.ql.parse.HiveParser_IdentifiersParser;
import org.apache.hadoop.hive.ql.parse.HiveParser_ResourcePlanParser;
import org.apache.hadoop.hive.ql.parse.HiveParser_SelectClauseParser;
import org.apache.hadoop.hive.ql.parse.ImmutableCommonToken;
import org.apache.hadoop.hive.ql.parse.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParseDriver {
    private static final Logger LOG = LoggerFactory.getLogger(ParseDriver.class);
    public static final TreeAdaptor adaptor = new CommonTreeAdaptor(){

        public Object create(Token payload) {
            return new ASTNode(payload);
        }

        public Token createToken(int tokenType, String text) {
            if (tokenType == 1063) {
                return new CommonToken(tokenType, text);
            }
            return new ImmutableCommonToken(tokenType, text);
        }

        public Object dupNode(Object t) {
            return this.create(((CommonTree)t).token);
        }

        public Object dupTree(Object t, Object parent) {
            ASTNode astNode = (ASTNode)t;
            ASTNode astNodeCopy = (ASTNode)super.dupTree(t, parent);
            astNodeCopy.setTokenStartIndex(astNode.getTokenStartIndex());
            astNodeCopy.setTokenStopIndex(astNode.getTokenStopIndex());
            return astNodeCopy;
        }

        public Object errorNode(TokenStream input, Token start, Token stop, RecognitionException e) {
            return new ASTErrorNode(input, start, stop, e);
        }
    };

    public ASTNode parse(String command) throws ParseException {
        return this.parse(command, null);
    }

    public ASTNode parse(String command, Context ctx) throws ParseException {
        return this.parse(command, ctx, null);
    }

    public ASTNode parse(String command, Context ctx, String viewFullyQualifiedName) throws ParseException {
        HiveParser.statement_return r;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Parsing command: " + command);
        }
        Configuration configuration = ctx == null ? null : ctx.getConf();
        GenericHiveLexer lexer = GenericHiveLexer.of(command, configuration);
        TokenRewriteStream tokens = new TokenRewriteStream((TokenSource)lexer);
        if (ctx != null) {
            if (viewFullyQualifiedName == null) {
                ctx.setTokenRewriteStream(tokens);
            } else {
                ctx.addViewTokenRewriteStream(viewFullyQualifiedName, tokens);
            }
        }
        HiveParser parser = new HiveParser((TokenStream)tokens);
        parser.setTreeAdaptor(adaptor);
        parser.setHiveConf(configuration);
        try {
            r = parser.statement();
        }
        catch (RecognitionException e) {
            throw new ParseException(parser.errors);
        }
        if (lexer.getErrors().size() != 0 || parser.errors.size() != 0) {
            if (lexer.getErrors().size() != 0) {
                throw new ParseException(lexer.getErrors());
            }
            throw new ParseException(parser.errors);
        }
        LOG.debug("Parse Completed");
        ASTNode tree = (ASTNode)r.getTree();
        tree.setUnknownTokenBoundaries();
        return tree;
    }

    public ASTNode parseHint(String command) throws ParseException {
        LOG.debug("Parsing hint: {}", (Object)command);
        GenericHiveLexer lexer = GenericHiveLexer.of(command, null);
        TokenRewriteStream tokens = new TokenRewriteStream((TokenSource)lexer);
        HintParser parser = new HintParser((TokenStream)tokens);
        parser.setTreeAdaptor(adaptor);
        HintParser.hint_return r = null;
        try {
            r = parser.hint();
        }
        catch (RecognitionException e) {
            throw new ParseException(parser.errors);
        }
        if (lexer.getErrors().size() != 0 || parser.errors.size() != 0) {
            if (lexer.getErrors().size() != 0) {
                throw new ParseException(lexer.getErrors());
            }
            throw new ParseException(parser.errors);
        }
        LOG.debug("Parse Completed");
        return r.getTree();
    }

    public ASTNode parseSelect(String command, Context ctx) throws ParseException {
        HiveParser_SelectClauseParser.selectClause_return r;
        LOG.debug("Parsing command: {}", (Object)command);
        Configuration configuration = ctx == null ? null : ctx.getConf();
        GenericHiveLexer lexer = GenericHiveLexer.of(command, configuration);
        TokenRewriteStream tokens = new TokenRewriteStream((TokenSource)lexer);
        if (ctx != null) {
            ctx.setTokenRewriteStream(tokens);
        }
        HiveParser parser = new HiveParser((TokenStream)tokens);
        parser.setTreeAdaptor(adaptor);
        parser.setHiveConf(configuration);
        try {
            r = parser.selectClause();
        }
        catch (RecognitionException e) {
            throw new ParseException(parser.errors);
        }
        if (lexer.getErrors().size() != 0 || parser.errors.size() != 0) {
            if (lexer.getErrors().size() != 0) {
                throw new ParseException(lexer.getErrors());
            }
            throw new ParseException(parser.errors);
        }
        LOG.debug("Parse Completed");
        return (ASTNode)r.getTree();
    }

    public ASTNode parseExpression(String command) throws ParseException {
        HiveParser_IdentifiersParser.expression_return r;
        LOG.debug("Parsing expression: {}", (Object)command);
        GenericHiveLexer lexer = GenericHiveLexer.of(command, null);
        TokenRewriteStream tokens = new TokenRewriteStream((TokenSource)lexer);
        HiveParser parser = new HiveParser((TokenStream)tokens);
        parser.setTreeAdaptor(adaptor);
        try {
            r = parser.expression();
        }
        catch (RecognitionException e) {
            throw new ParseException(parser.errors);
        }
        if (lexer.getErrors().size() != 0 || parser.errors.size() != 0) {
            if (lexer.getErrors().size() != 0) {
                throw new ParseException(lexer.getErrors());
            }
            throw new ParseException(parser.errors);
        }
        LOG.debug("Parse Completed");
        return (ASTNode)r.getTree();
    }

    public ASTNode parseTriggerExpression(String command) throws ParseException {
        HiveParser_ResourcePlanParser.triggerExpressionStandalone_return r;
        GenericHiveLexer lexer = GenericHiveLexer.of(command, null);
        TokenRewriteStream tokens = new TokenRewriteStream((TokenSource)lexer);
        HiveParser parser = new HiveParser((TokenStream)tokens);
        parser.setTreeAdaptor(adaptor);
        try {
            r = parser.triggerExpressionStandalone();
        }
        catch (RecognitionException e) {
            throw new ParseException(parser.errors);
        }
        if (lexer.getErrors().size() != 0) {
            throw new ParseException(lexer.getErrors());
        }
        if (parser.errors.size() != 0) {
            throw new ParseException(parser.errors);
        }
        return (ASTNode)r.getTree();
    }

    public ASTNode parseTriggerActionExpression(String command) throws ParseException {
        HiveParser_ResourcePlanParser.triggerActionExpressionStandalone_return r;
        GenericHiveLexer lexer = GenericHiveLexer.of(command, null);
        TokenRewriteStream tokens = new TokenRewriteStream((TokenSource)lexer);
        HiveParser parser = new HiveParser((TokenStream)tokens);
        parser.setTreeAdaptor(adaptor);
        try {
            r = parser.triggerActionExpressionStandalone();
        }
        catch (RecognitionException e) {
            throw new ParseException(parser.errors);
        }
        if (lexer.getErrors().size() != 0) {
            throw new ParseException(lexer.getErrors());
        }
        if (parser.errors.size() != 0) {
            throw new ParseException(parser.errors);
        }
        return (ASTNode)r.getTree();
    }
}

