/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import com.google.common.base.Function;
import java.util.Map;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.plan.PlanUtils;

public class ReplicationSpec {
    private boolean isInReplicationScope = false;
    private boolean isMetadataOnly = false;
    private String eventId = null;
    private String currStateId = null;
    private boolean isNoop = false;
    private boolean isReplace = true;
    private String validWriteIdList = null;
    private String validTxnList = null;
    private Type specType = Type.DEFAULT;
    private boolean needDupCopyCheck = false;
    private boolean isRepl = false;
    private boolean isMetadataOnlyForExternalTables = false;

    public void setInReplicationScope(boolean inReplicationScope) {
        this.isInReplicationScope = inReplicationScope;
    }

    public ReplicationSpec(ASTNode node) {
        if (node != null) {
            if (ReplicationSpec.isApplicable(node)) {
                this.init(node);
                return;
            }
            for (int i = 1; i < node.getChildCount(); ++i) {
                ASTNode child = (ASTNode)node.getChild(i);
                if (!ReplicationSpec.isApplicable(child)) continue;
                this.init(child);
                return;
            }
        }
    }

    public ReplicationSpec() {
        this((ASTNode)null);
    }

    public ReplicationSpec(String fromId, String toId) {
        this(true, false, fromId, toId, false, false);
    }

    public ReplicationSpec(boolean isInReplicationScope, boolean isMetadataOnly, String eventReplicationState, String currentReplicationState, boolean isNoop, boolean isReplace) {
        this.setInReplicationScope(isInReplicationScope);
        this.isMetadataOnly = isMetadataOnly;
        this.eventId = eventReplicationState;
        this.currStateId = currentReplicationState;
        this.isNoop = isNoop;
        this.isReplace = isReplace;
        this.specType = Type.DEFAULT;
    }

    public ReplicationSpec(Function<String, String> keyFetcher) {
        String scope = keyFetcher.apply(KEY.REPL_SCOPE.toString());
        this.setInReplicationScope(false);
        this.isMetadataOnly = false;
        this.specType = Type.DEFAULT;
        if (scope != null) {
            if (scope.equalsIgnoreCase("metadata")) {
                this.isMetadataOnly = true;
                this.setInReplicationScope(true);
            } else if (scope.equalsIgnoreCase("all")) {
                this.setInReplicationScope(true);
            }
        }
        this.eventId = keyFetcher.apply(KEY.EVENT_ID.toString());
        this.currStateId = keyFetcher.apply(KEY.CURR_STATE_ID.toString());
        this.isNoop = Boolean.parseBoolean(keyFetcher.apply(KEY.NOOP.toString()));
        this.isReplace = Boolean.parseBoolean(keyFetcher.apply(KEY.IS_REPLACE.toString()));
        this.validWriteIdList = keyFetcher.apply(KEY.VALID_WRITEID_LIST.toString());
        this.validTxnList = keyFetcher.apply(KEY.VALID_TXN_LIST.toString());
    }

    public static boolean isApplicable(ASTNode node) {
        return node.getToken().getType() == 1033;
    }

    public boolean allowReplacement(String currReplState, String replacementReplState) {
        if (currReplState == null || currReplState.isEmpty()) {
            return true;
        }
        if (replacementReplState == null || replacementReplState.isEmpty()) {
            return false;
        }
        long currReplStateLong = Long.parseLong(currReplState.replaceAll("\\D", ""));
        long replacementReplStateLong = Long.parseLong(replacementReplState.replaceAll("\\D", ""));
        if (this.specType == Type.IMPORT) {
            return currReplStateLong <= replacementReplStateLong;
        }
        return currReplStateLong < replacementReplStateLong;
    }

    public boolean allowReplacementInto(Map<String, String> params) {
        return this.allowReplacement(ReplicationSpec.getLastReplicatedStateFromParameters(params), this.getCurrentReplicationState());
    }

    public boolean allowEventReplacementInto(Map<String, String> params) {
        return this.allowReplacement(ReplicationSpec.getLastReplicatedStateFromParameters(params), this.getReplicationState());
    }

    private void init(ASTNode node) {
        this.setInReplicationScope(true);
        this.eventId = PlanUtils.stripQuotes(node.getChild(0).getText());
        if (node.getChildCount() > 1 && node.getChild(1).getText().toLowerCase().equals("metadata")) {
            this.isMetadataOnly = true;
            try {
                if (Long.parseLong(this.eventId) >= 0L) {
                    this.currStateId = this.eventId;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static String getLastReplicatedStateFromParameters(Map<String, String> m) {
        if (m != null && m.containsKey(KEY.CURR_STATE_ID.toString())) {
            return m.get(KEY.CURR_STATE_ID.toString());
        }
        return null;
    }

    public Type getReplSpecType() {
        return this.specType;
    }

    public void setReplSpecType(Type specType) {
        this.specType = specType;
    }

    public boolean isInReplicationScope() {
        return this.isInReplicationScope;
    }

    public boolean isMetadataOnly() {
        return this.isMetadataOnly;
    }

    public void setIsMetadataOnly(boolean isMetadataOnly) {
        this.isMetadataOnly = isMetadataOnly;
    }

    public boolean isMetadataOnlyForExternalTables() {
        return this.isMetadataOnlyForExternalTables;
    }

    public void setMetadataOnlyForExternalTables(boolean metadataOnlyForExternalTables) {
        this.isMetadataOnlyForExternalTables = metadataOnlyForExternalTables;
    }

    public boolean isReplace() {
        return this.isReplace;
    }

    public void setIsReplace(boolean isReplace) {
        this.isReplace = isReplace;
    }

    public String getReplicationState() {
        return this.eventId;
    }

    public String getCurrentReplicationState() {
        return this.currStateId;
    }

    public void setCurrentReplicationState(String currStateId) {
        this.currStateId = currStateId;
    }

    public boolean isNoop() {
        return this.isNoop;
    }

    public void setNoop(boolean isNoop) {
        this.isNoop = isNoop;
    }

    public String getValidWriteIdList() {
        return this.validWriteIdList;
    }

    public void setValidWriteIdList(String validWriteIdList) {
        this.validWriteIdList = validWriteIdList;
    }

    public String getValidTxnList() {
        return this.validTxnList;
    }

    public void setValidTxnList(String validTxnList) {
        this.validTxnList = validTxnList;
    }

    public boolean isTransactionalTableDump() {
        return this.validWriteIdList != null;
    }

    public String get(KEY key) {
        switch (key) {
            case REPL_SCOPE: {
                switch (this.getScope()) {
                    case MD_ONLY: {
                        return "metadata";
                    }
                    case REPL: {
                        return "all";
                    }
                    case NO_REPL: {
                        return "none";
                    }
                }
            }
            case EVENT_ID: {
                return this.getReplicationState();
            }
            case CURR_STATE_ID: {
                return this.getCurrentReplicationState();
            }
            case NOOP: {
                return String.valueOf(this.isNoop());
            }
            case IS_REPLACE: {
                return String.valueOf(this.isReplace());
            }
            case VALID_WRITEID_LIST: {
                return this.getValidWriteIdList();
            }
            case VALID_TXN_LIST: {
                return this.getValidTxnList();
            }
        }
        return null;
    }

    public SCOPE getScope() {
        if (this.isInReplicationScope()) {
            if (this.isMetadataOnly()) {
                return SCOPE.MD_ONLY;
            }
            return SCOPE.REPL;
        }
        return SCOPE.NO_REPL;
    }

    public static void copyLastReplId(Map<String, String> srcParameter, Map<String, String> destParameter) {
        String lastReplId = srcParameter.get(KEY.CURR_STATE_ID.toString());
        if (lastReplId != null) {
            destParameter.put(KEY.CURR_STATE_ID.toString(), lastReplId);
        }
    }

    public boolean needDupCopyCheck() {
        return this.needDupCopyCheck;
    }

    public void setNeedDupCopyCheck(boolean isFirstIncPending) {
        this.needDupCopyCheck = isFirstIncPending;
    }

    public boolean isRepl() {
        return this.isRepl;
    }

    public void setRepl(boolean repl) {
        this.isRepl = repl;
    }

    public static enum Type {
        DEFAULT,
        INCREMENTAL_DUMP,
        IMPORT;

    }

    public static enum SCOPE {
        NO_REPL,
        MD_ONLY,
        REPL;

    }

    public static enum KEY {
        REPL_SCOPE("repl.scope"),
        EVENT_ID("repl.event.id"),
        CURR_STATE_ID("repl.last.id"),
        NOOP("repl.noop"),
        IS_REPLACE("repl.is.replace"),
        VALID_WRITEID_LIST("repl.valid.writeid.list"),
        VALID_TXN_LIST("repl.valid.txnid.list");

        private final String keyName;

        private KEY(String s) {
            this.keyName = s;
        }

        public String toString() {
            return this.keyName;
        }
    }
}

