/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.io.IOException;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.runtime.TokenRewriteStream;
import org.antlr.runtime.tree.Tree;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.hooks.Entity;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveUtils;
import org.apache.hadoop.hive.ql.metadata.InvalidTableException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.metadata.VirtualColumn;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.CalcitePlanner;
import org.apache.hadoop.hive.ql.parse.ColumnAccessInfo;
import org.apache.hadoop.hive.ql.parse.ParseException;
import org.apache.hadoop.hive.ql.parse.ParseUtils;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RewriteSemanticAnalyzer
extends CalcitePlanner {
    protected static final Logger LOG = LoggerFactory.getLogger(RewriteSemanticAnalyzer.class);
    protected boolean useSuper = false;
    protected static final String INDENT = "  ";
    private IdentifierQuoter quotedIdentifierHelper;
    private Table targetTable;
    private String targetTableFullName;

    RewriteSemanticAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    public void analyzeInternal(ASTNode tree) throws SemanticException {
        if (this.useSuper) {
            super.analyzeInternal(tree);
        } else {
            if (!this.getTxnMgr().supportsAcid()) {
                throw new SemanticException(ErrorMsg.ACID_OP_ON_NONACID_TXNMGR.getMsg());
            }
            this.quotedIdentifierHelper = new IdentifierQuoter(this.ctx.getTokenRewriteStream());
            this.analyze(tree);
            this.cleanUpMetaColumnAccessControl();
        }
    }

    protected abstract ASTNode getTargetTableNode(ASTNode var1);

    private void analyze(ASTNode tree) throws SemanticException {
        ASTNode tableName = this.getTargetTableNode(tree);
        this.targetTableFullName = this.getFullTableNameForSQL(tableName);
        this.targetTable = RewriteSemanticAnalyzer.getTable(tableName, this.db, true);
        this.validateTargetTable(this.targetTable);
        this.analyze(tree, this.targetTable, tableName);
    }

    protected abstract void analyze(ASTNode var1, Table var2, ASTNode var3) throws SemanticException;

    public void analyzeRewrittenTree(ASTNode rewrittenTree, Context rewrittenCtx) throws SemanticException {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Rewritten AST {}", (Object)rewrittenTree.dump());
            }
            this.useSuper = true;
            super.analyze(rewrittenTree, rewrittenCtx);
        }
        finally {
            this.useSuper = false;
        }
    }

    protected void addPartitionColsToSelect(List<FieldSchema> partCols, StringBuilder rewrittenQueryStr) throws SemanticException {
        if (partCols != null) {
            for (FieldSchema fschema : partCols) {
                rewrittenQueryStr.append(", ");
                rewrittenQueryStr.append(HiveUtils.unparseIdentifier(fschema.getName(), this.conf));
            }
        }
    }

    protected void addPartitionColsToSelect(List<FieldSchema> partCols, StringBuilder rewrittenQueryStr, ASTNode target) throws SemanticException {
        this.addPartitionColsToSelect(partCols, rewrittenQueryStr, this.getSimpleTableName(target));
    }

    protected void addPartitionColsToSelect(List<FieldSchema> partCols, StringBuilder rewrittenQueryStr, String alias) {
        if (partCols != null) {
            for (FieldSchema fschema : partCols) {
                rewrittenQueryStr.append(", ");
                rewrittenQueryStr.append(alias).append('.');
                rewrittenQueryStr.append(HiveUtils.unparseIdentifier(fschema.getName(), this.conf));
            }
        }
    }

    protected void addPartitionColsAsValues(List<FieldSchema> partCols, String alias, List<String> values) {
        if (partCols == null) {
            return;
        }
        partCols.forEach(fieldSchema -> values.add(alias + "." + HiveUtils.unparseIdentifier(fieldSchema.getName(), this.conf)));
    }

    protected void checkValidSetClauseTarget(ASTNode colName, Table targetTable) throws SemanticException {
        String columnName = RewriteSemanticAnalyzer.normalizeColName(colName.getText());
        for (FieldSchema fschema : targetTable.getPartCols()) {
            if (!fschema.getName().equalsIgnoreCase(columnName)) continue;
            throw new SemanticException(ErrorMsg.UPDATE_CANNOT_UPDATE_PART_VALUE.getMsg());
        }
        if (targetTable.getBucketCols() != null && targetTable.getBucketCols().contains(columnName)) {
            throw new SemanticException(ErrorMsg.UPDATE_CANNOT_UPDATE_BUCKET_VALUE, columnName);
        }
        boolean foundColumnInTargetTable = false;
        for (FieldSchema col : targetTable.getCols()) {
            if (!columnName.equalsIgnoreCase(col.getName())) continue;
            foundColumnInTargetTable = true;
            break;
        }
        if (!foundColumnInTargetTable) {
            throw new SemanticException(ErrorMsg.INVALID_TARGET_COLUMN_IN_SET_CLAUSE, colName.getText(), targetTable.getFullyQualifiedName());
        }
    }

    protected ASTNode findLHSofAssignment(ASTNode assignment) {
        assert (assignment.getToken().getType() == 18) : "Expected set assignments to use equals operator but found " + assignment.getName();
        ASTNode tableOrColTok = (ASTNode)assignment.getChildren().get(0);
        assert (tableOrColTok.getToken().getType() == 1133) : "Expected left side of assignment to be table or column";
        ASTNode colName = (ASTNode)tableOrColTok.getChildren().get(0);
        assert (colName.getToken().getType() == 24) : "Expected column name";
        return colName;
    }

    protected Map<String, ASTNode> collectSetColumnsAndExpressions(ASTNode setClause, Set<String> setRCols, Table targetTable) throws SemanticException {
        assert (setClause.getToken().getType() == 1065) : "Expected second child of update token to be set token";
        List<Node> assignments = setClause.getChildren();
        LinkedHashMap<String, ASTNode> setCols = new LinkedHashMap<String, ASTNode>(assignments.size());
        for (Node a : assignments) {
            ASTNode assignment = (ASTNode)a;
            ASTNode colName = this.findLHSofAssignment(assignment);
            if (setRCols != null) {
                this.addSetRCols((ASTNode)assignment.getChildren().get(1), setRCols);
            }
            this.checkValidSetClauseTarget(colName, targetTable);
            String columnName = RewriteSemanticAnalyzer.normalizeColName(colName.getText());
            setCols.put(columnName, (ASTNode)assignment.getChildren().get(1));
        }
        return setCols;
    }

    protected static Table getTable(ASTNode tabRef, Hive db, boolean throwException) throws SemanticException {
        Table mTable;
        TableName tableName;
        switch (tabRef.getType()) {
            case 1137: {
                tableName = RewriteSemanticAnalyzer.getQualifiedTableName((ASTNode)tabRef.getChild(0));
                break;
            }
            case 1136: {
                tableName = RewriteSemanticAnalyzer.getQualifiedTableName(tabRef);
                break;
            }
            default: {
                throw RewriteSemanticAnalyzer.raiseWrongType("TOK_TABREF|TOK_TABNAME", tabRef);
            }
        }
        try {
            mTable = db.getTable(tableName.getDb(), tableName.getTable(), throwException);
        }
        catch (InvalidTableException e) {
            LOG.error("Failed to find table " + tableName.getNotEmptyDbTable() + " got exception " + e.getMessage());
            throw new SemanticException(ErrorMsg.INVALID_TABLE.getMsg(tableName.getNotEmptyDbTable()), e);
        }
        catch (HiveException e) {
            LOG.error("Failed to find table " + tableName.getNotEmptyDbTable() + " got exception " + e.getMessage());
            throw new SemanticException(e.getMessage(), e);
        }
        return mTable;
    }

    protected void markReadEntityForUpdate() {
        for (ReadEntity input : this.inputs) {
            if (!this.isWritten(input)) continue;
            input.setUpdateOrDelete(true);
        }
    }

    protected void setUpAccessControlInfoForUpdate(Table mTable, Map<String, ASTNode> setCols) {
        ColumnAccessInfo cai = new ColumnAccessInfo();
        for (String colName : setCols.keySet()) {
            cai.add(Table.getCompleteName(mTable.getDbName(), mTable.getTableName()), colName);
        }
        this.setUpdateColumnAccessInfo(cai);
    }

    private void cleanUpMetaColumnAccessControl() {
        if (this.columnAccessInfo != null) {
            this.columnAccessInfo.stripVirtualColumn(VirtualColumn.ROWID);
        }
    }

    protected ReparseResult parseRewrittenQuery(StringBuilder rewrittenQueryStr, String originalQuery) throws SemanticException {
        ASTNode rewrittenTree;
        Context rewrittenCtx;
        HiveConf.setVar(this.conf, HiveConf.ConfVars.DYNAMICPARTITIONINGMODE, "nonstrict");
        HiveConf.setBoolVar(this.conf, HiveConf.ConfVars.LLAP_IO_ROW_WRAPPER_ENABLED, false);
        try {
            rewrittenCtx = new Context(this.conf);
            rewrittenCtx.setHDFSCleanup(true);
            this.ctx.addSubContext(rewrittenCtx);
        }
        catch (IOException e) {
            throw new SemanticException(ErrorMsg.UPDATEDELETE_IO_ERROR.getMsg());
        }
        rewrittenCtx.setExplainConfig(this.ctx.getExplainConfig());
        rewrittenCtx.setExplainPlan(this.ctx.isExplainPlan());
        rewrittenCtx.setStatsSource(this.ctx.getStatsSource());
        rewrittenCtx.setPlanMapper(this.ctx.getPlanMapper());
        rewrittenCtx.setIsUpdateDeleteMerge(true);
        rewrittenCtx.setCmd(rewrittenQueryStr.toString());
        try {
            LOG.info("Going to reparse <" + originalQuery + "> as \n<" + rewrittenQueryStr.toString() + ">");
            rewrittenTree = ParseUtils.parse(rewrittenQueryStr.toString(), rewrittenCtx);
        }
        catch (ParseException e) {
            throw new SemanticException(ErrorMsg.UPDATEDELETE_PARSE_ERROR.getMsg(), e);
        }
        return new ReparseResult(rewrittenTree, rewrittenCtx);
    }

    protected void validateTargetTable(Table mTable) throws SemanticException {
        if (mTable.getTableType() == TableType.VIRTUAL_VIEW || mTable.getTableType() == TableType.MATERIALIZED_VIEW) {
            LOG.error("Table " + mTable.getFullyQualifiedName() + " is a view or materialized view");
            throw new SemanticException(ErrorMsg.UPDATE_DELETE_VIEW.getMsg());
        }
    }

    private boolean isWritten(Entity readEntity) {
        for (Entity writeEntity : this.outputs) {
            if (!writeEntity.toString().equalsIgnoreCase(readEntity.toString())) continue;
            return true;
        }
        return false;
    }

    private void addSetRCols(ASTNode node, Set<String> setRCols) {
        if (node.getToken().getType() == 1133) {
            ASTNode colName = (ASTNode)node.getChildren().get(0);
            if (colName.getToken().getType() == 868) {
                return;
            }
            assert (colName.getToken().getType() == 24) : "Expected column name";
            setRCols.add(RewriteSemanticAnalyzer.normalizeColName(colName.getText()));
        } else if (node.getChildren() != null) {
            for (Node n : node.getChildren()) {
                this.addSetRCols((ASTNode)n, setRCols);
            }
        }
    }

    private static String normalizeColName(String colName) {
        return colName.toLowerCase();
    }

    protected void updateOutputs(Table targetTable) {
        List<ReadEntity> partitionsRead;
        this.markReadEntityForUpdate();
        if (targetTable.isPartitioned() && !(partitionsRead = this.getRestrictedPartitionSet(targetTable)).isEmpty()) {
            ArrayList<WriteEntity> toRemove = new ArrayList<WriteEntity>();
            for (WriteEntity we : this.outputs) {
                WriteEntity.WriteType wt = we.getWriteType();
                if (!this.isTargetTable(we, targetTable) || wt != WriteEntity.WriteType.UPDATE && wt != WriteEntity.WriteType.DELETE) continue;
                toRemove.add(we);
            }
            this.outputs.removeAll(toRemove);
            for (ReadEntity re : partitionsRead) {
                for (WriteEntity original : toRemove) {
                    WriteEntity we = new WriteEntity(re.getPartition(), original.getWriteType());
                    we.setDynamicPartitionWrite(original.isDynamicPartitionWrite());
                    this.outputs.add(we);
                }
            }
        }
    }

    private List<ReadEntity> getRestrictedPartitionSet(Table targetTable) {
        ArrayList<ReadEntity> partitionsRead = new ArrayList<ReadEntity>();
        for (ReadEntity re : this.inputs) {
            if (!re.isFromTopLevelQuery || re.getType() != Entity.Type.PARTITION || !this.isTargetTable(re, targetTable)) continue;
            partitionsRead.add(re);
        }
        return partitionsRead;
    }

    private boolean isTargetTable(Entity entity, Table targetTable) {
        return targetTable.equalsWithIgnoreWriteId(entity.getTable());
    }

    protected String getSimpleTableName(ASTNode n) throws SemanticException {
        return HiveUtils.unparseIdentifier(this.getSimpleTableNameBase(n), this.conf);
    }

    protected String getSimpleTableNameBase(ASTNode n) throws SemanticException {
        switch (n.getType()) {
            case 1137: {
                int aliasIndex = this.findTabRefIdxs(n)[0];
                if (aliasIndex != 0) {
                    return n.getChild(aliasIndex).getText();
                }
                return this.getSimpleTableNameBase((ASTNode)n.getChild(0));
            }
            case 1136: {
                if (n.getChildCount() == 2) {
                    return n.getChild(1).getText();
                }
                return n.getChild(0).getText();
            }
            case 1100: {
                return n.getChild(1).getText();
            }
        }
        throw RewriteSemanticAnalyzer.raiseWrongType("TOK_TABREF|TOK_TABNAME|TOK_SUBQUERY", n);
    }

    protected void patchProjectionForUpdate(ASTNode insertBranch, Map<Integer, ASTNode> setColExprs) {
        ASTNode rewrittenSelect = (ASTNode)insertBranch.getChildren().get(1);
        assert (rewrittenSelect.getToken().getType() == 1056) : "Expected TOK_SELECT as second child of TOK_INSERT but found " + rewrittenSelect.getName();
        for (Map.Entry<Integer, ASTNode> entry : setColExprs.entrySet()) {
            ASTNode selExpr = (ASTNode)rewrittenSelect.getChildren().get(entry.getKey());
            assert (selExpr.getToken().getType() == 1058) : "Expected child of TOK_SELECT to be TOK_SELEXPR but was " + selExpr.getName();
            selExpr.setChild(0, (Tree)entry.getValue());
        }
    }

    protected StringBuilder createRewrittenQueryStrBuilder() {
        return new StringBuilder("FROM\n");
    }

    protected void appendTarget(StringBuilder rewrittenQueryStr, ASTNode target, String targetName) {
        rewrittenQueryStr.append(INDENT).append(this.targetTableFullName);
        if (this.isAliased(target)) {
            rewrittenQueryStr.append(" ").append(targetName);
        }
        rewrittenQueryStr.append('\n');
    }

    protected boolean isAliased(ASTNode n) {
        switch (n.getType()) {
            case 1137: {
                return this.findTabRefIdxs(n)[0] != 0;
            }
            case 1136: {
                return false;
            }
            case 1100: {
                assert (n.getChildCount() > 1) : "Expected Derived Table to be aliased";
                return true;
            }
        }
        throw RewriteSemanticAnalyzer.raiseWrongType("TOK_TABREF|TOK_TABNAME", n);
    }

    protected void appendInsertBranch(StringBuilder rewrittenQueryStr, String hintStr, List<String> values) {
        rewrittenQueryStr.append("INSERT INTO ").append(this.targetTableFullName);
        this.addPartitionColsToInsert(this.targetTable.getPartCols(), rewrittenQueryStr);
        rewrittenQueryStr.append("\n");
        rewrittenQueryStr.append(INDENT);
        rewrittenQueryStr.append("SELECT ");
        if (StringUtils.isNotBlank(hintStr)) {
            rewrittenQueryStr.append(hintStr);
        }
        rewrittenQueryStr.append(StringUtils.join(values, ","));
        rewrittenQueryStr.append("\n");
    }

    protected void appendDeleteBranch(StringBuilder rewrittenQueryStr, String hintStr, String alias, List<String> values) {
        ArrayList<String> deleteValues = new ArrayList<String>(this.targetTable.getPartCols().size() + values.size());
        deleteValues.addAll(values);
        this.addPartitionColsAsValues(this.targetTable.getPartCols(), alias, deleteValues);
        this.appendInsertBranch(rewrittenQueryStr, hintStr, deleteValues);
    }

    protected void appendSortBy(StringBuilder rewrittenQueryStr, List<String> keys) {
        rewrittenQueryStr.append(INDENT).append("SORT BY ");
        rewrittenQueryStr.append(StringUtils.join(keys, ","));
        rewrittenQueryStr.append("\n");
    }

    protected String getMatchedText(ASTNode n) {
        this.quotedIdentifierHelper.visit(n);
        return this.ctx.getTokenRewriteStream().toString(n.getTokenStartIndex(), n.getTokenStopIndex() + 1).trim();
    }

    private static class IdentifierQuoter {
        private final TokenRewriteStream trs;
        private final IdentityHashMap<ASTNode, ASTNode> visitedNodes = new IdentityHashMap();

        IdentifierQuoter(TokenRewriteStream trs) {
            this.trs = trs;
            if (trs == null) {
                throw new IllegalArgumentException("Must have a TokenRewriteStream");
            }
        }

        private void visit(ASTNode n) {
            if (n.getType() == 24) {
                if (this.visitedNodes.containsKey(n)) {
                    return;
                }
                this.visitedNodes.put(n, n);
                this.trs.insertBefore(n.getToken(), (Object)"`");
                this.trs.insertAfter(n.getToken(), (Object)"`");
            }
            if (n.getChildCount() <= 0) {
                return;
            }
            for (Node c : n.getChildren()) {
                this.visit((ASTNode)c);
            }
        }
    }

    protected static final class ReparseResult {
        final ASTNode rewrittenTree;
        final Context rewrittenCtx;

        ReparseResult(ASTNode n, Context c) {
            this.rewrittenTree = n;
            this.rewrittenCtx = c;
        }
    }
}

