/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.exec.AppMasterEventOperator;
import org.apache.hadoop.hive.ql.exec.CommonMergeJoinOperator;
import org.apache.hadoop.hive.ql.exec.ConditionalTask;
import org.apache.hadoop.hive.ql.exec.DummyStoreOperator;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.FilterOperator;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.GroupByOperator;
import org.apache.hadoop.hive.ql.exec.JoinOperator;
import org.apache.hadoop.hive.ql.exec.MapJoinOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorUtils;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.SelectOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TerminalOperator;
import org.apache.hadoop.hive.ql.exec.TezDummyStoreOperator;
import org.apache.hadoop.hive.ql.exec.TopNKeyOperator;
import org.apache.hadoop.hive.ql.exec.UnionOperator;
import org.apache.hadoop.hive.ql.exec.tez.TezTask;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.lib.CompositeProcessor;
import org.apache.hadoop.hive.ql.lib.DefaultGraphWalker;
import org.apache.hadoop.hive.ql.lib.DefaultRuleDispatcher;
import org.apache.hadoop.hive.ql.lib.ForwardWalker;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.PreOrderOnceWalker;
import org.apache.hadoop.hive.ql.lib.Rule;
import org.apache.hadoop.hive.ql.lib.RuleRegExp;
import org.apache.hadoop.hive.ql.log.PerfLogger;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.optimizer.BucketVersionPopulator;
import org.apache.hadoop.hive.ql.optimizer.ConstantPropagate;
import org.apache.hadoop.hive.ql.optimizer.ConstantPropagateProcCtx;
import org.apache.hadoop.hive.ql.optimizer.ConvertJoinMapJoin;
import org.apache.hadoop.hive.ql.optimizer.DynamicPartitionPruningOptimization;
import org.apache.hadoop.hive.ql.optimizer.MergeJoinProc;
import org.apache.hadoop.hive.ql.optimizer.NonBlockingOpDeDupProc;
import org.apache.hadoop.hive.ql.optimizer.ReduceSinkMapJoinProc;
import org.apache.hadoop.hive.ql.optimizer.RemoveDynamicPruningBySize;
import org.apache.hadoop.hive.ql.optimizer.SetHashGroupByMinReduction;
import org.apache.hadoop.hive.ql.optimizer.SetReducerParallelism;
import org.apache.hadoop.hive.ql.optimizer.SharedWorkOptimizer;
import org.apache.hadoop.hive.ql.optimizer.SortedDynPartitionOptimizer;
import org.apache.hadoop.hive.ql.optimizer.correlation.ReduceSinkDeDuplication;
import org.apache.hadoop.hive.ql.optimizer.correlation.ReduceSinkJoinDeDuplication;
import org.apache.hadoop.hive.ql.optimizer.metainfo.annotation.AnnotateWithOpTraits;
import org.apache.hadoop.hive.ql.optimizer.physical.AnnotateRunTimeStatsOptimizer;
import org.apache.hadoop.hive.ql.optimizer.physical.CrossProductHandler;
import org.apache.hadoop.hive.ql.optimizer.physical.LlapClusterStateForCompile;
import org.apache.hadoop.hive.ql.optimizer.physical.LlapDecider;
import org.apache.hadoop.hive.ql.optimizer.physical.LlapPreVectorizationPass;
import org.apache.hadoop.hive.ql.optimizer.physical.MemoryDecider;
import org.apache.hadoop.hive.ql.optimizer.physical.MetadataOnlyOptimizer;
import org.apache.hadoop.hive.ql.optimizer.physical.NullScanOptimizer;
import org.apache.hadoop.hive.ql.optimizer.physical.PhysicalContext;
import org.apache.hadoop.hive.ql.optimizer.physical.SerializeFilter;
import org.apache.hadoop.hive.ql.optimizer.physical.StageIDsRearranger;
import org.apache.hadoop.hive.ql.optimizer.physical.Vectorizer;
import org.apache.hadoop.hive.ql.optimizer.stats.annotation.AnnotateWithStatistics;
import org.apache.hadoop.hive.ql.optimizer.topnkey.TopNKeyProcessor;
import org.apache.hadoop.hive.ql.optimizer.topnkey.TopNKeyPushdownProcessor;
import org.apache.hadoop.hive.ql.parse.AppMasterEventProcessor;
import org.apache.hadoop.hive.ql.parse.FileSinkProcessor;
import org.apache.hadoop.hive.ql.parse.GenTezProcContext;
import org.apache.hadoop.hive.ql.parse.GenTezUtils;
import org.apache.hadoop.hive.ql.parse.GenTezWork;
import org.apache.hadoop.hive.ql.parse.GenTezWorkWalker;
import org.apache.hadoop.hive.ql.parse.GlobalLimitCtx;
import org.apache.hadoop.hive.ql.parse.OptimizeTezProcContext;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.ProcessAnalyzeTable;
import org.apache.hadoop.hive.ql.parse.RuntimeValuesInfo;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.SemiJoinBranchInfo;
import org.apache.hadoop.hive.ql.parse.TaskCompiler;
import org.apache.hadoop.hive.ql.parse.UnionProcessor;
import org.apache.hadoop.hive.ql.plan.AggregationDesc;
import org.apache.hadoop.hive.ql.plan.AppMasterEventDesc;
import org.apache.hadoop.hive.ql.plan.BaseWork;
import org.apache.hadoop.hive.ql.plan.ColStatistics;
import org.apache.hadoop.hive.ql.plan.DynamicPruningEventDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDescUtils;
import org.apache.hadoop.hive.ql.plan.ExprNodeDynamicValueDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.FileSinkDesc;
import org.apache.hadoop.hive.ql.plan.FilterDesc;
import org.apache.hadoop.hive.ql.plan.GroupByDesc;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.MoveWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.SelectDesc;
import org.apache.hadoop.hive.ql.plan.Statistics;
import org.apache.hadoop.hive.ql.plan.TezWork;
import org.apache.hadoop.hive.ql.plan.mapper.PlanMapper;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.stats.OperatorStats;
import org.apache.hadoop.hive.ql.stats.StatsUtils;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFBloomFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TezCompiler
extends TaskCompiler {
    protected static final Logger LOG = LoggerFactory.getLogger(TezCompiler.class);

    @Override
    public void init(QueryState queryState, SessionState.LogHelper console, Hive db) {
        super.init(queryState, console, db);
        HiveConf.setBoolVar(this.conf, HiveConf.ConfVars.HIVE_RPC_QUERY_PLAN, true);
        this.conf.setBoolean("mapred.input.dir.recursive", true);
    }

    @Override
    protected void optimizeOperatorPlan(ParseContext pCtx, Set<ReadEntity> inputs, Set<WriteEntity> outputs) throws SemanticException {
        PerfLogger perfLogger = SessionState.getPerfLogger();
        OptimizeTezProcContext procCtx = new OptimizeTezProcContext(this.conf, pCtx, inputs, outputs);
        perfLogger.PerfLogBegin(this.getClass().getName(), "TezCompiler");
        TezCompiler.runTopNKeyOptimization(procCtx);
        perfLogger.PerfLogEnd(this.getClass().getName(), "TezCompiler", "Run top n key optimization");
        perfLogger.PerfLogBegin(this.getClass().getName(), "TezCompiler");
        this.runDynamicPartitionPruning(procCtx, inputs, outputs);
        perfLogger.PerfLogEnd(this.getClass().getName(), "TezCompiler", "Setup dynamic partition pruning");
        if (procCtx.conf.getBoolVar(HiveConf.ConfVars.HIVEOPTCONSTANTPROPAGATION)) {
            new ConstantPropagate(ConstantPropagateProcCtx.ConstantPropagateOption.SHORTCUT).transform(procCtx.parseContext);
        }
        perfLogger.PerfLogBegin(this.getClass().getName(), "TezCompiler");
        this.runStatsAnnotation(procCtx);
        perfLogger.PerfLogEnd(this.getClass().getName(), "TezCompiler", "Setup stats in the operator plan");
        if (HiveConf.getBoolVar(procCtx.conf, HiveConf.ConfVars.DYNAMICPARTITIONING) && HiveConf.getVar(procCtx.conf, HiveConf.ConfVars.DYNAMICPARTITIONINGMODE).equals("nonstrict") && !HiveConf.getBoolVar(procCtx.conf, HiveConf.ConfVars.HIVEOPTLISTBUCKETING)) {
            perfLogger.PerfLogBegin(this.getClass().getName(), "TezCompiler");
            new SortedDynPartitionOptimizer().transform(procCtx.parseContext);
            perfLogger.PerfLogEnd(this.getClass().getName(), "TezCompiler", "Sorted dynamic partition optimization");
        }
        if (HiveConf.getBoolVar(procCtx.conf, HiveConf.ConfVars.HIVEOPTREDUCEDEDUPLICATION)) {
            perfLogger.PerfLogBegin(this.getClass().getName(), "TezCompiler");
            new ReduceSinkDeDuplication().transform(procCtx.parseContext);
            new NonBlockingOpDeDupProc().transform(procCtx.parseContext);
            perfLogger.PerfLogEnd(this.getClass().getName(), "TezCompiler", "Reduce Sink de-duplication");
        }
        perfLogger.PerfLogBegin(this.getClass().getName(), "TezCompiler");
        this.runStatsDependentOptimizations(procCtx, inputs, outputs);
        perfLogger.PerfLogEnd(this.getClass().getName(), "TezCompiler", "Run the optimizations that use stats for optimization");
        new BucketVersionPopulator().transform(pCtx);
        perfLogger.PerfLogBegin(this.getClass().getName(), "TezCompiler");
        if (procCtx.conf.getBoolVar(HiveConf.ConfVars.HIVEOPTJOINREDUCEDEDUPLICATION)) {
            new ReduceSinkJoinDeDuplication().transform(procCtx.parseContext);
        }
        perfLogger.PerfLogEnd(this.getClass().getName(), "TezCompiler", "Run reduce sink after join algorithm selection");
        this.semijoinRemovalBasedTransformations(procCtx, inputs, outputs);
        perfLogger.PerfLogBegin(this.getClass().getName(), "TezCompiler");
        if (procCtx.conf.getBoolVar(HiveConf.ConfVars.HIVE_SHARED_WORK_OPTIMIZATION)) {
            new SharedWorkOptimizer().transform(procCtx.parseContext);
        }
        perfLogger.PerfLogEnd(this.getClass().getName(), "TezCompiler", "Shared scans optimization");
        perfLogger.PerfLogBegin(this.getClass().getName(), "TezCompiler");
        this.markOperatorsWithUnstableRuntimeStats(procCtx);
        perfLogger.PerfLogEnd(this.getClass().getName(), "TezCompiler", "markOperatorsWithUnstableRuntimeStats");
        if (procCtx.conf.getBoolVar(HiveConf.ConfVars.HIVEOPTCONSTANTPROPAGATION)) {
            new ConstantPropagate(ConstantPropagateProcCtx.ConstantPropagateOption.SHORTCUT).transform(procCtx.parseContext);
        }
        if (procCtx.conf.getBoolVar(HiveConf.ConfVars.HIVE_IN_TEST)) {
            this.bucketingVersionSanityCheck(procCtx);
        }
    }

    private void runCycleAnalysisForPartitionPruning(OptimizeTezProcContext procCtx, Set<ReadEntity> inputs, Set<WriteEntity> outputs) throws SemanticException {
        this.connectTerminalOps(procCtx.parseContext);
        boolean cycleFree = false;
        while (!cycleFree) {
            cycleFree = true;
            Set<Set<Operator<?>>> components = this.getComponents(procCtx);
            for (Set<Operator<?>> component : components) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Component: ");
                    for (Operator<?> co : component) {
                        LOG.debug("Operator: " + co.getName() + ", " + co.getIdentifier());
                    }
                }
                if (component.size() == 1) continue;
                LOG.info("Found cycle in operator plan...");
                cycleFree = false;
                this.removeCycleOperator(component, procCtx);
                break;
            }
            LOG.info("Cycle free: " + cycleFree);
        }
    }

    private void removeCycleOperator(Set<Operator<?>> component, OptimizeTezProcContext context) throws SemanticException {
        AppMasterEventOperator victimAM = null;
        Operator victimTS = null;
        Operator victimRS = null;
        boolean hasHint = false;
        boolean removed = false;
        for (Operator<?> o : component) {
            SemiJoinBranchInfo sjInfo;
            if (o instanceof AppMasterEventOperator) {
                if (victimAM != null && o.getStatistics().getDataSize() >= victimAM.getStatistics().getDataSize()) continue;
                victimAM = (AppMasterEventOperator)o;
                removed = true;
                continue;
            }
            if (!(o instanceof ReduceSinkOperator) || (sjInfo = context.parseContext.getRsToSemiJoinBranchInfo().get(o)) == null) continue;
            if (sjInfo.getIsHint()) {
                hasHint = true;
                continue;
            }
            TableScanOperator ts = sjInfo.getTsOp();
            assert (component.contains(ts));
            if (victimRS != null && ts.getStatistics().getDataSize() >= victimTS.getStatistics().getDataSize()) continue;
            victimRS = (ReduceSinkOperator)o;
            victimTS = ts;
            removed = true;
        }
        AppMasterEventOperator victim = victimRS;
        if (victimRS == null && victimAM != null) {
            victim = victimAM;
        } else if (victimAM != null) {
            Operator op = victimRS;
            while (!(op instanceof TableScanOperator)) {
                op = op.getParentOperators().get(0);
            }
            if (2L * op.getStatistics().getDataSize() < victimAM.getStatistics().getDataSize()) {
                victim = victimAM;
            }
        }
        if (hasHint && !removed) {
            throw new SemanticException("The user hint is causing an operator cycle. Please fix it and retry");
        }
        if (victim == null || !context.pruningOpsRemovedByPriorOpt.isEmpty() && context.pruningOpsRemovedByPriorOpt.contains(victim)) {
            return;
        }
        GenTezUtils.removeBranch(victim);
        if (victim == victimRS) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cycle found. Removing semijoin " + OperatorUtils.getOpNamePretty(victimRS) + " - " + OperatorUtils.getOpNamePretty(victimTS));
            }
            GenTezUtils.removeSemiJoinOperator(context.parseContext, (ReduceSinkOperator)victimRS, victimTS);
        } else {
            LOG.info("Disabling dynamic pruning for: " + ((DynamicPruningEventDesc)victim.getConf()).getTableScan().toString() + ". Needed to break cyclic dependency");
        }
    }

    private Set<Set<Operator<?>>> getComponents(OptimizeTezProcContext procCtx) {
        LinkedList<TableScanOperator> deque = new LinkedList<TableScanOperator>();
        deque.addAll(procCtx.parseContext.getTopOps().values());
        AtomicInteger index = new AtomicInteger();
        HashMap indexes = new HashMap();
        HashMap lowLinks = new HashMap();
        Stack nodes = new Stack();
        LinkedHashSet components = new LinkedHashSet();
        for (Operator operator : deque) {
            if (indexes.containsKey(operator)) continue;
            this.connect(operator, index, nodes, indexes, lowLinks, components, procCtx.parseContext);
        }
        return components;
    }

    private void connect(Operator<?> o, AtomicInteger index, Stack<Operator<?>> nodes, Map<Operator<?>, Integer> indexes, Map<Operator<?>, Integer> lowLinks, Set<Set<Operator<?>>> components, ParseContext parseContext) {
        List<Operator<OperatorDesc>> children;
        indexes.put(o, index.get());
        lowLinks.put(o, index.get());
        index.incrementAndGet();
        nodes.push(o);
        if (o instanceof AppMasterEventOperator) {
            children = new ArrayList<Operator<OperatorDesc>>(o.getChildOperators());
            TableScanOperator ts = ((DynamicPruningEventDesc)o.getConf()).getTableScan();
            LOG.debug("Adding special edge: " + o.getName() + " --> " + ts.toString());
            children.add(ts);
        } else if (o instanceof TerminalOperator) {
            Object sjInfo;
            children = new ArrayList<Operator<OperatorDesc>>(o.getChildOperators());
            for (ReduceSinkOperator rs : parseContext.getTerminalOpToRSMap().get((TerminalOperator)o)) {
                LOG.debug("Adding special edge: From terminal op to semijoin edge " + o.getName() + " --> " + rs.toString());
                children.add(rs);
            }
            if (o instanceof ReduceSinkOperator && (sjInfo = parseContext.getRsToSemiJoinBranchInfo().get(o)) != null) {
                TableScanOperator ts = ((SemiJoinBranchInfo)sjInfo).getTsOp();
                LOG.debug("Adding special edge: " + o.getName() + " --> " + ts.toString());
                children.add(ts);
            }
        } else {
            children = o.getChildOperators();
        }
        for (Operator<OperatorDesc> child : children) {
            if (!indexes.containsKey(child)) {
                this.connect(child, index, nodes, indexes, lowLinks, components, parseContext);
                lowLinks.put(o, Math.min(lowLinks.get(o), lowLinks.get(child)));
                continue;
            }
            if (!nodes.contains(child)) continue;
            lowLinks.put(o, Math.min(lowLinks.get(o), indexes.get(child)));
        }
        if (lowLinks.get(o).equals(indexes.get(o))) {
            Operator<?> current;
            LinkedHashSet component = new LinkedHashSet();
            components.add(component);
            do {
                current = nodes.pop();
                component.add(current);
            } while (current != o);
        }
    }

    private void runStatsAnnotation(OptimizeTezProcContext procCtx) throws SemanticException {
        new AnnotateWithStatistics().transform(procCtx.parseContext);
        new AnnotateWithOpTraits().transform(procCtx.parseContext);
    }

    private void runStatsDependentOptimizations(OptimizeTezProcContext procCtx, Set<ReadEntity> inputs, Set<WriteEntity> outputs) throws SemanticException {
        LinkedList<TableScanOperator> deque = new LinkedList<TableScanOperator>();
        deque.addAll(procCtx.parseContext.getTopOps().values());
        LinkedHashMap<Rule, NodeProcessor> opRules = new LinkedHashMap<Rule, NodeProcessor>();
        opRules.put(new RuleRegExp("Set parallelism - ReduceSink", ReduceSinkOperator.getOperatorName() + "%"), new SetReducerParallelism());
        opRules.put(new RuleRegExp("Convert Join to Map-join", JoinOperator.getOperatorName() + "%"), new ConvertJoinMapJoin());
        if (procCtx.conf.getBoolVar(HiveConf.ConfVars.HIVEMAPAGGRHASHMINREDUCTIONSTATSADJUST)) {
            opRules.put(new RuleRegExp("Set min reduction - GBy (Hash)", GroupByOperator.getOperatorName() + "%"), new SetHashGroupByMinReduction());
        }
        DefaultRuleDispatcher disp = new DefaultRuleDispatcher(null, opRules, procCtx);
        ArrayList<Node> topNodes = new ArrayList<Node>();
        topNodes.addAll(procCtx.parseContext.getTopOps().values());
        ForwardWalker ogw = new ForwardWalker(disp);
        ogw.startWalking(topNodes, null);
    }

    private void semijoinRemovalBasedTransformations(OptimizeTezProcContext procCtx, Set<ReadEntity> inputs, Set<WriteEntity> outputs) throws SemanticException {
        PerfLogger perfLogger = SessionState.getPerfLogger();
        boolean dynamicPartitionPruningEnabled = procCtx.conf.getBoolVar(HiveConf.ConfVars.TEZ_DYNAMIC_PARTITION_PRUNING);
        boolean semiJoinReductionEnabled = dynamicPartitionPruningEnabled && procCtx.conf.getBoolVar(HiveConf.ConfVars.TEZ_DYNAMIC_SEMIJOIN_REDUCTION) && procCtx.parseContext.getRsToSemiJoinBranchInfo().size() != 0;
        boolean extendedReductionEnabled = dynamicPartitionPruningEnabled && procCtx.conf.getBoolVar(HiveConf.ConfVars.TEZ_DYNAMIC_PARTITION_PRUNING_EXTENDED);
        perfLogger.PerfLogBegin(this.getClass().getName(), "TezCompiler");
        if (dynamicPartitionPruningEnabled) {
            this.runRemoveDynamicPruningOptimization(procCtx, inputs, outputs);
        }
        perfLogger.PerfLogEnd(this.getClass().getName(), "TezCompiler", "Run remove dynamic pruning by size");
        if (semiJoinReductionEnabled) {
            perfLogger.PerfLogBegin(this.getClass().getName(), "TezCompiler");
            this.markSemiJoinForDPP(procCtx);
            perfLogger.PerfLogEnd(this.getClass().getName(), "TezCompiler", "Mark certain semijoin edges important based ");
            perfLogger.PerfLogBegin(this.getClass().getName(), "TezCompiler");
            this.removeSemiJoinEdgesForUnion(procCtx);
            perfLogger.PerfLogEnd(this.getClass().getName(), "TezCompiler", "Remove any semi join edge between Union and RS");
            perfLogger.PerfLogBegin(this.getClass().getName(), "TezCompiler");
            this.removeSemijoinsParallelToMapJoin(procCtx);
            perfLogger.PerfLogEnd(this.getClass().getName(), "TezCompiler", "Remove any parallel edge between semijoin and mapjoin");
            perfLogger.PerfLogBegin(this.getClass().getName(), "TezCompiler");
            TezCompiler.removeSemijoinOptimizationFromSMBJoins(procCtx);
            perfLogger.PerfLogEnd(this.getClass().getName(), "TezCompiler", "Remove semijoin optimizations if needed");
            perfLogger.PerfLogBegin(this.getClass().getName(), "TezCompiler");
            this.removeSemiJoinIfNoStats(procCtx);
            perfLogger.PerfLogEnd(this.getClass().getName(), "TezCompiler", "Remove bloom filter optimizations if needed");
            perfLogger.PerfLogBegin(this.getClass().getName(), "TezCompiler");
            this.removeSemijoinOptimizationByBenefit(procCtx);
            perfLogger.PerfLogEnd(this.getClass().getName(), "TezCompiler", "Remove Semijoins based on cost benefits");
        }
        perfLogger.PerfLogBegin(this.getClass().getName(), "TezCompiler");
        if (dynamicPartitionPruningEnabled) {
            this.runCycleAnalysisForPartitionPruning(procCtx, inputs, outputs);
        }
        perfLogger.PerfLogEnd(this.getClass().getName(), "TezCompiler", "Run cycle analysis for partition pruning");
        perfLogger.PerfLogBegin(this.getClass().getName(), "TezCompiler");
        if (extendedReductionEnabled) {
            this.removeRedundantSemijoinAndDpp(procCtx);
        }
        perfLogger.PerfLogEnd(this.getClass().getName(), "TezCompiler", "Remove redundant semijoin reduction");
    }

    private void runRemoveDynamicPruningOptimization(OptimizeTezProcContext procCtx, Set<ReadEntity> inputs, Set<WriteEntity> outputs) throws SemanticException {
        LinkedList<TableScanOperator> deque = new LinkedList<TableScanOperator>();
        deque.addAll(procCtx.parseContext.getTopOps().values());
        LinkedHashMap<Rule, NodeProcessor> opRules = new LinkedHashMap<Rule, NodeProcessor>();
        opRules.put(new RuleRegExp("Remove dynamic pruning by size", AppMasterEventOperator.getOperatorName() + "%"), new RemoveDynamicPruningBySize());
        DefaultRuleDispatcher disp = new DefaultRuleDispatcher(null, opRules, procCtx);
        ArrayList<Node> topNodes = new ArrayList<Node>();
        topNodes.addAll(procCtx.parseContext.getTopOps().values());
        ForwardWalker ogw = new ForwardWalker(disp);
        ogw.startWalking(topNodes, null);
    }

    private void runDynamicPartitionPruning(OptimizeTezProcContext procCtx, Set<ReadEntity> inputs, Set<WriteEntity> outputs) throws SemanticException {
        if (!procCtx.conf.getBoolVar(HiveConf.ConfVars.TEZ_DYNAMIC_PARTITION_PRUNING)) {
            return;
        }
        LinkedList<TableScanOperator> deque = new LinkedList<TableScanOperator>();
        deque.addAll(procCtx.parseContext.getTopOps().values());
        LinkedHashMap<Rule, NodeProcessor> opRules = new LinkedHashMap<Rule, NodeProcessor>();
        opRules.put(new RuleRegExp(new String("Dynamic Partition Pruning"), FilterOperator.getOperatorName() + "%"), new DynamicPartitionPruningOptimization());
        DefaultRuleDispatcher disp = new DefaultRuleDispatcher(null, opRules, procCtx);
        ArrayList<Node> topNodes = new ArrayList<Node>();
        topNodes.addAll(procCtx.parseContext.getTopOps().values());
        ForwardWalker ogw = new ForwardWalker(disp);
        ogw.startWalking(topNodes, null);
    }

    protected void generateTaskTree(List<Task<? extends Serializable>> rootTasks, ParseContext pCtx, List<Task<MoveWork>> mvTask, Set<ReadEntity> inputs, Set<WriteEntity> outputs) throws SemanticException {
        PerfLogger perfLogger = SessionState.getPerfLogger();
        perfLogger.PerfLogBegin(this.getClass().getName(), "TezCompiler");
        ParseContext tempParseContext = this.getParseContext(pCtx, rootTasks);
        GenTezUtils utils = new GenTezUtils();
        GenTezWork genTezWork = new GenTezWork(utils);
        GenTezProcContext procCtx = new GenTezProcContext(this.conf, tempParseContext, mvTask, rootTasks, inputs, outputs);
        LinkedHashMap<Rule, NodeProcessor> opRules = new LinkedHashMap<Rule, NodeProcessor>();
        opRules.put(new RuleRegExp("Split Work - ReduceSink", ReduceSinkOperator.getOperatorName() + "%"), genTezWork);
        opRules.put(new RuleRegExp("No more walking on ReduceSink-MapJoin", MapJoinOperator.getOperatorName() + "%"), new ReduceSinkMapJoinProc());
        opRules.put(new RuleRegExp("Recognize a Sorted Merge Join operator to setup the right edge and stop traversing the DummyStore-MapJoin", CommonMergeJoinOperator.getOperatorName() + "%"), new MergeJoinProc());
        opRules.put(new RuleRegExp("Split Work + Move/Merge - FileSink", FileSinkOperator.getOperatorName() + "%"), new CompositeProcessor(new FileSinkProcessor(), genTezWork));
        opRules.put(new RuleRegExp("Split work - DummyStore", DummyStoreOperator.getOperatorName() + "%"), genTezWork);
        opRules.put(new RuleRegExp("Handle Potential Analyze Command", TableScanOperator.getOperatorName() + "%"), new ProcessAnalyzeTable(utils));
        opRules.put(new RuleRegExp("Remember union", UnionOperator.getOperatorName() + "%"), new UnionProcessor());
        opRules.put(new RuleRegExp("AppMasterEventOperator", AppMasterEventOperator.getOperatorName() + "%"), new AppMasterEventProcessor());
        DefaultRuleDispatcher disp = new DefaultRuleDispatcher(null, opRules, procCtx);
        ArrayList<Node> topNodes = new ArrayList<Node>();
        topNodes.addAll(pCtx.getTopOps().values());
        GenTezWorkWalker ogw = new GenTezWorkWalker(disp, procCtx);
        ogw.startWalking(topNodes, null);
        for (List<BaseWork> baseWorkList : procCtx.mapJoinWorkMap.values()) {
            for (BaseWork w : baseWorkList) {
                w.setReservedMemoryMB((int)(this.conf.getLongVar(HiveConf.ConfVars.HIVECONVERTJOINNOCONDITIONALTASKTHRESHOLD) / 0x100000L));
            }
        }
        int indexForTezUnion = 0;
        for (BaseWork w : procCtx.workWithUnionOperators) {
            GenTezUtils.removeUnionOperators(procCtx, w, indexForTezUnion++);
        }
        for (FileSinkOperator fileSink : procCtx.fileSinkSet) {
            GenTezUtils.processFileSink(procCtx, fileSink);
        }
        if (pCtx.getRsToRuntimeValuesInfoMap().size() > 0) {
            for (ReduceSinkOperator rs : pCtx.getRsToRuntimeValuesInfoMap().keySet()) {
                GenTezUtils.processDynamicSemiJoinPushDownOperator(procCtx, pCtx.getRsToRuntimeValuesInfoMap().get(rs), rs);
            }
        }
        LOG.debug("There are " + procCtx.eventOperatorSet.size() + " app master events.");
        for (AppMasterEventOperator event : procCtx.eventOperatorSet) {
            LOG.debug("Handling AppMasterEventOperator: " + event);
            GenTezUtils.processAppMasterEvent(procCtx, event);
        }
        perfLogger.PerfLogEnd(this.getClass().getName(), "TezCompiler", "generateTaskTree");
    }

    protected void setInputFormat(Task<? extends Serializable> task) {
        if (task instanceof TezTask) {
            TezWork work = (TezWork)((TezTask)task).getWork();
            List<BaseWork> all = work.getAllWork();
            Iterator<BaseWork> iterator = all.iterator();
            while (iterator.hasNext()) {
                MapWork mapWork;
                Map<String, Operator<? extends OperatorDesc>> opMap;
                BaseWork w = iterator.next();
                if (!(w instanceof MapWork) || (opMap = (mapWork = (MapWork)w).getAliasToWork()).isEmpty()) continue;
                for (Operator<? extends OperatorDesc> op : opMap.values()) {
                    this.setInputFormat(mapWork, op);
                }
            }
        } else if (task instanceof ConditionalTask) {
            List<Task<? extends Serializable>> listTasks = ((ConditionalTask)task).getListTasks();
            for (Task task2 : listTasks) {
                this.setInputFormat(task2);
            }
        }
        if (task.getChildTasks() != null) {
            for (Task<Serializable> childTask : task.getChildTasks()) {
                this.setInputFormat((Task<? extends Serializable>)childTask);
            }
        }
    }

    private void setInputFormat(MapWork work, Operator<? extends OperatorDesc> op) {
        if (op == null) {
            return;
        }
        if (op.isUseBucketizedHiveInputFormat()) {
            work.setUseBucketizedHiveInputFormat(true);
            return;
        }
        if (op.getChildOperators() != null) {
            for (Operator<OperatorDesc> childOp : op.getChildOperators()) {
                this.setInputFormat(work, childOp);
            }
        }
    }

    protected void decideExecMode(List<Task<? extends Serializable>> rootTasks, Context ctx, GlobalLimitCtx globalLimitCtx) throws SemanticException {
    }

    protected void optimizeTaskPlan(List<Task<? extends Serializable>> rootTasks, ParseContext pCtx, Context ctx) throws SemanticException {
        PerfLogger perfLogger = SessionState.getPerfLogger();
        perfLogger.PerfLogBegin(this.getClass().getName(), "TezCompiler");
        PhysicalContext physicalCtx = new PhysicalContext(this.conf, pCtx, pCtx.getContext(), rootTasks, pCtx.getFetchTask());
        if (this.conf.getBoolVar(HiveConf.ConfVars.HIVENULLSCANOPTIMIZE)) {
            physicalCtx = new NullScanOptimizer().resolve(physicalCtx);
        } else {
            LOG.debug("Skipping null scan query optimization");
        }
        if (this.conf.getBoolVar(HiveConf.ConfVars.HIVEMETADATAONLYQUERIES)) {
            physicalCtx = new MetadataOnlyOptimizer().resolve(physicalCtx);
        } else {
            LOG.debug("Skipping metadata only query optimization");
        }
        if (this.conf.getBoolVar(HiveConf.ConfVars.HIVE_CHECK_CROSS_PRODUCT)) {
            physicalCtx = new CrossProductHandler().resolve(physicalCtx);
        } else {
            LOG.debug("Skipping cross product analysis");
        }
        if ("llap".equalsIgnoreCase(this.conf.getVar(HiveConf.ConfVars.HIVE_EXECUTION_MODE))) {
            physicalCtx = new LlapPreVectorizationPass().resolve(physicalCtx);
        } else {
            LOG.debug("Skipping llap pre-vectorization pass");
        }
        if (this.conf.getBoolVar(HiveConf.ConfVars.HIVE_VECTORIZATION_ENABLED)) {
            physicalCtx = new Vectorizer().resolve(physicalCtx);
        } else {
            LOG.debug("Skipping vectorization");
        }
        if (!"none".equalsIgnoreCase(this.conf.getVar(HiveConf.ConfVars.HIVESTAGEIDREARRANGE))) {
            physicalCtx = new StageIDsRearranger().resolve(physicalCtx);
        } else {
            LOG.debug("Skipping stage id rearranger");
        }
        if (this.conf.getBoolVar(HiveConf.ConfVars.HIVE_TEZ_ENABLE_MEMORY_MANAGER) && this.conf.getBoolVar(HiveConf.ConfVars.HIVEUSEHYBRIDGRACEHASHJOIN)) {
            physicalCtx = new MemoryDecider().resolve(physicalCtx);
        }
        if ("llap".equalsIgnoreCase(this.conf.getVar(HiveConf.ConfVars.HIVE_EXECUTION_MODE))) {
            LlapClusterStateForCompile llapInfo = LlapClusterStateForCompile.getClusterInfo(this.conf);
            physicalCtx = new LlapDecider(llapInfo).resolve(physicalCtx);
        } else {
            LOG.debug("Skipping llap decider");
        }
        physicalCtx = new SerializeFilter().resolve(physicalCtx);
        if (physicalCtx.getContext().getExplainAnalyze() != null) {
            new AnnotateRunTimeStatsOptimizer().resolve(physicalCtx);
        }
        perfLogger.PerfLogEnd(this.getClass().getName(), "TezCompiler", "optimizeTaskPlan");
    }

    private static void removeSemijoinOptimizationFromSMBJoins(OptimizeTezProcContext procCtx) throws SemanticException {
        LinkedHashMap<Rule, NodeProcessor> opRules = new LinkedHashMap<Rule, NodeProcessor>();
        opRules.put(new RuleRegExp("R1", TableScanOperator.getOperatorName() + "%.*" + TezDummyStoreOperator.getOperatorName() + "%" + CommonMergeJoinOperator.getOperatorName() + "%"), new SMBJoinOpProc());
        SMBJoinOpProcContext ctx = new SMBJoinOpProcContext();
        DefaultRuleDispatcher disp = new DefaultRuleDispatcher(null, opRules, ctx);
        ArrayList<Node> topNodes = new ArrayList<Node>();
        topNodes.addAll(procCtx.parseContext.getTopOps().values());
        PreOrderOnceWalker ogw = new PreOrderOnceWalker(disp);
        ogw.startWalking(topNodes, null);
        ArrayList<TableScanOperator> tsOps = new ArrayList<TableScanOperator>();
        for (CommonMergeJoinOperator joinOp : ctx.JoinOpToTsOpMap.keySet()) {
            tsOps.add(ctx.JoinOpToTsOpMap.get(joinOp));
            List<Operator<OperatorDesc>> parents = joinOp.getParentOperators();
            block1: for (Operator<OperatorDesc> parent : parents) {
                if (parent instanceof TezDummyStoreOperator) continue;
                while (parent != null) {
                    if (parent instanceof TableScanOperator) {
                        tsOps.add((TableScanOperator)parent);
                        continue block1;
                    }
                    parent = parent.getParentOperators().get(0);
                }
            }
        }
        ParseContext pctx = procCtx.parseContext;
        HashSet<ReduceSinkOperator> rsSet = new HashSet<ReduceSinkOperator>(pctx.getRsToSemiJoinBranchInfo().keySet());
        for (TableScanOperator ts : tsOps) {
            for (ReduceSinkOperator rs : rsSet) {
                SemiJoinBranchInfo sjInfo = pctx.getRsToSemiJoinBranchInfo().get(rs);
                if (sjInfo == null || ts != sjInfo.getTsOp()) continue;
                if (sjInfo.getIsHint()) {
                    throw new SemanticException("Removing hinted semijoin as it is with SMB join " + rs + " : " + ts);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Semijoin optimization found going to SMB join. Removing semijoin " + OperatorUtils.getOpNamePretty(rs) + " - " + OperatorUtils.getOpNamePretty(ts));
                }
                GenTezUtils.removeBranch(rs);
                GenTezUtils.removeSemiJoinOperator(pctx, rs, ts);
            }
        }
    }

    private void connectTerminalOps(ParseContext pCtx) {
        ArrayListMultimap<TerminalOperator<?>, ReduceSinkOperator> terminalOpToRSMap = ArrayListMultimap.create();
        HashMap<ReduceSinkOperator, TerminalOpsInfo> rsToTerminalOpsInfo = new HashMap<ReduceSinkOperator, TerminalOpsInfo>();
        for (ReduceSinkOperator rs : pCtx.getRsToSemiJoinBranchInfo().keySet()) {
            TerminalOpsInfo terminalOpsInfo = (TerminalOpsInfo)rsToTerminalOpsInfo.get(rs);
            if (terminalOpsInfo != null) continue;
            HashSet<ReduceSinkOperator> workRSOps = new HashSet<ReduceSinkOperator>();
            HashSet workTerminalOps = new HashSet();
            Operator<OperatorDesc> selOp = rs.getParentOperators().get(0).getParentOperators().get(0).getParentOperators().get(0).getParentOperators().get(0);
            OperatorUtils.findWorkOperatorsAndSemiJoinEdges(selOp, pCtx.getRsToSemiJoinBranchInfo(), workRSOps, workTerminalOps);
            TerminalOpsInfo candidate = new TerminalOpsInfo(workTerminalOps);
            for (ReduceSinkOperator rsFound : workRSOps) {
                rsToTerminalOpsInfo.put(rsFound, candidate);
                for (TerminalOperator<?> terminalOp : candidate.terminalOps) {
                    terminalOpToRSMap.put(terminalOp, rsFound);
                }
            }
        }
        pCtx.setTerminalOpToRSMap(terminalOpToRSMap);
    }

    private void removeSemiJoinIfNoStats(OptimizeTezProcContext procCtx) throws SemanticException {
        LinkedHashMap<Rule, NodeProcessor> opRules = new LinkedHashMap<Rule, NodeProcessor>();
        opRules.put(new RuleRegExp("R1", GroupByOperator.getOperatorName() + "%" + ReduceSinkOperator.getOperatorName() + "%" + GroupByOperator.getOperatorName() + "%" + ReduceSinkOperator.getOperatorName() + "%"), new SemiJoinRemovalProc(true, false));
        SemiJoinRemovalContext ctx = new SemiJoinRemovalContext(procCtx.parseContext);
        DefaultRuleDispatcher disp = new DefaultRuleDispatcher(null, opRules, ctx);
        ArrayList<Node> topNodes = new ArrayList<Node>();
        topNodes.addAll(procCtx.parseContext.getTopOps().values());
        PreOrderOnceWalker ogw = new PreOrderOnceWalker(disp);
        ogw.startWalking(topNodes, null);
    }

    private static boolean isBloomFilterAgg(AggregationDesc agg) {
        return "bloom_filter".equals(agg.getGenericUDAFName());
    }

    private void removeRedundantSemijoinAndDpp(OptimizeTezProcContext procCtx) throws SemanticException {
        LinkedHashMap<Rule, NodeProcessor> opRules = new LinkedHashMap<Rule, NodeProcessor>();
        opRules.put(new RuleRegExp("R1", GroupByOperator.getOperatorName() + "%" + ReduceSinkOperator.getOperatorName() + "%" + GroupByOperator.getOperatorName() + "%" + ReduceSinkOperator.getOperatorName() + "%"), new SemiJoinRemovalProc(false, true));
        opRules.put(new RuleRegExp("R2", AppMasterEventOperator.getOperatorName() + "%"), new DynamicPruningRemovalRedundantProc());
        SemiJoinRemovalContext ctx = new SemiJoinRemovalContext(procCtx.parseContext);
        DefaultRuleDispatcher disp = new DefaultRuleDispatcher(null, opRules, ctx);
        ArrayList<Node> topNodes = new ArrayList<Node>();
        topNodes.addAll(procCtx.parseContext.getTopOps().values());
        PreOrderOnceWalker ogw = new PreOrderOnceWalker(disp);
        ogw.startWalking(topNodes, null);
        for (Map.Entry p : ctx.opsToRemove.entrySet()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Removing redundant " + OperatorUtils.getOpNamePretty((Operator)p.getKey()) + " - " + OperatorUtils.getOpNamePretty((Operator)p.getValue()));
            }
            GenTezUtils.removeBranch((Operator)p.getKey());
            if (p.getKey() instanceof AppMasterEventOperator) {
                GenTezUtils.removeSemiJoinOperator(procCtx.parseContext, (AppMasterEventOperator)p.getKey(), (TableScanOperator)p.getValue());
                continue;
            }
            if (p.getKey() instanceof ReduceSinkOperator) {
                GenTezUtils.removeSemiJoinOperator(procCtx.parseContext, (ReduceSinkOperator)p.getKey(), (TableScanOperator)p.getValue());
                continue;
            }
            throw new SemanticException("Unexpected error - type for branch could not be recognized");
        }
    }

    private void markOperatorsWithUnstableRuntimeStats(OptimizeTezProcContext procCtx) throws SemanticException {
        LinkedHashMap<Rule, NodeProcessor> opRules = new LinkedHashMap<Rule, NodeProcessor>();
        opRules.put(new RuleRegExp("R1", ReduceSinkOperator.getOperatorName() + "%"), new MarkTsOfSemijoinsAsIncorrect());
        opRules.put(new RuleRegExp("R2", AppMasterEventOperator.getOperatorName() + "%"), new MarkTsOfSemijoinsAsIncorrect());
        DefaultRuleDispatcher disp = new DefaultRuleDispatcher(null, opRules, procCtx);
        ArrayList<Node> topNodes = new ArrayList<Node>();
        topNodes.addAll(procCtx.parseContext.getTopOps().values());
        PreOrderOnceWalker ogw = new PreOrderOnceWalker(disp);
        ogw.startWalking(topNodes, null);
    }

    private static void runTopNKeyOptimization(OptimizeTezProcContext procCtx) throws SemanticException {
        if (!procCtx.conf.getBoolVar(HiveConf.ConfVars.HIVE_OPTIMIZE_TOPNKEY)) {
            return;
        }
        LinkedHashMap<Rule, NodeProcessor> opRules = new LinkedHashMap<Rule, NodeProcessor>();
        opRules.put(new RuleRegExp("Top n key optimization", ReduceSinkOperator.getOperatorName() + "%"), new TopNKeyProcessor(HiveConf.getIntVar(procCtx.conf, HiveConf.ConfVars.HIVE_MAX_TOPN_ALLOWED), HiveConf.getFloatVar(procCtx.conf, HiveConf.ConfVars.HIVE_TOPN_EFFICIENCY_THRESHOLD), HiveConf.getIntVar(procCtx.conf, HiveConf.ConfVars.HIVE_TOPN_EFFICIENCY_CHECK_BATCHES), HiveConf.getIntVar(procCtx.conf, HiveConf.ConfVars.HIVE_TOPN_MAX_NUMBER_OF_PARTITIONS)));
        opRules.put(new RuleRegExp("Top n key pushdown", TopNKeyOperator.getOperatorName() + "%"), new TopNKeyPushdownProcessor());
        DefaultRuleDispatcher disp = new DefaultRuleDispatcher(null, opRules, procCtx);
        ArrayList<Node> topNodes = new ArrayList<Node>();
        topNodes.addAll(procCtx.parseContext.getTopOps().values());
        DefaultGraphWalker ogw = new DefaultGraphWalker(disp);
        ogw.startWalking(topNodes, null);
    }

    /*
     * WARNING - void declaration
     */
    private boolean findParallelSemiJoinBranch(Operator<?> mapjoin, TableScanOperator bigTableTS, ParseContext parseContext, Map<ReduceSinkOperator, TableScanOperator> semijoins) {
        boolean parallelEdges = false;
        for (Operator<OperatorDesc> operator : mapjoin.getParentOperators()) {
            void var7_10;
            if (!(operator instanceof ReduceSinkOperator)) continue;
            Operator<OperatorDesc> operator2 = operator.getParentOperators().get(0);
            while (!(var7_10 instanceof ReduceSinkOperator || var7_10 instanceof TableScanOperator || var7_10.getChildren() != null && ((ArrayList)var7_10.getChildren()).size() > 1)) {
                void var7_11;
                if (var7_10 instanceof MapJoinOperator) {
                    for (Operator operator3 : var7_10.getParentOperators()) {
                        if (operator3 instanceof ReduceSinkOperator) continue;
                        Operator operator4 = operator3;
                    }
                }
                Operator<OperatorDesc> operator5 = var7_11.getParentOperators().get(0);
            }
            if (var7_10 instanceof ReduceSinkOperator || var7_10 instanceof TableScanOperator) continue;
            for (Node node : var7_10.getChildren()) {
                TableScanOperator ts;
                if (!(node instanceof SelectOperator)) continue;
                Operator<OperatorDesc> child = (Operator<OperatorDesc>)node;
                while (child.getChildOperators().size() > 0) {
                    child = child.getChildOperators().get(0);
                }
                if (!(child instanceof ReduceSinkOperator)) {
                    if (!(child instanceof AppMasterEventOperator) || !(((AppMasterEventOperator)child).getConf() instanceof DynamicPruningEventDesc)) continue;
                    parallelEdges = true;
                    continue;
                }
                ReduceSinkOperator rs = (ReduceSinkOperator)child;
                SemiJoinBranchInfo sjInfo = parseContext.getRsToSemiJoinBranchInfo().get(rs);
                if (sjInfo == null || (ts = sjInfo.getTsOp()) != bigTableTS) continue;
                parallelEdges = true;
                if (sjInfo.getIsHint() || !sjInfo.getShouldRemove()) continue;
                semijoins.put(rs, ts);
            }
        }
        return parallelEdges;
    }

    private void removeSemiJoinEdges(Operator<?> op, OptimizeTezProcContext procCtx, Map<ReduceSinkOperator, TableScanOperator> sjToRemove) throws SemanticException {
        Map<ReduceSinkOperator, SemiJoinBranchInfo> sjMap;
        if (op instanceof ReduceSinkOperator && op.getNumChild() == 0 && (sjMap = procCtx.parseContext.getRsToSemiJoinBranchInfo()).get(op) != null) {
            sjToRemove.put((ReduceSinkOperator)op, sjMap.get(op).getTsOp());
        }
        for (Operator<OperatorDesc> child : op.getChildOperators()) {
            this.removeSemiJoinEdges(child, procCtx, sjToRemove);
        }
    }

    private void removeSemiJoinEdgesForUnion(OptimizeTezProcContext procCtx) throws SemanticException {
        ArrayList<TableScanOperator> topOps = new ArrayList<TableScanOperator>();
        topOps.addAll(procCtx.parseContext.getTopOps().values());
        HashSet<Operator> unionOps = new HashSet<Operator>();
        HashMap<ReduceSinkOperator, TableScanOperator> sjToRemove = new HashMap<ReduceSinkOperator, TableScanOperator>();
        for (Operator operator : topOps) {
            LinkedList<Operator<OperatorDesc>> deque = new LinkedList<Operator<OperatorDesc>>();
            deque.add(operator);
            while (!deque.isEmpty()) {
                Operator op = (Operator)deque.pollLast();
                if (op instanceof UnionOperator && !unionOps.contains(op)) {
                    unionOps.add(op);
                    this.removeSemiJoinEdges(op, procCtx, sjToRemove);
                }
                deque.addAll(op.getChildOperators());
            }
        }
        if (sjToRemove.size() > 0) {
            for (Map.Entry entry : sjToRemove.entrySet()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Semijoin optimization with Union operator. Removing semijoin " + OperatorUtils.getOpNamePretty((Operator)entry.getKey()) + " - " + OperatorUtils.getOpNamePretty((Operator)sjToRemove.get(entry.getKey())));
                }
                GenTezUtils.removeBranch((Operator)entry.getKey());
                GenTezUtils.removeSemiJoinOperator(procCtx.parseContext, (ReduceSinkOperator)entry.getKey(), (TableScanOperator)entry.getValue());
            }
        }
    }

    private void removeSemijoinsParallelToMapJoin(OptimizeTezProcContext procCtx) throws SemanticException {
        if (!procCtx.conf.getBoolVar(HiveConf.ConfVars.HIVECONVERTJOIN) || procCtx.conf.getBoolVar(HiveConf.ConfVars.TEZ_DYNAMIC_SEMIJOIN_REDUCTION_FOR_MAPJOIN)) {
            return;
        }
        ArrayList<TableScanOperator> topOps = new ArrayList<TableScanOperator>();
        topOps.addAll(procCtx.parseContext.getTopOps().values());
        HashMap<ReduceSinkOperator, TableScanOperator> semijoins = new HashMap<ReduceSinkOperator, TableScanOperator>();
        block0: for (Operator operator : topOps) {
            LinkedList<Operator<OperatorDesc>> deque = new LinkedList<Operator<OperatorDesc>>();
            deque.add(operator);
            while (!deque.isEmpty()) {
                Operator op = (Operator)deque.pollLast();
                if (op instanceof ReduceSinkOperator) continue;
                if (op instanceof MapJoinOperator && !this.findParallelSemiJoinBranch(op, (TableScanOperator)operator, procCtx.parseContext, semijoins)) continue block0;
                deque.addAll(op.getChildOperators());
            }
        }
        if (semijoins.size() > 0) {
            for (ReduceSinkOperator reduceSinkOperator : semijoins.keySet()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Semijoin optimization with parallel edge to map join. Removing semijoin " + OperatorUtils.getOpNamePretty(reduceSinkOperator) + " - " + OperatorUtils.getOpNamePretty((Operator)semijoins.get(reduceSinkOperator)));
                }
                GenTezUtils.removeBranch(reduceSinkOperator);
                GenTezUtils.removeSemiJoinOperator(procCtx.parseContext, reduceSinkOperator, (TableScanOperator)semijoins.get(reduceSinkOperator));
            }
        }
    }

    private static boolean canUseNDV(ColStatistics colStats) {
        return colStats != null && colStats.getCountDistint() >= 0L;
    }

    private static double getBloomFilterCost(SelectOperator sel) {
        double cost = -1.0;
        Statistics selStats = sel.getStatistics();
        if (selStats != null) {
            cost = selStats.getNumRows();
        }
        return cost;
    }

    private static long getCombinedKeyDomainCardinality(ColStatistics selColStat, ColStatistics selColSourceStat, ColStatistics tsColStat) {
        long keyDomainCardinality = -1L;
        if (!TezCompiler.canUseNDV(selColStat) || !TezCompiler.canUseNDV(tsColStat)) {
            return -1L;
        }
        long selColSourceNdv = TezCompiler.canUseNDV(selColSourceStat) ? selColSourceStat.getCountDistint() : -1L;
        boolean semiJoinKeyIsPK = StatsUtils.inferForeignKey(selColStat, tsColStat);
        if (semiJoinKeyIsPK) {
            if (selColSourceNdv >= 0L) {
                keyDomainCardinality = selColSourceNdv;
            }
        } else if (selColSourceNdv >= 0L) {
            keyDomainCardinality = selColSourceNdv + tsColStat.getCountDistint();
            if (StatsUtils.hasDiscreteRange(selColStat) && StatsUtils.hasDiscreteRange(tsColStat)) {
                long range = 0L;
                ColStatistics.Range combinedRange = StatsUtils.combineRange(selColStat.getRange(), tsColStat.getRange());
                range = combinedRange != null ? StatsUtils.getRangeDelta(combinedRange) : StatsUtils.getRangeDelta(selColStat.getRange()) + StatsUtils.getRangeDelta(tsColStat.getRange());
                keyDomainCardinality = Math.min(keyDomainCardinality, range);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Computing key domain cardinality, keyDomainCardinality=" + keyDomainCardinality + ", semiJoinKeyIsPK=" + semiJoinKeyIsPK + ", selColStat=" + selColStat + ", selColSourceStat=" + selColSourceStat + ", tsColStat=" + tsColStat);
        }
        return keyDomainCardinality;
    }

    private static double getBloomFilterBenefit(SelectOperator sel, ExprNodeDesc selExpr, Statistics filStats, ExprNodeDesc tsExpr) {
        double benefit = -1.0;
        Statistics selStats = sel.getStatistics();
        if (selStats == null || filStats == null) {
            LOG.debug("No stats available to compute BloomFilter benefit");
            return benefit;
        }
        long selKeyCardinality = selStats.getNumRows();
        long tsKeyCardinality = filStats.getNumRows();
        long tsRows = filStats.getNumRows();
        long tsRowSize = filStats.getAvgRowSize();
        long keyDomainCardinality = selKeyCardinality + tsKeyCardinality;
        ExprNodeColumnDesc selCol = ExprNodeDescUtils.getColumnExpr(selExpr);
        ExprNodeColumnDesc tsCol = ExprNodeDescUtils.getColumnExpr(tsExpr);
        if (selCol != null && tsCol != null) {
            long domainCardinalityFromColStats;
            ExprNodeDescUtils.ColumnOrigin selColSource;
            ColStatistics selColStat = selStats.getColumnStatisticsFromColName(selCol.getColumn());
            ColStatistics filColStat = filStats.getColumnStatisticsFromColName(tsCol.getColumn());
            if (TezCompiler.canUseNDV(selColStat)) {
                selKeyCardinality = selColStat.getCountDistint();
            }
            if (TezCompiler.canUseNDV(filColStat)) {
                tsKeyCardinality = filColStat.getCountDistint();
            }
            ColStatistics selColSourceStat = null;
            if (selColStat != null && (selColSource = ExprNodeDescUtils.findColumnOrigin(selCol, sel)) != null && selColSource.op.getStatistics() != null) {
                selColSourceStat = selColSource.op.getStatistics().getColumnStatisticsFromColName(selColSource.col.getColumn());
            }
            if ((domainCardinalityFromColStats = TezCompiler.getCombinedKeyDomainCardinality(selColStat, selColSourceStat, filColStat)) >= 0L) {
                keyDomainCardinality = domainCardinalityFromColStats;
            }
        }
        double selectivity = (double)selKeyCardinality / (double)keyDomainCardinality;
        selectivity = Math.min(selectivity, 1.0);
        benefit = (double)tsRows * (1.0 - selectivity);
        if (LOG.isDebugEnabled()) {
            LOG.debug("BloomFilter benefit for " + selCol + " to " + tsCol + ", selKeyCardinality=" + selKeyCardinality + ", tsKeyCardinality=" + tsKeyCardinality + ", tsRows=" + tsRows + ", keyDomainCardinality=" + keyDomainCardinality);
            LOG.debug("SemiJoin key selectivity=" + selectivity + ", benefit=" + benefit);
        }
        return benefit;
    }

    private static double computeBloomFilterNetBenefit(SelectOperator sel, ExprNodeDesc selExpr, Statistics filStats, ExprNodeDesc tsExpr) {
        double cost;
        double netBenefit = -1.0;
        double benefit = TezCompiler.getBloomFilterBenefit(sel, selExpr, filStats, tsExpr);
        if (benefit > 0.0 && filStats != null && (cost = TezCompiler.getBloomFilterCost(sel)) > 0.0) {
            long filDataSize = filStats.getNumRows();
            netBenefit = (benefit - cost) / (double)filDataSize;
            LOG.debug("BloomFilter benefit=" + benefit + ", cost=" + cost + ", tsDataSize=" + filDataSize + ", netBenefit=" + (benefit - cost));
        }
        LOG.debug("netBenefit=" + netBenefit);
        return netBenefit;
    }

    private static void sortSemijoinFilters(OptimizeTezProcContext procCtx, ListMultimap<FilterOperator, SemijoinOperatorInfo> globalReductionFactorMap) throws SemanticException {
        for (Map.Entry<FilterOperator, Collection<SemijoinOperatorInfo>> e : globalReductionFactorMap.asMap().entrySet()) {
            FilterOperator filterOp = e.getKey();
            Collection<SemijoinOperatorInfo> semijoinInfos = e.getValue();
            ExprNodeDesc pred = ((FilterDesc)filterOp.getConf()).getPredicate();
            if (!FunctionRegistry.isOpAnd(pred)) continue;
            LinkedHashSet<ExprNodeDesc> allPreds = new LinkedHashSet<ExprNodeDesc>(pred.getChildren());
            ArrayList<ExprNodeDesc> betweenPreds = new ArrayList<ExprNodeDesc>();
            ArrayList<ExprNodeDesc> inBloomFilterPreds = new ArrayList<ExprNodeDesc>();
            for (SemijoinOperatorInfo roi : semijoinInfos) {
                block2: for (ExprNodeDesc expr : pred.getChildren()) {
                    List<String> dynamicValueIdsFromMap;
                    String dynamicValueIdFromExpr;
                    if (FunctionRegistry.isOpBetween(expr) && expr.getChildren().get(2) instanceof ExprNodeDynamicValueDesc) {
                        dynamicValueIdFromExpr = ((ExprNodeDynamicValueDesc)expr.getChildren().get(2)).getDynamicValue().getId();
                        dynamicValueIdsFromMap = procCtx.parseContext.getRsToRuntimeValuesInfoMap().get(roi.rsOperator).getDynamicValueIDs();
                        for (String dynamicValueIdFromMap : dynamicValueIdsFromMap) {
                            if (!dynamicValueIdFromExpr.equals(dynamicValueIdFromMap)) continue;
                            betweenPreds.add(expr);
                            allPreds.remove(expr);
                            continue block2;
                        }
                        continue;
                    }
                    if (!FunctionRegistry.isOpInBloomFilter(expr) || !(expr.getChildren().get(1) instanceof ExprNodeDynamicValueDesc)) continue;
                    dynamicValueIdFromExpr = ((ExprNodeDynamicValueDesc)expr.getChildren().get(1)).getDynamicValue().getId();
                    dynamicValueIdsFromMap = procCtx.parseContext.getRsToRuntimeValuesInfoMap().get(roi.rsOperator).getDynamicValueIDs();
                    for (String dynamicValueIdFromMap : dynamicValueIdsFromMap) {
                        if (!dynamicValueIdFromExpr.equals(dynamicValueIdFromMap)) continue;
                        inBloomFilterPreds.add(expr);
                        allPreds.remove(expr);
                        continue block2;
                    }
                }
            }
            ArrayList<ExprNodeDesc> newAndArgs = new ArrayList<ExprNodeDesc>(allPreds);
            newAndArgs.addAll(betweenPreds);
            newAndArgs.addAll(inBloomFilterPreds);
            ExprNodeGenericFuncDesc andExpr = ExprNodeGenericFuncDesc.newInstance(FunctionRegistry.getFunctionInfo("and").getGenericUDF(), newAndArgs);
            ((FilterDesc)filterOp.getConf()).setPredicate(andExpr);
        }
    }

    private void removeSemijoinOptimizationByBenefit(OptimizeTezProcContext procCtx) throws SemanticException {
        Map<ReduceSinkOperator, SemiJoinBranchInfo> map = procCtx.parseContext.getRsToSemiJoinBranchInfo();
        if (map.isEmpty()) {
            return;
        }
        HashMap<FilterOperator, Statistics> adjustedStatsMap = new HashMap<FilterOperator, Statistics>();
        ArrayList<ReduceSinkOperator> semijoinRsToRemove = new ArrayList<ReduceSinkOperator>();
        double semijoinReductionThreshold = procCtx.conf.getFloatVar(HiveConf.ConfVars.TEZ_DYNAMIC_SEMIJOIN_REDUCTION_THRESHOLD);
        Comparator rsOpComp = (o1, o2) -> o1.toString().compareTo(o2.toString());
        TreeSet<ReduceSinkOperator> semiJoinRsOps = new TreeSet<ReduceSinkOperator>(rsOpComp);
        semiJoinRsOps.addAll(map.keySet());
        ArrayListMultimap<FilterOperator, SemijoinOperatorInfo> globalReductionFactorMap = ArrayListMultimap.create();
        while (!semiJoinRsOps.isEmpty()) {
            HashMap<FilterOperator, SemijoinOperatorInfo> reductionFactorMap = new HashMap<FilterOperator, SemijoinOperatorInfo>();
            TreeSet<ReduceSinkOperator> semiJoinRsOpsNewIter = new TreeSet<ReduceSinkOperator>(rsOpComp);
            for (ReduceSinkOperator rs : semiJoinRsOps) {
                double reductionFactor;
                FilterOperator filterOperator;
                Statistics filterStats;
                SemiJoinBranchInfo sjInfo = map.get(rs);
                if (sjInfo.getIsHint() || !sjInfo.getShouldRemove()) continue;
                SelectOperator sel = null;
                Operator currOp = rs;
                while (currOp.getParentOperators().size() > 0) {
                    if (currOp instanceof SelectOperator) {
                        sel = (SelectOperator)currOp;
                        break;
                    }
                    currOp = currOp.getParentOperators().get(0);
                }
                if (sel == null) {
                    throw new SemanticException("Unexpected error - could not find SEL ancestor from semijoin branch of " + rs);
                }
                TableScanOperator ts = sjInfo.getTsOp();
                RuntimeValuesInfo rti = procCtx.parseContext.getRsToRuntimeValuesInfoMap().get(rs);
                ExprNodeDesc tsExpr = rti.getTsColExpr();
                ExprNodeDesc selExpr = ((SelectDesc)sel.getConf()).getColList().get(0);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Computing BloomFilter cost/benefit for " + OperatorUtils.getOpNamePretty(rs) + " - " + OperatorUtils.getOpNamePretty(ts) + " (" + tsExpr + ")");
                }
                if ((filterStats = (Statistics)adjustedStatsMap.get(filterOperator = (FilterOperator)ts.getChildOperators().get(0))) == null && filterOperator.getStatistics() != null) {
                    filterStats = filterOperator.getStatistics().clone();
                    adjustedStatsMap.put(filterOperator, filterStats);
                }
                if ((reductionFactor = TezCompiler.computeBloomFilterNetBenefit(sel, selExpr, filterStats, tsExpr)) < semijoinReductionThreshold) {
                    semijoinRsToRemove.add(rs);
                    continue;
                }
                if (filterStats == null) continue;
                ImmutableSet.Builder colNames = ImmutableSet.builder();
                Set<ExprNodeColumnDesc> allReferencedColumns = ExprNodeDescUtils.findAllColumnDescs(tsExpr);
                for (ExprNodeColumnDesc col : allReferencedColumns) {
                    colNames.add(col.getColumn());
                }
                SemijoinOperatorInfo prevResult = (SemijoinOperatorInfo)reductionFactorMap.get(filterOperator);
                if (prevResult != null) {
                    if (prevResult.reductionFactor < reductionFactor) {
                        reductionFactorMap.put(filterOperator, new SemijoinOperatorInfo(rs, filterOperator, filterStats, colNames.build(), reductionFactor));
                        semiJoinRsOpsNewIter.add(prevResult.rsOperator);
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug("Adding " + OperatorUtils.getOpNamePretty(prevResult.rsOperator) + " for re-iteration");
                        continue;
                    }
                    semiJoinRsOpsNewIter.add(rs);
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("Adding " + OperatorUtils.getOpNamePretty(rs) + " for re-iteration");
                    continue;
                }
                reductionFactorMap.put(filterOperator, new SemijoinOperatorInfo(rs, filterOperator, filterStats, colNames.build(), reductionFactor));
            }
            for (SemijoinOperatorInfo roi : reductionFactorMap.values()) {
                long newNumRows = (long)(1.0 - roi.reductionFactor) * roi.filterStats.getNumRows();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Old stats for {}: {}", (Object)roi.filterOperator, (Object)roi.filterStats);
                    LOG.debug("Number of rows reduction: {}/{}", (Object)newNumRows, (Object)roi.filterStats.getNumRows());
                }
                StatsUtils.updateStats(roi.filterStats, newNumRows, roi.filterStats.getColumnStats() != null, roi.filterOperator, roi.colNames);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("New stats for {}: {}", (Object)roi.filterOperator, (Object)roi.filterStats);
                }
                adjustedStatsMap.put(roi.filterOperator, roi.filterStats);
                globalReductionFactorMap.put(roi.filterOperator, roi);
            }
            semiJoinRsOps = semiJoinRsOpsNewIter;
        }
        for (ReduceSinkOperator rs : semijoinRsToRemove) {
            TableScanOperator ts = map.get(rs).getTsOp();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Reduction factor not satisfied for " + OperatorUtils.getOpNamePretty(rs) + "-" + OperatorUtils.getOpNamePretty(ts) + ". Removing semijoin optimization.");
            }
            GenTezUtils.removeBranch(rs);
            GenTezUtils.removeSemiJoinOperator(procCtx.parseContext, rs, ts);
        }
        if (!globalReductionFactorMap.isEmpty()) {
            TezCompiler.sortSemijoinFilters(procCtx, globalReductionFactorMap);
        }
    }

    private void markSemiJoinForDPP(OptimizeTezProcContext procCtx) throws SemanticException {
        Map<ReduceSinkOperator, SemiJoinBranchInfo> map = procCtx.parseContext.getRsToSemiJoinBranchInfo();
        block2: for (ReduceSinkOperator rs : map.keySet()) {
            SemiJoinBranchInfo sjInfo = map.get(rs);
            TableScanOperator ts = sjInfo.getTsOp();
            if (sjInfo.getIsHint() || !sjInfo.getShouldRemove()) continue;
            LinkedList<Operator<OperatorDesc>> deque = new LinkedList<Operator<OperatorDesc>>();
            deque.add(ts);
            while (!deque.isEmpty()) {
                Operator op = (Operator)deque.pollLast();
                if (op instanceof AppMasterEventOperator && ((AppMasterEventOperator)op).getConf() instanceof DynamicPruningEventDesc) {
                    SelectOperator selOp = (SelectOperator)rs.getParentOperators().get(0).getParentOperators().get(0).getParentOperators().get(0).getParentOperators().get(0);
                    try {
                        long nDVsOfTS;
                        double nDVsOfTSFactored;
                        String colName;
                        ColStatistics colStatisticsTarget;
                        long nDVs;
                        String selCol;
                        ColStatistics colStatisticsSJ;
                        Statistics stats = selOp.getStatistics();
                        if (stats == null || (colStatisticsSJ = stats.getColumnStatisticsFromColName(selCol = ExprNodeDescUtils.extractColName(((SelectDesc)selOp.getConf()).getColList().get(0)))) == null || (nDVs = colStatisticsSJ.getCountDistint()) <= 0L) continue block2;
                        RuntimeValuesInfo rti = procCtx.parseContext.getRsToRuntimeValuesInfoMap().get(rs);
                        ExprNodeDesc tsExpr = rti.getTsColExpr();
                        FilterOperator fil = (FilterOperator)ts.getChildOperators().get(0);
                        Statistics filStats = fil.getStatistics();
                        if (filStats == null || (colStatisticsTarget = filStats.getColumnStatisticsFromColName(colName = ExprNodeDescUtils.extractColName(tsExpr))) == null || (long)(nDVsOfTSFactored = (double)((float)(nDVsOfTS = colStatisticsTarget.getCountDistint()) * procCtx.conf.getFloatVar(HiveConf.ConfVars.TEZ_DYNAMIC_SEMIJOIN_REDUCTION_FOR_DPP_FACTOR))) <= nDVs) continue block2;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("nDVs = " + nDVs + ", nDVsOfTS = " + nDVsOfTS + " and nDVsOfTSFactored = " + nDVsOfTSFactored + "Adding semijoin branch from ReduceSink " + rs + " to TS " + sjInfo.getTsOp());
                        }
                        sjInfo.setShouldRemove(false);
                    }
                    catch (NullPointerException e) {
                        if (!LOG.isDebugEnabled()) continue block2;
                        LOG.debug("Caught NPE in markSemiJoinForDPP from ReduceSink " + rs + " to TS " + sjInfo.getTsOp());
                    }
                    continue block2;
                }
                if (op instanceof TerminalOperator) continue;
                deque.addAll(op.getChildOperators());
            }
        }
    }

    private void bucketingVersionSanityCheck(OptimizeTezProcContext procCtx) throws SemanticException {
        HashSet<FileSinkOperator> fsOpsAll = new HashSet<FileSinkOperator>();
        for (TableScanOperator ts : procCtx.parseContext.getTopOps().values()) {
            Set<FileSinkOperator> fsOps = OperatorUtils.findOperators(ts, FileSinkOperator.class);
            fsOpsAll.addAll(fsOps);
        }
        IdentityHashMap<Operator, Integer> processedOperators = new IdentityHashMap<Operator, Integer>();
        block1: for (FileSinkOperator fsOp : fsOpsAll) {
            Operator parent = fsOp;
            List<Operator<OperatorDesc>> parentOps = parent.getParentOperators();
            while (parentOps != null && parentOps.size() == 1) {
                parent = parentOps.get(0);
                if (!(parent instanceof ReduceSinkOperator)) {
                    parentOps = parent.getParentOperators();
                    continue;
                }
                int bucketingVersion = ((FileSinkDesc)fsOp.getConf()).getTableInfo().getBucketingVersion();
                if (((FileSinkDesc)fsOp.getConf()).getTableInfo().getBucketingVersion() == -1) continue block1;
                if (((FileSinkDesc)fsOp.getConf()).getTableInfo().getBucketingVersion() != ((FileSinkDesc)fsOp.getConf()).getBucketingVersion()) {
                    throw new RuntimeException("FsOp bucketingVersions is inconsistent with its tableinfo");
                }
                if (processedOperators.containsKey(parent) && (Integer)processedOperators.get(parent) != bucketingVersion) {
                    throw new SemanticException(String.format("Operator (%s) is already processed and is using bucketingVersion(%d); so it can't be changed to %d ", parent, processedOperators.get(parent), bucketingVersion));
                }
                processedOperators.put(parent, bucketingVersion);
                continue block1;
            }
        }
    }

    private class SemijoinOperatorInfo {
        final ReduceSinkOperator rsOperator;
        final FilterOperator filterOperator;
        final ImmutableSet<String> colNames;
        final Statistics filterStats;
        final double reductionFactor;

        private SemijoinOperatorInfo(ReduceSinkOperator rsOperator, FilterOperator filterOperator, Statistics filterStats, Collection<String> colNames, double reductionFactor) {
            this.rsOperator = rsOperator;
            this.filterOperator = filterOperator;
            this.colNames = ImmutableSet.copyOf(colNames);
            this.filterStats = filterStats;
            this.reductionFactor = reductionFactor;
        }
    }

    private static class MarkTsOfSemijoinsAsIncorrect
    implements NodeProcessor {
        private PlanMapper planMapper;

        private MarkTsOfSemijoinsAsIncorrect() {
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            AppMasterEventOperator ame;
            AppMasterEventDesc c;
            ParseContext pCtx = ((OptimizeTezProcContext)procCtx).parseContext;
            this.planMapper = pCtx.getContext().getPlanMapper();
            if (nd instanceof ReduceSinkOperator) {
                ReduceSinkOperator rs = (ReduceSinkOperator)nd;
                SemiJoinBranchInfo sjInfo = pCtx.getRsToSemiJoinBranchInfo().get(rs);
                if (sjInfo == null) {
                    return null;
                }
                this.walkSubtree(sjInfo.getTsOp());
            }
            if (nd instanceof AppMasterEventOperator && (c = (AppMasterEventDesc)(ame = (AppMasterEventOperator)nd).getConf()) instanceof DynamicPruningEventDesc) {
                DynamicPruningEventDesc dped = (DynamicPruningEventDesc)c;
                this.mark(dped.getTableScan());
            }
            return null;
        }

        private void walkSubtree(Operator<?> root) {
            LinkedList deque = new LinkedList();
            deque.add(root);
            while (!deque.isEmpty()) {
                Operator op = (Operator)deque.pollLast();
                this.mark(op);
                if (op instanceof ReduceSinkOperator) continue;
                deque.addAll(op.getChildOperators());
            }
        }

        private void mark(Operator<?> op) {
            this.planMapper.link(op, new OperatorStats.IncorrectRuntimeStatsMarker());
        }
    }

    private class SemiJoinRemovalContext
    implements NodeProcessorCtx {
        private final ParseContext parseContext;
        private final Map<Operator<?>, TableScanOperator> opsToRemove;

        private SemiJoinRemovalContext(ParseContext parseContext) {
            this.parseContext = parseContext;
            this.opsToRemove = new HashMap();
        }
    }

    private static class DynamicPruningRemovalRedundantProc
    implements NodeProcessor {
        private DynamicPruningRemovalRedundantProc() {
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            AppMasterEventOperator event = (AppMasterEventOperator)nd;
            if (!(event.getConf() instanceof DynamicPruningEventDesc)) {
                return null;
            }
            SemiJoinRemovalContext rCtx = (SemiJoinRemovalContext)procCtx;
            DynamicPruningEventDesc desc = (DynamicPruningEventDesc)event.getConf();
            TableScanOperator targetTSOp = desc.getTableScan();
            String targetColumnName = desc.getTargetColumnName();
            Operator<OperatorDesc> op = event.getParentOperators().get(0);
            while (op.getChildOperators().size() < 2) {
                op = op.getParentOperators().get(0);
            }
            Set<AppMasterEventOperator> eventOps = OperatorUtils.findOperators(op, AppMasterEventOperator.class);
            for (AppMasterEventOperator otherEvent : eventOps) {
                if (!(otherEvent.getConf() instanceof DynamicPruningEventDesc)) continue;
                DynamicPruningEventDesc otherDesc = (DynamicPruningEventDesc)otherEvent.getConf();
                if (otherEvent == event || otherDesc.getTableScan() != targetTSOp || !otherDesc.getTargetColumnName().equals(targetColumnName) || rCtx.opsToRemove.containsKey(otherEvent)) continue;
                rCtx.opsToRemove.put(event, targetTSOp);
                break;
            }
            return null;
        }
    }

    private class SemiJoinRemovalProc
    implements NodeProcessor {
        private final boolean removeBasedOnStats;
        private final boolean removeRedundant;

        private SemiJoinRemovalProc(boolean removeBasedOnStats, boolean removeRedundant) {
            this.removeBasedOnStats = removeBasedOnStats;
            this.removeRedundant = removeRedundant;
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            long numRows;
            TableScanOperator ts;
            ReduceSinkOperator rs = (ReduceSinkOperator)nd;
            SemiJoinRemovalContext rCtx = (SemiJoinRemovalContext)procCtx;
            ParseContext pCtx = rCtx.parseContext;
            SemiJoinBranchInfo sjInfo = pCtx.getRsToSemiJoinBranchInfo().get(rs);
            if (sjInfo == null) {
                return null;
            }
            TableScanOperator targetTSOp = sjInfo.getTsOp();
            ExprNodeDesc targetColExpr = pCtx.getRsToRuntimeValuesInfoMap().get(rs).getTsColExpr();
            GroupByOperator gbOp = (GroupByOperator)stack.get(stack.size() - 2);
            GroupByDesc gbDesc = (GroupByDesc)gbOp.getConf();
            List<AggregationDesc> aggregationDescs = gbDesc.getAggregators();
            for (AggregationDesc agg : aggregationDescs) {
                long expectedEntries;
                if (!TezCompiler.isBloomFilterAgg(agg)) continue;
                GenericUDAFBloomFilter.GenericUDAFBloomFilterEvaluator genericUDAFBloomFilterEvaluator = (GenericUDAFBloomFilter.GenericUDAFBloomFilterEvaluator)agg.getGenericUDAFEvaluator();
                if (genericUDAFBloomFilterEvaluator.hasHintEntries()) {
                    return null;
                }
                if (!this.removeBasedOnStats || (expectedEntries = genericUDAFBloomFilterEvaluator.getExpectedEntries()) != -1L && expectedEntries <= pCtx.getConf().getLongVar(HiveConf.ConfVars.TEZ_MAX_BLOOM_FILTER_ENTRIES)) continue;
                if (sjInfo.getIsHint() && expectedEntries == -1L) {
                    throw new SemanticException("Removing hinted semijoin due to lack to stats or exceeding max bloom filter entries");
                }
                if (sjInfo.getIsHint()) continue;
                for (Node node : gbOp.getChildren()) {
                    ReduceSinkOperator rsFinal = (ReduceSinkOperator)node;
                    TableScanOperator ts2 = pCtx.getRsToSemiJoinBranchInfo().get(rsFinal).getTsOp();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("expectedEntries=" + expectedEntries + ". Either stats unavailable or expectedEntries exceeded max allowable bloomfilter size. Removing semijoin " + OperatorUtils.getOpNamePretty(rs) + " - " + OperatorUtils.getOpNamePretty(ts2));
                    }
                    GenTezUtils.removeBranch(rsFinal);
                    GenTezUtils.removeSemiJoinOperator(pCtx, rsFinal, ts2);
                }
                return null;
            }
            if (this.removeBasedOnStats && (ts = sjInfo.getTsOp()).getStatistics() != null && (numRows = ts.getStatistics().getNumRows()) < pCtx.getConf().getLongVar(HiveConf.ConfVars.TEZ_BIGTABLE_MIN_SIZE_SEMIJOIN_REDUCTION) && sjInfo.getShouldRemove()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Insufficient rows (" + numRows + ") to justify semijoin optimization. Removing semijoin " + OperatorUtils.getOpNamePretty(rs) + " - " + OperatorUtils.getOpNamePretty(ts));
                }
                GenTezUtils.removeBranch(rs);
                GenTezUtils.removeSemiJoinOperator(pCtx, rs, ts);
            }
            if (this.removeRedundant) {
                Set<ReduceSinkOperator> rsOps = OperatorUtils.findOperators(((Operator)stack.get(stack.size() - 5)).getParentOperators().get(0), ReduceSinkOperator.class);
                for (Operator operator : rsOps) {
                    ExprNodeDesc otherColExpr;
                    SemiJoinBranchInfo otherSjInfo = pCtx.getRsToSemiJoinBranchInfo().get(operator);
                    if (operator == rs || otherSjInfo == null || otherSjInfo.getTsOp() != targetTSOp || rCtx.opsToRemove.containsKey(operator) || !(otherColExpr = pCtx.getRsToRuntimeValuesInfoMap().get(operator).getTsColExpr()).isSame(targetColExpr)) continue;
                    rCtx.opsToRemove.put(rs, targetTSOp);
                    break;
                }
            }
            return null;
        }
    }

    private static class TerminalOpsInfo {
        public Set<TerminalOperator<?>> terminalOps;

        TerminalOpsInfo(Set<TerminalOperator<?>> terminalOps) {
            this.terminalOps = terminalOps;
        }
    }

    private static class SMBJoinOpProc
    implements NodeProcessor {
        private SMBJoinOpProc() {
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            SMBJoinOpProcContext ctx = (SMBJoinOpProcContext)procCtx;
            ctx.JoinOpToTsOpMap.put((CommonMergeJoinOperator)nd, (TableScanOperator)stack.get(0));
            return null;
        }
    }

    private static class SMBJoinOpProcContext
    implements NodeProcessorCtx {
        HashMap<CommonMergeJoinOperator, TableScanOperator> JoinOpToTsOpMap = new HashMap();

        private SMBJoinOpProcContext() {
        }
    }
}

