/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.antlr.runtime.tree.Tree;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.metadata.HiveUtils;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.CalcitePlanner;
import org.apache.hadoop.hive.ql.parse.RewriteSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;

public class UpdateDeleteSemanticAnalyzer
extends RewriteSemanticAnalyzer {
    private Context.Operation operation = Context.Operation.OTHER;

    UpdateDeleteSemanticAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    protected ASTNode getTargetTableNode(ASTNode tree) {
        ASTNode tabName = (ASTNode)tree.getChild(0);
        assert (tabName.getToken().getType() == 1136) : "Expected tablename as first child of " + (Object)((Object)this.operation) + " but found " + tabName.getName();
        return tabName;
    }

    @Override
    protected void analyze(ASTNode tree, Table table, ASTNode tabNameNode) throws SemanticException {
        switch (tree.getToken().getType()) {
            case 870: {
                this.analyzeDelete(tree, table, tabNameNode);
                break;
            }
            case 1166: {
                this.analyzeUpdate(tree, table, tabNameNode);
                break;
            }
            default: {
                throw new RuntimeException("Asked to parse token " + tree.getName() + " in UpdateDeleteSemanticAnalyzer");
            }
        }
    }

    private void analyzeUpdate(ASTNode tree, Table mTable, ASTNode tabNameNode) throws SemanticException {
        this.operation = Context.Operation.UPDATE;
        if (HiveConf.getBoolVar(this.queryState.getConf(), HiveConf.ConfVars.SPLIT_UPDATE)) {
            this.analyzeSplitUpdate(tree, mTable, tabNameNode);
        } else {
            this.reparseAndSuperAnalyze(tree, mTable, tabNameNode);
        }
    }

    private void analyzeDelete(ASTNode tree, Table mTable, ASTNode tabNameNode) throws SemanticException {
        this.operation = Context.Operation.DELETE;
        this.reparseAndSuperAnalyze(tree, mTable, tabNameNode);
    }

    private void reparseAndSuperAnalyze(ASTNode tree, Table mTable, ASTNode tabNameNode) throws SemanticException {
        int whereIndex;
        List<Node> children = tree.getChildren();
        StringBuilder rewrittenQueryStr = new StringBuilder();
        rewrittenQueryStr.append("insert into table ");
        rewrittenQueryStr.append(this.getFullTableNameForSQL(tabNameNode));
        this.addPartitionColsToInsert(mTable.getPartCols(), rewrittenQueryStr);
        rewrittenQueryStr.append(" select ROW__ID");
        HashMap<Integer, ASTNode> setColExprs = null;
        Map<String, ASTNode> setCols = null;
        LinkedHashSet<String> setRCols = new LinkedHashSet<String>();
        if (this.updating()) {
            assert (children.size() >= 2) : "Expected update token to have at least two children";
            ASTNode setClause = (ASTNode)children.get(1);
            setCols = this.collectSetColumnsAndExpressions(setClause, setRCols, mTable);
            setColExprs = new HashMap<Integer, ASTNode>(setClause.getChildCount());
            List<FieldSchema> nonPartCols = mTable.getCols();
            for (int i = 0; i < nonPartCols.size(); ++i) {
                rewrittenQueryStr.append(',');
                String name = nonPartCols.get(i).getName();
                ASTNode setCol = setCols.get(name);
                rewrittenQueryStr.append(HiveUtils.unparseIdentifier(name, this.conf));
                if (setCol == null) continue;
                setColExprs.put(i + 1, setCol);
            }
        }
        this.addPartitionColsToSelect(mTable.getPartCols(), rewrittenQueryStr);
        rewrittenQueryStr.append(" from ");
        rewrittenQueryStr.append(this.getFullTableNameForSQL(tabNameNode));
        ASTNode where = null;
        int n = whereIndex = this.deleting() ? 1 : 2;
        if (children.size() > whereIndex) {
            where = (ASTNode)children.get(whereIndex);
            assert (where.getToken().getType() == 1177) : "Expected where clause, but found " + where.getName();
        }
        rewrittenQueryStr.append(" sort by ROW__ID ");
        RewriteSemanticAnalyzer.ReparseResult rr = this.parseRewrittenQuery(rewrittenQueryStr, this.ctx.getCmd());
        Context rewrittenCtx = rr.rewrittenCtx;
        ASTNode rewrittenTree = rr.rewrittenTree;
        ASTNode rewrittenInsert = (ASTNode)rewrittenTree.getChildren().get(1);
        assert (rewrittenInsert.getToken().getType() == 928) : "Expected TOK_INSERT as second child of TOK_QUERY but found " + rewrittenInsert.getName();
        if (this.updating()) {
            rewrittenCtx.setOperation(Context.Operation.UPDATE);
            rewrittenCtx.addDestNamePrefix(1, Context.DestClausePrefix.UPDATE);
        } else if (this.deleting()) {
            rewrittenCtx.setOperation(Context.Operation.DELETE);
            rewrittenCtx.addDestNamePrefix(1, Context.DestClausePrefix.DELETE);
        }
        if (where != null) {
            ASTNode sortBy = (ASTNode)rewrittenInsert.getChildren().get(2);
            assert (sortBy.getToken().getType() == 1093) : "Expected TOK_SORTBY to be first child of TOK_SELECT, but found " + sortBy.getName();
            rewrittenInsert.addChild((Tree)sortBy);
            rewrittenInsert.setChild(2, (Tree)where);
        }
        if (this.updating() && setColExprs != null) {
            this.patchProjectionForUpdate(rewrittenInsert, setColExprs);
        }
        rewrittenCtx.setEnableUnparse(false);
        this.analyzeRewrittenTree(rewrittenTree, rewrittenCtx);
        this.updateOutputs(mTable);
        if (this.updating()) {
            this.setUpAccessControlInfoForUpdate(mTable, setCols);
            for (String colName : setRCols) {
                if (this.columnAccessInfo == null) continue;
                this.columnAccessInfo.add(Table.getCompleteName(mTable.getDbName(), mTable.getTableName()), colName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void analyzeSplitUpdate(ASTNode tree, Table mTable, ASTNode tabNameNode) throws SemanticException {
        this.operation = Context.Operation.UPDATE;
        List<Node> children = tree.getChildren();
        ASTNode where = null;
        int whereIndex = 2;
        if (children.size() > whereIndex) {
            where = (ASTNode)children.get(whereIndex);
            assert (where.getToken().getType() == 1177) : "Expected where clause, but found " + where.getName();
        }
        LinkedHashSet<String> setRCols = new LinkedHashSet<String>();
        assert (children.size() >= 2) : "Expected update token to have at least two children";
        ASTNode setClause = (ASTNode)children.get(1);
        Map<String, ASTNode> setCols = this.collectSetColumnsAndExpressions(setClause, setRCols, mTable);
        HashMap<Integer, ASTNode> setColExprs = new HashMap<Integer, ASTNode>(setClause.getChildCount());
        List<FieldSchema> nonPartCols = mTable.getCols();
        Map<String, String> colNameToDefaultConstraint = UpdateDeleteSemanticAnalyzer.getColNameToDefaultValueMap(mTable);
        ArrayList<String> values = new ArrayList<String>(mTable.getCols().size());
        StringBuilder rewrittenQueryStr = this.createRewrittenQueryStrBuilder();
        rewrittenQueryStr.append("(SELECT ROW__ID");
        for (int i = 0; i < nonPartCols.size(); ++i) {
            rewrittenQueryStr.append(',');
            String name = nonPartCols.get(i).getName();
            ASTNode setCol = setCols.get(name);
            String identifier = HiveUtils.unparseIdentifier(name, this.conf);
            if (setCol != null) {
                if (setCol.getType() == 1133 && setCol.getChildCount() == 1 && setCol.getChild(0).getType() == 868) {
                    rewrittenQueryStr.append(colNameToDefaultConstraint.get(name));
                } else {
                    rewrittenQueryStr.append(identifier);
                    setColExprs.put(i + 1, setCol);
                }
            } else {
                rewrittenQueryStr.append(identifier);
            }
            rewrittenQueryStr.append(" AS ");
            rewrittenQueryStr.append(identifier);
            values.add("s." + identifier);
        }
        this.addPartitionColsToSelect(mTable.getPartCols(), rewrittenQueryStr);
        this.addPartitionColsAsValues(mTable.getPartCols(), "s", values);
        rewrittenQueryStr.append(" FROM ").append(this.getFullTableNameForSQL(tabNameNode)).append(") s\n");
        this.appendInsertBranch(rewrittenQueryStr, null, values);
        this.appendDeleteBranch(rewrittenQueryStr, null, "s", Collections.singletonList("s.ROW__ID "));
        this.appendSortBy(rewrittenQueryStr, Collections.singletonList("s.ROW__ID "));
        RewriteSemanticAnalyzer.ReparseResult rr = this.parseRewrittenQuery(rewrittenQueryStr, this.ctx.getCmd());
        Context rewrittenCtx = rr.rewrittenCtx;
        ASTNode rewrittenTree = rr.rewrittenTree;
        ASTNode rewrittenInsert = new CalcitePlanner.ASTSearcher().simpleBreadthFirstSearch(rewrittenTree, 909, 1100, 928);
        rewrittenCtx.setOperation(Context.Operation.UPDATE);
        rewrittenCtx.addDestNamePrefix(1, Context.DestClausePrefix.INSERT);
        rewrittenCtx.addDeleteOfUpdateDestNamePrefix(2, Context.DestClausePrefix.DELETE);
        if (where != null) {
            rewrittenInsert.addChild((Tree)where);
        }
        this.patchProjectionForUpdate(rewrittenInsert, setColExprs);
        try {
            this.useSuper = true;
            rewrittenCtx.setEnableUnparse(false);
            super.analyze(rewrittenTree, rewrittenCtx);
        }
        finally {
            this.useSuper = false;
        }
        this.updateOutputs(mTable);
        this.setUpAccessControlInfoForUpdate(mTable, setCols);
        if (this.columnAccessInfo == null) {
            return;
        }
        for (String colName : setRCols) {
            this.columnAccessInfo.add(Table.getCompleteName(mTable.getDbName(), mTable.getTableName()), colName);
        }
    }

    private boolean updating() {
        return this.operation == Context.Operation.UPDATE;
    }

    private boolean deleting() {
        return this.operation == Context.Operation.DELETE;
    }

    @Override
    protected boolean allowOutputMultipleTimes() {
        return this.conf.getBoolVar(HiveConf.ConfVars.SPLIT_UPDATE);
    }

    @Override
    protected boolean enableColumnStatsCollecting() {
        return false;
    }
}

