/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.repl.dump;

import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.Function;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;
import org.apache.hadoop.hive.ql.parse.repl.dump.BootStrapReplicationSpecFunction;
import org.apache.hadoop.hive.ql.parse.repl.dump.Utils;

public class HiveWrapper {
    private final Hive db;
    private final String dbName;
    private final Tuple.Function<ReplicationSpec> functionForSpec;

    public HiveWrapper(Hive db, String dbName) {
        this(db, dbName, 0L);
    }

    public HiveWrapper(Hive db, String dbName, long lastReplId) {
        this.dbName = dbName;
        this.db = db;
        this.functionForSpec = new BootStrapReplicationSpecFunction(db, lastReplId);
    }

    public Tuple<Function> function(String name) throws HiveException {
        return new Tuple<Function>(this.functionForSpec, () -> this.db.getFunction(this.dbName, name));
    }

    public Tuple<Database> database() throws HiveException {
        return new Tuple<Database>(this.functionForSpec, () -> this.db.getDatabase(this.dbName));
    }

    public Tuple<Table> table(String tableName, HiveConf conf) throws HiveException {
        boolean getColStats = !Utils.shouldDumpMetaDataOnlyForExternalTables(this.db.getTable(this.dbName, tableName), conf) && !Utils.shouldDumpMetaDataOnly(conf);
        return new Tuple<Table>(this.functionForSpec, () -> this.db.getTable(this.dbName, tableName, true, false, getColStats));
    }

    public Tuple<Table> table(Table tblObj) throws HiveException {
        return new Tuple<Table>(this.functionForSpec, () -> tblObj);
    }

    public static class Tuple<T> {
        public final ReplicationSpec replicationSpec;
        public final T object;

        Tuple(Function<ReplicationSpec> replicationSpecFunction, Function<T> functionForObject) throws HiveException {
            this.replicationSpec = replicationSpecFunction.fromMetaStore();
            this.object = functionForObject.fromMetaStore();
        }

        static interface Function<T> {
            public T fromMetaStore() throws HiveException;
        }
    }
}

