/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.repl.dump.events;

import java.io.File;
import java.util.Iterator;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.NotificationEvent;
import org.apache.hadoop.hive.metastore.messaging.AddPartitionMessage;
import org.apache.hadoop.hive.metastore.messaging.EventMessage;
import org.apache.hadoop.hive.metastore.messaging.PartitionFiles;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.EximUtil;
import org.apache.hadoop.hive.ql.parse.repl.DumpType;
import org.apache.hadoop.hive.ql.parse.repl.dump.Utils;
import org.apache.hadoop.hive.ql.parse.repl.dump.events.AbstractEventHandler;
import org.apache.hadoop.hive.ql.parse.repl.dump.events.EventHandler;

class AddPartitionHandler
extends AbstractEventHandler {
    protected AddPartitionHandler(NotificationEvent notificationEvent) {
        super(notificationEvent);
    }

    EventMessage eventMessage(String stringRepresentation) {
        return this.deserializer.getAddPartitionMessage(stringRepresentation);
    }

    @Override
    public void handle(EventHandler.Context withinContext) throws Exception {
        LOG.info("Processing#{} ADD_PARTITION message : {}", (Object)this.fromEventId(), (Object)this.eventMessageAsJSON);
        if (withinContext.hiveConf.getBoolVar(HiveConf.ConfVars.REPL_DUMP_METADATA_ONLY)) {
            return;
        }
        AddPartitionMessage apm = (AddPartitionMessage)this.eventMessage;
        org.apache.hadoop.hive.metastore.api.Table tobj = apm.getTableObj();
        if (tobj == null) {
            LOG.debug("Event#{} was a ADD_PTN_EVENT with no table listed", (Object)this.fromEventId());
            return;
        }
        Table qlMdTable = new Table(tobj);
        if (!Utils.shouldReplicate(withinContext.replicationSpec, qlMdTable, true, withinContext.getTablesForBootstrap(), withinContext.oldReplScope, withinContext.hiveConf)) {
            return;
        }
        Iterable<org.apache.hadoop.hive.metastore.api.Partition> ptns = apm.getPartitionObjs();
        if (ptns == null || !ptns.iterator().hasNext()) {
            LOG.debug("Event#{} was an ADD_PTN_EVENT with no partitions", (Object)this.fromEventId());
            return;
        }
        Iterable qlPtns = StreamSupport.stream(ptns.spliterator(), true).map(input -> {
            if (input == null) {
                return null;
            }
            try {
                return new Partition(qlMdTable, (org.apache.hadoop.hive.metastore.api.Partition)input);
            }
            catch (HiveException e) {
                throw new IllegalArgumentException(e);
            }
        }).collect(Collectors.toList());
        Path metaDataPath = new Path(withinContext.eventRoot, "_metadata");
        EximUtil.createExportDump(metaDataPath.getFileSystem((Configuration)withinContext.hiveConf), metaDataPath, qlMdTable, qlPtns, withinContext.replicationSpec, withinContext.hiveConf);
        boolean copyAtLoad = withinContext.hiveConf.getBoolVar(HiveConf.ConfVars.REPL_RUN_DATA_COPY_TASKS_ON_TARGET);
        Iterator<PartitionFiles> partitionFilesIter = apm.getPartitionFilesIter().iterator();
        if (partitionFilesIter.hasNext()) {
            for (Partition qlPtn : qlPtns) {
                Iterable<String> files = partitionFilesIter.next().getFiles();
                if (files == null) continue;
                if (copyAtLoad) {
                    Path ptnDataPath = new Path(withinContext.eventRoot, "data" + File.separator + qlPtn.getName());
                    this.writeEncodedDumpFiles(withinContext, files, ptnDataPath);
                    continue;
                }
                for (String file : files) {
                    this.writeFileEntry(qlMdTable, qlPtn, file, withinContext);
                }
            }
        }
        withinContext.createDmd(this).write();
    }

    @Override
    public DumpType dumpType() {
        return DumpType.EVENT_ADD_PARTITION;
    }
}

