/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.repl.dump.events;

import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.repl.ReplScope;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.NotificationEvent;
import org.apache.hadoop.hive.metastore.messaging.AlterTableMessage;
import org.apache.hadoop.hive.ql.exec.repl.util.ReplUtils;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.EximUtil;
import org.apache.hadoop.hive.ql.parse.repl.DumpType;
import org.apache.hadoop.hive.ql.parse.repl.dump.Utils;
import org.apache.hadoop.hive.ql.parse.repl.dump.events.AbstractEventHandler;
import org.apache.hadoop.hive.ql.parse.repl.dump.events.EventHandler;
import org.apache.hadoop.hive.ql.parse.repl.load.DumpMetaData;

class AlterTableHandler
extends AbstractEventHandler<AlterTableMessage> {
    private final org.apache.hadoop.hive.metastore.api.Table before;
    private final org.apache.hadoop.hive.metastore.api.Table after;
    private final boolean isTruncateOp;
    private Scenario scenario;

    AlterTableHandler(NotificationEvent event) throws Exception {
        super(event);
        this.before = ((AlterTableMessage)this.eventMessage).getTableObjBefore();
        this.after = ((AlterTableMessage)this.eventMessage).getTableObjAfter();
        this.isTruncateOp = ((AlterTableMessage)this.eventMessage).getIsTruncateOp();
        this.scenario = this.scenarioType(this.before, this.after);
    }

    @Override
    AlterTableMessage eventMessage(String stringRepresentation) {
        return this.deserializer.getAlterTableMessage(stringRepresentation);
    }

    private Scenario scenarioType(org.apache.hadoop.hive.metastore.api.Table before, org.apache.hadoop.hive.metastore.api.Table after) {
        if (before.getDbName().equalsIgnoreCase(after.getDbName()) && before.getTableName().equalsIgnoreCase(after.getTableName())) {
            return this.isTruncateOp ? Scenario.TRUNCATE : Scenario.ALTER;
        }
        return Scenario.RENAME;
    }

    private boolean handleRenameForReplacePolicy(EventHandler.Context withinContext, String oldName, String newName) {
        boolean oldTableInBootstrapList = withinContext.removeFromListOfTablesForBootstrap(oldName);
        if (ReplUtils.tableIncludedInReplScope(withinContext.replScope, newName)) {
            LOG.info("Table " + newName + " is added for bootstrap  during rename from " + oldName);
            withinContext.addToListOfTablesForBootstrap(newName);
        }
        if (ReplUtils.tableIncludedInReplScope(withinContext.oldReplScope, oldName)) {
            if (oldTableInBootstrapList) {
                return false;
            }
            this.scenario = Scenario.DROP;
            LOG.info("Table " + oldName + " will be dropped as the table is renamed to " + newName);
            return true;
        }
        return false;
    }

    private boolean handleRenameForTableLevelReplication(EventHandler.Context withinContext, String oldName, String newName) {
        if (ReplUtils.tableIncludedInReplScope(withinContext.replScope, oldName)) {
            boolean oldTableInBootstrapList = withinContext.removeFromListOfTablesForBootstrap(oldName);
            if (!ReplUtils.tableIncludedInReplScope(withinContext.replScope, newName)) {
                if (oldTableInBootstrapList) {
                    return false;
                }
                this.scenario = Scenario.DROP;
                LOG.info("Table " + oldName + " will be dropped as the table is renamed to " + newName);
                return true;
            }
            if (oldTableInBootstrapList) {
                withinContext.addToListOfTablesForBootstrap(newName);
                return false;
            }
            LOG.info("both old and new table satisfies the policy");
            return true;
        }
        if (ReplUtils.tableIncludedInReplScope(withinContext.replScope, newName)) {
            LOG.info("Table " + newName + " is added for bootstrap  during rename from " + oldName);
            withinContext.addToListOfTablesForBootstrap(newName);
            return false;
        }
        LOG.info("both old and new table does not satisfies the policy");
        return false;
    }

    @Override
    public void handle(EventHandler.Context withinContext) throws Exception {
        ReplScope oldReplScope;
        Set<String> bootstrapTableList;
        LOG.info("Processing#{} ALTER_TABLE message : {}", (Object)this.fromEventId(), (Object)this.eventMessageAsJSON);
        Table qlMdTableBefore = new Table(this.before);
        if (Scenario.RENAME == this.scenario) {
            bootstrapTableList = null;
            oldReplScope = null;
        } else {
            if (!ReplUtils.tableIncludedInReplScope(withinContext.replScope, this.before.getTableName())) {
                LOG.debug("Table " + this.before.getTableName() + " does not satisfy the policy");
                return;
            }
            bootstrapTableList = withinContext.getTablesForBootstrap();
            oldReplScope = withinContext.oldReplScope;
        }
        if (!Utils.shouldReplicate(withinContext.replicationSpec, qlMdTableBefore, true, bootstrapTableList, oldReplScope, withinContext.hiveConf)) {
            return;
        }
        if (withinContext.hiveConf.getBoolVar(HiveConf.ConfVars.REPL_BOOTSTRAP_ACID_TABLES) && !AcidUtils.isTransactionalTable(this.before) && AcidUtils.isTransactionalTable(this.after)) {
            LOG.info("The table " + this.after.getTableName() + " is converted to ACID table. It will be replicated with bootstrap load as hive.repl.bootstrap.acid.tables is set to true.");
            return;
        }
        if (Scenario.RENAME == this.scenario) {
            String oldName = this.before.getTableName();
            String newName = this.after.getTableName();
            boolean needDump = true;
            if (withinContext.oldReplScope != null && !withinContext.oldReplScope.equals(withinContext.replScope)) {
                needDump = this.handleRenameForReplacePolicy(withinContext, oldName, newName);
            } else if (!withinContext.replScope.includeAllTables()) {
                needDump = this.handleRenameForTableLevelReplication(withinContext, oldName, newName);
            }
            if (!needDump) {
                LOG.info("Rename event for table " + oldName + " to " + newName + " is skipped from dumping");
                return;
            }
        }
        if (Scenario.ALTER == this.scenario) {
            withinContext.replicationSpec.setIsMetadataOnly(true);
            Table qlMdTableAfter = new Table(this.after);
            Path metaDataPath = new Path(withinContext.eventRoot, "_metadata");
            if (Utils.shouldDumpMetaDataOnly(withinContext.hiveConf) || Utils.shouldDumpMetaDataOnlyForExternalTables(qlMdTableAfter, withinContext.hiveConf)) {
                qlMdTableAfter.setStatsStateLikeNewTable();
            }
            EximUtil.createExportDump(metaDataPath.getFileSystem((Configuration)withinContext.hiveConf), metaDataPath, qlMdTableAfter, null, withinContext.replicationSpec, withinContext.hiveConf);
        }
        DumpMetaData dmd = withinContext.createDmd(this);
        dmd.setPayload(this.eventMessageAsJSON);
        dmd.write();
    }

    @Override
    public DumpType dumpType() {
        return this.scenario.dumpType();
    }

    private static enum Scenario {
        ALTER{

            @Override
            DumpType dumpType() {
                return DumpType.EVENT_ALTER_TABLE;
            }
        }
        ,
        RENAME{

            @Override
            DumpType dumpType() {
                return DumpType.EVENT_RENAME_TABLE;
            }
        }
        ,
        TRUNCATE{

            @Override
            DumpType dumpType() {
                return DumpType.EVENT_TRUNCATE_TABLE;
            }
        }
        ,
        DROP{

            @Override
            DumpType dumpType() {
                return DumpType.EVENT_RENAME_DROP_TABLE;
            }
        };


        abstract DumpType dumpType();
    }
}

