/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.repl.dump.io;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.ReplChangeManager;
import org.apache.hadoop.hive.metastore.api.Function;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.ResourceUri;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.parse.EximUtil;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.repl.PathBuilder;
import org.apache.hadoop.hive.ql.parse.repl.dump.Utils;
import org.apache.hadoop.hive.ql.parse.repl.dump.io.JsonWriter;
import org.apache.thrift.TException;
import org.apache.thrift.TSerializer;
import org.apache.thrift.protocol.TJSONProtocol;
import org.apache.thrift.transport.TTransportException;

public class FunctionSerializer
implements JsonWriter.Serializer {
    public static final String FIELD_NAME = "function";
    private Function function;
    private HiveConf hiveConf;
    private Path functionDataRoot;
    private boolean copyAtLoad;
    private List<EximUtil.DataCopyPath> functionBinaryCopyPaths = new ArrayList<EximUtil.DataCopyPath>();

    public FunctionSerializer(Function function, Path functionDataRoot, boolean copyAtLoad, HiveConf hiveConf) {
        this.hiveConf = hiveConf;
        this.function = function;
        this.functionDataRoot = functionDataRoot;
        this.copyAtLoad = copyAtLoad;
    }

    @Override
    public void writeTo(JsonWriter writer, ReplicationSpec additionalPropertiesProvider) throws SemanticException, IOException, MetaException {
        TSerializer serializer = null;
        try {
            serializer = new TSerializer(new TJSONProtocol.Factory());
        }
        catch (TTransportException ex) {
            throw new MetaException(ex.toString());
        }
        ArrayList<ResourceUri> resourceUris = new ArrayList<ResourceUri>();
        if (this.function.getResourceUris() != null) {
            for (ResourceUri uri : this.function.getResourceUris()) {
                Path inputPath = new Path(uri.getUri());
                if ("hdfs".equals(inputPath.toUri().getScheme())) {
                    FileSystem fileSystem = inputPath.getFileSystem((Configuration)this.hiveConf);
                    Path qualifiedUri = PathBuilder.fullyQualifiedHDFSUri(inputPath, fileSystem);
                    String checkSum = ReplChangeManager.checksumFor(qualifiedUri, fileSystem);
                    String encodedSrcUri = ReplChangeManager.getInstance(this.hiveConf).encodeFileUri(qualifiedUri.toString(), checkSum, null);
                    if (this.copyAtLoad) {
                        if (this.hiveConf.getBoolVar(HiveConf.ConfVars.REPL_HA_DATAPATH_REPLACE_REMOTE_NAMESERVICE)) {
                            encodedSrcUri = Utils.replaceNameserviceInEncodedURI(encodedSrcUri, this.hiveConf);
                        }
                        resourceUris.add(new ResourceUri(uri.getResourceType(), encodedSrcUri));
                        continue;
                    }
                    Path newBinaryPath = new Path(this.functionDataRoot, qualifiedUri.getName());
                    resourceUris.add(new ResourceUri(uri.getResourceType(), newBinaryPath.toString()));
                    this.functionBinaryCopyPaths.add(new EximUtil.DataCopyPath(additionalPropertiesProvider, new Path(encodedSrcUri), newBinaryPath));
                    continue;
                }
                resourceUris.add(uri);
            }
        }
        Function copyObj = new Function(this.function);
        if (!resourceUris.isEmpty()) {
            assert (resourceUris.size() == this.function.getResourceUris().size());
            copyObj.setResourceUris(resourceUris);
        }
        try {
            writer.jsonGenerator.writeStringField(ReplicationSpec.KEY.REPL_SCOPE.toString(), "all");
            writer.jsonGenerator.writeStringField(ReplicationSpec.KEY.CURR_STATE_ID.toString(), additionalPropertiesProvider.getCurrentReplicationState());
            writer.jsonGenerator.writeStringField(FIELD_NAME, serializer.toString(copyObj));
        }
        catch (TException e) {
            throw new SemanticException(ErrorMsg.ERROR_SERIALIZE_METASTORE.getMsg(), e);
        }
    }

    public List<EximUtil.DataCopyPath> getFunctionBinaryCopyPaths() {
        return this.functionBinaryCopyPaths;
    }
}

