/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.repl.load;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.repl.ReplScope;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.repl.DumpType;
import org.apache.hadoop.hive.ql.parse.repl.dump.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DumpMetaData {
    public static final String DUMP_METADATA = "_dumpmetadata";
    private static final Logger LOG = LoggerFactory.getLogger(DumpMetaData.class);
    private DumpType dumpType;
    private Long eventFrom = null;
    private Long eventTo = null;
    private Path cmRoot;
    private String payload = null;
    private ReplScope replScope = null;
    private boolean initialized = false;
    private final Path dumpFile;
    private final HiveConf hiveConf;
    private Long dumpExecutionId;
    private boolean replScopeModified = false;

    public DumpMetaData(Path dumpRoot, HiveConf hiveConf) {
        this.hiveConf = hiveConf;
        this.dumpFile = new Path(dumpRoot, DUMP_METADATA);
    }

    public DumpMetaData(Path dumpRoot, DumpType lvl, Long eventFrom, Long eventTo, Path cmRoot, HiveConf hiveConf) {
        this(dumpRoot, hiveConf);
        this.setDump(lvl, eventFrom, eventTo, cmRoot, 0L, false);
    }

    public void setDump(DumpType lvl, Long eventFrom, Long eventTo, Path cmRoot, Long dumpExecutionId, boolean replScopeModified) {
        this.dumpType = lvl;
        this.eventFrom = eventFrom;
        this.eventTo = eventTo;
        this.cmRoot = cmRoot;
        this.initialized = true;
        this.dumpExecutionId = dumpExecutionId;
        this.replScopeModified = replScopeModified;
    }

    public void setPayload(String payload) {
        this.payload = payload;
    }

    public void setReplScope(ReplScope replScope) {
        this.replScope = replScope;
    }

    public void setDumpType(DumpType dumpType) {
        this.dumpType = dumpType;
    }

    private void readReplScope(String line) throws IOException {
        if (line == null) {
            return;
        }
        String[] lineContents = line.split("\t");
        this.replScope = new ReplScope();
        block5: for (int idx = 0; idx < lineContents.length; ++idx) {
            String value = lineContents[idx];
            switch (idx) {
                case 0: {
                    LOG.info("Read ReplScope: Set Db Name: {}.", (Object)value);
                    this.replScope.setDbName(value);
                    continue block5;
                }
                case 1: {
                    LOG.info("Read ReplScope: Include table name list: {}.", (Object)value);
                    this.replScope.setIncludedTablePatterns(value);
                    continue block5;
                }
                case 2: {
                    LOG.info("Read ReplScope: Exclude table name list: {}.", (Object)value);
                    this.replScope.setExcludedTablePatterns(value);
                    continue block5;
                }
                default: {
                    throw new IOException("Invalid repl tables list data in dump metadata file");
                }
            }
        }
    }

    private void loadDumpFromFile() throws SemanticException {
        BufferedReader br = null;
        try {
            FileSystem fs = this.dumpFile.getFileSystem((Configuration)this.hiveConf);
            br = new BufferedReader(new InputStreamReader((InputStream)fs.open(this.dumpFile)));
            String line = br.readLine();
            if (line == null) {
                throw new IOException("Unable to read valid values from dumpFile:" + this.dumpFile.toUri().toString());
            }
            String[] lineContents = line.split("\t", 7);
            this.setDump(lineContents[0].equals("NULL") ? null : DumpType.valueOf(lineContents[0]), lineContents[1].equals("NULL") ? null : Long.valueOf(lineContents[1]), lineContents[2].equals("NULL") ? null : Long.valueOf(lineContents[2]), lineContents[3].equals("NULL") ? null : new Path(lineContents[3]), lineContents[4].equals("NULL") ? null : Long.valueOf(lineContents[4]), lineContents.length < 7 || lineContents[6].equals("NULL") ? Boolean.valueOf(false) : Boolean.valueOf(lineContents[6]));
            this.setPayload(lineContents[5].equals("NULL") ? null : lineContents[5]);
            this.readReplScope(br.readLine());
        }
        catch (IOException ioe) {
            throw new SemanticException(ioe);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    throw new SemanticException(e);
                }
            }
        }
    }

    public DumpType getDumpType() throws SemanticException {
        this.initializeIfNot();
        return this.dumpType;
    }

    public String getPayload() throws SemanticException {
        this.initializeIfNot();
        return this.payload;
    }

    public Long getEventFrom() throws SemanticException {
        this.initializeIfNot();
        return this.eventFrom;
    }

    public Long getEventTo() throws SemanticException {
        this.initializeIfNot();
        return this.eventTo;
    }

    public Long getDumpExecutionId() throws SemanticException {
        this.initializeIfNot();
        return this.dumpExecutionId;
    }

    public boolean isReplScopeModified() throws SemanticException {
        this.initializeIfNot();
        return this.replScopeModified;
    }

    public ReplScope getReplScope() throws SemanticException {
        this.initializeIfNot();
        return this.replScope;
    }

    public Path getDumpFilePath() {
        return this.dumpFile;
    }

    public static String getDmdFileName() {
        return DUMP_METADATA;
    }

    public boolean isIncrementalDump() throws SemanticException {
        this.initializeIfNot();
        return this.dumpType == DumpType.INCREMENTAL;
    }

    private void initializeIfNot() throws SemanticException {
        if (!this.initialized) {
            this.loadDumpFromFile();
        }
    }

    public List<String> prepareReplScopeValues() {
        assert (this.replScope != null);
        ArrayList<String> values = new ArrayList<String>();
        values.add(this.replScope.getDbName());
        String includedTableNames = this.replScope.getIncludedTableNames();
        String excludedTableNames = this.replScope.getExcludedTableNames();
        if (includedTableNames != null) {
            values.add(includedTableNames);
        }
        if (excludedTableNames != null) {
            values.add(excludedTableNames);
        }
        LOG.info("Preparing ReplScope {} to dump.", values);
        return values;
    }

    public void write() throws SemanticException {
        this.write(false);
    }

    public void write(boolean replace) throws SemanticException {
        ArrayList<List<String>> listValues = new ArrayList<List<String>>();
        listValues.add(Arrays.asList(this.dumpType != null ? this.dumpType.toString() : null, this.eventFrom != null ? this.eventFrom.toString() : null, this.eventTo != null ? this.eventTo.toString() : null, this.cmRoot != null ? this.cmRoot.toString() : null, this.dumpExecutionId != null ? this.dumpExecutionId.toString() : null, this.payload, String.valueOf(this.replScopeModified)));
        if (this.replScope != null) {
            listValues.add(this.prepareReplScopeValues());
        }
        Utils.writeOutput(listValues, this.dumpFile, this.hiveConf, replace);
    }
}

