/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.repl.load;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.repl.dump.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
public class FailoverMetaData {
    public static final String FAILOVER_METADATA = "_failovermetadata";
    private static final Logger LOG = LoggerFactory.getLogger(FailoverMetaData.class);
    private static ObjectMapper JSON_OBJECT_MAPPER = new ObjectMapper();
    @JsonProperty
    private Long failoverEventId = null;
    @JsonProperty
    private Long cursorPoint = null;
    @JsonProperty
    private List<Long> abortedTxns;
    @JsonProperty
    private List<Long> openTxns;
    @JsonProperty
    private List<Long> txnsWithoutLock;
    @JsonIgnore
    private volatile boolean initialized = false;
    @JsonIgnore
    private final Path metadataFile;
    @JsonIgnore
    private final HiveConf hiveConf;

    public FailoverMetaData() {
        this.metadataFile = null;
        this.hiveConf = null;
    }

    public FailoverMetaData(Path dumpDir, HiveConf hiveConf) {
        this.hiveConf = hiveConf;
        this.metadataFile = new Path(dumpDir, FAILOVER_METADATA);
    }

    private void initializeIfNot() throws SemanticException {
        if (!this.initialized) {
            this.loadMetadataFromFile();
            this.initialized = true;
        }
    }

    public void setMetaData(FailoverMetaData otherDMD) {
        this.failoverEventId = otherDMD.failoverEventId;
        this.abortedTxns = otherDMD.abortedTxns;
        this.openTxns = otherDMD.openTxns;
        this.cursorPoint = otherDMD.cursorPoint;
        this.txnsWithoutLock = otherDMD.txnsWithoutLock;
        this.initialized = true;
    }

    private synchronized void loadMetadataFromFile() throws SemanticException {
        block12: {
            if (!this.initialized) {
                LOG.info("Reading failover metadata from file: ", (Object)this.metadataFile);
                BufferedReader br = null;
                try {
                    FileSystem fs = this.metadataFile.getFileSystem((Configuration)this.hiveConf);
                    br = new BufferedReader(new InputStreamReader((InputStream)fs.open(this.metadataFile)));
                    String line = br.readLine();
                    if (line != null) {
                        FailoverMetaData otherDMD = (FailoverMetaData)JSON_OBJECT_MAPPER.readValue(line, FailoverMetaData.class);
                        this.setMetaData(otherDMD);
                        break block12;
                    }
                    throw new IOException("Unable to read valid values from failover Metadata file:" + this.metadataFile.toUri().toString());
                }
                catch (IOException ioe) {
                    throw new SemanticException(ioe);
                }
                finally {
                    if (br != null) {
                        try {
                            br.close();
                        }
                        catch (IOException e) {
                            throw new SemanticException(e);
                        }
                    }
                }
            }
        }
    }

    public void setFailoverEventId(Long failoverEventId) {
        this.failoverEventId = failoverEventId;
        this.initialized = true;
    }

    public void setAbortedTxns(List<Long> abortedTxns) {
        this.abortedTxns = abortedTxns;
        this.initialized = true;
    }

    public void addToAbortedTxns(List<Long> abortedTxns) {
        if (this.abortedTxns == null) {
            this.abortedTxns = abortedTxns;
        } else {
            this.abortedTxns.addAll(abortedTxns);
        }
    }

    public void setCursorPoint(Long cursorPoint) {
        this.cursorPoint = cursorPoint;
        this.initialized = true;
    }

    public void setOpenTxns(List<Long> openTxns) {
        this.openTxns = openTxns;
        this.initialized = true;
    }

    public void setTxnsWithoutLock(List<Long> txnsWithoutLock) {
        this.txnsWithoutLock = txnsWithoutLock;
        this.initialized = true;
    }

    public Long getCursorPoint() throws SemanticException {
        this.initializeIfNot();
        return this.cursorPoint;
    }

    public List<Long> getOpenTxns() throws SemanticException {
        this.initializeIfNot();
        return this.openTxns;
    }

    public Long getFailoverEventId() throws SemanticException {
        this.initializeIfNot();
        return this.failoverEventId;
    }

    public List<Long> getAbortedTxns() throws SemanticException {
        this.initializeIfNot();
        return this.abortedTxns;
    }

    public List<Long> getTxnsWithoutLock() throws SemanticException {
        this.initializeIfNot();
        return this.txnsWithoutLock;
    }

    @JsonIgnore
    public boolean isValidMetadata() throws SemanticException {
        this.initializeIfNot();
        return this.openTxns != null && this.abortedTxns != null && this.failoverEventId != null && this.cursorPoint != null && this.txnsWithoutLock != null;
    }

    public boolean equals(FailoverMetaData otherFmd) throws SemanticException {
        this.initializeIfNot();
        return this.failoverEventId.equals(otherFmd.getFailoverEventId()) && this.openTxns.equals(otherFmd.getOpenTxns()) && this.abortedTxns.equals(otherFmd.getAbortedTxns()) && this.txnsWithoutLock.equals(otherFmd.getTxnsWithoutLock()) && this.cursorPoint.equals(otherFmd.getCursorPoint());
    }

    @JsonIgnore
    public String getFilePath() {
        return this.metadataFile == null ? null : this.metadataFile.toString();
    }

    public void write() throws SemanticException {
        try {
            String failoverContentAsJSON = JSON_OBJECT_MAPPER.writeValueAsString((Object)this);
            Utils.writeOutput(failoverContentAsJSON, this.metadataFile, this.hiveConf);
        }
        catch (JsonProcessingException e) {
            throw new SemanticException(e);
        }
    }
}

