/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.repl.load.message;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.metastore.messaging.DropConstraintMessage;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.table.constraint.drop.AlterTableDropConstraintDesc;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.parse.HiveTableName;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.repl.load.message.AbstractMessageHandler;
import org.apache.hadoop.hive.ql.parse.repl.load.message.MessageHandler;

public class DropConstraintHandler
extends AbstractMessageHandler {
    @Override
    public List<Task<? extends Serializable>> handle(MessageHandler.Context context) throws SemanticException {
        DropConstraintMessage msg = this.deserializer.getDropConstraintMessage(context.dmd.getPayload());
        String actualDbName = context.isDbNameEmpty() ? msg.getDB() : context.dbName;
        String actualTblName = msg.getTable();
        TableName tName = HiveTableName.ofNullable(actualTblName, actualDbName);
        String constraintName = msg.getConstraint();
        AlterTableDropConstraintDesc dropConstraintsDesc = new AlterTableDropConstraintDesc(tName, context.eventOnlyReplicationSpec(), constraintName);
        Task<DDLWork> dropConstraintsTask = TaskFactory.get(new DDLWork(this.readEntitySet, this.writeEntitySet, dropConstraintsDesc, true, context.getDumpDirectory(), context.getMetricCollector()), context.hiveConf);
        context.log.debug("Added drop constrain task : {}:{}", (Object)dropConstraintsTask.getId(), (Object)actualTblName);
        this.updatedMetadata.set(context.dmd.getEventTo().toString(), actualDbName, actualTblName, null);
        return Collections.singletonList(dropConstraintsTask);
    }
}

