/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.repl.load.message;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hive.metastore.messaging.DropFunctionMessage;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.function.drop.DropFunctionDesc;
import org.apache.hadoop.hive.ql.exec.FunctionInfo;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.FunctionUtils;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.repl.load.message.AbstractMessageHandler;
import org.apache.hadoop.hive.ql.parse.repl.load.message.MessageHandler;

public class DropFunctionHandler
extends AbstractMessageHandler {
    @Override
    public List<Task<? extends Serializable>> handle(MessageHandler.Context context) throws SemanticException {
        DropFunctionMessage msg = this.deserializer.getDropFunctionMessage(context.dmd.getPayload());
        String actualDbName = context.isDbNameEmpty() ? msg.getDB() : context.dbName;
        String qualifiedFunctionName = FunctionUtils.qualifyFunctionName(msg.getFunctionName(), actualDbName);
        FunctionInfo functionInfo = FunctionRegistry.getFunctionInfo(qualifiedFunctionName);
        DropFunctionDesc desc = new DropFunctionDesc(qualifiedFunctionName, false, context.eventOnlyReplicationSpec());
        Task<DDLWork> dropFunctionTask = TaskFactory.get(new DDLWork(this.readEntitySet, this.writeEntitySet, desc, true, context.getDumpDirectory(), context.getMetricCollector()), context.hiveConf);
        context.log.debug("Added drop function task : {}:{}", (Object)dropFunctionTask.getId(), (Object)desc.getName());
        this.updatedMetadata.set(context.dmd.getEventTo().toString(), actualDbName, null, null);
        return Collections.singletonList(dropFunctionTask);
    }
}

