/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.repl.load.message;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hive.metastore.messaging.OpenTxnMessage;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.metadata.HiveUtils;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.repl.load.message.AbstractMessageHandler;
import org.apache.hadoop.hive.ql.parse.repl.load.message.MessageHandler;
import org.apache.hadoop.hive.ql.plan.ReplTxnWork;

public class OpenTxnHandler
extends AbstractMessageHandler {
    @Override
    public List<Task<? extends Serializable>> handle(MessageHandler.Context context) throws SemanticException {
        if (!AcidUtils.isAcidEnabled(context.hiveConf)) {
            context.log.error("Cannot load transaction events as acid is not enabled");
            throw new SemanticException("Cannot load transaction events as acid is not enabled");
        }
        OpenTxnMessage msg = this.deserializer.getOpenTxnMessage(context.dmd.getPayload());
        Task<ReplTxnWork> openTxnTask = TaskFactory.get(new ReplTxnWork(HiveUtils.getReplPolicy(context.dbName), context.dbName, null, msg.getTxnIds(), ReplTxnWork.OperationType.REPL_OPEN_TXN, context.eventOnlyReplicationSpec(), context.getDumpDirectory(), context.getMetricCollector()), context.hiveConf);
        if (!context.isDbNameEmpty()) {
            this.updatedMetadata.set(context.dmd.getEventTo().toString(), context.dbName, null, null);
        }
        context.log.debug("Added Open txn task : {}", (Object)openTxnTask.getId());
        return Collections.singletonList(openTxnTask);
    }
}

