/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.type;

import java.math.BigDecimal;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.hadoop.hive.common.type.Date;
import org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.HiveIntervalDayTime;
import org.apache.hadoop.hive.common.type.HiveIntervalYearMonth;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.common.type.TimestampTZ;
import org.apache.hadoop.hive.common.type.TimestampTZUtil;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.FunctionInfo;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.optimizer.ConstantPropagateProcFactory;
import org.apache.hadoop.hive.ql.optimizer.calcite.CalciteSubquerySemanticException;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.TypeConverter;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.RowResolver;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.type.ExprFactory;
import org.apache.hadoop.hive.ql.parse.type.TypeCheckCtx;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnListDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDescUtils;
import org.apache.hadoop.hive.ql.plan.ExprNodeFieldDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeSubQueryDesc;
import org.apache.hadoop.hive.ql.plan.SubqueryType;
import org.apache.hadoop.hive.ql.udf.SettableUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBaseCompare;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFIn;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPAnd;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqual;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualNS;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPOr;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFStruct;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFWhen;
import org.apache.hadoop.hive.serde2.objectinspector.ConstantObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.typeinfo.CharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.hive.serde2.typeinfo.VarcharTypeInfo;
import org.apache.hadoop.io.NullWritable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExprNodeDescExprFactory
extends ExprFactory<ExprNodeDesc> {
    private static final Logger LOG = LoggerFactory.getLogger(ExprNodeDescExprFactory.class);

    @Override
    protected boolean isExprInstance(Object o) {
        return o instanceof ExprNodeDesc;
    }

    @Override
    protected ExprNodeDesc toExpr(ColumnInfo colInfo, RowResolver rowResolver, int offset) throws SemanticException {
        ObjectInspector listElementOI;
        ObjectInspector inspector = colInfo.getObjectInspector();
        if (inspector instanceof ConstantObjectInspector && inspector instanceof PrimitiveObjectInspector) {
            return ExprNodeDescExprFactory.toPrimitiveConstDesc(colInfo, inspector);
        }
        if (inspector instanceof ConstantObjectInspector && inspector instanceof ListObjectInspector && (listElementOI = ((ListObjectInspector)inspector).getListElementObjectInspector()) instanceof PrimitiveObjectInspector) {
            return ExprNodeDescExprFactory.toListConstDesc(colInfo, inspector, listElementOI);
        }
        if (inspector instanceof ConstantObjectInspector && inspector instanceof MapObjectInspector) {
            ObjectInspector keyOI = ((MapObjectInspector)inspector).getMapKeyObjectInspector();
            ObjectInspector valueOI = ((MapObjectInspector)inspector).getMapValueObjectInspector();
            if (keyOI instanceof PrimitiveObjectInspector && valueOI instanceof PrimitiveObjectInspector) {
                return ExprNodeDescExprFactory.toMapConstDesc(colInfo, inspector, keyOI, valueOI);
            }
        }
        if (inspector instanceof ConstantObjectInspector && inspector instanceof StructObjectInspector) {
            boolean allPrimitive = true;
            List<? extends StructField> fields = ((StructObjectInspector)inspector).getAllStructFieldRefs();
            for (StructField structField : fields) {
                allPrimitive &= structField.getFieldObjectInspector() instanceof PrimitiveObjectInspector;
            }
            if (allPrimitive) {
                return ExprNodeDescExprFactory.toStructConstDesc(colInfo, inspector, fields);
            }
        }
        ExprNodeColumnDesc column = new ExprNodeColumnDesc(colInfo);
        column.setSkewedCol(colInfo.isSkewedCol());
        return column;
    }

    private static ExprNodeConstantDesc toPrimitiveConstDesc(ColumnInfo colInfo, ObjectInspector inspector) {
        PrimitiveObjectInspector poi = (PrimitiveObjectInspector)inspector;
        Object constant = ((ConstantObjectInspector)inspector).getWritableConstantValue();
        ExprNodeConstantDesc constantExpr = new ExprNodeConstantDesc(colInfo.getType(), poi.getPrimitiveJavaObject(constant));
        constantExpr.setFoldedFromCol(colInfo.getInternalName());
        constantExpr.setFoldedFromTab(colInfo.getTabAlias());
        return constantExpr;
    }

    private static ExprNodeConstantDesc toListConstDesc(ColumnInfo colInfo, ObjectInspector inspector, ObjectInspector listElementOI) {
        PrimitiveObjectInspector poi = (PrimitiveObjectInspector)listElementOI;
        List values = (List)((ConstantObjectInspector)inspector).getWritableConstantValue();
        ArrayList<Object> constant = new ArrayList<Object>();
        for (Object o : values) {
            constant.add(poi.getPrimitiveJavaObject(o));
        }
        ExprNodeConstantDesc constantExpr = new ExprNodeConstantDesc(colInfo.getType(), constant);
        constantExpr.setFoldedFromCol(colInfo.getInternalName());
        constantExpr.setFoldedFromTab(colInfo.getTabAlias());
        return constantExpr;
    }

    private static ExprNodeConstantDesc toMapConstDesc(ColumnInfo colInfo, ObjectInspector inspector, ObjectInspector keyOI, ObjectInspector valueOI) {
        PrimitiveObjectInspector keyPoi = (PrimitiveObjectInspector)keyOI;
        PrimitiveObjectInspector valuePoi = (PrimitiveObjectInspector)valueOI;
        Map values = (Map)((ConstantObjectInspector)inspector).getWritableConstantValue();
        LinkedHashMap<Object, Object> constant = new LinkedHashMap<Object, Object>();
        for (Map.Entry e : values.entrySet()) {
            constant.put(keyPoi.getPrimitiveJavaObject(e.getKey()), valuePoi.getPrimitiveJavaObject(e.getValue()));
        }
        ExprNodeConstantDesc constantExpr = new ExprNodeConstantDesc(colInfo.getType(), constant);
        constantExpr.setFoldedFromCol(colInfo.getInternalName());
        constantExpr.setFoldedFromTab(colInfo.getTabAlias());
        return constantExpr;
    }

    private static ExprNodeConstantDesc toStructConstDesc(ColumnInfo colInfo, ObjectInspector inspector, List<? extends StructField> fields) {
        List values = (List)((ConstantObjectInspector)inspector).getWritableConstantValue();
        ArrayList<Object> constant = new ArrayList<Object>();
        for (int i = 0; i < values.size(); ++i) {
            Object value = values.get(i);
            PrimitiveObjectInspector fieldPoi = (PrimitiveObjectInspector)fields.get(i).getFieldObjectInspector();
            constant.add(fieldPoi.getPrimitiveJavaObject(value));
        }
        ExprNodeConstantDesc constantExpr = new ExprNodeConstantDesc(colInfo.getType(), constant);
        constantExpr.setFoldedFromCol(colInfo.getInternalName());
        constantExpr.setFoldedFromTab(colInfo.getTabAlias());
        return constantExpr;
    }

    @Override
    protected ExprNodeColumnDesc createColumnRefExpr(ColumnInfo colInfo, RowResolver rowResolver, int offset) {
        return new ExprNodeColumnDesc(colInfo);
    }

    @Override
    protected ExprNodeColumnDesc createColumnRefExpr(ColumnInfo colInfo, List<RowResolver> rowResolverList) {
        return new ExprNodeColumnDesc(colInfo);
    }

    @Override
    protected ExprNodeConstantDesc createNullConstantExpr() {
        return new ExprNodeConstantDesc(TypeInfoFactory.getPrimitiveTypeInfoFromPrimitiveWritable(NullWritable.class), null);
    }

    @Override
    protected ExprNodeConstantDesc createBooleanConstantExpr(String value) {
        Boolean b = value != null ? Boolean.valueOf(value) : null;
        return new ExprNodeConstantDesc(TypeInfoFactory.booleanTypeInfo, b);
    }

    @Override
    protected ExprNodeConstantDesc createBigintConstantExpr(String value) {
        Long l = Long.valueOf(value);
        return new ExprNodeConstantDesc(l);
    }

    @Override
    protected ExprNodeConstantDesc createIntConstantExpr(String value) {
        Integer i = Integer.valueOf(value);
        return new ExprNodeConstantDesc(i);
    }

    @Override
    protected ExprNodeConstantDesc createSmallintConstantExpr(String value) {
        Short s = Short.valueOf(value);
        return new ExprNodeConstantDesc(s);
    }

    @Override
    protected ExprNodeConstantDesc createTinyintConstantExpr(String value) {
        Byte b = Byte.valueOf(value);
        return new ExprNodeConstantDesc(b);
    }

    @Override
    protected ExprNodeConstantDesc createFloatConstantExpr(String value) {
        Float f = Float.valueOf(value);
        return new ExprNodeConstantDesc(f);
    }

    @Override
    protected ExprNodeConstantDesc createDoubleConstantExpr(String value) {
        Double d = Double.valueOf(value);
        return new ExprNodeConstantDesc(d);
    }

    @Override
    protected ExprNodeConstantDesc createDecimalConstantExpr(String value, boolean allowNullValueConstantExpr) {
        HiveDecimal hd = HiveDecimal.create(value);
        if (!allowNullValueConstantExpr && hd == null) {
            return null;
        }
        return new ExprNodeConstantDesc(this.adjustType(hd), hd);
    }

    @Override
    protected TypeInfo adjustConstantType(PrimitiveTypeInfo targetType, Object constantValue) {
        if (constantValue instanceof HiveDecimal) {
            return this.adjustType((HiveDecimal)constantValue);
        }
        return targetType;
    }

    private DecimalTypeInfo adjustType(HiveDecimal hd) {
        int prec = 1;
        int scale = 0;
        if (hd != null) {
            prec = hd.precision();
            scale = hd.scale();
        }
        DecimalTypeInfo typeInfo = TypeInfoFactory.getDecimalTypeInfo(prec, scale);
        return typeInfo;
    }

    @Override
    protected Object interpretConstantAsPrimitive(PrimitiveTypeInfo targetType, Object constantValue, PrimitiveTypeInfo sourceType) {
        if (constantValue instanceof Number || constantValue instanceof String) {
            try {
                PrimitiveObjectInspectorUtils.PrimitiveTypeEntry primitiveTypeEntry = targetType.getPrimitiveTypeEntry();
                if (PrimitiveObjectInspectorUtils.intTypeEntry.equals(primitiveTypeEntry)) {
                    return this.toBigDecimal(constantValue.toString()).intValueExact();
                }
                if (PrimitiveObjectInspectorUtils.longTypeEntry.equals(primitiveTypeEntry)) {
                    return this.toBigDecimal(constantValue.toString()).longValueExact();
                }
                if (PrimitiveObjectInspectorUtils.doubleTypeEntry.equals(primitiveTypeEntry)) {
                    return Double.valueOf(constantValue.toString());
                }
                if (PrimitiveObjectInspectorUtils.floatTypeEntry.equals(primitiveTypeEntry)) {
                    return Float.valueOf(constantValue.toString());
                }
                if (PrimitiveObjectInspectorUtils.byteTypeEntry.equals(primitiveTypeEntry)) {
                    return this.toBigDecimal(constantValue.toString()).byteValueExact();
                }
                if (PrimitiveObjectInspectorUtils.shortTypeEntry.equals(primitiveTypeEntry)) {
                    return this.toBigDecimal(constantValue.toString()).shortValueExact();
                }
                if (PrimitiveObjectInspectorUtils.decimalTypeEntry.equals(primitiveTypeEntry)) {
                    return HiveDecimal.create(constantValue.toString());
                }
            }
            catch (ArithmeticException | NumberFormatException nfe) {
                LOG.trace("Failed to narrow type of constant", (Throwable)nfe);
                return null;
            }
        }
        if (constantValue instanceof HiveDecimal) {
            HiveDecimal hiveDecimal = (HiveDecimal)constantValue;
            PrimitiveObjectInspectorUtils.PrimitiveTypeEntry primitiveTypeEntry = targetType.getPrimitiveTypeEntry();
            if (PrimitiveObjectInspectorUtils.doubleTypeEntry.equals(primitiveTypeEntry)) {
                return hiveDecimal.doubleValue();
            }
            if (PrimitiveObjectInspectorUtils.floatTypeEntry.equals(primitiveTypeEntry)) {
                return Float.valueOf(hiveDecimal.floatValue());
            }
            return hiveDecimal;
        }
        String constTypeInfoName = sourceType.getTypeName();
        if (constTypeInfoName.equalsIgnoreCase("string")) {
            if (targetType instanceof CharTypeInfo) {
                int length;
                HiveChar newValue;
                String constValue = constantValue.toString();
                HiveChar maxCharConst = new HiveChar(constValue, 255);
                if (maxCharConst.equals(newValue = new HiveChar(constValue, length = TypeInfoUtils.getCharacterLengthForType(targetType)))) {
                    return newValue;
                }
                return null;
            }
            if (targetType instanceof VarcharTypeInfo) {
                int length;
                HiveVarchar newValue;
                String constValue = constantValue.toString();
                HiveVarchar maxCharConst = new HiveVarchar(constValue, 65535);
                if (maxCharConst.equals(newValue = new HiveVarchar(constValue, length = TypeInfoUtils.getCharacterLengthForType(targetType)))) {
                    return newValue;
                }
                return null;
            }
        }
        return constantValue;
    }

    private BigDecimal toBigDecimal(String val) {
        if (!NumberUtils.isNumber(val)) {
            throw new NumberFormatException("The given string is not a valid number: " + val);
        }
        return new BigDecimal(val.replaceAll("[dDfFlL]$", ""));
    }

    @Override
    protected ExprNodeConstantDesc createStringConstantExpr(String value) {
        return new ExprNodeConstantDesc(TypeInfoFactory.stringTypeInfo, value);
    }

    @Override
    protected ExprNodeConstantDesc createDateConstantExpr(String value) {
        Date d = Date.valueOf(value);
        return new ExprNodeConstantDesc(TypeInfoFactory.dateTypeInfo, d);
    }

    @Override
    protected ExprNodeConstantDesc createTimestampConstantExpr(String value) {
        Timestamp t = Timestamp.valueOf(value);
        return new ExprNodeConstantDesc(TypeInfoFactory.timestampTypeInfo, t);
    }

    @Override
    protected ExprNodeConstantDesc createTimestampLocalTimeZoneConstantExpr(String value, ZoneId zoneId) {
        TimestampTZ t = TimestampTZUtil.parse(value);
        return new ExprNodeConstantDesc(TypeInfoFactory.getTimestampTZTypeInfo(zoneId), t);
    }

    @Override
    protected ExprNodeConstantDesc createIntervalYearMonthConstantExpr(String value) {
        return new ExprNodeConstantDesc(TypeInfoFactory.intervalYearMonthTypeInfo, HiveIntervalYearMonth.valueOf(value));
    }

    @Override
    protected ExprNodeConstantDesc createIntervalDayTimeConstantExpr(String value) {
        return new ExprNodeConstantDesc(TypeInfoFactory.intervalDayTimeTypeInfo, HiveIntervalDayTime.valueOf(value));
    }

    @Override
    protected ExprNodeConstantDesc createIntervalYearConstantExpr(String value) {
        return new ExprNodeConstantDesc(TypeInfoFactory.intervalYearMonthTypeInfo, new HiveIntervalYearMonth(Integer.parseInt(value), 0));
    }

    @Override
    protected ExprNodeConstantDesc createIntervalMonthConstantExpr(String value) {
        return new ExprNodeConstantDesc(TypeInfoFactory.intervalYearMonthTypeInfo, new HiveIntervalYearMonth(0, Integer.parseInt(value)));
    }

    @Override
    protected ExprNodeConstantDesc createIntervalDayConstantExpr(String value) {
        return new ExprNodeConstantDesc(TypeInfoFactory.intervalDayTimeTypeInfo, new HiveIntervalDayTime(Integer.parseInt(value), 0, 0, 0, 0));
    }

    @Override
    protected ExprNodeConstantDesc createIntervalHourConstantExpr(String value) {
        return new ExprNodeConstantDesc(TypeInfoFactory.intervalDayTimeTypeInfo, new HiveIntervalDayTime(0, Integer.parseInt(value), 0, 0, 0));
    }

    @Override
    protected ExprNodeConstantDesc createIntervalMinuteConstantExpr(String value) {
        return new ExprNodeConstantDesc(TypeInfoFactory.intervalDayTimeTypeInfo, new HiveIntervalDayTime(0, 0, Integer.parseInt(value), 0, 0));
    }

    @Override
    protected ExprNodeConstantDesc createIntervalSecondConstantExpr(String value) {
        BigDecimal bd = new BigDecimal(value);
        BigDecimal bdSeconds = new BigDecimal(bd.toBigInteger());
        BigDecimal bdNanos = bd.subtract(bdSeconds);
        return new ExprNodeConstantDesc(TypeInfoFactory.intervalDayTimeTypeInfo, new HiveIntervalDayTime(0, 0, 0, bdSeconds.intValueExact(), bdNanos.multiply(NANOS_PER_SEC_BD).intValue()));
    }

    @Override
    protected ExprNodeDesc createStructExpr(TypeInfo typeInfo, List<ExprNodeDesc> operands) throws SemanticException {
        assert (typeInfo instanceof StructTypeInfo);
        if (this.isAllConstants(operands)) {
            return this.createConstantExpr(typeInfo, operands.stream().map(this::getConstantValue).collect(Collectors.toList()));
        }
        return ExprNodeGenericFuncDesc.newInstance(new GenericUDFStruct(), GenericUDFStruct.class.getAnnotation(Description.class).name(), operands);
    }

    @Override
    protected ExprNodeConstantDesc createConstantExpr(TypeInfo typeInfo, Object constantValue) {
        return new ExprNodeConstantDesc(typeInfo, constantValue);
    }

    @Override
    protected ExprNodeFieldDesc createNestedColumnRefExpr(TypeInfo typeInfo, ExprNodeDesc expr, String fieldName, Boolean isList) {
        return new ExprNodeFieldDesc(typeInfo, expr, fieldName, isList);
    }

    @Override
    protected ExprNodeGenericFuncDesc createFuncCallExpr(TypeInfo typeInfo, FunctionInfo fi, String funcText, List<ExprNodeDesc> inputs) throws UDFArgumentException {
        GenericUDF genericUDF = fi.getGenericUDF();
        if (genericUDF instanceof SettableUDF) {
            ((SettableUDF)((Object)genericUDF)).setTypeInfo(typeInfo);
        }
        return ExprNodeGenericFuncDesc.newInstance(genericUDF, funcText, inputs);
    }

    @Override
    protected ExprNodeColumnListDesc createExprsListExpr() {
        return new ExprNodeColumnListDesc();
    }

    @Override
    protected void addExprToExprsList(ExprNodeDesc columnList, ExprNodeDesc expr) {
        ExprNodeColumnListDesc l = (ExprNodeColumnListDesc)columnList;
        l.addColumn(expr);
    }

    @Override
    protected boolean isConstantExpr(Object o) {
        return o instanceof ExprNodeConstantDesc;
    }

    @Override
    protected boolean isFuncCallExpr(Object o) {
        return o instanceof ExprNodeGenericFuncDesc;
    }

    @Override
    protected Object getConstantValue(ExprNodeDesc expr) {
        return ((ExprNodeConstantDesc)expr).getValue();
    }

    @Override
    protected String getConstantValueAsString(ExprNodeDesc expr) {
        return ((ExprNodeConstantDesc)expr).getValue().toString();
    }

    @Override
    protected boolean isColumnRefExpr(Object o) {
        return o instanceof ExprNodeColumnDesc;
    }

    @Override
    protected String getColumnName(ExprNodeDesc expr, RowResolver rowResolver) {
        return ((ExprNodeColumnDesc)expr).getColumn();
    }

    @Override
    protected boolean isExprsListExpr(Object o) {
        return o instanceof ExprNodeColumnListDesc;
    }

    @Override
    protected List<ExprNodeDesc> getExprChildren(ExprNodeDesc expr) {
        return expr.getChildren();
    }

    @Override
    protected TypeInfo getTypeInfo(ExprNodeDesc expr) {
        return expr.getTypeInfo();
    }

    @Override
    protected List<TypeInfo> getStructTypeInfoList(ExprNodeDesc expr) {
        StructTypeInfo structTypeInfo = (StructTypeInfo)expr.getTypeInfo();
        return structTypeInfo.getAllStructFieldTypeInfos();
    }

    @Override
    protected List<String> getStructNameList(ExprNodeDesc expr) {
        StructTypeInfo structTypeInfo = (StructTypeInfo)expr.getTypeInfo();
        return structTypeInfo.getAllStructFieldNames();
    }

    @Override
    protected boolean isORFuncCallExpr(ExprNodeDesc expr) {
        return FunctionRegistry.isOpOr(expr);
    }

    @Override
    protected boolean isANDFuncCallExpr(ExprNodeDesc expr) {
        return FunctionRegistry.isOpAnd(expr);
    }

    @Override
    protected boolean isPOSITIVEFuncCallExpr(ExprNodeDesc expr) {
        return FunctionRegistry.isOpPositive(expr);
    }

    @Override
    protected boolean isNEGATIVEFuncCallExpr(ExprNodeDesc expr) {
        return FunctionRegistry.isOpNegative(expr);
    }

    @Override
    protected boolean isAndFunction(FunctionInfo fi) {
        return fi.getGenericUDF() instanceof GenericUDFOPAnd;
    }

    @Override
    protected boolean isOrFunction(FunctionInfo fi) {
        return fi.getGenericUDF() instanceof GenericUDFOPOr;
    }

    @Override
    protected boolean isInFunction(FunctionInfo fi) {
        return fi.getGenericUDF() instanceof GenericUDFIn;
    }

    @Override
    protected boolean isCompareFunction(FunctionInfo fi) {
        return fi.getGenericUDF() instanceof GenericUDFBaseCompare;
    }

    @Override
    protected boolean isEqualFunction(FunctionInfo fi) {
        return fi.getGenericUDF() instanceof GenericUDFOPEqual && !(fi.getGenericUDF() instanceof GenericUDFOPEqualNS);
    }

    @Override
    protected boolean isConsistentWithinQuery(FunctionInfo fi) {
        return FunctionRegistry.isConsistentWithinQuery(fi.getGenericUDF());
    }

    @Override
    protected boolean isStateful(FunctionInfo fi) {
        return FunctionRegistry.isStateful(fi.getGenericUDF());
    }

    @Override
    protected ExprNodeDesc setTypeInfo(ExprNodeDesc expr, TypeInfo type) {
        expr.setTypeInfo(type);
        return expr;
    }

    @Override
    protected boolean convertCASEIntoCOALESCEFuncCallExpr(FunctionInfo fi, List<ExprNodeDesc> inputs) {
        GenericUDF genericUDF = fi.getGenericUDF();
        if (genericUDF instanceof GenericUDFWhen && inputs.size() == 3 && inputs.get(1) instanceof ExprNodeConstantDesc && inputs.get(2) instanceof ExprNodeConstantDesc) {
            ExprNodeConstantDesc constThen = (ExprNodeConstantDesc)inputs.get(1);
            ExprNodeConstantDesc constElse = (ExprNodeConstantDesc)inputs.get(2);
            Object thenVal = constThen.getValue();
            Object elseVal = constElse.getValue();
            if (thenVal instanceof Boolean && elseVal instanceof Boolean) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean convertCASEIntoIFFuncCallExpr(FunctionInfo fi, List<ExprNodeDesc> inputs) {
        GenericUDF genericUDF = fi.getGenericUDF();
        return genericUDF instanceof GenericUDFWhen && inputs.size() == 3 && TypeInfoFactory.booleanTypeInfo.equals(inputs.get(0).getTypeInfo());
    }

    @Override
    protected ExprNodeDesc foldExpr(ExprNodeDesc expr) {
        if (expr instanceof ExprNodeGenericFuncDesc) {
            return ConstantPropagateProcFactory.foldExpr((ExprNodeGenericFuncDesc)expr);
        }
        return expr;
    }

    @Override
    protected boolean isSTRUCTFuncCallExpr(ExprNodeDesc expr) {
        return ExprNodeDescUtils.isStructUDF(expr);
    }

    @Override
    protected boolean isConstantStruct(ExprNodeDesc expr) {
        return ExprNodeDescUtils.isConstantStruct(expr);
    }

    @Override
    protected ExprNodeDesc createSubqueryExpr(TypeCheckCtx ctx, ASTNode expr, SubqueryType subqueryType, Object[] inputs) throws CalciteSubquerySemanticException {
        Map<ASTNode, RelNode> subqueryToRelNode = ctx.getSubqueryToRelNode();
        if (subqueryToRelNode == null) {
            throw new CalciteSubquerySemanticException(ErrorMsg.UNSUPPORTED_SUBQUERY_EXPRESSION.getMsg(" Currently SubQuery expressions are only allowed as Where and Having Clause predicates"));
        }
        ASTNode subqueryOp = (ASTNode)expr.getChild(0);
        RelNode subqueryRel = subqueryToRelNode.get(expr);
        switch (subqueryType) {
            case EXISTS: {
                return new ExprNodeSubQueryDesc(TypeInfoFactory.booleanTypeInfo, subqueryRel, SubqueryType.EXISTS);
            }
            case IN: {
                assert (inputs[2] != null);
                ExprNodeDesc lhs = (ExprNodeDesc)inputs[2];
                return new ExprNodeSubQueryDesc(TypeInfoFactory.booleanTypeInfo, subqueryRel, SubqueryType.IN, lhs);
            }
            case SCALAR: {
                if (subqueryRel.getRowType().getFieldCount() != 1) {
                    throw new CalciteSubquerySemanticException(ErrorMsg.INVALID_SUBQUERY_EXPRESSION.getMsg("More than one column expression in subquery"));
                }
                TypeInfo subExprType = TypeConverter.convert(((RelDataTypeField)subqueryRel.getRowType().getFieldList().get(0)).getType());
                return new ExprNodeSubQueryDesc(subExprType, subqueryRel, SubqueryType.SCALAR);
            }
        }
        return null;
    }

    @Override
    protected FunctionInfo getFunctionInfo(String funcName) throws SemanticException {
        return FunctionRegistry.getFunctionInfo(funcName);
    }
}

