/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.type;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.hadoop.hive.ql.exec.FunctionInfo;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;

public interface FunctionHelper {
    public FunctionInfo getFunctionInfo(String var1) throws SemanticException;

    public RelDataType getReturnType(FunctionInfo var1, List<RexNode> var2) throws SemanticException;

    public List<RexNode> convertInputs(FunctionInfo var1, List<RexNode> var2, RelDataType var3) throws SemanticException;

    public RexNode getExpression(String var1, FunctionInfo var2, List<RexNode> var3, RelDataType var4) throws SemanticException;

    public AggregateInfo getAggregateFunctionInfo(boolean var1, boolean var2, String var3, List<RexNode> var4) throws SemanticException;

    public AggregateInfo getWindowAggregateFunctionInfo(boolean var1, boolean var2, String var3, List<RexNode> var4) throws SemanticException;

    default public RexNode foldExpression(RexNode expr) {
        return expr;
    }

    public boolean isAndFunction(FunctionInfo var1);

    public boolean isOrFunction(FunctionInfo var1);

    public boolean isInFunction(FunctionInfo var1);

    public boolean isCompareFunction(FunctionInfo var1);

    public boolean isEqualFunction(FunctionInfo var1);

    public boolean isConsistentWithinQuery(FunctionInfo var1);

    public boolean isStateful(FunctionInfo var1);

    public static class AggregateInfo {
        private final List<RexNode> parameters;
        private final TypeInfo returnType;
        private final String aggregateName;
        private final boolean distinct;

        public AggregateInfo(List<RexNode> parameters, TypeInfo returnType, String aggregateName, boolean distinct) {
            this.parameters = ImmutableList.copyOf(parameters);
            this.returnType = returnType;
            this.aggregateName = aggregateName;
            this.distinct = distinct;
        }

        public List<RexNode> getParameters() {
            return this.parameters;
        }

        public TypeInfo getReturnType() {
            return this.returnType;
        }

        public String getAggregateName() {
            return this.aggregateName;
        }

        public boolean isDistinct() {
            return this.distinct;
        }
    }
}

