/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.hadoop.hive.common.type.DataTypePhysicalVariation;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.HashTableDummyOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorUtils;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatchCtx;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedSupport;
import org.apache.hadoop.hive.ql.metadata.VirtualColumn;
import org.apache.hadoop.hive.ql.optimizer.physical.VectorizerReason;
import org.apache.hadoop.hive.ql.parse.RuntimeValuesInfo;
import org.apache.hadoop.hive.ql.plan.AbstractOperatorDesc;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.FileSinkDesc;
import org.apache.hadoop.hive.ql.plan.MapredLocalWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.mapred.JobConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseWork
extends AbstractOperatorDesc {
    protected static final Logger LOG = LoggerFactory.getLogger(BaseWork.class);
    List<HashTableDummyOperator> dummyOps;
    int tag = 0;
    private final List<String> sortColNames = new ArrayList<String>();
    private MapredLocalWork mrLocalWork;
    private boolean gatheringStats;
    private String name;
    protected boolean vectorizationExamined;
    protected boolean vectorizationEnabled;
    protected VectorizedRowBatchCtx vectorizedRowBatchCtx;
    protected boolean useVectorizedInputFileFormat;
    protected Set<VectorizedSupport.Support> inputFormatSupportSet;
    protected Set<VectorizedSupport.Support> supportSetInUse;
    protected List<String> supportRemovedReasons;
    private transient VectorizerReason notVectorizedReason;
    private boolean groupByVectorOutput;
    private boolean allNative;
    private boolean usesVectorUDFAdaptor;
    protected long vectorizedVertexNum;
    protected int vectorizedTestingReducerBatchSize;
    private boolean isTestForcedVectorizationEnable;
    private boolean isTestVectorizationSuppressExplainExecutionMode;
    protected boolean llapMode = false;
    protected boolean uberMode = false;
    private int reservedMemoryMB = -1;
    private Map<String, RuntimeValuesInfo> inputSourceToRuntimeValuesInfo = new HashMap<String, RuntimeValuesInfo>();

    public BaseWork() {
    }

    public BaseWork(String name) {
        this.setName(name);
    }

    public void setGatheringStats(boolean gatherStats) {
        this.gatheringStats = gatherStats;
    }

    public boolean isGatheringStats() {
        return this.gatheringStats;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<HashTableDummyOperator> getDummyOps() {
        return this.dummyOps;
    }

    public void setDummyOps(List<HashTableDummyOperator> dummyOps) {
        if (this.dummyOps != null && !this.dummyOps.isEmpty() && (dummyOps == null || dummyOps.isEmpty())) {
            LOG.info("Removing dummy operators from " + this.name + " " + this.getClass().getSimpleName());
        }
        this.dummyOps = dummyOps;
    }

    public void addDummyOp(HashTableDummyOperator dummyOp) {
        if (this.dummyOps == null) {
            this.dummyOps = new LinkedList<HashTableDummyOperator>();
        }
        this.dummyOps.add(dummyOp);
    }

    public abstract void replaceRoots(Map<Operator<?>, Operator<?>> var1);

    public abstract Set<Operator<? extends OperatorDesc>> getAllRootOperators();

    public abstract Operator<? extends OperatorDesc> getAnyRootOperator();

    public Set<Operator<?>> getAllOperators() {
        LinkedHashSet returnSet = new LinkedHashSet();
        Set<Operator<? extends OperatorDesc>> opSet = this.getAllRootOperators();
        Stack<Operator<? extends OperatorDesc>> opStack = new Stack<Operator<? extends OperatorDesc>>();
        opStack.addAll(opSet);
        while (!opStack.empty()) {
            Operator op = (Operator)opStack.pop();
            returnSet.add(op);
            if (op.getChildOperators() == null) continue;
            opStack.addAll(op.getChildOperators());
        }
        return returnSet;
    }

    public Set<Operator<? extends OperatorDesc>> getAllLeafOperators() {
        LinkedHashSet<Operator<? extends OperatorDesc>> returnSet = new LinkedHashSet<Operator<? extends OperatorDesc>>();
        Set<Operator<? extends OperatorDesc>> opSet = this.getAllRootOperators();
        Stack<Operator<? extends OperatorDesc>> opStack = new Stack<Operator<? extends OperatorDesc>>();
        opStack.addAll(opSet);
        while (!opStack.empty()) {
            Operator op = (Operator)opStack.pop();
            if (op.getNumChild() == 0) {
                returnSet.add(op);
            }
            if (op.getChildOperators() == null) continue;
            opStack.addAll(op.getChildOperators());
        }
        return returnSet;
    }

    public void setVectorizedVertexNum(long vectorizedVertexNum) {
        this.vectorizedVertexNum = vectorizedVertexNum;
    }

    public long getVectorizedVertexNum() {
        return this.vectorizedVertexNum;
    }

    public void setVectorizedTestingReducerBatchSize(int vectorizedTestingReducerBatchSize) {
        this.vectorizedTestingReducerBatchSize = vectorizedTestingReducerBatchSize;
    }

    public int getVectorizedTestingReducerBatchSize() {
        return this.vectorizedTestingReducerBatchSize;
    }

    public void setVectorizationExamined(boolean vectorizationExamined) {
        this.vectorizationExamined = vectorizationExamined;
    }

    public boolean getVectorizationExamined() {
        return this.vectorizationExamined;
    }

    public void setVectorizationEnabled(boolean vectorizationEnabled) {
        this.vectorizationEnabled = vectorizationEnabled;
    }

    public boolean getVectorizationEnabled() {
        return this.vectorizationEnabled;
    }

    public VectorizedRowBatchCtx getVectorizedRowBatchCtx() {
        return this.vectorizedRowBatchCtx;
    }

    public void setVectorizedRowBatchCtx(VectorizedRowBatchCtx vectorizedRowBatchCtx) {
        this.vectorizedRowBatchCtx = vectorizedRowBatchCtx;
    }

    public void setNotVectorizedReason(VectorizerReason notVectorizedReason) {
        this.notVectorizedReason = notVectorizedReason;
    }

    public VectorizerReason getNotVectorizedReason() {
        return this.notVectorizedReason;
    }

    public void setUsesVectorUDFAdaptor(boolean usesVectorUDFAdaptor) {
        this.usesVectorUDFAdaptor = usesVectorUDFAdaptor;
    }

    public boolean getUsesVectorUDFAdaptor() {
        return this.usesVectorUDFAdaptor;
    }

    public void setAllNative(boolean allNative) {
        this.allNative = allNative;
    }

    public boolean getAllNative() {
        return this.allNative;
    }

    public void setIsTestForcedVectorizationEnable(boolean isTestForcedVectorizationEnable) {
        this.isTestForcedVectorizationEnable = isTestForcedVectorizationEnable;
    }

    public boolean getIsTestForcedVectorizationEnable() {
        return this.isTestForcedVectorizationEnable;
    }

    public void setIsTestVectorizationSuppressExplainExecutionMode(boolean isTestVectorizationSuppressExplainExecutionMode) {
        this.isTestVectorizationSuppressExplainExecutionMode = isTestVectorizationSuppressExplainExecutionMode;
    }

    public boolean getIsTestVectorizationSuppressExplainExecutionMode() {
        return this.isTestVectorizationSuppressExplainExecutionMode;
    }

    @Explain(displayName="Local Work", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public MapredLocalWork getMapRedLocalWork() {
        return this.mrLocalWork;
    }

    public void setMapRedLocalWork(MapredLocalWork mapLocalWork) {
        this.mrLocalWork = mapLocalWork;
    }

    public void setUberMode(boolean uberMode) {
        this.uberMode = uberMode;
    }

    public boolean getUberMode() {
        return this.uberMode;
    }

    public void setLlapMode(boolean llapMode) {
        this.llapMode = llapMode;
    }

    public boolean getLlapMode() {
        return this.llapMode;
    }

    public int getReservedMemoryMB() {
        return this.reservedMemoryMB;
    }

    public void setReservedMemoryMB(int memoryMB) {
        this.reservedMemoryMB = memoryMB;
    }

    public void configureJobConf(JobConf job) {
        OperatorUtils.findOperators(this.getAllRootOperators(), FileSinkOperator.class).forEach(fs -> {
            LOG.debug("Configuring JobConf for table {}.{}", (Object)((FileSinkDesc)fs.getConf()).getTableInfo().getDbName(), (Object)((FileSinkDesc)fs.getConf()).getTableInfo().getTableName());
            PlanUtils.configureJobConf(((FileSinkDesc)fs.getConf()).getTableInfo(), job);
        });
    }

    public void setTag(int tag) {
        this.tag = tag;
    }

    @Explain(displayName="tag", explainLevels={Explain.Level.USER})
    public int getTag() {
        return this.tag;
    }

    public void addSortCols(List<String> sortCols) {
        this.sortColNames.addAll(sortCols);
    }

    public List<String> getSortCols() {
        return this.sortColNames;
    }

    public Map<String, RuntimeValuesInfo> getInputSourceToRuntimeValuesInfo() {
        return this.inputSourceToRuntimeValuesInfo;
    }

    public void setInputSourceToRuntimeValuesInfo(String workName, RuntimeValuesInfo runtimeValuesInfo) {
        this.inputSourceToRuntimeValuesInfo.put(workName, runtimeValuesInfo);
    }

    public static class BaseExplainVectorization {
        private final BaseWork baseWork;

        public BaseExplainVectorization(BaseWork baseWork) {
            this.baseWork = baseWork;
        }

        public static List<String> getColumnAndTypes(int[] projectionColumns, String[] columnNames, TypeInfo[] typeInfos, DataTypePhysicalVariation[] dataTypePhysicalVariations) {
            int size = columnNames.length;
            ArrayList<String> result = new ArrayList<String>(size);
            for (int i = 0; i < size; ++i) {
                String displayString = projectionColumns[i] + ":" + columnNames[i] + ":" + typeInfos[i];
                if (dataTypePhysicalVariations != null && dataTypePhysicalVariations[i] != DataTypePhysicalVariation.NONE) {
                    displayString = displayString + "/" + dataTypePhysicalVariations[i].toString();
                }
                result.add(displayString);
            }
            return result;
        }

        @Explain(vectorization=Explain.Vectorization.SUMMARY, displayName="enabled", explainLevels={Explain.Level.DEFAULT, Explain.Level.EXTENDED})
        public boolean enabled() {
            return this.baseWork.getVectorizationEnabled();
        }

        @Explain(vectorization=Explain.Vectorization.SUMMARY, displayName="vectorized", explainLevels={Explain.Level.DEFAULT, Explain.Level.EXTENDED})
        public Boolean vectorized() {
            if (!this.baseWork.getVectorizationEnabled()) {
                return null;
            }
            return this.baseWork.getVectorMode();
        }

        @Explain(vectorization=Explain.Vectorization.SUMMARY, displayName="notVectorizedReason", explainLevels={Explain.Level.DEFAULT, Explain.Level.EXTENDED})
        public String notVectorizedReason() {
            if (!this.baseWork.getVectorizationEnabled() || this.baseWork.getVectorMode()) {
                return null;
            }
            VectorizerReason notVectorizedReason = this.baseWork.getNotVectorizedReason();
            if (notVectorizedReason == null) {
                return "Unknown";
            }
            return notVectorizedReason.toString();
        }

        @Explain(vectorization=Explain.Vectorization.SUMMARY, displayName="allNative", explainLevels={Explain.Level.DEFAULT, Explain.Level.EXTENDED})
        public Boolean nativeVectorized() {
            if (!this.baseWork.getVectorMode()) {
                return null;
            }
            return this.baseWork.getAllNative();
        }

        public static List<String> getColumns(VectorizedRowBatchCtx vectorizedRowBatchCtx, int startIndex, int count) {
            String[] rowColumnNames = vectorizedRowBatchCtx.getRowColumnNames();
            TypeInfo[] rowColumnTypeInfos = vectorizedRowBatchCtx.getRowColumnTypeInfos();
            DataTypePhysicalVariation[] dataTypePhysicalVariations = vectorizedRowBatchCtx.getRowdataTypePhysicalVariations();
            ArrayList<String> result = new ArrayList<String>(count);
            int end = startIndex + count;
            for (int i = startIndex; i < end; ++i) {
                String displayString = rowColumnNames[i] + ":" + rowColumnTypeInfos[i];
                if (dataTypePhysicalVariations != null && dataTypePhysicalVariations[i] != DataTypePhysicalVariation.NONE) {
                    displayString = displayString + "/" + dataTypePhysicalVariations[i].toString();
                }
                result.add(displayString);
            }
            return result;
        }

        public static String getScratchColumns(VectorizedRowBatchCtx vectorizedRowBatchCtx) {
            String[] scratchColumnTypeNames = vectorizedRowBatchCtx.getScratchColumnTypeNames();
            DataTypePhysicalVariation[] scratchDataTypePhysicalVariations = vectorizedRowBatchCtx.getScratchDataTypePhysicalVariations();
            int size = scratchColumnTypeNames.length;
            ArrayList<String> result = new ArrayList<String>(size);
            for (int i = 0; i < size; ++i) {
                String displayString = scratchColumnTypeNames[i];
                if (scratchDataTypePhysicalVariations != null && scratchDataTypePhysicalVariations[i] != DataTypePhysicalVariation.NONE) {
                    displayString = displayString + "/" + scratchDataTypePhysicalVariations[i].toString();
                }
                result.add(displayString);
            }
            return ((Object)result).toString();
        }

        @Explain(vectorization=Explain.Vectorization.SUMMARY, displayName="usesVectorUDFAdaptor", explainLevels={Explain.Level.DEFAULT, Explain.Level.EXTENDED})
        public Boolean usesVectorUDFAdaptor() {
            if (!this.baseWork.getVectorMode()) {
                return null;
            }
            return this.baseWork.getUsesVectorUDFAdaptor();
        }

        @Explain(vectorization=Explain.Vectorization.DETAIL, displayName="rowBatchContext", explainLevels={Explain.Level.DEFAULT, Explain.Level.EXTENDED})
        public RowBatchContextExplainVectorization vectorizedRowBatchContext() {
            if (!this.baseWork.getVectorMode()) {
                return null;
            }
            return new RowBatchContextExplainVectorization(this.baseWork.getVectorizedRowBatchCtx());
        }

        public static class RowBatchContextExplainVectorization {
            private final VectorizedRowBatchCtx vectorizedRowBatchCtx;

            public RowBatchContextExplainVectorization(VectorizedRowBatchCtx vectorizedRowBatchCtx) {
                this.vectorizedRowBatchCtx = vectorizedRowBatchCtx;
            }

            @Explain(vectorization=Explain.Vectorization.DETAIL, displayName="dataColumns", explainLevels={Explain.Level.DEFAULT, Explain.Level.EXTENDED})
            public List<String> getDataColumns() {
                return BaseExplainVectorization.getColumns(this.vectorizedRowBatchCtx, 0, this.vectorizedRowBatchCtx.getDataColumnCount());
            }

            @Explain(vectorization=Explain.Vectorization.DETAIL, displayName="partitionColumns", explainLevels={Explain.Level.DEFAULT, Explain.Level.EXTENDED})
            public List<String> getPartitionColumns() {
                return BaseExplainVectorization.getColumns(this.vectorizedRowBatchCtx, this.vectorizedRowBatchCtx.getDataColumnCount(), this.vectorizedRowBatchCtx.getPartitionColumnCount());
            }

            @Explain(vectorization=Explain.Vectorization.DETAIL, displayName="includeColumns", explainLevels={Explain.Level.DEFAULT, Explain.Level.EXTENDED})
            public String getDataColumnNums() {
                int[] dataColumnNums = this.vectorizedRowBatchCtx.getDataColumnNums();
                if (dataColumnNums == null) {
                    return null;
                }
                return Arrays.toString(dataColumnNums);
            }

            @Explain(vectorization=Explain.Vectorization.DETAIL, displayName="dataColumnCount", explainLevels={Explain.Level.DEFAULT, Explain.Level.EXTENDED})
            public int getDataColumnCount() {
                return this.vectorizedRowBatchCtx.getDataColumnCount();
            }

            @Explain(vectorization=Explain.Vectorization.DETAIL, displayName="partitionColumnCount", explainLevels={Explain.Level.DEFAULT, Explain.Level.EXTENDED})
            public int getPartitionColumnCount() {
                return this.vectorizedRowBatchCtx.getPartitionColumnCount();
            }

            @Explain(vectorization=Explain.Vectorization.DETAIL, displayName="scratchColumnTypeNames", explainLevels={Explain.Level.DEFAULT, Explain.Level.EXTENDED})
            public String getScratchColumnTypeNames() {
                return BaseExplainVectorization.getScratchColumns(this.vectorizedRowBatchCtx);
            }

            @Explain(vectorization=Explain.Vectorization.DETAIL, displayName="neededVirtualColumns", explainLevels={Explain.Level.DEFAULT, Explain.Level.EXTENDED})
            public String getNeededVirtualColumns() {
                VirtualColumn[] neededVirtualColumns = this.vectorizedRowBatchCtx.getNeededVirtualColumns();
                if (neededVirtualColumns == null || neededVirtualColumns.length == 0) {
                    return null;
                }
                return Arrays.toString((Object[])neededVirtualColumns);
            }
        }
    }
}

