/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.NoDynamicValuesException;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.DynamicValueRegistry;
import org.apache.hadoop.hive.ql.exec.ObjectCache;
import org.apache.hadoop.hive.ql.exec.ObjectCacheFactory;
import org.apache.hadoop.hive.ql.io.sarg.LiteralDelegate;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;

public class DynamicValue
implements LiteralDelegate,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String DYNAMIC_VALUE_REGISTRY_CACHE_KEY = "DynamicValueRegistry";
    protected transient Configuration conf;
    protected String id;
    TypeInfo typeInfo;
    PrimitiveObjectInspector objectInspector;
    protected transient Object val;
    transient boolean initialized = false;

    public DynamicValue(String id, TypeInfo typeInfo) {
        this.id = id;
        this.typeInfo = typeInfo;
        this.objectInspector = (PrimitiveObjectInspector)TypeInfoUtils.getStandardWritableObjectInspectorFromTypeInfo(typeInfo);
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public TypeInfo getTypeInfo() {
        return this.typeInfo;
    }

    public void setTypeInfo(TypeInfo typeInfo) {
        this.typeInfo = typeInfo;
    }

    public PrimitiveObjectInspector getObjectInspector() {
        return this.objectInspector;
    }

    public void setObjectInspector(PrimitiveObjectInspector objectInspector) {
        this.objectInspector = objectInspector;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public Object getLiteral() {
        return this.getJavaValue();
    }

    public Object getJavaValue() {
        return this.objectInspector.getPrimitiveJavaObject(this.getValue());
    }

    public Object getWritableValue() {
        return this.objectInspector.getPrimitiveWritableObject(this.getValue());
    }

    public Object getValue() {
        if (this.initialized) {
            return this.val;
        }
        if (this.conf == null) {
            throw new NoDynamicValuesException("Cannot retrieve dynamic value " + this.id + " - no conf set");
        }
        try {
            String queryId = HiveConf.getVar(this.conf, HiveConf.ConfVars.HIVEQUERYID);
            ObjectCache cache = ObjectCacheFactory.getCache(this.conf, queryId, false, true);
            if (cache == null) {
                return null;
            }
            DynamicValueRegistry valueRegistry = (DynamicValueRegistry)cache.retrieve(DYNAMIC_VALUE_REGISTRY_CACHE_KEY);
            if (valueRegistry == null) {
                throw new NoDynamicValuesException("DynamicValueRegistry not available");
            }
            this.val = valueRegistry.getValue(this.id);
            this.initialized = true;
        }
        catch (NoDynamicValuesException err) {
            throw err;
        }
        catch (Exception err) {
            throw new IllegalStateException("Failed to retrieve dynamic value for " + this.id, err);
        }
        return this.val;
    }

    public String toString() {
        return "DynamicValue(" + this.id + ")";
    }
}

