/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.Serializable;
import org.apache.calcite.rel.RelNode;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.SubqueryType;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;

public class ExprNodeSubQueryDesc
extends ExprNodeDesc
implements Serializable {
    private static final long serialVersionUID = 1L;
    private RelNode rexSubQuery;
    private ExprNodeDesc subQueryLhs;
    private SubqueryType type;

    public ExprNodeSubQueryDesc(TypeInfo typeInfo, RelNode subQuery, SubqueryType type) {
        super(typeInfo);
        this.rexSubQuery = subQuery;
        this.subQueryLhs = null;
        this.type = type;
    }

    public ExprNodeSubQueryDesc(TypeInfo typeInfo, RelNode subQuery, SubqueryType type, ExprNodeDesc lhs) {
        super(typeInfo);
        this.rexSubQuery = subQuery;
        this.subQueryLhs = lhs;
        this.type = type;
    }

    public SubqueryType getType() {
        return this.type;
    }

    public ExprNodeDesc getSubQueryLhs() {
        return this.subQueryLhs;
    }

    public RelNode getRexSubQuery() {
        return this.rexSubQuery;
    }

    @Override
    public ExprNodeDesc clone() {
        return new ExprNodeSubQueryDesc(this.typeInfo, this.rexSubQuery, this.type, this.subQueryLhs);
    }

    @Override
    public boolean isSame(Object o) {
        if (!(o instanceof ExprNodeSubQueryDesc)) {
            return false;
        }
        ExprNodeSubQueryDesc dest = (ExprNodeSubQueryDesc)o;
        if (this.subQueryLhs != null && dest.getSubQueryLhs() != null && !this.subQueryLhs.equals(dest.getSubQueryLhs())) {
            return false;
        }
        if (!this.typeInfo.equals(dest.getTypeInfo())) {
            return false;
        }
        if (!this.rexSubQuery.equals(dest.getRexSubQuery())) {
            return false;
        }
        return this.type == dest.getType();
    }
}

