/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.vector.VectorAggregationDesc;
import org.apache.hadoop.hive.ql.optimizer.signature.Signature;
import org.apache.hadoop.hive.ql.plan.AbstractOperatorDesc;
import org.apache.hadoop.hive.ql.plan.AggregationDesc;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.OperatorExplainVectorization;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.VectorGroupByDesc;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hive.common.util.AnnotationUtils;

@Explain(displayName="Group By Operator", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class GroupByDesc
extends AbstractOperatorDesc {
    private static final long serialVersionUID = 1L;
    private Mode mode;
    private boolean bucketGroup;
    private List<ExprNodeDesc> keys;
    private List<Long> listGroupingSets;
    private boolean groupingSetsPresent;
    private int groupingSetPosition = -1;
    private List<AggregationDesc> aggregators;
    private List<String> outputColumnNames;
    private float groupByMemoryUsage;
    private float memoryThreshold;
    private float minReductionHashAggr;
    private transient boolean isDistinct;
    private boolean dontResetAggrsDistinct;

    public GroupByDesc() {
    }

    public GroupByDesc(Mode mode, List<String> outputColumnNames, List<ExprNodeDesc> keys, List<AggregationDesc> aggregators, float groupByMemoryUsage, float memoryThreshold, float minReductionHashAggr, List<Long> listGroupingSets, boolean groupingSetsPresent, int groupingSetsPosition, boolean isDistinct) {
        this(mode, outputColumnNames, keys, aggregators, false, groupByMemoryUsage, memoryThreshold, minReductionHashAggr, listGroupingSets, groupingSetsPresent, groupingSetsPosition, isDistinct);
    }

    public GroupByDesc(Mode mode, List<String> outputColumnNames, List<ExprNodeDesc> keys, List<AggregationDesc> aggregators, boolean bucketGroup, float groupByMemoryUsage, float memoryThreshold, float minReductionHashAggr, List<Long> listGroupingSets, boolean groupingSetsPresent, int groupingSetsPosition, boolean isDistinct) {
        this.mode = mode;
        this.outputColumnNames = outputColumnNames;
        this.keys = keys;
        this.aggregators = aggregators;
        this.bucketGroup = bucketGroup;
        this.groupByMemoryUsage = groupByMemoryUsage;
        this.memoryThreshold = memoryThreshold;
        this.minReductionHashAggr = minReductionHashAggr;
        this.listGroupingSets = listGroupingSets;
        this.groupingSetsPresent = groupingSetsPresent;
        this.groupingSetPosition = groupingSetsPosition;
        this.isDistinct = isDistinct;
    }

    public Mode getMode() {
        return this.mode;
    }

    @Explain(displayName="mode")
    @Signature
    public String getModeString() {
        switch (this.mode) {
            case COMPLETE: {
                return "complete";
            }
            case PARTIAL1: {
                return "partial1";
            }
            case PARTIAL2: {
                return "partial2";
            }
            case PARTIALS: {
                return "partials";
            }
            case HASH: {
                return "hash";
            }
            case FINAL: {
                return "final";
            }
            case MERGEPARTIAL: {
                return "mergepartial";
            }
        }
        return "unknown";
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    @Explain(displayName="keys")
    @Signature
    public String getKeyString() {
        return PlanUtils.getExprListString(this.keys);
    }

    @Explain(displayName="keys", explainLevels={Explain.Level.USER})
    public String getUserLevelExplainKeyString() {
        return PlanUtils.getExprListString(this.keys, true);
    }

    public List<ExprNodeDesc> getKeys() {
        return this.keys;
    }

    public void setKeys(List<ExprNodeDesc> keys) {
        this.keys = keys;
    }

    @Explain(displayName="outputColumnNames")
    @Signature
    public List<String> getOutputColumnNames() {
        return this.outputColumnNames;
    }

    @Explain(displayName="Output", explainLevels={Explain.Level.USER})
    public List<String> getUserLevelExplainOutputColumnNames() {
        return this.outputColumnNames;
    }

    @Explain(displayName="pruneGroupingSetId", displayOnlyOnTrue=true)
    @Signature
    public boolean pruneGroupingSetId() {
        return this.groupingSetPosition >= 0 && this.outputColumnNames.size() != this.keys.size() + this.aggregators.size();
    }

    public void setOutputColumnNames(List<String> outputColumnNames) {
        this.outputColumnNames = outputColumnNames;
    }

    public float getGroupByMemoryUsage() {
        return this.groupByMemoryUsage;
    }

    public void setGroupByMemoryUsage(float groupByMemoryUsage) {
        this.groupByMemoryUsage = groupByMemoryUsage;
    }

    public float getMemoryThreshold() {
        return this.memoryThreshold;
    }

    public void setMemoryThreshold(float memoryThreshold) {
        this.memoryThreshold = memoryThreshold;
    }

    public float getMinReductionHashAggr() {
        return this.minReductionHashAggr;
    }

    public void setMinReductionHashAggr(float minReductionHashAggr) {
        this.minReductionHashAggr = minReductionHashAggr;
    }

    @Explain(displayName="minReductionHashAggr")
    public String getMinReductionHashAggrString() {
        return this.mode == Mode.HASH ? Float.toString(this.minReductionHashAggr) : null;
    }

    @Explain(displayName="aggregations", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    @Signature
    public List<String> getAggregatorStrings() {
        ArrayList<String> res = new ArrayList<String>();
        for (AggregationDesc agg : this.aggregators) {
            res.add(agg.getExprString());
        }
        return res;
    }

    public List<AggregationDesc> getAggregators() {
        return this.aggregators;
    }

    public void setAggregators(List<AggregationDesc> aggregators) {
        this.aggregators = aggregators;
    }

    public boolean isAggregate() {
        return this.aggregators != null && !this.aggregators.isEmpty();
    }

    @Explain(displayName="bucketGroup", displayOnlyOnTrue=true)
    @Signature
    public boolean getBucketGroup() {
        return this.bucketGroup;
    }

    public void setBucketGroup(boolean bucketGroup) {
        this.bucketGroup = bucketGroup;
    }

    public boolean isDistinctLike() {
        List<AggregationDesc> aggregators = this.getAggregators();
        for (AggregationDesc ad : aggregators) {
            GenericUDAFEvaluator udafEval;
            UDFType annot;
            if (ad.getDistinct() || (annot = AnnotationUtils.getAnnotation((udafEval = ad.getGenericUDAFEvaluator()).getClass(), UDFType.class)) != null && annot.distinctLike()) continue;
            return false;
        }
        return true;
    }

    public List<Long> getListGroupingSets() {
        return this.listGroupingSets;
    }

    public void setListGroupingSets(List<Long> listGroupingSets) {
        this.listGroupingSets = listGroupingSets;
    }

    public boolean isGroupingSetsPresent() {
        return this.groupingSetsPresent;
    }

    public void setGroupingSetsPresent(boolean groupingSetsPresent) {
        this.groupingSetsPresent = groupingSetsPresent;
    }

    public int getGroupingSetPosition() {
        return this.groupingSetPosition;
    }

    public void setGroupingSetPosition(int groupingSetPosition) {
        this.groupingSetPosition = groupingSetPosition;
    }

    public boolean isDontResetAggrsDistinct() {
        return this.dontResetAggrsDistinct;
    }

    public void setDontResetAggrsDistinct(boolean dontResetAggrsDistinct) {
        this.dontResetAggrsDistinct = dontResetAggrsDistinct;
    }

    public boolean isDistinct() {
        return this.isDistinct;
    }

    public void setDistinct(boolean isDistinct) {
        this.isDistinct = isDistinct;
    }

    @Override
    public Object clone() {
        ArrayList<String> outputColumnNames = new ArrayList<String>();
        outputColumnNames.addAll(this.outputColumnNames);
        ArrayList<ExprNodeDesc> keys = new ArrayList<ExprNodeDesc>();
        keys.addAll(this.keys);
        ArrayList<AggregationDesc> aggregators = new ArrayList<AggregationDesc>();
        aggregators.addAll(this.aggregators);
        ArrayList<Long> listGroupingSets = new ArrayList<Long>();
        listGroupingSets.addAll(this.listGroupingSets);
        return new GroupByDesc(this.mode, outputColumnNames, keys, aggregators, this.groupByMemoryUsage, this.memoryThreshold, this.minReductionHashAggr, listGroupingSets, this.groupingSetsPresent, this.groupingSetPosition, this.isDistinct);
    }

    @Explain(vectorization=Explain.Vectorization.OPERATOR, displayName="Group By Vectorization", explainLevels={Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public GroupByOperatorExplainVectorization getGroupByVectorization() {
        VectorGroupByDesc vectorGroupByDesc = (VectorGroupByDesc)this.getVectorDesc();
        if (vectorGroupByDesc == null) {
            return null;
        }
        return new GroupByOperatorExplainVectorization(this, vectorGroupByDesc);
    }

    public static String getComplexTypeEnabledCondition(boolean isVectorizationComplexTypesEnabled) {
        return HiveConf.ConfVars.HIVE_VECTORIZATION_COMPLEX_TYPES_ENABLED.varname + " IS " + isVectorizationComplexTypesEnabled;
    }

    public static String getComplexTypeWithGroupByEnabledCondition(boolean isVectorizationComplexTypesEnabled, boolean isVectorizationGroupByComplexTypesEnabled) {
        boolean enabled = isVectorizationComplexTypesEnabled && isVectorizationGroupByComplexTypesEnabled;
        return "(" + HiveConf.ConfVars.HIVE_VECTORIZATION_COMPLEX_TYPES_ENABLED.varname + " " + isVectorizationComplexTypesEnabled + " AND " + HiveConf.ConfVars.HIVE_VECTORIZATION_GROUPBY_COMPLEX_TYPES_ENABLED.varname + " " + isVectorizationGroupByComplexTypesEnabled + ") IS " + enabled;
    }

    @Override
    public boolean isSame(OperatorDesc other) {
        if (this.getClass().getName().equals(other.getClass().getName())) {
            GroupByDesc otherDesc = (GroupByDesc)other;
            return Objects.equals(this.getModeString(), otherDesc.getModeString()) && Objects.equals(this.getKeyString(), otherDesc.getKeyString()) && Objects.equals(this.getOutputColumnNames(), otherDesc.getOutputColumnNames()) && this.pruneGroupingSetId() == otherDesc.pruneGroupingSetId() && Objects.equals(this.getAggregatorStrings(), otherDesc.getAggregatorStrings()) && this.getBucketGroup() == otherDesc.getBucketGroup();
        }
        return false;
    }

    public class GroupByOperatorExplainVectorization
    extends OperatorExplainVectorization {
        private final GroupByDesc groupByDesc;
        private final VectorGroupByDesc vectorGroupByDesc;

        public GroupByOperatorExplainVectorization(GroupByDesc groupByDesc, VectorGroupByDesc vectorGroupByDesc) {
            super(vectorGroupByDesc, false);
            this.groupByDesc = groupByDesc;
            this.vectorGroupByDesc = vectorGroupByDesc;
        }

        @Explain(vectorization=Explain.Vectorization.EXPRESSION, displayName="keyExpressions", explainLevels={Explain.Level.DEFAULT, Explain.Level.EXTENDED})
        public List<String> getKeysExpression() {
            return this.vectorExpressionsToStringList(this.vectorGroupByDesc.getKeyExpressions());
        }

        @Explain(vectorization=Explain.Vectorization.EXPRESSION, displayName="aggregators", explainLevels={Explain.Level.DEFAULT, Explain.Level.EXTENDED})
        public List<String> getAggregators() {
            VectorAggregationDesc[] vecAggrDescs = this.vectorGroupByDesc.getVecAggrDescs();
            ArrayList<String> vecAggrList = new ArrayList<String>(vecAggrDescs.length);
            for (VectorAggregationDesc vecAggrDesc : vecAggrDescs) {
                vecAggrList.add(vecAggrDesc.toString());
            }
            return vecAggrList;
        }

        @Explain(vectorization=Explain.Vectorization.OPERATOR, displayName="vectorProcessingMode", explainLevels={Explain.Level.DEFAULT, Explain.Level.EXTENDED})
        public String getProcessingMode() {
            return this.vectorGroupByDesc.getProcessingMode().name();
        }

        @Explain(vectorization=Explain.Vectorization.OPERATOR, displayName="groupByMode", explainLevels={Explain.Level.DEFAULT, Explain.Level.EXTENDED})
        public String getGroupByMode() {
            return this.groupByDesc.getMode().name();
        }

        @Explain(vectorization=Explain.Vectorization.OPERATOR, displayName="vectorOutputConditionsNotMet", explainLevels={Explain.Level.DEFAULT, Explain.Level.EXTENDED})
        public List<String> getVectorOutputConditionsNotMet() {
            ArrayList<String> results = new ArrayList<String>();
            boolean isVectorizationComplexTypesEnabled = this.vectorGroupByDesc.getIsVectorizationComplexTypesEnabled();
            boolean isVectorizationGroupByComplexTypesEnabled = this.vectorGroupByDesc.getIsVectorizationGroupByComplexTypesEnabled();
            if (isVectorizationComplexTypesEnabled && isVectorizationGroupByComplexTypesEnabled) {
                return null;
            }
            results.add(GroupByDesc.getComplexTypeWithGroupByEnabledCondition(isVectorizationComplexTypesEnabled, isVectorizationGroupByComplexTypesEnabled));
            return results;
        }

        @Explain(vectorization=Explain.Vectorization.EXPRESSION, displayName="projectedOutputColumnNums", explainLevels={Explain.Level.DEFAULT, Explain.Level.EXTENDED})
        public String getProjectedOutputColumnNums() {
            return Arrays.toString(this.vectorGroupByDesc.getProjectedOutputColumns());
        }
    }

    public static enum Mode {
        COMPLETE,
        PARTIAL1,
        PARTIAL2,
        PARTIALS,
        FINAL,
        HASH,
        MERGEPARTIAL;

    }
}

