/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hive.ql.security.authorization.Privilege;

public enum HiveOperation {
    EXPLAIN("EXPLAIN", 898, null, null),
    LOAD("LOAD", 957, null, new Privilege[]{Privilege.ALTER_DATA}),
    EXPORT("EXPORT", 901, new Privilege[]{Privilege.SELECT}, null),
    IMPORT("IMPORT", 926, null, new Privilege[]{Privilege.ALTER_METADATA, Privilege.ALTER_DATA}),
    REPLDUMP("REPLDUMP", 1036, new Privilege[]{Privilege.ALL}, null),
    REPLLOAD("REPLLOAD", 1037, null, new Privilege[]{Privilege.ALL}),
    REPLSTATUS("REPLSTATUS", 1038, new Privilege[]{Privilege.SELECT}, null),
    CREATEDATABASE("CREATEDATABASE", 839, null, new Privilege[]{Privilege.CREATE}),
    DROPDATABASE("DROPDATABASE", 880, null, new Privilege[]{Privilege.DROP}),
    SWITCHDATABASE("SWITCHDATABASE", 1106, null, null, true, false),
    LOCKDB("LOCKDATABASE", 958, new Privilege[]{Privilege.LOCK}, null),
    UNLOCKDB("UNLOCKDATABASE", 1162, new Privilege[]{Privilege.LOCK}, null),
    DROPTABLE("DROPTABLE", 884, null, new Privilege[]{Privilege.DROP}),
    DESCTABLE("DESCTABLE", 873, null, null),
    DESCFUNCTION("DESCFUNCTION", 872, null, null),
    MSCK("MSCK", 964, null, null),
    ALTERTABLE_ADDCOLS("ALTERTABLE_ADDCOLS", 770, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERTABLE_REPLACECOLS("ALTERTABLE_REPLACECOLS", 791, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERTABLE_RENAMECOL("ALTERTABLE_RENAMECOL", 789, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERTABLE_RENAMEPART("ALTERTABLE_RENAMEPART", 790, new Privilege[]{Privilege.DROP}, new Privilege[]{Privilege.CREATE}),
    ALTERTABLE_UPDATEPARTSTATS("ALTERTABLE_UPDATEPARTSTATS", new int[]{768, 767}, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERTABLE_UPDATETABLESTATS("ALTERTABLE_UPDATETABLESTATS", new int[]{800, 798}, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERTABLE_RENAME("ALTERTABLE_RENAME", 788, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERTABLE_DROPPARTS("ALTERTABLE_DROPPARTS", new int[]{779, 803}, new Privilege[]{Privilege.DROP}, null),
    ALTERTABLE_ADDPARTS("ALTERTABLE_ADDPARTS", new int[]{772, 802}, null, new Privilege[]{Privilege.CREATE}),
    ALTERTABLE_TOUCH("ALTERTABLE_TOUCH", 796, null, null),
    ALTERTABLE_ARCHIVE("ALTERTABLE_ARCHIVE", 773, new Privilege[]{Privilege.ALTER_DATA}, null),
    ALTERTABLE_UNARCHIVE("ALTERTABLE_UNARCHIVE", 797, new Privilege[]{Privilege.ALTER_DATA}, null),
    ALTERTABLE_PROPERTIES("ALTERTABLE_PROPERTIES", new int[]{787, 780}, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERTABLE_OWNER("ALTERTABLE_OWNER", 785, null, null),
    ALTERTABLE_SERIALIZER("ALTERTABLE_SERIALIZER", 793, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERPARTITION_SERIALIZER("ALTERPARTITION_SERIALIZER", 766, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERTABLE_SERDEPROPERTIES("ALTERTABLE_SERDEPROPERTIES", 792, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERPARTITION_SERDEPROPERTIES("ALTERPARTITION_SERDEPROPERTIES", 765, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERTABLE_CLUSTER_SORT("ALTERTABLE_CLUSTER_SORT", 776, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ANALYZE_TABLE("ANALYZE_TABLE", 823, null, null),
    CACHE_METADATA("CACHE_METADATA", 829, new Privilege[]{Privilege.SELECT}, null),
    ALTERTABLE_BUCKETNUM("ALTERTABLE_BUCKETNUM", 774, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERPARTITION_BUCKETNUM("ALTERPARTITION_BUCKETNUM", 761, new Privilege[]{Privilege.ALTER_METADATA}, null),
    SHOWDATABASES("SHOWDATABASES", 1069, new Privilege[]{Privilege.SHOW_DATABASE}, null, true, false),
    SHOWTABLES("SHOWTABLES", 1075, null, null, true, false),
    SHOWCOLUMNS("SHOWCOLUMNS", 1067, null, null, true, false),
    SHOW_TABLESTATUS("SHOW_TABLESTATUS", 1086, null, null, true, false),
    SHOW_TBLPROPERTIES("SHOW_TBLPROPERTIES", 1087, null, null, true, false),
    SHOW_CREATEDATABASE("SHOW_CREATEDATABASE", 1078, new Privilege[]{Privilege.SELECT}, null),
    SHOW_CREATETABLE("SHOW_CREATETABLE", 1079, new Privilege[]{Privilege.SELECT}, null),
    SHOWFUNCTIONS("SHOWFUNCTIONS", 1071, null, null, true, false),
    SHOWPARTITIONS("SHOWPARTITIONS", 1074, null, null),
    SHOWLOCKS("SHOWLOCKS", new int[]{1072, 1070}, null, null, true, false),
    SHOWCONF("SHOWCONF", 1068, null, null),
    SHOWVIEWS("SHOWVIEWS", 1076, null, null, true, false),
    SHOWMATERIALIZEDVIEWS("SHOWMATERIALIZEDVIEWS", 1073, null, null, true, false),
    CREATEFUNCTION("CREATEFUNCTION", 840, null, null),
    DROPFUNCTION("DROPFUNCTION", 881, null, null),
    RELOADFUNCTION("RELOADFUNCTION", 1029, null, null),
    CREATEMACRO("CREATEMACRO", 841, null, null),
    DROPMACRO("DROPMACRO", 882, null, null),
    CREATEVIEW("CREATEVIEW", 844, new Privilege[]{Privilege.SELECT}, new Privilege[]{Privilege.CREATE}),
    CREATE_MATERIALIZED_VIEW("CREATE_MATERIALIZED_VIEW", 846, new Privilege[]{Privilege.SELECT}, new Privilege[]{Privilege.CREATE}),
    DROPVIEW("DROPVIEW", 885, null, new Privilege[]{Privilege.DROP}),
    DROP_MATERIALIZED_VIEW("DROP_MATERIALIZED_VIEW", 887, null, new Privilege[]{Privilege.DROP}),
    ALTER_MATERIALIZED_VIEW_REWRITE("ALTER_MATERIALIZED_VIEW_REWRITE", 810, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERVIEW_PROPERTIES("ALTERVIEW_PROPERTIES", new int[]{805, 804}, null, null),
    LOCKTABLE("LOCKTABLE", 959, new Privilege[]{Privilege.LOCK}, null),
    UNLOCKTABLE("UNLOCKTABLE", 1163, new Privilege[]{Privilege.LOCK}, null),
    CREATEROLE("CREATEROLE", 842, null, null),
    DROPROLE("DROPROLE", 883, null, null),
    GRANT_PRIVILEGE("GRANT_PRIVILEGE", 914, null, null),
    REVOKE_PRIVILEGE("REVOKE_PRIVILEGE", 1045, null, null),
    SHOW_GRANT("SHOW_GRANT", 1081, null, null, true, false),
    GRANT_ROLE("GRANT_ROLE", 916, null, null),
    REVOKE_ROLE("REVOKE_ROLE", 1046, null, null),
    SHOW_ROLES("SHOW_ROLES", new int[]{1082, 1080, 1066}, null, null, true, false),
    SHOW_ROLE_PRINCIPALS("SHOW_ROLE_PRINCIPALS", 1084, null, null, true, false),
    SHOW_ROLE_GRANT("SHOW_ROLE_GRANT", 1083, null, null, true, false),
    ALTERTABLE_FILEFORMAT("ALTERTABLE_FILEFORMAT", 782, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERPARTITION_FILEFORMAT("ALTERPARTITION_FILEFORMAT", 762, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERTABLE_LOCATION("ALTERTABLE_LOCATION", 783, new Privilege[]{Privilege.ALTER_DATA}, null),
    ALTERPARTITION_LOCATION("ALTERPARTITION_LOCATION", 763, new Privilege[]{Privilege.ALTER_DATA}, null),
    CREATETABLE("CREATETABLE", 843, null, new Privilege[]{Privilege.CREATE}),
    TRUNCATETABLE("TRUNCATETABLE", 1153, null, new Privilege[]{Privilege.DROP}),
    CREATETABLE_AS_SELECT("CREATETABLE_AS_SELECT", null, new Privilege[]{Privilege.SELECT}, new Privilege[]{Privilege.CREATE}),
    QUERY("QUERY", 1024, new Privilege[]{Privilege.SELECT}, new Privilege[]{Privilege.ALTER_DATA, Privilege.CREATE}, true, false),
    ALTERDATABASE("ALTERDATABASE", 760, null, null),
    ALTERDATABASE_OWNER("ALTERDATABASE_OWNER", 759, null, null),
    ALTERDATABASE_LOCATION("ALTERDATABASE_LOCATION", new int[]{757, 758}, new Privilege[]{Privilege.ALTER_DATA}, null),
    DESCDATABASE("DESCDATABASE", 871, null, null),
    ALTERTABLE_MERGEFILES("ALTER_TABLE_MERGE", 784, new Privilege[]{Privilege.SELECT}, new Privilege[]{Privilege.ALTER_DATA}),
    ALTERPARTITION_MERGEFILES("ALTER_PARTITION_MERGE", 764, new Privilege[]{Privilege.SELECT}, new Privilege[]{Privilege.ALTER_DATA}),
    ALTERTABLE_SKEWED("ALTERTABLE_SKEWED", 794, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERTBLPART_SKEWED_LOCATION("ALTERTBLPART_SKEWED_LOCATION", 795, new Privilege[]{Privilege.ALTER_DATA}, null),
    ALTERTABLE_PARTCOLTYPE("ALTERTABLE_PARTCOLTYPE", 786, new Privilege[]{Privilege.SELECT}, new Privilege[]{Privilege.ALTER_DATA}),
    ALTERTABLE_EXCHANGEPARTITION("ALTERTABLE_EXCHANGEPARTITION", 781, new Privilege[]{Privilege.SELECT, Privilege.DELETE}, new Privilege[]{Privilege.INSERT}),
    ALTERTABLE_DROPCONSTRAINT("ALTERTABLE_DROPCONSTRAINT", 778, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERTABLE_ADDCONSTRAINT("ALTERTABLE_ADDCONSTRAINT", 771, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERTABLE_UPDATECOLUMNS("ALTERTABLE_UPDATECOLUMNS", 799, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERVIEW_RENAME("ALTERVIEW_RENAME", 806, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERVIEW_AS("ALTERVIEW_AS", 801, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERTABLE_COMPACT("ALTERTABLE_COMPACT", 777, new Privilege[]{Privilege.SELECT}, new Privilege[]{Privilege.ALTER_DATA}),
    SHOW_COMPACTIONS("SHOW COMPACTIONS", 1077, null, null, true, false),
    SHOW_TRANSACTIONS("SHOW TRANSACTIONS", 1088, null, null, true, false),
    START_TRANSACTION("START TRANSACTION", 1094, null, null, false, false),
    COMMIT("COMMIT", 837, null, null, true, true),
    ROLLBACK("ROLLBACK", 1051, null, null, true, true),
    SET_AUTOCOMMIT("SET AUTOCOMMIT", 1064, null, null, true, false),
    ABORT_TRANSACTIONS("ABORT TRANSACTIONS", 750, null, null, false, false),
    KILL_QUERY("KILL QUERY", 947, null, null),
    CREATE_RESOURCEPLAN("CREATE RESOURCEPLAN", 848, null, null, false, false),
    SHOW_RESOURCEPLAN("SHOW RESOURCEPLAN", 1085, null, null, false, false),
    ALTER_RESOURCEPLAN("ALTER RESOURCEPLAN", new int[]{820, 816, 818, 819, 815, 814, 817}, null, null, false, false),
    DROP_RESOURCEPLAN("DROP RESOURCEPLAN", 889, null, null, false, false),
    CREATE_TRIGGER("CREATE TRIGGER", 850, null, null, false, false),
    ALTER_TRIGGER("ALTER TRIGGER", 822, null, null, false, false),
    DROP_TRIGGER("DROP TRIGGER", 891, null, null, false, false),
    CREATE_POOL("CREATE POOL", 847, null, null, false, false),
    ALTER_POOL("ALTER POOL", new int[]{811, 812, 813}, null, null, false, false),
    DROP_POOL("DROP POOL", 888, null, null, false, false),
    CREATE_MAPPING("CREATE MAPPING", 845, null, null, false, false),
    ALTER_MAPPING("ALTER MAPPING", 807, null, null, false, false),
    DROP_MAPPING("DROP MAPPING", 886, null, null, false, false),
    CREATE_SCHEDULED_QUERY("CREATE SCHEDULED QUERY", 849, null, null),
    ALTER_SCHEDULED_QUERY("ALTER SCHEDULED QUERY", 821, null, null),
    DROP_SCHEDULED_QUERY("DROP SCHEDULED QUERY", 890, null, null);

    private final String operationName;
    private final int[] tokens;
    private final Privilege[] inputRequiredPrivileges;
    private final Privilege[] outputRequiredPrivileges;
    private final boolean allowedInTransaction;
    private final boolean requiresOpenTransaction;
    private static final Map<Integer, HiveOperation> TOKEN_TO_OPERATION;

    private HiveOperation(String operationName, int token, Privilege[] inputRequiredPrivileges, Privilege[] outputRequiredPrivileges) {
        this(operationName, new int[]{token}, inputRequiredPrivileges, outputRequiredPrivileges, false, false);
    }

    private HiveOperation(String operationName, int[] tokens, Privilege[] inputRequiredPrivileges, Privilege[] outputRequiredPrivileges) {
        this(operationName, tokens, inputRequiredPrivileges, outputRequiredPrivileges, false, false);
    }

    private HiveOperation(String operationName, int token, Privilege[] inputRequiredPrivileges, Privilege[] outputRequiredPrivileges, boolean allowedInTransaction, boolean requiresOpenTransaction) {
        this(operationName, new int[]{token}, inputRequiredPrivileges, outputRequiredPrivileges, allowedInTransaction, requiresOpenTransaction);
    }

    private HiveOperation(String operationName, int[] tokens, Privilege[] inputRequiredPrivileges, Privilege[] outputRequiredPrivileges, boolean allowedInTransaction, boolean requiresOpenTransaction) {
        this.operationName = operationName;
        this.tokens = tokens;
        this.inputRequiredPrivileges = inputRequiredPrivileges;
        this.outputRequiredPrivileges = outputRequiredPrivileges;
        this.requiresOpenTransaction = requiresOpenTransaction;
        this.allowedInTransaction = allowedInTransaction || requiresOpenTransaction;
    }

    public String getOperationName() {
        return this.operationName;
    }

    public Privilege[] getInputRequiredPrivileges() {
        return this.inputRequiredPrivileges;
    }

    public Privilege[] getOutputRequiredPrivileges() {
        return this.outputRequiredPrivileges;
    }

    public boolean isAllowedInTransaction() {
        return this.allowedInTransaction;
    }

    public boolean isRequiresOpenTransaction() {
        return this.requiresOpenTransaction;
    }

    public static HiveOperation operationForToken(int token) {
        return TOKEN_TO_OPERATION.get(token);
    }

    static {
        TOKEN_TO_OPERATION = new HashMap<Integer, HiveOperation>();
        for (HiveOperation hiveOperation : HiveOperation.values()) {
            if (hiveOperation.tokens == null) continue;
            for (int token : hiveOperation.tokens) {
                TOKEN_TO_OPERATION.put(token, hiveOperation);
            }
        }
    }
}

