/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.table.create.CreateTableDesc;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.HiveTableName;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.repl.metric.ReplicationMetricCollector;

public class ImportTableDesc {
    private String dbName = null;
    private CreateTableDesc createTblDesc = null;

    public ImportTableDesc(String dbName, Table table) throws Exception {
        if (table.getTableType() == TableType.VIRTUAL_VIEW || table.getTableType() == TableType.MATERIALIZED_VIEW) {
            throw new IllegalStateException("Trying to import view or materialized view: " + table.getTableName());
        }
        this.dbName = dbName;
        TableName tableName = HiveTableName.ofNullable(table.getTableName(), dbName);
        this.createTblDesc = new CreateTableDesc(tableName, false, false, table.getSd().getCols(), table.getPartitionKeys(), table.getSd().getBucketCols(), table.getSd().getSortCols(), table.getSd().getNumBuckets(), null, null, null, null, null, null, table.getSd().getInputFormat(), table.getSd().getOutputFormat(), null, table.getSd().getSerdeInfo().getSerializationLib(), null, table.getSd().getSerdeInfo().getParameters(), table.getParameters(), false, null == table.getSd().getSkewedInfo() ? null : table.getSd().getSkewedInfo().getSkewedColNames(), null == table.getSd().getSkewedInfo() ? null : table.getSd().getSkewedInfo().getSkewedColValues(), null, null, null, null, null, null, table.getColStats(), table.getTTable().getWriteId());
        this.createTblDesc.setStoredAsSubDirectories(table.getSd().isStoredAsSubDirectories());
    }

    public void setReplicationSpec(ReplicationSpec replSpec) {
        this.createTblDesc.setReplicationSpec(replSpec);
    }

    public void setExternal(boolean isExternal) {
        this.createTblDesc.setExternal(isExternal);
    }

    public boolean isExternal() {
        return this.createTblDesc.isExternal();
    }

    public void setLocation(String location) {
        this.createTblDesc.setLocation(location);
    }

    public String getLocation() {
        return this.createTblDesc.getLocation();
    }

    public void setTableName(TableName tableName) throws SemanticException {
        this.createTblDesc.setTableName(tableName);
    }

    public String getTableName() throws SemanticException {
        return this.createTblDesc.getTableName().getTable();
    }

    public List<FieldSchema> getPartCols() {
        return this.createTblDesc.getPartCols();
    }

    public List<FieldSchema> getCols() {
        return this.createTblDesc.getCols();
    }

    public Map<String, String> getTblProps() {
        return this.createTblDesc.getTblProps();
    }

    public String getInputFormat() {
        return this.createTblDesc.getInputFormat();
    }

    public String getOutputFormat() {
        return this.createTblDesc.getOutputFormat();
    }

    public String getSerName() {
        return this.createTblDesc.getSerName();
    }

    public Map<String, String> getSerdeProps() {
        return this.createTblDesc.getSerdeProps();
    }

    public List<String> getBucketCols() {
        return this.createTblDesc.getBucketCols();
    }

    public List<Order> getSortCols() {
        return this.createTblDesc.getSortCols();
    }

    public void setReplaceMode(boolean replaceMode) {
        this.createTblDesc.setReplaceMode(replaceMode);
    }

    public String getDatabaseName() {
        return this.dbName;
    }

    public Task<?> getCreateTableTask(Set<ReadEntity> inputs, Set<WriteEntity> outputs, HiveConf conf) {
        return TaskFactory.get(new DDLWork(inputs, outputs, this.createTblDesc), conf);
    }

    public Task<?> getCreateTableTask(Set<ReadEntity> inputs, Set<WriteEntity> outputs, HiveConf conf, boolean isReplication, String dumpRoot, ReplicationMetricCollector metricCollector) {
        return TaskFactory.get(new DDLWork(inputs, outputs, this.createTblDesc, isReplication, dumpRoot, metricCollector), conf);
    }

    public TableType tableType() {
        return TableType.MANAGED_TABLE;
    }

    public Table toTable(HiveConf conf) throws Exception {
        return this.createTblDesc.toTable(conf);
    }

    public void setReplWriteId(Long replWriteId) {
        this.createTblDesc.setReplWriteId(replWriteId);
    }

    public void setOwnerName(String ownerName) {
        this.createTblDesc.setOwnerName(ownerName);
    }

    public Long getReplWriteId() {
        return this.createTblDesc.getReplWriteId();
    }
}

