/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.plan.DynamicPartitionCtx;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.ListBucketingCtx;
import org.apache.hadoop.hive.ql.plan.LoadDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;

public class LoadTableDesc
extends LoadDesc
implements Serializable {
    private static final long serialVersionUID = 1L;
    private LoadFileType loadFileType;
    private DynamicPartitionCtx dpCtx;
    private ListBucketingCtx lbCtx;
    private boolean inheritTableSpecs = true;
    private boolean inheritLocation = false;
    private int stmtId;
    private Long currentWriteId;
    private boolean isInsertOverwrite;
    private boolean isDirectInsert;
    private Table mdTable;
    private TableDesc table;
    private Map<String, String> partitionSpec;
    private String moveTaskId;

    public LoadTableDesc(LoadTableDesc o) {
        super(o.getSourcePath(), o.getWriteType());
        this.loadFileType = o.loadFileType;
        this.dpCtx = o.dpCtx;
        this.lbCtx = o.lbCtx;
        this.inheritTableSpecs = o.inheritTableSpecs;
        this.inheritLocation = o.inheritLocation;
        this.currentWriteId = o.currentWriteId;
        this.table = o.table;
        this.partitionSpec = o.partitionSpec;
        this.isDirectInsert = o.isDirectInsert;
    }

    public LoadTableDesc(Path sourcePath, TableDesc table, Map<String, String> partitionSpec, LoadFileType loadFileType, AcidUtils.Operation writeType, Long currentWriteId) {
        super(sourcePath, writeType);
        if (Utilities.FILE_OP_LOGGER.isTraceEnabled()) {
            Utilities.FILE_OP_LOGGER.trace("creating part LTD from " + sourcePath + " to " + (table.getProperties() == null ? "null" : table.getTableName()));
        }
        this.init(table, partitionSpec, loadFileType, currentWriteId);
    }

    public LoadTableDesc(Path sourcePath, TableDesc table, Map<String, String> partitionSpec, LoadFileType loadFileType, Long writeId) {
        this(sourcePath, table, partitionSpec, loadFileType, AcidUtils.Operation.NOT_ACID, writeId);
    }

    public LoadTableDesc(Path sourcePath, TableDesc table, Map<String, String> partitionSpec, AcidUtils.Operation writeType, Long currentWriteId) {
        this(sourcePath, table, partitionSpec, LoadFileType.REPLACE_ALL, writeType, currentWriteId);
    }

    public LoadTableDesc(Path sourcePath, TableDesc table, Map<String, String> partitionSpec) {
        this(sourcePath, table, partitionSpec, LoadFileType.REPLACE_ALL, AcidUtils.Operation.NOT_ACID, null);
    }

    public LoadTableDesc(Path sourcePath, TableDesc table, DynamicPartitionCtx dpCtx, AcidUtils.Operation writeType, boolean isReplace, Long writeId) {
        super(sourcePath, writeType);
        LoadFileType lft;
        if (Utilities.FILE_OP_LOGGER.isTraceEnabled()) {
            Utilities.FILE_OP_LOGGER.trace("creating LTD from " + sourcePath + " to " + table.getTableName());
        }
        this.dpCtx = dpCtx;
        LoadFileType loadFileType = lft = isReplace ? LoadFileType.REPLACE_ALL : LoadFileType.OVERWRITE_EXISTING;
        if (dpCtx != null && dpCtx.getPartSpec() != null && this.partitionSpec == null) {
            this.init(table, dpCtx.getPartSpec(), lft, writeId);
        } else {
            this.init(table, new LinkedHashMap<String, String>(), lft, writeId);
        }
    }

    private void init(TableDesc table, Map<String, String> partitionSpec, LoadFileType loadFileType, Long writeId) {
        this.table = table;
        this.partitionSpec = partitionSpec;
        this.loadFileType = loadFileType;
        this.currentWriteId = writeId;
    }

    @Explain(displayName="table", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public TableDesc getTable() {
        return this.table;
    }

    public void setTable(TableDesc table) {
        this.table = table;
    }

    @Explain(displayName="partition")
    public Map<String, String> getPartitionSpec() {
        return this.partitionSpec;
    }

    public void setPartitionSpec(Map<String, String> partitionSpec) {
        this.partitionSpec = partitionSpec;
    }

    @Explain(displayName="replace")
    public boolean getReplace() {
        return this.loadFileType == LoadFileType.REPLACE_ALL;
    }

    public LoadFileType getLoadFileType() {
        return this.loadFileType;
    }

    @Explain(displayName="micromanaged table")
    public Boolean isMmTableExplain() {
        return this.isMmTable() ? Boolean.valueOf(true) : null;
    }

    public boolean isMmTable() {
        return AcidUtils.isInsertOnlyTable(this.table.getProperties());
    }

    public void setLoadFileType(LoadFileType loadFileType) {
        this.loadFileType = loadFileType;
    }

    public DynamicPartitionCtx getDPCtx() {
        return this.dpCtx;
    }

    public void setDPCtx(DynamicPartitionCtx dpCtx) {
        this.dpCtx = dpCtx;
    }

    public boolean getInheritTableSpecs() {
        return this.inheritTableSpecs;
    }

    public boolean getInheritLocation() {
        return this.inheritLocation;
    }

    public void setInheritTableSpecs(boolean inheritTableSpecs) {
        this.inheritTableSpecs = this.inheritLocation = inheritTableSpecs;
    }

    public boolean isInsertOverwrite() {
        return this.isInsertOverwrite;
    }

    public void setInsertOverwrite(boolean v) {
        this.isInsertOverwrite = v;
    }

    public void setIsDirectInsert(boolean isDirectInsert) {
        this.isDirectInsert = isDirectInsert;
    }

    public boolean isDirectInsert() {
        return this.isDirectInsert;
    }

    public ListBucketingCtx getLbCtx() {
        return this.lbCtx;
    }

    public void setLbCtx(ListBucketingCtx lbCtx) {
        this.lbCtx = lbCtx;
    }

    public long getWriteId() {
        return this.currentWriteId == null ? 0L : this.currentWriteId;
    }

    public void setWriteId(long writeId) {
        this.currentWriteId = writeId;
    }

    public int getStmtId() {
        return this.stmtId;
    }

    public void setStmtId(int stmtId) {
        this.stmtId = stmtId;
    }

    public Table getMdTable() {
        return this.mdTable;
    }

    public void setMdTable(Table mdTable) {
        this.mdTable = mdTable;
    }

    public String getMoveTaskId() {
        return this.moveTaskId;
    }

    public void setMoveTaskId(String moveTaskId) {
        this.moveTaskId = moveTaskId;
    }

    public static enum LoadFileType {
        REPLACE_ALL,
        KEEP_EXISTING,
        OVERWRITE_EXISTING,
        IGNORE;

    }
}

