/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.plan.BaseWork;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.TezEdgeProperty;
import org.apache.hadoop.hive.ql.plan.VectorizationCondition;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;

public class ReduceWork
extends BaseWork {
    private TableDesc keyDesc;
    private List<TableDesc> tagToValueDesc = new ArrayList<TableDesc>();
    private Operator<?> reducer;
    private Integer numReduceTasks;
    private boolean needsTagging;
    private Map<Integer, String> tagToInput = new HashMap<Integer, String>();
    private boolean isAutoReduceParallelism;
    private transient boolean isUniformDistribution = false;
    private boolean isSlowStart = true;
    private int minReduceTasks;
    private int maxReduceTasks;
    private ObjectInspector keyObjectInspector = null;
    private ObjectInspector valueObjectInspector = null;
    private boolean reduceVectorizationEnabled;
    private String vectorReduceEngine;
    private String vectorReduceColumnSortOrder;
    private String vectorReduceColumnNullOrder;
    private transient TezEdgeProperty edgeProp;
    private static Set<String> reduceVectorizableEngines = new LinkedHashSet<String>(Arrays.asList("tez", "spark"));

    public ReduceWork() {
    }

    public ReduceWork(String name) {
        super(name);
    }

    public void setKeyDesc(TableDesc keyDesc) {
        this.keyDesc = keyDesc;
    }

    public TableDesc getKeyDesc() {
        return this.keyDesc;
    }

    public List<TableDesc> getTagToValueDesc() {
        return this.tagToValueDesc;
    }

    public void setTagToValueDesc(List<TableDesc> tagToValueDesc) {
        this.tagToValueDesc = tagToValueDesc;
    }

    @Explain(displayName="Execution mode", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED}, vectorization=Explain.Vectorization.SUMMARY_PATH)
    public String getExecutionMode() {
        if (!(!this.vectorMode || this.getIsTestForcedVectorizationEnable() && this.getIsTestVectorizationSuppressExplainExecutionMode())) {
            if (this.llapMode) {
                if (this.uberMode) {
                    return "vectorized, uber";
                }
                return "vectorized, llap";
            }
            return "vectorized";
        }
        if (this.llapMode) {
            return this.uberMode ? "uber" : "llap";
        }
        return null;
    }

    @Explain(displayName="Reduce Operator Tree", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED}, vectorization=Explain.Vectorization.OPERATOR_PATH)
    public Operator<?> getReducer() {
        return this.reducer;
    }

    public void setReducer(Operator<?> reducer) {
        this.reducer = reducer;
    }

    @Explain(displayName="Needs Tagging", explainLevels={Explain.Level.EXTENDED})
    public boolean getNeedsTagging() {
        return this.needsTagging;
    }

    public void setNeedsTagging(boolean needsTagging) {
        this.needsTagging = needsTagging;
    }

    public void setTagToInput(Map<Integer, String> tagToInput) {
        this.tagToInput = tagToInput;
    }

    @Explain(displayName="tagToInput", explainLevels={Explain.Level.USER})
    public Map<Integer, String> getTagToInput() {
        return this.tagToInput;
    }

    @Override
    public void replaceRoots(Map<Operator<?>, Operator<?>> replacementMap) {
        this.setReducer(replacementMap.get(this.getReducer()));
    }

    public Set<Operator<?>> getAllRootOperators() {
        LinkedHashSet opSet = new LinkedHashSet();
        opSet.add(this.getReducer());
        return opSet;
    }

    @Override
    public Operator<? extends OperatorDesc> getAnyRootOperator() {
        return this.getReducer();
    }

    public Integer getNumReduceTasks() {
        return this.numReduceTasks;
    }

    public void setNumReduceTasks(Integer numReduceTasks) {
        this.numReduceTasks = numReduceTasks;
    }

    public void setAutoReduceParallelism(boolean isAutoReduceParallelism) {
        this.isAutoReduceParallelism = isAutoReduceParallelism;
    }

    public boolean isAutoReduceParallelism() {
        return this.isAutoReduceParallelism;
    }

    public boolean isSlowStart() {
        return this.isSlowStart;
    }

    public void setSlowStart(boolean isSlowStart) {
        this.isSlowStart = isSlowStart;
    }

    public void setUniformDistribution(boolean isUniformDistribution) {
        this.isUniformDistribution = isUniformDistribution;
    }

    public boolean isUniformDistribution() {
        return this.isUniformDistribution;
    }

    public void setMinReduceTasks(int minReduceTasks) {
        this.minReduceTasks = minReduceTasks;
    }

    public int getMinReduceTasks() {
        return this.minReduceTasks;
    }

    public int getMaxReduceTasks() {
        return this.maxReduceTasks;
    }

    public void setMaxReduceTasks(int maxReduceTasks) {
        this.maxReduceTasks = maxReduceTasks;
    }

    public void setReduceVectorizationEnabled(boolean reduceVectorizationEnabled) {
        this.reduceVectorizationEnabled = reduceVectorizationEnabled;
    }

    public boolean getReduceVectorizationEnabled() {
        return this.reduceVectorizationEnabled;
    }

    public void setVectorReduceEngine(String vectorReduceEngine) {
        this.vectorReduceEngine = vectorReduceEngine;
    }

    public String getVectorReduceEngine() {
        return this.vectorReduceEngine;
    }

    public void setVectorReduceColumnSortOrder(String vectorReduceColumnSortOrder) {
        this.vectorReduceColumnSortOrder = vectorReduceColumnSortOrder;
    }

    public String getVectorReduceColumnSortOrder() {
        return this.vectorReduceColumnSortOrder;
    }

    public void setVectorReduceColumnNullOrder(String vectorReduceColumnNullOrder) {
        this.vectorReduceColumnNullOrder = vectorReduceColumnNullOrder;
    }

    public String getVectorReduceColumnNullOrder() {
        return this.vectorReduceColumnNullOrder;
    }

    @Explain(vectorization=Explain.Vectorization.SUMMARY, displayName="Reduce Vectorization", explainLevels={Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public ReduceExplainVectorization getReduceExplainVectorization() {
        if (!this.getVectorizationExamined()) {
            return null;
        }
        return new ReduceExplainVectorization(this);
    }

    public void setEdgePropRef(TezEdgeProperty edgeProp) {
        this.edgeProp = edgeProp;
    }

    public TezEdgeProperty getEdgePropRef() {
        return this.edgeProp;
    }

    public class ReduceExplainVectorization
    extends BaseWork.BaseExplainVectorization {
        private final ReduceWork reduceWork;
        private VectorizationCondition[] reduceVectorizationConditions;

        public ReduceExplainVectorization(ReduceWork reduceWork) {
            super(reduceWork);
            this.reduceWork = reduceWork;
        }

        private VectorizationCondition[] createReduceExplainVectorizationConditions() {
            boolean enabled = this.reduceWork.getReduceVectorizationEnabled();
            String engine = this.reduceWork.getVectorReduceEngine();
            String engineInSupportedCondName = HiveConf.ConfVars.HIVE_EXECUTION_ENGINE.varname + " " + engine + " IN " + reduceVectorizableEngines;
            boolean engineInSupported = reduceVectorizableEngines.contains(engine);
            VectorizationCondition[] conditions = new VectorizationCondition[]{new VectorizationCondition(enabled, HiveConf.ConfVars.HIVE_VECTORIZATION_REDUCE_ENABLED.varname), new VectorizationCondition(engineInSupported, engineInSupportedCondName)};
            return conditions;
        }

        @Explain(vectorization=Explain.Vectorization.SUMMARY, displayName="enableConditionsMet", explainLevels={Explain.Level.DEFAULT, Explain.Level.EXTENDED})
        public List<String> getEnableConditionsMet() {
            if (this.reduceVectorizationConditions == null) {
                this.reduceVectorizationConditions = this.createReduceExplainVectorizationConditions();
            }
            return VectorizationCondition.getConditionsMet(this.reduceVectorizationConditions);
        }

        @Explain(vectorization=Explain.Vectorization.SUMMARY, displayName="enableConditionsNotMet", explainLevels={Explain.Level.DEFAULT, Explain.Level.EXTENDED})
        public List<String> getEnableConditionsNotMet() {
            if (this.reduceVectorizationConditions == null) {
                this.reduceVectorizationConditions = this.createReduceExplainVectorizationConditions();
            }
            return VectorizationCondition.getConditionsNotMet(this.reduceVectorizationConditions);
        }

        @Explain(vectorization=Explain.Vectorization.DETAIL, displayName="reduceColumnSortOrder", explainLevels={Explain.Level.DEFAULT, Explain.Level.EXTENDED})
        public String getReduceColumnSortOrder() {
            if (!ReduceWork.this.getVectorizationExamined()) {
                return null;
            }
            return this.reduceWork.getVectorReduceColumnSortOrder();
        }

        @Explain(vectorization=Explain.Vectorization.DETAIL, displayName="reduceColumnNullOrder", explainLevels={Explain.Level.DEFAULT, Explain.Level.EXTENDED})
        public String getReduceColumnNullOrder() {
            if (!ReduceWork.this.getVectorizationExamined()) {
                return null;
            }
            return this.reduceWork.getVectorReduceColumnNullOrder();
        }
    }
}

