/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.parse.repl.metric.ReplicationMetricCollector;
import org.apache.hadoop.hive.ql.plan.CopyWork;
import org.apache.hadoop.hive.ql.plan.Explain;

@Explain(displayName="Repl Copy", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class ReplCopyWork
extends CopyWork {
    protected boolean readSrcAsFilesList = false;
    private boolean deleteDestIfExist = false;
    private boolean isAutoPurge = false;
    private boolean needRecycle = false;
    private String distCpDoAsUser = null;
    private boolean checkDuplicateCopy = false;
    private boolean overWrite = false;
    private String dumpDirectory;
    private transient ReplicationMetricCollector metricCollector;

    public ReplCopyWork(Path srcPath, Path destPath, boolean errorOnSrcEmpty) {
        super(srcPath, destPath, errorOnSrcEmpty);
    }

    public ReplCopyWork(Path srcPath, Path destPath, boolean errorOnSrcEmpty, boolean overWrite) {
        this(srcPath, destPath, errorOnSrcEmpty);
        this.overWrite = overWrite;
    }

    public ReplCopyWork(Path srcPath, Path destPath, boolean errorOnSrcEmpty, boolean overWrite, String dumpDirectory, ReplicationMetricCollector metricCollector) {
        this(srcPath, destPath, errorOnSrcEmpty);
        this.overWrite = overWrite;
        this.dumpDirectory = dumpDirectory;
        this.metricCollector = metricCollector;
    }

    public void setReadSrcAsFilesList(boolean readSrcAsFilesList) {
        this.readSrcAsFilesList = readSrcAsFilesList;
    }

    public boolean readSrcAsFilesList() {
        return this.readSrcAsFilesList;
    }

    public void setDistCpDoAsUser(String distCpDoAsUser) {
        this.distCpDoAsUser = distCpDoAsUser;
    }

    public String distCpDoAsUser() {
        return this.distCpDoAsUser;
    }

    public boolean getDeleteDestIfExist() {
        return this.deleteDestIfExist;
    }

    public void setDeleteDestIfExist(boolean deleteDestIfExist) {
        this.deleteDestIfExist = deleteDestIfExist;
    }

    public boolean getNeedRecycle() {
        return this.needRecycle;
    }

    public void setNeedRecycle(boolean needRecycle) {
        this.needRecycle = needRecycle;
    }

    public boolean getIsAutoPurge() {
        return this.isAutoPurge;
    }

    public void setAutoPurge(boolean isAutoPurge) {
        this.isAutoPurge = isAutoPurge;
    }

    public boolean isNeedCheckDuplicateCopy() {
        return this.checkDuplicateCopy;
    }

    public void setCheckDuplicateCopy(boolean flag) {
        this.checkDuplicateCopy = flag;
    }

    @Override
    public ReplicationMetricCollector getMetricCollector() {
        return this.metricCollector;
    }

    @Override
    public String getDumpDirectory() {
        return this.dumpDirectory;
    }

    public boolean isOverWrite() {
        return this.overWrite;
    }
}

