/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.hadoop.hive.ql.optimizer.topnkey.CommonKeyPrefix;
import org.apache.hadoop.hive.ql.plan.AbstractOperatorDesc;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDescUtils;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.OperatorExplainVectorization;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.VectorTopNKeyDesc;

@Explain(displayName="Top N Key Operator", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class TopNKeyDesc
extends AbstractOperatorDesc {
    private static final long serialVersionUID = 1L;
    private int topN;
    private String columnSortOrder;
    private String nullOrder;
    private List<ExprNodeDesc> keyColumns;
    private List<ExprNodeDesc> partitionKeyColumns;
    private float efficiencyThreshold;
    private long checkEfficiencyNumBatches;
    private long checkEfficiencyNumRows;
    private int maxNumberOfPartitions;

    public TopNKeyDesc() {
    }

    public TopNKeyDesc(int topN, String columnSortOrder, String nullOrder, List<ExprNodeDesc> keyColumns, List<ExprNodeDesc> partitionKeyColumns, float efficiencyThreshold, long checkEfficiencyNumBatches, int maxNumberOfPartitions) {
        this.topN = topN;
        this.keyColumns = new ArrayList<ExprNodeDesc>(keyColumns.size());
        this.efficiencyThreshold = efficiencyThreshold;
        this.checkEfficiencyNumBatches = checkEfficiencyNumBatches;
        this.checkEfficiencyNumRows = checkEfficiencyNumBatches * 1024L;
        this.maxNumberOfPartitions = maxNumberOfPartitions;
        StringBuilder sortOrder = new StringBuilder(columnSortOrder.length());
        StringBuilder nullSortOrder = new StringBuilder(nullOrder.length());
        this.partitionKeyColumns = new ArrayList<ExprNodeDesc>(partitionKeyColumns.size());
        for (int i = 0; i < keyColumns.size(); ++i) {
            ExprNodeDesc keyExpression = keyColumns.get(i);
            if (keyExpression instanceof ExprNodeConstantDesc) continue;
            this.keyColumns.add(keyExpression);
            sortOrder.append(columnSortOrder.charAt(i));
            nullSortOrder.append(nullOrder.charAt(i));
        }
        this.columnSortOrder = sortOrder.toString();
        this.nullOrder = nullSortOrder.toString();
        for (ExprNodeDesc keyExpression : partitionKeyColumns) {
            if (keyExpression instanceof ExprNodeConstantDesc) continue;
            this.partitionKeyColumns.add(keyExpression);
        }
    }

    @Explain(displayName="top n", explainLevels={Explain.Level.DEFAULT, Explain.Level.EXTENDED, Explain.Level.USER})
    public int getTopN() {
        return this.topN;
    }

    public float getEfficiencyThreshold() {
        return this.efficiencyThreshold;
    }

    public long getCheckEfficiencyNumBatches() {
        return this.checkEfficiencyNumBatches;
    }

    public long getCheckEfficiencyNumRows() {
        return this.checkEfficiencyNumRows;
    }

    public int getMaxNumberOfPartitions() {
        return this.maxNumberOfPartitions;
    }

    public void setTopN(int topN) {
        this.topN = topN;
    }

    @Explain(displayName="sort order", explainLevels={Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getColumnSortOrder() {
        return this.columnSortOrder;
    }

    public void setColumnSortOrder(String columnSortOrder) {
        this.columnSortOrder = columnSortOrder;
    }

    @Explain(displayName="null sort order", explainLevels={Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getNullOrder() {
        return this.nullOrder;
    }

    public void setNullOrder(String nullOrder) {
        this.nullOrder = nullOrder;
    }

    @Explain(displayName="keys")
    public String getKeyString() {
        return PlanUtils.getExprListString(this.keyColumns);
    }

    @Explain(displayName="keys", explainLevels={Explain.Level.USER})
    public String getUserLevelExplainKeyString() {
        return PlanUtils.getExprListString(this.keyColumns, true);
    }

    public List<ExprNodeDesc> getKeyColumns() {
        return this.keyColumns;
    }

    public void setKeyColumns(List<ExprNodeDesc> keyColumns) {
        this.keyColumns = keyColumns;
    }

    public List<String> getKeyColumnNames() {
        ArrayList<String> ret = new ArrayList<String>();
        for (ExprNodeDesc keyColumn : this.keyColumns) {
            ret.add(keyColumn.getExprString());
        }
        return ret;
    }

    public List<ExprNodeDesc> getPartitionKeyColumns() {
        return this.partitionKeyColumns;
    }

    public void setPartitionKeyColumns(List<ExprNodeDesc> partitionKeyColumns) {
        this.partitionKeyColumns = partitionKeyColumns;
    }

    @Explain(displayName="Map-reduce partition columns")
    public String getPartitionKeyString() {
        return PlanUtils.getExprListString(this.partitionKeyColumns);
    }

    @Explain(displayName="PartitionCols", explainLevels={Explain.Level.USER})
    public String getUserLevelExplainPartitionKeyString() {
        return PlanUtils.getExprListString(this.partitionKeyColumns, true);
    }

    @Override
    public boolean isSame(OperatorDesc other) {
        if (this.getClass().getName().equals(other.getClass().getName())) {
            TopNKeyDesc otherDesc = (TopNKeyDesc)other;
            return this.getTopN() == otherDesc.getTopN() && this.getEfficiencyThreshold() == otherDesc.getEfficiencyThreshold() && this.getCheckEfficiencyNumRows() == otherDesc.getCheckEfficiencyNumRows() && this.getCheckEfficiencyNumBatches() == otherDesc.getCheckEfficiencyNumBatches() && this.getMaxNumberOfPartitions() == otherDesc.getMaxNumberOfPartitions() && ExprNodeDescUtils.isSame(this.partitionKeyColumns, otherDesc.partitionKeyColumns) && Objects.equals(this.columnSortOrder, otherDesc.columnSortOrder) && Objects.equals(this.nullOrder, otherDesc.nullOrder) && ExprNodeDescUtils.isSame(this.keyColumns, otherDesc.keyColumns);
        }
        return false;
    }

    @Override
    public Object clone() {
        TopNKeyDesc ret = new TopNKeyDesc();
        ret.setTopN(this.topN);
        ret.setColumnSortOrder(this.columnSortOrder);
        ret.setNullOrder(this.nullOrder);
        ret.setKeyColumns((List<ExprNodeDesc>)(this.getKeyColumns() == null ? null : new ArrayList<ExprNodeDesc>(this.getKeyColumns())));
        ret.setPartitionKeyColumns((List<ExprNodeDesc>)(this.getPartitionKeyColumns() == null ? null : new ArrayList<ExprNodeDesc>(this.getPartitionKeyColumns())));
        ret.setCheckEfficiencyNumRows(this.checkEfficiencyNumRows);
        ret.setCheckEfficiencyNumBatches(this.checkEfficiencyNumBatches);
        ret.setEfficiencyThreshold(this.efficiencyThreshold);
        ret.setMaxNumberOfPartitions(this.maxNumberOfPartitions);
        return ret;
    }

    public void setEfficiencyThreshold(float efficiencyThreshold) {
        this.efficiencyThreshold = efficiencyThreshold;
    }

    public void setCheckEfficiencyNumBatches(long checkEfficiencyNumBatches) {
        this.checkEfficiencyNumBatches = checkEfficiencyNumBatches;
    }

    public void setCheckEfficiencyNumRows(long checkEfficiencyNumRows) {
        this.checkEfficiencyNumRows = checkEfficiencyNumRows;
    }

    public void setMaxNumberOfPartitions(int maxNumberOfPartitions) {
        this.maxNumberOfPartitions = maxNumberOfPartitions;
    }

    @Explain(vectorization=Explain.Vectorization.OPERATOR, displayName="Top N Key Vectorization", explainLevels={Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public TopNKeyDescExplainVectorization getTopNKeyVectorization() {
        VectorTopNKeyDesc vectorTopNKeyDesc = (VectorTopNKeyDesc)this.getVectorDesc();
        if (vectorTopNKeyDesc == null) {
            return null;
        }
        return new TopNKeyDescExplainVectorization(this, vectorTopNKeyDesc);
    }

    public TopNKeyDesc combine(CommonKeyPrefix commonKeyPrefix) {
        return new TopNKeyDesc(this.topN, commonKeyPrefix.getMappedOrder(), commonKeyPrefix.getMappedNullOrder(), commonKeyPrefix.getMappedColumns(), commonKeyPrefix.getMappedColumns().subList(0, this.partitionKeyColumns.size()), this.efficiencyThreshold, this.checkEfficiencyNumBatches, this.maxNumberOfPartitions);
    }

    public class TopNKeyDescExplainVectorization
    extends OperatorExplainVectorization {
        private final TopNKeyDesc topNKeyDesc;
        private final VectorTopNKeyDesc vectorTopNKeyDesc;

        public TopNKeyDescExplainVectorization(TopNKeyDesc topNKeyDesc, VectorTopNKeyDesc vectorTopNKeyDesc) {
            super(vectorTopNKeyDesc, true);
            this.topNKeyDesc = topNKeyDesc;
            this.vectorTopNKeyDesc = vectorTopNKeyDesc;
        }

        @Explain(vectorization=Explain.Vectorization.OPERATOR, displayName="keyExpressions", explainLevels={Explain.Level.DEFAULT, Explain.Level.EXTENDED})
        public List<String> getKeyExpressions() {
            return this.vectorExpressionsToStringList(this.vectorTopNKeyDesc.getKeyExpressions());
        }
    }
}

