/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.processors;

import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.processors.CommandProcessor;
import org.apache.hadoop.hive.ql.processors.CommandProcessorException;
import org.apache.hadoop.hive.ql.processors.CommandProcessorResponse;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CryptoProcessor
implements CommandProcessor {
    public static final Logger LOG = LoggerFactory.getLogger((String)CryptoProcessor.class.getName());
    private HadoopShims.HdfsEncryptionShim encryptionShim;
    private Options CREATE_KEY_OPTIONS;
    private Options DELETE_KEY_OPTIONS;
    private Options CREATE_ZONE_OPTIONS;
    private int DEFAULT_BIT_LENGTH = 128;

    public CryptoProcessor(HadoopShims.HdfsEncryptionShim encryptionShim, HiveConf conf) {
        this.encryptionShim = encryptionShim;
        this.CREATE_KEY_OPTIONS = new Options();
        OptionBuilder.hasArg();
        OptionBuilder.withLongOpt((String)"keyName");
        OptionBuilder.isRequired();
        this.CREATE_KEY_OPTIONS.addOption(OptionBuilder.create());
        OptionBuilder.hasArg();
        OptionBuilder.withLongOpt((String)"bitLength");
        this.CREATE_KEY_OPTIONS.addOption(OptionBuilder.create());
        this.DELETE_KEY_OPTIONS = new Options();
        OptionBuilder.hasArg();
        OptionBuilder.withLongOpt((String)"keyName");
        OptionBuilder.isRequired();
        this.DELETE_KEY_OPTIONS.addOption(OptionBuilder.create());
        this.CREATE_ZONE_OPTIONS = new Options();
        OptionBuilder.hasArg();
        OptionBuilder.withLongOpt((String)"keyName");
        OptionBuilder.isRequired();
        this.CREATE_ZONE_OPTIONS.addOption(OptionBuilder.create());
        OptionBuilder.hasArg();
        OptionBuilder.withLongOpt((String)"path");
        OptionBuilder.isRequired();
        this.CREATE_ZONE_OPTIONS.addOption(OptionBuilder.create());
    }

    private CommandLine parseCommandArgs(Options opts, String[] args) throws ParseException {
        GnuParser parser = new GnuParser();
        return parser.parse(opts, args);
    }

    private void writeTestOutput(String msg) {
        SessionState.get().out.println(msg);
    }

    @Override
    public CommandProcessorResponse run(String command) throws CommandProcessorException {
        block7: {
            String[] args = command.split("\\s+");
            if (args.length < 1) {
                throw new CommandProcessorException("Encryption Processor Helper Failed: Command arguments are empty.");
            }
            if (this.encryptionShim == null) {
                throw new CommandProcessorException("Encryption Processor Helper Failed: Hadoop encryption shim is not initialized.");
            }
            String action = args[0];
            String[] params = Arrays.copyOfRange(args, 1, args.length);
            try {
                if (action.equalsIgnoreCase("create_key")) {
                    this.createEncryptionKey(params);
                    break block7;
                }
                if (action.equalsIgnoreCase("create_zone")) {
                    this.createEncryptionZone(params);
                    break block7;
                }
                if (action.equalsIgnoreCase("delete_key")) {
                    this.deleteEncryptionKey(params);
                    break block7;
                }
                throw new CommandProcessorException("Encryption Processor Helper Failed: Unknown command action: " + action);
            }
            catch (Exception e) {
                throw new CommandProcessorException("Encryption Processor Helper Failed: " + e.getMessage());
            }
        }
        return new CommandProcessorResponse();
    }

    private void createEncryptionKey(String[] params) throws Exception {
        CommandLine args = this.parseCommandArgs(this.CREATE_KEY_OPTIONS, params);
        String keyName = args.getOptionValue("keyName");
        String bitLength = args.getOptionValue("bitLength", Integer.toString(this.DEFAULT_BIT_LENGTH));
        try {
            this.encryptionShim.createKey(keyName, new Integer(bitLength));
        }
        catch (Exception e) {
            throw new Exception("Cannot create encryption key: " + e.getMessage());
        }
        this.writeTestOutput("Encryption key created: '" + keyName + "'");
    }

    private void createEncryptionZone(String[] params) throws Exception {
        CommandLine args = this.parseCommandArgs(this.CREATE_ZONE_OPTIONS, params);
        String keyName = args.getOptionValue("keyName");
        Path cryptoZone = new Path(args.getOptionValue("path"));
        if (cryptoZone == null) {
            throw new Exception("Cannot create encryption zone: Invalid path '" + args.getOptionValue("path") + "'");
        }
        try {
            this.encryptionShim.createEncryptionZone(cryptoZone, keyName);
        }
        catch (IOException e) {
            throw new Exception("Cannot create encryption zone: " + e.getMessage());
        }
        this.writeTestOutput("Encryption zone created: '" + cryptoZone + "' using key: '" + keyName + "'");
    }

    private void deleteEncryptionKey(String[] params) throws Exception {
        CommandLine args = this.parseCommandArgs(this.DELETE_KEY_OPTIONS, params);
        String keyName = args.getOptionValue("keyName");
        try {
            this.encryptionShim.deleteKey(keyName);
        }
        catch (IOException e) {
            throw new Exception("Cannot delete encryption key: " + e.getMessage());
        }
        this.writeTestOutput("Encryption key deleted: '" + keyName + "'");
    }

    @Override
    public void close() throws Exception {
    }
}

