/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.processors;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.hive.conf.HiveVariableSource;
import org.apache.hadoop.hive.conf.VariableSubstitution;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Schema;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.processors.CommandProcessor;
import org.apache.hadoop.hive.ql.processors.CommandProcessorException;
import org.apache.hadoop.hive.ql.processors.CommandProcessorResponse;
import org.apache.hadoop.hive.ql.processors.CommandUtil;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveOperationType;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DfsProcessor
implements CommandProcessor {
    private static final Logger LOG = LoggerFactory.getLogger((String)DfsProcessor.class.getName());
    private static final SessionState.LogHelper console = new SessionState.LogHelper(LOG);
    public static final String DFS_RESULT_HEADER = "DFS Output";
    private final FsShell dfs;
    private final Schema dfsSchema;

    public DfsProcessor(Configuration conf) {
        this(conf, false);
    }

    public DfsProcessor(Configuration conf, boolean addSchema) {
        this.dfs = new FsShell(conf);
        this.dfsSchema = new Schema();
        this.dfsSchema.addToFieldSchemas(new FieldSchema(DFS_RESULT_HEADER, "string", ""));
    }

    @Override
    public CommandProcessorResponse run(String command) throws CommandProcessorException {
        try {
            SessionState ss = SessionState.get();
            command = new VariableSubstitution(new HiveVariableSource(){

                @Override
                public Map<String, String> getHiveVariable() {
                    return SessionState.get().getHiveVariables();
                }
            }).substitute(ss.getConf(), command);
            String[] tokens = this.splitCmd(command);
            CommandProcessorResponse authErrResp = CommandUtil.authorizeCommand(ss, HiveOperationType.DFS, Arrays.asList(tokens));
            if (authErrResp != null) {
                return authErrResp;
            }
            PrintStream oldOut = System.out;
            if (ss != null && ss.out != null) {
                System.setOut(ss.out);
            }
            int ret = this.dfs.run(tokens);
            System.setOut(oldOut);
            if (ret != 0) {
                console.printError("Command " + command + " failed with exit code = " + ret);
                throw new CommandProcessorException(ret);
            }
            return new CommandProcessorResponse(this.dfsSchema, null);
        }
        catch (CommandProcessorException e) {
            throw e;
        }
        catch (Exception e) {
            console.printError("Exception raised from DFSShell.run " + e.getLocalizedMessage(), StringUtils.stringifyException((Throwable)e));
            throw new CommandProcessorException(1);
        }
    }

    private String[] splitCmd(String command) throws HiveException {
        ArrayList<String> paras = new ArrayList<String>();
        int cmdLng = command.length();
        char y = '\u0000';
        int start = 0;
        block5: for (int i = 0; i < cmdLng; ++i) {
            char x = command.charAt(i);
            switch (x) {
                case ' ': {
                    String str;
                    if (y != '\u0000' || (str = command.substring(start, i).trim()).equals("")) continue block5;
                    paras.add(str);
                    start = i + 1;
                    continue block5;
                }
                case '\"': {
                    if (y == '\u0000') {
                        y = x;
                        start = i + 1;
                        continue block5;
                    }
                    if ('\"' != y) continue block5;
                    paras.add(command.substring(start, i).trim());
                    y = '\u0000';
                    start = i + 1;
                    continue block5;
                }
                case '\'': {
                    if (y == '\u0000') {
                        y = x;
                        start = i + 1;
                        continue block5;
                    }
                    if ('\'' != y) continue block5;
                    paras.add(command.substring(start, i).trim());
                    y = '\u0000';
                    start = i + 1;
                    continue block5;
                }
                default: {
                    if (i != cmdLng - 1 || start >= cmdLng) continue block5;
                    paras.add(command.substring(start, cmdLng).trim());
                }
            }
        }
        if (y != '\u0000') {
            String message = "Syntax error on hadoop options: dfs " + command;
            console.printError(message);
            throw new HiveException(message);
        }
        return paras.toArray(new String[paras.size()]);
    }

    @Override
    public void close() throws Exception {
    }
}

