/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.security.authorization.command;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.Function;
import org.apache.hadoop.hive.ql.exec.FunctionInfo;
import org.apache.hadoop.hive.ql.exec.FunctionUtils;
import org.apache.hadoop.hive.ql.hooks.Entity;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveStorageAuthorizationHandler;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.plan.HiveOperation;
import org.apache.hadoop.hive.ql.security.authorization.AuthorizationUtils;
import org.apache.hadoop.hive.ql.security.authorization.HiveCustomStorageHandlerUtils;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzContext;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveOperationType;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeObject;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class CommandAuthorizerV2 {
    private static final Logger LOG = LoggerFactory.getLogger((String)CommandAuthorizerV2.class.getName());

    private CommandAuthorizerV2() {
        throw new UnsupportedOperationException("CommandAuthorizerV2 should not be instantiated");
    }

    static void doAuthorization(HiveOperation op, BaseSemanticAnalyzer sem, SessionState ss, Set<ReadEntity> inputs, Set<WriteEntity> outputs, String command) throws HiveException {
        HiveOperationType hiveOpType = HiveOperationType.valueOf(op.name());
        Map<String, List<String>> selectTab2Cols = sem.getColumnAccessInfo() != null ? sem.getColumnAccessInfo().getTableToColumnAccessMap() : null;
        Map<String, List<String>> updateTab2Cols = sem.getUpdateColumnAccessInfo() != null ? sem.getUpdateColumnAccessInfo().getTableToColumnAccessMap() : null;
        ArrayList<ReadEntity> inputList = new ArrayList<ReadEntity>(inputs);
        ArrayList<WriteEntity> outputList = new ArrayList<WriteEntity>(outputs);
        CommandAuthorizerV2.addPermanentFunctionEntities(ss, inputList);
        List<HivePrivilegeObject> inputsHObjs = CommandAuthorizerV2.getHivePrivObjects(inputList, selectTab2Cols, hiveOpType, sem);
        List<HivePrivilegeObject> outputHObjs = CommandAuthorizerV2.getHivePrivObjects(outputList, updateTab2Cols, hiveOpType, sem);
        HiveAuthzContext.Builder authzContextBuilder = new HiveAuthzContext.Builder();
        authzContextBuilder.setUserIpAddress(ss.getUserIpAddress());
        authzContextBuilder.setForwardedAddresses(ss.getForwardedAddresses());
        authzContextBuilder.setCommandString(command);
        ss.getAuthorizerV2().checkPrivileges(hiveOpType, inputsHObjs, outputHObjs, authzContextBuilder.build());
    }

    private static void addPermanentFunctionEntities(SessionState ss, List<ReadEntity> inputList) throws HiveException {
        for (Map.Entry<String, FunctionInfo> function : ss.getCurrentFunctionsInUse().entrySet()) {
            if (function.getValue().getFunctionType() != FunctionInfo.FunctionType.PERSISTENT) continue;
            String[] qualifiedFunctionName = FunctionUtils.getQualifiedFunctionNameParts(function.getKey());
            Database db = new Database(qualifiedFunctionName[0], "", "", null);
            inputList.add(new ReadEntity(db, qualifiedFunctionName[1], function.getValue().getClassName(), Entity.Type.FUNCTION));
        }
    }

    private static List<HivePrivilegeObject> getHivePrivObjects(List<? extends Entity> privObjects, Map<String, List<String>> tableName2Cols, HiveOperationType hiveOpType, BaseSemanticAnalyzer sem) throws HiveException {
        ArrayList<HivePrivilegeObject> hivePrivobjs = new ArrayList<HivePrivilegeObject>();
        if (privObjects == null) {
            return hivePrivobjs;
        }
        for (Entity entity : privObjects) {
            if (entity.isDummy()) continue;
            if (entity instanceof ReadEntity && !((ReadEntity)entity).isDirect()) {
                ReadEntity reTable = (ReadEntity)entity;
                Boolean isDeferred = false;
                if (reTable.getParents() != null && reTable.getParents().size() > 0) {
                    for (ReadEntity re : reTable.getParents()) {
                        Table t;
                        if (re.getTyp() != Entity.Type.TABLE || re.getTable() == null || !CommandAuthorizerV2.isDeferredAuthView(t = re.getTable())) continue;
                        isDeferred = true;
                    }
                }
                if (!isDeferred.booleanValue()) continue;
            }
            if (entity instanceof WriteEntity && ((WriteEntity)entity).isTempURI() || entity.getTyp() == Entity.Type.TABLE && (entity.getT() == null || entity.getT().isTemporary())) continue;
            if (entity.getTyp() == Entity.Type.FUNCTION && !HiveConf.getBoolVar(SessionState.get().getConf(), HiveConf.ConfVars.HIVE_AUTHORIZATION_FUNCTIONS_IN_VIEW) && hiveOpType == HiveOperationType.QUERY) {
                String[] qualifiedFunctionName = new String[]{entity.getDatabase() != null ? entity.getDatabase().getName() : null, entity.getFunctionName()};
                if (!sem.getUserSuppliedFunctions().contains(qualifiedFunctionName[0] + "." + qualifiedFunctionName[1])) continue;
            }
            CommandAuthorizerV2.addHivePrivObject(entity, tableName2Cols, hivePrivobjs, hiveOpType);
        }
        return hivePrivobjs;
    }

    private static boolean isDeferredAuthView(Table t) {
        String tableType = t.getTTable().getTableType();
        String authorizedKeyword = "Authorized";
        boolean isView = false;
        if (TableType.MATERIALIZED_VIEW.name().equals(tableType) || TableType.VIRTUAL_VIEW.name().equals(tableType)) {
            isView = true;
        }
        if (isView) {
            String authorizedValue;
            Map<String, String> params = t.getParameters();
            if (HiveConf.getBoolVar(SessionState.get().getConf(), HiveConf.ConfVars.HIVE_AUTHORIZATION_ENABLED_ON_SPARK_VIEWS) && params != null && params.containsKey(authorizedKeyword) && "false".equalsIgnoreCase(authorizedValue = params.get(authorizedKeyword))) {
                return true;
            }
        }
        return false;
    }

    private static void addHivePrivObject(Entity privObject, Map<String, List<String>> tableName2Cols, List<HivePrivilegeObject> hivePrivObjs, HiveOperationType hiveOpType) throws HiveException {
        HivePrivilegeObject.HivePrivilegeObjectType privObjType = AuthorizationUtils.getHivePrivilegeObjectType(privObject.getType());
        HivePrivilegeObject.HivePrivObjectActionType actionType = AuthorizationUtils.getActionType(privObject);
        HivePrivilegeObject hivePrivObject = null;
        switch (privObject.getType()) {
            case DATABASE: {
                Database database = privObject.getDatabase();
                hivePrivObject = new HivePrivilegeObject(privObjType, database.getName(), null, null, null, actionType, null, null, database.getOwnerName(), database.getOwnerType());
                break;
            }
            case TABLE: {
                Table table = privObject.getTable();
                List<String> columns = tableName2Cols == null ? null : tableName2Cols.get(Table.getCompleteName(table.getDbName(), table.getTableName()));
                hivePrivObject = new HivePrivilegeObject(privObjType, table.getDbName(), table.getTableName(), null, columns, actionType, null, null, table.getOwner(), table.getOwnerType());
                if (table.getStorageHandler() == null || !HiveConf.getBoolVar(SessionState.getSessionConf(), HiveConf.ConfVars.HIVE_AUTHORIZATION_TABLES_ON_STORAGEHANDLERS) || hiveOpType != HiveOperationType.CREATETABLE && hiveOpType != HiveOperationType.ALTERTABLE_PROPERTIES && hiveOpType != HiveOperationType.CREATETABLE_AS_SELECT && hiveOpType != HiveOperationType.DROPTABLE) break;
                String storageuri = null;
                HashMap<String, String> tableProperties = new HashMap<String, String>();
                Configuration conf = new Configuration();
                tableProperties.putAll(table.getSd().getSerdeInfo().getParameters());
                tableProperties.putAll(table.getParameters());
                try {
                    if (table.getStorageHandler() instanceof HiveStorageAuthorizationHandler) {
                        HiveStorageAuthorizationHandler authorizationHandler = (HiveStorageAuthorizationHandler)ReflectionUtils.newInstance((Class)conf.getClassByName(table.getStorageHandler().getClass().getName()), (Configuration)SessionState.get().getConf());
                        storageuri = authorizationHandler.getURIForAuth(tableProperties).toString();
                    } else {
                        storageuri = table.getStorageHandler().getClass().getSimpleName().toLowerCase() + "://" + HiveCustomStorageHandlerUtils.getTablePropsForCustomStorageHandler(tableProperties);
                    }
                }
                catch (Exception ex) {
                    LOG.error("Exception occured while getting the URI from storage handler: " + ex.getMessage(), (Throwable)ex);
                    throw new HiveException(ex);
                }
                hivePrivObjs.add(new HivePrivilegeObject(HivePrivilegeObject.HivePrivilegeObjectType.STORAGEHANDLER_URI, null, storageuri, null, null, actionType, null, table.getStorageHandler().getClass().getName(), table.getOwner(), table.getOwnerType()));
                break;
            }
            case DFS_DIR: 
            case LOCAL_DIR: {
                hivePrivObject = new HivePrivilegeObject(privObjType, null, privObject.getD().toString(), null, null, actionType, null, null, null, null);
                break;
            }
            case FUNCTION: {
                if (privObject.getFunction() != null) {
                    Function function = privObject.getFunction();
                    hivePrivObject = new HivePrivilegeObject(privObjType, function.getDbName(), function.getFunctionName(), null, null, actionType, null, function.getClassName(), function.getOwnerName(), function.getOwnerType());
                    break;
                }
                String dbName = privObject.getDatabase() != null ? privObject.getDatabase().getName() : null;
                hivePrivObject = new HivePrivilegeObject(privObjType, dbName, privObject.getFunctionName(), null, null, actionType, null, privObject.getClassName(), null, null);
                break;
            }
            case DUMMYPARTITION: 
            case PARTITION: {
                return;
            }
            case SERVICE_NAME: {
                hivePrivObject = new HivePrivilegeObject(privObjType, null, privObject.getServiceName(), null, null, actionType, null, null, null, null);
                break;
            }
            default: {
                throw new AssertionError((Object)"Unexpected object type");
            }
        }
        hivePrivObjs.add(hivePrivObject);
    }
}

