/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.security.authorization.plugin;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.hadoop.hive.metastore.DefaultMetaStoreFilterHookImpl;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.TableMeta;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAccessControlException;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzContext;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzPluginException;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeObject;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeObjectUtils;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class AuthorizationMetaStoreFilterHook
extends DefaultMetaStoreFilterHookImpl {
    public static final Logger LOG = LoggerFactory.getLogger(AuthorizationMetaStoreFilterHook.class);

    public AuthorizationMetaStoreFilterHook(Configuration conf) {
        super(conf);
    }

    @Override
    public List<String> filterTableNames(String catName, String dbName, List<String> tableList) throws MetaException {
        List<HivePrivilegeObject> listObjs = this.getHivePrivObjects(dbName, tableList);
        return this.getTableNames(this.getFilteredObjects(listObjs));
    }

    @Override
    public List<Table> filterTables(List<Table> tableList) throws MetaException {
        List<HivePrivilegeObject> listObjs = this.tablesToPrivilegeObjs(tableList);
        return this.getFilteredTableList(this.getFilteredObjects(listObjs), tableList);
    }

    private List<Table> getFilteredTableList(List<HivePrivilegeObject> hivePrivilegeObjects, List<Table> tableList) {
        ArrayList<Table> ret = new ArrayList<Table>();
        for (HivePrivilegeObject hivePrivilegeObject : hivePrivilegeObjects) {
            String tblName;
            String dbName = hivePrivilegeObject.getDbname();
            Table table = this.getFilteredTable(dbName, tblName = hivePrivilegeObject.getObjectName(), tableList);
            if (table == null) continue;
            ret.add(table);
        }
        return ret;
    }

    private Table getFilteredTable(String dbName, String tblName, List<Table> tableList) {
        Table ret = null;
        for (Table table : tableList) {
            String databaseName = table.getDbName();
            String tableName = table.getTableName();
            if (!dbName.equals(databaseName) || !tblName.equals(tableName)) continue;
            ret = table;
            break;
        }
        return ret;
    }

    @Override
    public List<String> filterDatabases(List<String> dbList) throws MetaException {
        List<HivePrivilegeObject> listObjs = HivePrivilegeObjectUtils.getHivePrivDbObjects(dbList);
        return this.getDbNames(this.getFilteredObjects(listObjs));
    }

    private List<String> getDbNames(List<HivePrivilegeObject> filteredObjects) {
        ArrayList<String> tnames = new ArrayList<String>();
        for (HivePrivilegeObject obj : filteredObjects) {
            tnames.add(obj.getDbname());
        }
        return tnames;
    }

    private List<String> getTableNames(List<HivePrivilegeObject> filteredObjects) {
        ArrayList<String> tnames = new ArrayList<String>();
        for (HivePrivilegeObject obj : filteredObjects) {
            tnames.add(obj.getObjectName());
        }
        return tnames;
    }

    private List<HivePrivilegeObject> getFilteredObjects(List<HivePrivilegeObject> listObjs) throws MetaException {
        SessionState ss = SessionState.get();
        HiveAuthzContext.Builder authzContextBuilder = new HiveAuthzContext.Builder();
        authzContextBuilder.setUserIpAddress(ss.getUserIpAddress());
        authzContextBuilder.setForwardedAddresses(ss.getForwardedAddresses());
        try {
            return ss.getAuthorizerV2().filterListCmdObjects(listObjs, authzContextBuilder.build());
        }
        catch (HiveAuthzPluginException e) {
            LOG.error("Authorization error", (Throwable)e);
            throw new MetaException(e.getMessage());
        }
        catch (HiveAccessControlException e) {
            LOG.error("AccessControlException", (Throwable)e);
            throw new MetaException(e.getMessage());
        }
    }

    private List<HivePrivilegeObject> getHivePrivObjects(String dbName, List<String> tableList) {
        ArrayList<HivePrivilegeObject> objs = new ArrayList<HivePrivilegeObject>();
        for (String tname : tableList) {
            objs.add(new HivePrivilegeObject(HivePrivilegeObject.HivePrivilegeObjectType.TABLE_OR_VIEW, dbName, tname));
        }
        return objs;
    }

    private HivePrivilegeObject createPrivilegeObjectForTable(String dbName, String tableName, String owner, PrincipalType ownerType) {
        return new HivePrivilegeObject(HivePrivilegeObject.HivePrivilegeObjectType.TABLE_OR_VIEW, dbName, tableName, null, null, HivePrivilegeObject.HivePrivObjectActionType.OTHER, null, null, owner, ownerType);
    }

    private List<HivePrivilegeObject> tablesToPrivilegeObjs(List<Table> tableList) {
        ArrayList<HivePrivilegeObject> objs = new ArrayList<HivePrivilegeObject>();
        for (Table tableObject : tableList) {
            objs.add(this.createPrivilegeObjectForTable(tableObject.getDbName(), tableObject.getTableName(), tableObject.getOwner(), tableObject.getOwnerType()));
        }
        return objs;
    }

    private List<HivePrivilegeObject> tableMetasToPrivilegeObjs(List<TableMeta> tableMetas) {
        ArrayList<HivePrivilegeObject> objs = new ArrayList<HivePrivilegeObject>();
        for (TableMeta tableMeta : tableMetas) {
            objs.add(this.createPrivilegeObjectForTable(tableMeta.getDbName(), tableMeta.getTableName(), tableMeta.getOwnerName(), tableMeta.getOwnerType()));
        }
        return objs;
    }

    private ImmutablePair<String, String> tableMetaKey(String dbName, String tableName) {
        return new ImmutablePair<String, String>(dbName, tableName);
    }

    @Override
    public List<TableMeta> filterTableMetas(List<TableMeta> tableMetas) throws MetaException {
        List<HivePrivilegeObject> listObjs = this.tableMetasToPrivilegeObjs(tableMetas);
        List<HivePrivilegeObject> filteredList = this.getFilteredObjects(listObjs);
        Set filteredNames = filteredList.stream().map(e -> this.tableMetaKey(e.getDbname(), e.getObjectName())).collect(Collectors.toSet());
        return tableMetas.stream().filter(e -> filteredNames.contains(this.tableMetaKey(e.getDbName(), e.getTableName()))).collect(Collectors.toList());
    }
}

