/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.security.authorization.plugin.metastore;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStore;
import org.apache.hadoop.hive.metastore.MetaStoreFilterHook;
import org.apache.hadoop.hive.metastore.MetaStorePreEventListener;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.Catalog;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PartitionSpec;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.TableMeta;
import org.apache.hadoop.hive.metastore.events.PreAlterTableEvent;
import org.apache.hadoop.hive.metastore.events.PreCreateTableEvent;
import org.apache.hadoop.hive.metastore.events.PreDropTableEvent;
import org.apache.hadoop.hive.metastore.events.PreEventContext;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveUtils;
import org.apache.hadoop.hive.ql.security.HiveMetastoreAuthenticationProvider;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthorizer;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthorizerFactory;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzContext;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzSessionContext;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveMetastoreClientFactoryImpl;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveOperationType;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeObject;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.HiveMetaStoreAuthorizableEvent;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.HiveMetaStoreAuthzInfo;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.events.AddPartitionEvent;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.events.AlterDatabaseEvent;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.events.AlterPartitionEvent;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.events.AlterTableEvent;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.events.CreateDatabaseEvent;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.events.CreateFunctionEvent;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.events.CreateTableEvent;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.events.DropDatabaseEvent;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.events.DropFunctionEvent;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.events.DropPartitionEvent;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.events.DropTableEvent;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.events.LoadPartitionDoneEvent;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.events.ReadDatabaseEvent;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.events.ReadTableEvent;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.filtercontext.DatabaseFilterContext;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.filtercontext.TableFilterContext;
import org.apache.hadoop.security.UserGroupInformation;

public class HiveMetaStoreAuthorizer
extends MetaStorePreEventListener
implements MetaStoreFilterHook {
    private static final Log LOG = LogFactory.getLog(HiveMetaStoreAuthorizer.class);
    private static final ThreadLocal<Configuration> tConfig = new ThreadLocal<Configuration>(){

        @Override
        protected Configuration initialValue() {
            return null;
        }
    };
    private static final ThreadLocal<HiveMetastoreAuthenticationProvider> tAuthenticator = new ThreadLocal<HiveMetastoreAuthenticationProvider>(){

        @Override
        protected HiveMetastoreAuthenticationProvider initialValue() {
            try {
                return (HiveMetastoreAuthenticationProvider)HiveUtils.getAuthenticator((Configuration)tConfig.get(), HiveConf.ConfVars.HIVE_METASTORE_AUTHENTICATOR_MANAGER);
            }
            catch (HiveException excp) {
                throw new IllegalStateException("Authentication provider instantiation failure", excp);
            }
        }
    };

    public HiveMetaStoreAuthorizer(Configuration config) {
        super(config);
    }

    @Override
    public final void onEvent(PreEventContext preEventContext) throws MetaException, NoSuchObjectException, InvalidOperationException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> HiveMetaStoreAuthorizer.onEvent(): EventType=" + (Object)((Object)preEventContext.getEventType())));
        }
        try {
            HiveAuthorizer hiveAuthorizer = this.createHiveMetaStoreAuthorizer();
            if (!this.skipAuthorization()) {
                HiveMetaStoreAuthzInfo authzContext = this.buildAuthzContext(preEventContext);
                this.checkPrivileges(authzContext, hiveAuthorizer);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"HiveMetaStoreAuthorizer.onEvent(): failed", (Throwable)e);
            throw new MetaException(e.getMessage());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== HiveMetaStoreAuthorizer.onEvent(): EventType=" + (Object)((Object)preEventContext.getEventType())));
        }
    }

    @Override
    public final List<String> filterDatabases(List<String> list) throws MetaException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"HiveMetaStoreAuthorizer.filterDatabases()");
        }
        if (list == null) {
            return Collections.emptyList();
        }
        DatabaseFilterContext databaseFilterContext = new DatabaseFilterContext(list);
        HiveMetaStoreAuthzInfo hiveMetaStoreAuthzInfo = databaseFilterContext.getAuthzContext();
        List<String> filteredDatabases = this.filterDatabaseObjects(hiveMetaStoreAuthzInfo);
        if (CollectionUtils.isEmpty(filteredDatabases)) {
            filteredDatabases = Collections.emptyList();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("HiveMetaStoreAuthorizer.filterDatabases() :" + filteredDatabases));
        }
        return filteredDatabases;
    }

    @Override
    public final Database filterDatabase(Database database) throws MetaException, NoSuchObjectException {
        String dbName;
        List<String> databases;
        if (database != null && (databases = this.filterDatabases(Collections.singletonList(dbName = database.getName()))).isEmpty()) {
            throw new NoSuchObjectException(String.format("Database %s does not exist", dbName));
        }
        return database;
    }

    @Override
    public final List<String> filterTableNames(String s, String s1, List<String> list) throws MetaException {
        String dbName;
        TableFilterContext tableFilterContext;
        HiveMetaStoreAuthzInfo hiveMetaStoreAuthzInfo;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HiveMetaStoreAuthorizer.filterTableNames()");
        }
        List<String> filteredTableNames = null;
        if (list != null && CollectionUtils.isEmpty(filteredTableNames = this.filterTableNames(hiveMetaStoreAuthzInfo = (tableFilterContext = new TableFilterContext(dbName = this.getDBName(s1), list)).getAuthzContext(), dbName, list))) {
            filteredTableNames = Collections.emptyList();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== HiveMetaStoreAuthorizer.filterTableNames() : " + filteredTableNames));
        }
        return filteredTableNames;
    }

    @Override
    public final Table filterTable(Table table) throws MetaException, NoSuchObjectException {
        List<Table> tables;
        if (table != null && (tables = this.filterTables(Collections.singletonList(table))).isEmpty()) {
            throw new NoSuchObjectException(String.format("Database %s does not exist", table.getTableName()));
        }
        return table;
    }

    @Override
    public final List<Table> filterTables(List<Table> list) throws MetaException {
        TableFilterContext tableFilterContext;
        HiveMetaStoreAuthzInfo hiveMetaStoreAuthzInfo;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HiveMetaStoreAuthorizer.filterTables()");
        }
        List<Table> filteredTables = null;
        if (list != null && CollectionUtils.isEmpty(filteredTables = this.filterTableObjects(hiveMetaStoreAuthzInfo = (tableFilterContext = new TableFilterContext(list)).getAuthzContext(), list))) {
            filteredTables = Collections.emptyList();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== HiveMetaStoreAuthorizer.filterTables(): " + filteredTables));
        }
        return filteredTables;
    }

    @Override
    public final Catalog filterCatalog(Catalog catalog) throws MetaException {
        return catalog;
    }

    @Override
    public final List<String> filterCatalogs(List<String> catalogs) throws MetaException {
        return catalogs;
    }

    @Override
    @Deprecated
    public List<TableMeta> filterTableMetas(String catName, String dbName, List<TableMeta> tableMetas) throws MetaException {
        return this.filterTableMetas(tableMetas);
    }

    @Override
    public final List<TableMeta> filterTableMetas(List<TableMeta> tableMetas) throws MetaException {
        return tableMetas;
    }

    @Override
    public final List<Partition> filterPartitions(List<Partition> list) throws MetaException {
        return list;
    }

    @Override
    public final List<PartitionSpec> filterPartitionSpecs(List<PartitionSpec> list) throws MetaException {
        return list;
    }

    @Override
    public final Partition filterPartition(Partition partition) throws MetaException, NoSuchObjectException {
        return partition;
    }

    @Override
    public final List<String> filterPartitionNames(String s, String s1, String s2, List<String> list) throws MetaException {
        return list;
    }

    private List<String> filterDatabaseObjects(HiveMetaStoreAuthzInfo hiveMetaStoreAuthzInfo) throws MetaException {
        List<String> ret = null;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HiveMetaStoreAuthorizer.filterDatabaseObjects()");
        }
        try {
            HiveAuthorizer hiveAuthorizer = this.createHiveMetaStoreAuthorizer();
            List<HivePrivilegeObject> hivePrivilegeObjects = hiveMetaStoreAuthzInfo.getInputHObjs();
            HiveAuthzContext hiveAuthzContext = hiveMetaStoreAuthzInfo.getHiveAuthzContext();
            List<HivePrivilegeObject> filteredHivePrivilegeObjects = hiveAuthorizer.filterListCmdObjects(hivePrivilegeObjects, hiveAuthzContext);
            if (CollectionUtils.isNotEmpty(filteredHivePrivilegeObjects)) {
                ret = this.getFilterDatabaseList(filteredHivePrivilegeObjects);
            }
        }
        catch (Exception e) {
            throw new MetaException("Error in HiveMetaStoreAuthorizer.filterDatabase()" + e.getMessage());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== HiveMetaStoreAuthorizer.filterDatabaseObjects() :" + ret));
        }
        return ret;
    }

    private List<Table> filterTableObjects(HiveMetaStoreAuthzInfo hiveMetaStoreAuthzInfo, List<Table> tableList) throws MetaException {
        List<Table> ret = null;
        try {
            HiveAuthorizer hiveAuthorizer = this.createHiveMetaStoreAuthorizer();
            List<HivePrivilegeObject> hivePrivilegeObjects = hiveMetaStoreAuthzInfo.getInputHObjs();
            HiveAuthzContext hiveAuthzContext = hiveMetaStoreAuthzInfo.getHiveAuthzContext();
            List<HivePrivilegeObject> filteredHivePrivilegeObjects = hiveAuthorizer.filterListCmdObjects(hivePrivilegeObjects, hiveAuthzContext);
            if (CollectionUtils.isNotEmpty(filteredHivePrivilegeObjects)) {
                ret = this.getFilteredTableList(filteredHivePrivilegeObjects, tableList);
            }
        }
        catch (Exception e) {
            throw new MetaException("Error in HiveMetaStoreAuthorizer.filterTables()" + e.getMessage());
        }
        return ret;
    }

    private List<String> getFilterDatabaseList(List<HivePrivilegeObject> hivePrivilegeObjects) {
        ArrayList<String> ret = new ArrayList<String>();
        for (HivePrivilegeObject hivePrivilegeObject : hivePrivilegeObjects) {
            String dbName = hivePrivilegeObject.getDbname();
            ret.add(dbName);
        }
        return ret;
    }

    private List<Table> getFilteredTableList(List<HivePrivilegeObject> hivePrivilegeObjects, List<Table> tableList) {
        ArrayList<Table> ret = new ArrayList<Table>();
        for (HivePrivilegeObject hivePrivilegeObject : hivePrivilegeObjects) {
            String tblName;
            String dbName = hivePrivilegeObject.getDbname();
            Table table = this.getFilteredTable(dbName, tblName = hivePrivilegeObject.getObjectName(), tableList);
            if (table == null) continue;
            ret.add(table);
        }
        return ret;
    }

    private Table getFilteredTable(String dbName, String tblName, List<Table> tableList) {
        Table ret = null;
        for (Table table : tableList) {
            String databaseName = table.getDbName();
            String tableName = table.getTableName();
            if (!dbName.equals(databaseName) || !tblName.equals(tableName)) continue;
            ret = table;
            break;
        }
        return ret;
    }

    private List<String> filterTableNames(HiveMetaStoreAuthzInfo hiveMetaStoreAuthzInfo, String dbName, List<String> tableNames) throws MetaException {
        List<String> ret = null;
        try {
            HiveAuthorizer hiveAuthorizer = this.createHiveMetaStoreAuthorizer();
            List<HivePrivilegeObject> hivePrivilegeObjects = hiveMetaStoreAuthzInfo.getInputHObjs();
            HiveAuthzContext hiveAuthzContext = hiveMetaStoreAuthzInfo.getHiveAuthzContext();
            List<HivePrivilegeObject> filteredHivePrivilegeObjects = hiveAuthorizer.filterListCmdObjects(hivePrivilegeObjects, hiveAuthzContext);
            if (CollectionUtils.isNotEmpty(filteredHivePrivilegeObjects)) {
                ret = this.getFilteredTableNames(filteredHivePrivilegeObjects, dbName, tableNames);
            }
        }
        catch (Exception e) {
            throw new MetaException("Error in HiveMetaStoreAuthorizer.filterTables()" + e.getMessage());
        }
        return ret;
    }

    private List<String> getFilteredTableNames(List<HivePrivilegeObject> hivePrivilegeObjects, String databaseName, List<String> tableNames) {
        ArrayList<String> ret = new ArrayList<String>();
        for (HivePrivilegeObject hivePrivilegeObject : hivePrivilegeObjects) {
            String tblName;
            String dbName = hivePrivilegeObject.getDbname();
            String table = this.getFilteredTableNames(dbName, tblName = hivePrivilegeObject.getObjectName(), databaseName, tableNames);
            if (table == null) continue;
            ret.add(table);
        }
        return ret;
    }

    private String getFilteredTableNames(String dbName, String tblName, String databaseName, List<String> tableNames) {
        String ret = null;
        for (String tableName : tableNames) {
            if (!dbName.equals(databaseName) || !tblName.equals(tableName)) continue;
            ret = tableName;
            break;
        }
        return ret;
    }

    private String getDBName(String str) {
        return str != null ? str.substring(str.indexOf("#") + 1) : null;
    }

    HiveMetaStoreAuthzInfo buildAuthzContext(PreEventContext preEventContext) throws MetaException {
        HiveMetaStoreAuthzInfo ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> HiveMetaStoreAuthorizer.buildAuthzContext(): EventType=" + (Object)((Object)preEventContext.getEventType())));
        }
        HiveMetaStoreAuthorizableEvent authzEvent = null;
        if (preEventContext != null) {
            switch (preEventContext.getEventType()) {
                case CREATE_DATABASE: {
                    authzEvent = new CreateDatabaseEvent(preEventContext);
                    break;
                }
                case ALTER_DATABASE: {
                    authzEvent = new AlterDatabaseEvent(preEventContext);
                    break;
                }
                case DROP_DATABASE: {
                    authzEvent = new DropDatabaseEvent(preEventContext);
                    break;
                }
                case CREATE_TABLE: {
                    authzEvent = new CreateTableEvent(preEventContext);
                    if (!this.isViewOperation(preEventContext) || this.isSuperUser(this.getCurrentUser(authzEvent))) break;
                    PreEventContext pcte = (PreCreateTableEvent)preEventContext;
                    Map<String, String> params = ((PreCreateTableEvent)pcte).getTable().getParameters();
                    params.put("Authorized", "false");
                    break;
                }
                case ALTER_TABLE: {
                    authzEvent = new AlterTableEvent(preEventContext);
                    if (!this.isViewOperation(preEventContext) || this.isSuperUser(this.getCurrentUser(authzEvent))) break;
                    PreEventContext pcte = (PreAlterTableEvent)preEventContext;
                    Map<String, String> params = ((PreAlterTableEvent)pcte).getNewTable().getParameters();
                    params.put("Authorized", "false");
                    break;
                }
                case DROP_TABLE: {
                    authzEvent = new DropTableEvent(preEventContext);
                    if (!this.isViewOperation(preEventContext) || this.isSuperUser(this.getCurrentUser(authzEvent))) break;
                    break;
                }
                case ADD_PARTITION: {
                    authzEvent = new AddPartitionEvent(preEventContext);
                    break;
                }
                case ALTER_PARTITION: {
                    authzEvent = new AlterPartitionEvent(preEventContext);
                    break;
                }
                case LOAD_PARTITION_DONE: {
                    authzEvent = new LoadPartitionDoneEvent(preEventContext);
                    break;
                }
                case DROP_PARTITION: {
                    authzEvent = new DropPartitionEvent(preEventContext);
                    break;
                }
                case READ_TABLE: {
                    authzEvent = new ReadTableEvent(preEventContext);
                    break;
                }
                case READ_DATABASE: {
                    authzEvent = new ReadDatabaseEvent(preEventContext);
                    break;
                }
                case CREATE_FUNCTION: {
                    authzEvent = new CreateFunctionEvent(preEventContext);
                    break;
                }
                case DROP_FUNCTION: {
                    authzEvent = new DropFunctionEvent(preEventContext);
                    break;
                }
                case AUTHORIZATION_API_CALL: 
                case READ_ISCHEMA: 
                case CREATE_ISCHEMA: 
                case DROP_ISCHEMA: 
                case ALTER_ISCHEMA: 
                case ADD_SCHEMA_VERSION: 
                case ALTER_SCHEMA_VERSION: 
                case DROP_SCHEMA_VERSION: 
                case READ_SCHEMA_VERSION: 
                case CREATE_CATALOG: 
                case ALTER_CATALOG: 
                case DROP_CATALOG: {
                    if (this.isSuperUser(this.getCurrentUser())) break;
                    throw new MetaException(this.getErrorMessage(preEventContext, this.getCurrentUser()));
                }
            }
        }
        HiveMetaStoreAuthzInfo hiveMetaStoreAuthzInfo = ret = authzEvent != null ? authzEvent.getAuthzContext() : null;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== HiveMetaStoreAuthorizer.buildAuthzContext(): EventType=" + (Object)((Object)preEventContext.getEventType()) + "; ret=" + ret));
        }
        return ret;
    }

    HiveAuthorizer createHiveMetaStoreAuthorizer() throws Exception {
        HiveAuthorizerFactory authorizerFactory;
        HiveAuthorizer ret = null;
        HiveConf hiveConf = (HiveConf)tConfig.get();
        if (hiveConf == null) {
            HiveConf hiveConf1 = new HiveConf(super.getConf(), HiveConf.class);
            tConfig.set(hiveConf1);
            hiveConf = hiveConf1;
        }
        if ((authorizerFactory = HiveUtils.getAuthorizerFactory(hiveConf, HiveConf.ConfVars.HIVE_AUTHORIZATION_MANAGER)) != null) {
            HiveMetastoreAuthenticationProvider authenticator = tAuthenticator.get();
            authenticator.setConf(hiveConf);
            HiveAuthzSessionContext.Builder authzContextBuilder = new HiveAuthzSessionContext.Builder();
            authzContextBuilder.setClientType(HiveAuthzSessionContext.CLIENT_TYPE.HIVEMETASTORE);
            authzContextBuilder.setSessionString("HiveMetaStore");
            HiveAuthzSessionContext authzSessionContext = authzContextBuilder.build();
            ret = authorizerFactory.createHiveAuthorizer(new HiveMetastoreClientFactoryImpl(), hiveConf, authenticator, authzSessionContext);
        }
        return ret;
    }

    boolean isSuperUser(String userName) {
        Configuration conf = this.getConf();
        String ipAddress = HiveMetaStore.HMSHandler.getIPAddress();
        return MetaStoreUtils.checkUserHasHostProxyPrivileges(userName, conf, ipAddress);
    }

    boolean isViewOperation(PreEventContext preEventContext) {
        boolean ret = false;
        PreEventContext.PreEventType preEventType = preEventContext.getEventType();
        switch (preEventType) {
            case CREATE_TABLE: {
                PreCreateTableEvent preCreateTableEvent = (PreCreateTableEvent)preEventContext;
                Table table = preCreateTableEvent.getTable();
                ret = this.isViewType(table);
                break;
            }
            case ALTER_TABLE: {
                PreAlterTableEvent preAlterTableEvent = (PreAlterTableEvent)preEventContext;
                Table inTable = preAlterTableEvent.getOldTable();
                Table outTable = preAlterTableEvent.getNewTable();
                ret = this.isViewType(inTable) || this.isViewType(outTable);
                break;
            }
            case DROP_TABLE: {
                PreDropTableEvent preDropTableEvent = (PreDropTableEvent)preEventContext;
                Table droppedTable = preDropTableEvent.getTable();
                ret = this.isViewType(droppedTable);
            }
        }
        return ret;
    }

    private void checkPrivileges(HiveMetaStoreAuthzInfo authzContext, HiveAuthorizer authorizer) throws MetaException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> HiveMetaStoreAuthorizer.checkPrivileges(): authzContext=" + authzContext + ", authorizer=" + authorizer));
        }
        HiveOperationType hiveOpType = authzContext.getOperationType();
        List<HivePrivilegeObject> inputHObjs = authzContext.getInputHObjs();
        List<HivePrivilegeObject> outputHObjs = authzContext.getOutputHObjs();
        HiveAuthzContext hiveAuthzContext = authzContext.getHiveAuthzContext();
        try {
            authorizer.checkPrivileges(hiveOpType, inputHObjs, outputHObjs, hiveAuthzContext);
        }
        catch (Exception e) {
            throw new MetaException(e.getMessage());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== HiveMetaStoreAuthorizer.checkPrivileges(): authzContext=" + authzContext + ", authorizer=" + authorizer));
        }
    }

    private boolean skipAuthorization() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> HiveMetaStoreAuthorizer.skipAuthorization()");
        }
        boolean ret = false;
        UserGroupInformation ugi = this.getUGI();
        ret = ugi == null ? true : this.isSuperUser(ugi.getShortUserName());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== HiveMetaStoreAuthorizer.skipAuthorization(): " + ret));
        }
        return ret;
    }

    private boolean isViewType(Table table) {
        boolean ret = false;
        String tableType = table.getTableType();
        if (TableType.MATERIALIZED_VIEW.name().equals(tableType) || TableType.VIRTUAL_VIEW.name().equals(tableType)) {
            ret = true;
        }
        return ret;
    }

    private String getErrorMessage(PreEventContext preEventContext, String user) {
        String err = "Operation type " + preEventContext.getEventType().name() + " not allowed for user:" + user;
        return err;
    }

    private String getErrorMessage(String eventType, String user) {
        String err = "Operation type " + eventType + " not allowed for user:" + user;
        return err;
    }

    private String getCurrentUser() {
        try {
            return UserGroupInformation.getCurrentUser().getShortUserName();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private String getCurrentUser(HiveMetaStoreAuthorizableEvent authorizableEvent) {
        return authorizableEvent.getAuthzContext().getUGI().getShortUserName();
    }

    private UserGroupInformation getUGI() {
        try {
            return UserGroupInformation.getCurrentUser();
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

