/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.session;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.hive.common.io.SessionStream;
import org.apache.hadoop.hive.common.log.ProgressMonitor;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.common.type.TimestampTZ;
import org.apache.hadoop.hive.common.type.TimestampTZUtil;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.conf.HiveConfUtil;
import org.apache.hadoop.hive.metastore.ObjectStore;
import org.apache.hadoop.hive.metastore.PersistenceManagerProvider;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.cache.CachedStore;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.ql.MapRedStats;
import org.apache.hadoop.hive.ql.exec.AddToClassPathAction;
import org.apache.hadoop.hive.ql.exec.FunctionInfo;
import org.apache.hadoop.hive.ql.exec.Registry;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.spark.session.SparkSession;
import org.apache.hadoop.hive.ql.exec.spark.session.SparkSessionManagerImpl;
import org.apache.hadoop.hive.ql.exec.tez.ExternalSessionsRegistry;
import org.apache.hadoop.hive.ql.exec.tez.TezExternalSessionState;
import org.apache.hadoop.hive.ql.exec.tez.TezSession;
import org.apache.hadoop.hive.ql.exec.tez.TezSessionPoolManager;
import org.apache.hadoop.hive.ql.exec.tez.TezSessionState;
import org.apache.hadoop.hive.ql.history.HiveHistory;
import org.apache.hadoop.hive.ql.history.HiveHistoryImpl;
import org.apache.hadoop.hive.ql.history.HiveHistoryProxyHandler;
import org.apache.hadoop.hive.ql.lockmgr.HiveTxnManager;
import org.apache.hadoop.hive.ql.lockmgr.LockException;
import org.apache.hadoop.hive.ql.lockmgr.TxnManagerFactory;
import org.apache.hadoop.hive.ql.log.PerfLogger;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveUtils;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.metadata.TempTable;
import org.apache.hadoop.hive.ql.security.HiveAuthenticationProvider;
import org.apache.hadoop.hive.ql.security.authorization.HiveAuthorizationProvider;
import org.apache.hadoop.hive.ql.security.authorization.plugin.AuthorizationMetaStoreFilterHook;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthorizer;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthorizerFactory;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzSessionContext;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveMetastoreClientFactoryImpl;
import org.apache.hadoop.hive.ql.session.CreateTableAutomaticGrant;
import org.apache.hadoop.hive.ql.session.KillQuery;
import org.apache.hadoop.hive.ql.session.NullKillQuery;
import org.apache.hadoop.hive.ql.session.ResourceMaps;
import org.apache.hadoop.hive.ql.util.ResourceDownloader;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.hive.shims.Utils;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionState {
    private static final Logger LOG = LoggerFactory.getLogger(SessionState.class);
    public static final String TMP_PREFIX = "_tmp_space.db";
    private static final String LOCAL_SESSION_PATH_KEY = "_hive.local.session.path";
    private static final String HDFS_SESSION_PATH_KEY = "_hive.hdfs.session.path";
    private static final String TMP_TABLE_SPACE_KEY = "_hive.tmp_table_space";
    static final String LOCK_FILE_NAME = "inuse.lck";
    static final String INFO_FILE_NAME = "inuse.info";
    private final Map<String, Map<String, Table>> tempTables = new ConcurrentHashMap<String, Map<String, Table>>();
    private final Map<String, Map<String, ColumnStatisticsObj>> tempTableColStats = new ConcurrentHashMap<String, Map<String, ColumnStatisticsObj>>();
    private final Map<String, TempTable> tempPartitions = new ConcurrentHashMap<String, TempTable>();
    protected ClassLoader parentLoader;
    private final ReentrantLock compileLock = new ReentrantLock(true);
    private HiveConf sessionConf;
    protected boolean isSilent;
    protected boolean isQtestLogging;
    protected boolean isVerbose;
    private boolean isHiveServerQuery = false;
    private boolean isUsingThriftJDBCBinarySerDe = false;
    private AtomicBoolean isStarted = new AtomicBoolean(false);
    protected HiveHistory hiveHist;
    public InputStream in;
    public SessionStream out;
    public SessionStream info;
    public SessionStream err;
    public PrintStream childOut;
    public PrintStream childErr;
    protected File tmpOutputFile;
    protected File tmpErrOutputFile;
    private String lastCommand;
    private HiveAuthorizationProvider authorizer;
    private HiveAuthorizer authorizerV2;
    private volatile ProgressMonitor progressMonitor;
    private String hiveServer2HostName;
    private KillQuery killQuery;
    private HiveAuthenticationProvider authenticator;
    private CreateTableAutomaticGrant createTableGrants;
    private Map<String, MapRedStats> mapRedStats;
    private Map<String, String> hiveVariables;
    private Map<String, List<List<String>>> stackTraces;
    private Map<String, String> overriddenConfigurations;
    private Map<String, List<String>> localMapRedErrors;
    private TezSession tezSessionState;
    private String currentDatabase;
    private String currentCatalog;
    private final String CONFIG_AUTHZ_SETTINGS_APPLIED_MARKER = "hive.internal.ss.authz.settings.applied.marker";
    private String userIpAddress;
    private SparkSession sparkSession;
    private Map<URI, HadoopShims.HdfsEncryptionShim> hdfsEncryptionShims = Maps.newHashMap();
    private Map<URI, HadoopShims.HdfsErasureCodingShim> erasureCodingShims;
    private final String userName;
    private final Map<Class, Object> dynamicVars = new HashMap<Class, Object>();
    private Path hdfsSessionPath;
    private FSDataOutputStream hdfsSessionPathLockFile = null;
    private Path hdfsTmpTableSpace;
    private Path localSessionPath;
    private String hdfsScratchDirURIString;
    private int nextValueTempTableSuffix = 1;
    private HiveTxnManager txnMgr = null;
    private final Set<String> preReloadableAuxJars = new HashSet<String>();
    private final Registry registry;
    private final Map<String, FunctionInfo> currentFunctionsInUse = new HashMap<String, FunctionInfo>();
    private static ExternalSessionsRegistry externalSessions = null;
    private Instant queryCurrentTimestamp;
    private final ResourceMaps resourceMaps;
    private final ResourceDownloader resourceDownloader;
    private List<String> forwardedAddresses;
    private String atsDomainId;
    private List<Closeable> cleanupItems = new LinkedList<Closeable>();
    private volatile long waitingTezSession;
    private Hive hiveDb;
    private static ThreadLocal<SessionStates> tss = new ThreadLocal<SessionStates>(){

        @Override
        protected SessionStates initialValue() {
            return new SessionStates();
        }
    };
    private static LogHelper _console;

    public HiveConf getConf() {
        return this.sessionConf;
    }

    public void setConf(HiveConf conf) {
        if (this.hiveDb != null) {
            this.hiveDb.setConf(conf);
        }
        this.sessionConf = conf;
    }

    public File getTmpOutputFile() {
        return this.tmpOutputFile;
    }

    public void setTmpOutputFile(File f) {
        this.tmpOutputFile = f;
    }

    public File getTmpErrOutputFile() {
        return this.tmpErrOutputFile;
    }

    public void setTmpErrOutputFile(File tmpErrOutputFile) {
        this.tmpErrOutputFile = tmpErrOutputFile;
    }

    public void deleteTmpOutputFile() {
        FileUtils.deleteTmpFile(this.tmpOutputFile);
    }

    public void deleteTmpErrOutputFile() {
        FileUtils.deleteTmpFile(this.tmpErrOutputFile);
    }

    public boolean getIsSilent() {
        if (this.sessionConf != null) {
            return this.sessionConf.getBoolVar(HiveConf.ConfVars.HIVESESSIONSILENT);
        }
        return this.isSilent;
    }

    public boolean getIsQtestLogging() {
        return this.isQtestLogging;
    }

    public boolean isHiveServerQuery() {
        return this.isHiveServerQuery;
    }

    public void setIsSilent(boolean isSilent) {
        if (this.sessionConf != null) {
            this.sessionConf.setBoolVar(HiveConf.ConfVars.HIVESESSIONSILENT, isSilent);
        }
        this.isSilent = isSilent;
    }

    public void setIsQtestLogging(boolean isQtestLogging) {
        this.isQtestLogging = isQtestLogging;
    }

    public ReentrantLock getCompileLock() {
        return this.compileLock;
    }

    public boolean getIsVerbose() {
        return this.isVerbose;
    }

    public void setIsVerbose(boolean isVerbose) {
        this.isVerbose = isVerbose;
    }

    public void setIsUsingThriftJDBCBinarySerDe(boolean isUsingThriftJDBCBinarySerDe) {
        this.isUsingThriftJDBCBinarySerDe = isUsingThriftJDBCBinarySerDe;
    }

    public boolean getIsUsingThriftJDBCBinarySerDe() {
        return this.isUsingThriftJDBCBinarySerDe;
    }

    public void setIsHiveServerQuery(boolean isHiveServerQuery) {
        this.isHiveServerQuery = isHiveServerQuery;
    }

    public SessionState(HiveConf conf) {
        this(conf, null);
    }

    public SessionState(HiveConf conf, String userName) {
        this.sessionConf = conf;
        this.userName = userName;
        this.registry = new Registry(false);
        if (LOG.isDebugEnabled()) {
            LOG.debug("SessionState user: " + userName);
        }
        this.isSilent = conf.getBoolVar(HiveConf.ConfVars.HIVESESSIONSILENT);
        this.resourceMaps = new ResourceMaps();
        this.overriddenConfigurations = new LinkedHashMap<String, String>();
        if (StringUtils.isEmpty(conf.getVar(HiveConf.ConfVars.HIVESESSIONID))) {
            conf.setVar(HiveConf.ConfVars.HIVESESSIONID, SessionState.makeSessionId());
            SessionState.getConsole().printInfo("Hive Session ID = " + this.getSessionId());
        }
        this.parentLoader = SessionState.class.getClassLoader();
        AddToClassPathAction addAction = new AddToClassPathAction(this.parentLoader, Collections.emptyList(), true);
        ClassLoader currentLoader = AccessController.doPrivileged(addAction);
        this.sessionConf.setClassLoader(currentLoader);
        this.resourceDownloader = new ResourceDownloader(conf, HiveConf.getVar(conf, HiveConf.ConfVars.DOWNLOADED_RESOURCES_DIR));
        this.killQuery = new NullKillQuery();
        ShimLoader.getHadoopShims().setHadoopSessionContext(String.format("%s_User:%s", this.getSessionId(), userName));
    }

    public Map<String, String> getHiveVariables() {
        if (this.hiveVariables == null) {
            this.hiveVariables = new HashMap<String, String>();
        }
        return this.hiveVariables;
    }

    public void setHiveVariables(Map<String, String> hiveVariables) {
        this.hiveVariables = hiveVariables;
    }

    public String getSessionId() {
        return this.sessionConf.getVar(HiveConf.ConfVars.HIVESESSIONID);
    }

    public void updateThreadName() {
        String sessionId = this.getSessionId();
        String logPrefix = this.getConf().getLogIdVar(sessionId);
        String currThreadName = Thread.currentThread().getName();
        if (!currThreadName.contains(logPrefix)) {
            String newThreadName = logPrefix + " " + currThreadName;
            LOG.debug("Updating thread name to {}", (Object)newThreadName);
            Thread.currentThread().setName(newThreadName);
        }
    }

    public void resetThreadName() {
        String sessionId = this.getSessionId();
        String logPrefix = this.getConf().getLogIdVar(sessionId);
        String currThreadName = Thread.currentThread().getName();
        if (currThreadName.contains(logPrefix)) {
            String[] names = currThreadName.split(logPrefix);
            LOG.debug("Resetting thread name to {}", (Object)names[names.length - 1]);
            Thread.currentThread().setName(names[names.length - 1].trim());
        }
    }

    public synchronized HiveTxnManager initTxnMgr(HiveConf conf) throws LockException {
        if (this.txnMgr != null && !this.txnMgr.getTxnManagerName().equals(conf.getVar(HiveConf.ConfVars.HIVE_TXN_MANAGER))) {
            this.txnMgr.closeTxnManager();
            this.txnMgr = null;
        }
        if (this.txnMgr == null) {
            this.txnMgr = TxnManagerFactory.getTxnManagerFactory().getTxnManager(conf);
        }
        return this.txnMgr;
    }

    public HiveTxnManager getTxnMgr() {
        return this.txnMgr;
    }

    @VisibleForTesting
    public HiveTxnManager setTxnMgr(HiveTxnManager mgr) {
        if (!this.sessionConf.getBoolVar(HiveConf.ConfVars.HIVE_IN_TEST) && !this.sessionConf.getBoolVar(HiveConf.ConfVars.HIVE_IN_TEZ_TEST)) {
            throw new IllegalStateException("Only for testing!");
        }
        HiveTxnManager tmp = this.txnMgr;
        this.txnMgr = mgr;
        return tmp;
    }

    public HadoopShims.HdfsEncryptionShim getHdfsEncryptionShim() throws HiveException {
        try {
            return this.getHdfsEncryptionShim(FileSystem.get((Configuration)this.sessionConf));
        }
        catch (HiveException hiveException) {
            throw hiveException;
        }
        catch (Exception exception) {
            throw new HiveException(exception);
        }
    }

    public HadoopShims.HdfsEncryptionShim getHdfsEncryptionShim(FileSystem fs) throws HiveException {
        if (!this.hdfsEncryptionShims.containsKey(fs.getUri())) {
            try {
                if ("hdfs".equals(fs.getUri().getScheme())) {
                    this.hdfsEncryptionShims.put(fs.getUri(), ShimLoader.getHadoopShims().createHdfsEncryptionShim(fs, this.sessionConf));
                } else {
                    LOG.info("Could not get hdfsEncryptionShim, it is only applicable to hdfs filesystem.");
                }
            }
            catch (Exception e) {
                throw new HiveException(e);
            }
        }
        return this.hdfsEncryptionShims.get(fs.getUri());
    }

    public static SessionState start(HiveConf conf) {
        SessionState ss = new SessionState(conf);
        return SessionState.start(ss);
    }

    public static void setCurrentSessionState(SessionState startSs) {
        SessionState.tss.get().attach(startSs);
    }

    public static void detachSession() {
        tss.remove();
    }

    public static SessionState start(SessionState startSs) {
        SessionState.start(startSs, false, null);
        return startSs;
    }

    public static void beginStart(SessionState startSs, LogHelper console) {
        SessionState.start(startSs, true, console);
    }

    public static void endStart(SessionState startSs) throws CancellationException, InterruptedException {
        if (startSs.tezSessionState == null) {
            return;
        }
        startSs.tezSessionState.endOpen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void start(SessionState startSs, boolean isAsync, LogHelper console) {
        SessionState.setCurrentSessionState(startSs);
        Class<SessionState> clazz = SessionState.class;
        synchronized (SessionState.class) {
            block29: {
                if (!startSs.isStarted.compareAndSet(false, true)) {
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return;
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                if (startSs.hiveHist == null) {
                    startSs.hiveHist = startSs.getConf().getBoolVar(HiveConf.ConfVars.HIVE_SESSION_HISTORY_ENABLED) ? new HiveHistoryImpl(startSs) : HiveHistoryProxyHandler.getNoOpHiveHistoryProxy();
                }
                try {
                    UserGroupInformation sessionUGI = Utils.getUGI();
                    FileSystem.get((Configuration)startSs.sessionConf);
                    startSs.createSessionDirs(sessionUGI.getShortUserName());
                    if (startSs.getTmpOutputFile() == null) {
                        try {
                            startSs.setTmpOutputFile(SessionState.createTempFile(startSs.getConf()));
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    if (startSs.getTmpErrOutputFile() != null) break block29;
                    try {
                        startSs.setTmpErrOutputFile(SessionState.createTempFile(startSs.getConf()));
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            String engine = HiveConf.getVar(startSs.getConf(), HiveConf.ConfVars.HIVE_EXECUTION_ENGINE);
            if (!engine.equals("tez") || startSs.isHiveServerQuery) {
                return;
            }
            if (HiveConf.getBoolVar(startSs.getConf(), HiveConf.ConfVars.HIVE_SERVER2_TEZ_USE_EXTERNAL_SESSIONS)) {
                try {
                    externalSessions = ExternalSessionsRegistry.getClient(startSs.getConf());
                }
                catch (MetaException e) {
                    throw new RuntimeException(e);
                }
            } else {
                externalSessions = null;
            }
            try {
                if (startSs.tezSessionState == null) {
                    if (externalSessions != null) {
                        startSs.setTezSession(new TezExternalSessionState(startSs.getSessionId(), startSs.sessionConf, externalSessions));
                    } else {
                        startSs.setTezSession(new TezSessionState(startSs.getSessionId(), startSs.sessionConf));
                    }
                } else {
                    LOG.warn("Tez session was already present in SessionState before start: " + startSs.tezSessionState);
                }
                if (startSs.tezSessionState.isOpen()) {
                    return;
                }
                if (startSs.tezSessionState.isOpening()) {
                    if (!isAsync) {
                        startSs.tezSessionState.endOpen();
                    }
                    return;
                }
                if (!isAsync) {
                    startSs.tezSessionState.open();
                } else {
                    startSs.tezSessionState.beginOpen(null, console);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return;
        }
    }

    private void createSessionDirs(String userName) throws IOException {
        HiveConf conf = this.getConf();
        Path rootHDFSDirPath = this.createRootHDFSDir(conf);
        String scratchDirPermission = HiveConf.getVar(conf, HiveConf.ConfVars.SCRATCHDIRPERMISSION);
        Path path = new Path(rootHDFSDirPath, userName);
        this.hdfsScratchDirURIString = path.toUri().toString();
        SessionState.createPath(conf, path, scratchDirPermission, false, false);
        path = new Path(HiveConf.getVar(conf, HiveConf.ConfVars.LOCALSCRATCHDIR));
        SessionState.createPath(conf, path, scratchDirPermission, true, false);
        path = new Path(HiveConf.getVar(conf, HiveConf.ConfVars.DOWNLOADED_RESOURCES_DIR));
        SessionState.createPath(conf, path, scratchDirPermission, true, false);
        String sessionId = this.getSessionId();
        this.hdfsSessionPath = new Path(this.hdfsScratchDirURIString, sessionId);
        SessionState.createPath(conf, this.hdfsSessionPath, scratchDirPermission, false, true);
        conf.set(HDFS_SESSION_PATH_KEY, this.hdfsSessionPath.toUri().toString());
        if (conf.getBoolVar(HiveConf.ConfVars.HIVE_SCRATCH_DIR_LOCK)) {
            FileSystem fs = this.hdfsSessionPath.getFileSystem((Configuration)conf);
            FSDataOutputStream hdfsSessionPathInfoFile = fs.create(new Path(this.hdfsSessionPath, INFO_FILE_NAME), true);
            hdfsSessionPathInfoFile.writeUTF("process: " + ManagementFactory.getRuntimeMXBean().getName() + "\n");
            hdfsSessionPathInfoFile.close();
            this.hdfsSessionPathLockFile = fs.create(new Path(this.hdfsSessionPath, LOCK_FILE_NAME), true);
        }
        this.localSessionPath = new Path(HiveConf.getVar(conf, HiveConf.ConfVars.LOCALSCRATCHDIR), sessionId);
        SessionState.createPath(conf, this.localSessionPath, scratchDirPermission, true, true);
        conf.set(LOCAL_SESSION_PATH_KEY, this.localSessionPath.toUri().toString());
        this.hdfsTmpTableSpace = new Path(this.hdfsSessionPath, TMP_PREFIX);
        SessionState.createPath(conf, this.hdfsTmpTableSpace, scratchDirPermission, false, false);
        conf.set(TMP_TABLE_SPACE_KEY, this.hdfsTmpTableSpace.toUri().toString());
        conf.addToRestrictList("_hive.local.session.path,_hive.hdfs.session.path,_hive.tmp_table_space");
    }

    private Path createRootHDFSDir(HiveConf conf) throws IOException {
        Path rootHDFSDirPath = new Path(HiveConf.getVar(conf, HiveConf.ConfVars.SCRATCHDIR));
        Utilities.ensurePathIsWritable(rootHDFSDirPath, conf);
        return rootHDFSDirPath;
    }

    @VisibleForTesting
    static void createPath(HiveConf conf, Path path, String permission, boolean isLocal, boolean isCleanUp) throws IOException {
        FsPermission fsPermission = new FsPermission(permission);
        Object fs = isLocal ? FileSystem.getLocal((Configuration)conf) : path.getFileSystem((Configuration)conf);
        if (!fs.exists(path)) {
            if (!fs.mkdirs(path, fsPermission)) {
                throw new IOException("Failed to create directory " + path + " on fs " + fs.getUri());
            }
            String dirType = isLocal ? "local" : "HDFS";
            LOG.info("Created " + dirType + " directory: " + path.toString());
        }
        if (isCleanUp) {
            fs.deleteOnExit(path);
        }
    }

    public String getHdfsScratchDirURIString() {
        return this.hdfsScratchDirURIString;
    }

    public static Path getLocalSessionPath(Configuration conf) {
        SessionState ss = SessionState.get();
        if (ss == null) {
            String localPathString = conf.get(LOCAL_SESSION_PATH_KEY);
            Preconditions.checkNotNull(localPathString, "Conf local session path expected to be non-null");
            return new Path(localPathString);
        }
        Preconditions.checkNotNull(ss.localSessionPath, "Local session path expected to be non-null");
        return ss.localSessionPath;
    }

    public static Path getHDFSSessionPath(Configuration conf) {
        SessionState ss = SessionState.get();
        if (ss == null) {
            String sessionPathString = conf.get(HDFS_SESSION_PATH_KEY);
            Preconditions.checkNotNull(sessionPathString, "Conf non-local session path expected to be non-null");
            return new Path(sessionPathString);
        }
        Preconditions.checkNotNull(ss.hdfsSessionPath, "Non-local session path expected to be non-null");
        return ss.hdfsSessionPath;
    }

    public static Path getTempTableSpace(Configuration conf) {
        SessionState ss = SessionState.get();
        if (ss == null) {
            String tempTablePathString = conf.get(TMP_TABLE_SPACE_KEY);
            Preconditions.checkNotNull(tempTablePathString, "Conf temp table path expected to be non-null");
            return new Path(tempTablePathString);
        }
        return ss.getTempTableSpace();
    }

    public Path getTempTableSpace() {
        Preconditions.checkNotNull(this.hdfsTmpTableSpace, "Temp table path expected to be non-null");
        return this.hdfsTmpTableSpace;
    }

    public static String generateTempTableLocation(Configuration conf) throws MetaException {
        Path path = new Path(SessionState.getTempTableSpace(conf), UUID.randomUUID().toString());
        path = Warehouse.getDnsPath(path, conf);
        return path.toString();
    }

    @VisibleForTesting
    void releaseSessionLockFile() throws IOException {
        if (this.hdfsSessionPath != null && this.hdfsSessionPathLockFile != null) {
            this.hdfsSessionPathLockFile.close();
        }
    }

    private void dropSessionPaths(Configuration conf) throws IOException {
        if (this.hdfsSessionPath != null) {
            if (this.hdfsSessionPathLockFile != null) {
                try {
                    this.hdfsSessionPathLockFile.close();
                }
                catch (IOException e) {
                    LOG.error("Failed while closing remoteFsSessionLockFile", (Throwable)e);
                }
            }
            this.dropPathAndUnregisterDeleteOnExit(this.hdfsSessionPath, conf, false);
        }
        if (this.localSessionPath != null) {
            this.dropPathAndUnregisterDeleteOnExit(this.localSessionPath, conf, true);
        }
        this.deleteTmpOutputFile();
        this.deleteTmpErrOutputFile();
    }

    private void dropPathAndUnregisterDeleteOnExit(Path path, Configuration conf, boolean localFs) {
        Object fs = null;
        try {
            fs = localFs ? FileSystem.getLocal((Configuration)conf) : path.getFileSystem(conf);
            fs.cancelDeleteOnExit(path);
            fs.delete(path, true);
            LOG.info("Deleted directory: {} on fs with scheme {}", (Object)path, (Object)fs.getScheme());
        }
        catch (IOException | IllegalArgumentException | UnsupportedOperationException e) {
            LOG.error("Failed to delete path at {} on fs with scheme {}", new Object[]{path, fs == null ? "Unknown-null" : fs.getScheme(), e});
        }
    }

    private synchronized void setupAuth() {
        if (this.authenticator != null) {
            return;
        }
        try {
            this.authenticator = HiveUtils.getAuthenticator(this.sessionConf, HiveConf.ConfVars.HIVE_AUTHENTICATOR_MANAGER);
            this.authenticator.setSessionState(this);
            String clsStr = HiveConf.getVar(this.sessionConf, HiveConf.ConfVars.HIVE_AUTHORIZATION_MANAGER);
            this.authorizer = HiveUtils.getAuthorizeProviderManager(this.sessionConf, clsStr, this.authenticator, true);
            if (this.authorizer == null) {
                HiveAuthorizerFactory authorizerFactory = HiveUtils.getAuthorizerFactory(this.sessionConf, HiveConf.ConfVars.HIVE_AUTHORIZATION_MANAGER);
                HiveAuthzSessionContext.Builder authzContextBuilder = new HiveAuthzSessionContext.Builder();
                authzContextBuilder.setClientType(this.isHiveServerQuery() ? HiveAuthzSessionContext.CLIENT_TYPE.HIVESERVER2 : HiveAuthzSessionContext.CLIENT_TYPE.HIVECLI);
                authzContextBuilder.setSessionString(this.getSessionId());
                this.authorizerV2 = authorizerFactory.createHiveAuthorizer(new HiveMetastoreClientFactoryImpl(), this.sessionConf, this.authenticator, authzContextBuilder.build());
                this.setAuthorizerV2Config();
            }
            this.createTableGrants = CreateTableAutomaticGrant.create(this.sessionConf);
        }
        catch (HiveException e) {
            LOG.error("Error setting up authorization: " + e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        if (LOG.isDebugEnabled()) {
            Object authorizationClass = this.getActiveAuthorizer();
            LOG.debug("Session is using authorization class " + authorizationClass.getClass());
        }
    }

    private void setAuthorizerV2Config() throws HiveException {
        if (this.sessionConf.get("hive.internal.ss.authz.settings.applied.marker", "").equals(Boolean.TRUE.toString())) {
            return;
        }
        String metastoreHook = this.sessionConf.getVar(HiveConf.ConfVars.METASTORE_FILTER_HOOK);
        if (!HiveConf.ConfVars.METASTORE_FILTER_HOOK.getDefaultValue().equals(metastoreHook) && !AuthorizationMetaStoreFilterHook.class.getName().equals(metastoreHook)) {
            LOG.warn(HiveConf.ConfVars.METASTORE_FILTER_HOOK.varname + " will be ignored, since hive.security.authorization.manager is set to instance of HiveAuthorizerFactory.");
        }
        this.sessionConf.setVar(HiveConf.ConfVars.METASTORE_FILTER_HOOK, AuthorizationMetaStoreFilterHook.class.getName());
        this.authorizerV2.applyAuthorizationConfigPolicy(this.sessionConf);
        try {
            Hive.get(this.sessionConf).getMSC();
        }
        catch (Exception e) {
            throw new HiveException(e.getMessage(), e);
        }
        this.sessionConf.set("hive.internal.ss.authz.settings.applied.marker", Boolean.TRUE.toString());
    }

    public Object getActiveAuthorizer() {
        return this.getAuthorizationMode() == AuthorizationMode.V1 ? this.getAuthorizer() : this.getAuthorizerV2();
    }

    public Class<?> getAuthorizerInterface() {
        return this.getAuthorizationMode() == AuthorizationMode.V1 ? HiveAuthorizationProvider.class : HiveAuthorizer.class;
    }

    public void setActiveAuthorizer(Object authorizer) {
        if (authorizer instanceof HiveAuthorizationProvider) {
            this.authorizer = (HiveAuthorizationProvider)authorizer;
        } else if (authorizer instanceof HiveAuthorizer) {
            this.authorizerV2 = (HiveAuthorizer)authorizer;
        } else if (authorizer != null) {
            throw new IllegalArgumentException("Invalid authorizer " + authorizer);
        }
    }

    private static File createTempFile(HiveConf conf) throws IOException {
        String lScratchDir = HiveConf.getVar(conf, HiveConf.ConfVars.LOCALSCRATCHDIR);
        String sessionID = conf.getVar(HiveConf.ConfVars.HIVESESSIONID);
        return FileUtils.createTempFile(lScratchDir, sessionID, ".pipeout");
    }

    public static SessionState get() {
        return tss.get().state;
    }

    public static HiveConf getSessionConf() {
        SessionStates state = tss.get();
        if (state.conf == null) {
            state.attach(new HiveConf());
        }
        return state.conf;
    }

    public static Registry getRegistry() {
        SessionState session = SessionState.get();
        return session != null ? session.registry : null;
    }

    public static Registry getRegistryForWrite() {
        Registry registry = SessionState.getRegistry();
        if (registry == null) {
            throw new RuntimeException("Function registery for session is not initialized");
        }
        return registry;
    }

    public HiveHistory getHiveHistory() {
        return this.hiveHist;
    }

    public void updateHistory(boolean historyEnabled, SessionState ss) {
        if (historyEnabled) {
            if (ss.hiveHist.getHistFileName() == null) {
                ss.hiveHist = new HiveHistoryImpl(ss);
            }
        } else if (ss.hiveHist.getHistFileName() != null) {
            ss.hiveHist = HiveHistoryProxyHandler.getNoOpHiveHistoryProxy();
        }
    }

    private static String makeSessionId() {
        return UUID.randomUUID().toString();
    }

    public String getLastCommand() {
        return this.lastCommand;
    }

    public void setLastCommand(String lastCommand) {
        this.lastCommand = lastCommand;
    }

    public static LogHelper getConsole() {
        if (_console == null) {
            Logger LOG = LoggerFactory.getLogger((String)"SessionState");
            _console = new LogHelper(LOG);
        }
        return _console;
    }

    public static String getUserFromAuthenticator() {
        if (SessionState.get() != null && SessionState.get().getAuthenticator() != null) {
            return SessionState.get().getAuthenticator().getUserName();
        }
        return null;
    }

    public static List<String> getGroupsFromAuthenticator() {
        if (SessionState.get() != null && SessionState.get().getAuthenticator() != null) {
            return SessionState.get().getAuthenticator().getGroupNames();
        }
        return null;
    }

    static void validateFiles(List<String> newFiles) throws IllegalArgumentException {
        SessionState ss = SessionState.get();
        Configuration conf = ss == null ? new Configuration() : ss.getConf();
        for (String newFile : newFiles) {
            try {
                if (Utilities.realFile(newFile, conf) != null) continue;
                String message = newFile + " does not exist";
                throw new IllegalArgumentException(message);
            }
            catch (IOException e) {
                String message = "Unable to validate " + newFile;
                throw new IllegalArgumentException(message, e);
            }
        }
    }

    public void loadAuxJars() throws IOException {
        Object[] jarPaths = StringUtils.split(this.sessionConf.getAuxJars(), ',');
        if (ArrayUtils.isEmpty(jarPaths)) {
            return;
        }
        AddToClassPathAction addAction = new AddToClassPathAction(SessionState.get().getConf().getClassLoader(), Arrays.asList(jarPaths));
        ClassLoader currentCLoader = AccessController.doPrivileged(addAction);
        this.sessionConf.setClassLoader(currentCLoader);
        Thread.currentThread().setContextClassLoader(currentCLoader);
    }

    public void loadReloadableAuxJars() throws IOException {
        HashSet<String> reloadedAuxJars = new HashSet<String>();
        String renewableJarPath = this.sessionConf.getVar(HiveConf.ConfVars.HIVERELOADABLEJARS);
        if (renewableJarPath == null || renewableJarPath.isEmpty()) {
            return;
        }
        Set<String> jarPaths = FileUtils.getJarFilesByPath(renewableJarPath, this.sessionConf);
        if (!jarPaths.isEmpty()) {
            reloadedAuxJars.addAll(jarPaths);
        }
        if (this.preReloadableAuxJars != null && !this.preReloadableAuxJars.isEmpty()) {
            Utilities.removeFromClassPath(this.preReloadableAuxJars.toArray(new String[0]));
        }
        if (reloadedAuxJars != null && !reloadedAuxJars.isEmpty()) {
            AddToClassPathAction addAction = new AddToClassPathAction(SessionState.get().getConf().getClassLoader(), reloadedAuxJars);
            ClassLoader currentCLoader = AccessController.doPrivileged(addAction);
            this.sessionConf.setClassLoader(currentCLoader);
            Thread.currentThread().setContextClassLoader(currentCLoader);
        }
        this.preReloadableAuxJars.clear();
        this.preReloadableAuxJars.addAll(reloadedAuxJars);
    }

    static void registerJars(List<String> newJars) throws IllegalArgumentException {
        LogHelper console = SessionState.getConsole();
        try {
            AddToClassPathAction addAction = new AddToClassPathAction(Thread.currentThread().getContextClassLoader(), newJars);
            ClassLoader newLoader = AccessController.doPrivileged(addAction);
            Thread.currentThread().setContextClassLoader(newLoader);
            SessionState.get().getConf().setClassLoader(newLoader);
            console.printInfo("Added " + newJars + " to class path");
        }
        catch (Exception e) {
            String message = "Unable to register " + newJars;
            throw new IllegalArgumentException(message, e);
        }
    }

    static boolean unregisterJar(List<String> jarsToUnregister) {
        LogHelper console = SessionState.getConsole();
        try {
            Utilities.removeFromClassPath(jarsToUnregister.toArray(new String[0]));
            console.printInfo("Deleted " + jarsToUnregister + " from class path");
            return true;
        }
        catch (IOException e) {
            console.printError("Unable to unregister " + jarsToUnregister + "\nException: " + e.getMessage(), "\n" + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            return false;
        }
    }

    public String getATSDomainId() {
        return this.atsDomainId;
    }

    public void setATSDomainId(String domainId) {
        this.atsDomainId = domainId;
    }

    public static ResourceType find_resource_type(String s) {
        s = s.trim().toUpperCase();
        try {
            return ResourceType.valueOf(s);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (!s.endsWith("S")) {
                return null;
            }
            s = s.substring(0, s.length() - 1);
            try {
                return ResourceType.valueOf(s);
            }
            catch (IllegalArgumentException illegalArgumentException2) {
                return null;
            }
        }
    }

    public String add_resource(ResourceType t, String value) throws RuntimeException {
        return this.add_resource(t, value, false);
    }

    public String add_resource(ResourceType t, String value, boolean convertToUnix) throws RuntimeException {
        List<String> added = this.add_resources(t, Arrays.asList(value), convertToUnix);
        if (added == null || added.isEmpty()) {
            return null;
        }
        return added.get(0);
    }

    public List<String> add_resources(ResourceType t, Collection<String> values) throws RuntimeException {
        return this.add_resources(t, values, false);
    }

    public List<String> add_resources(ResourceType t, Collection<String> values, boolean convertToUnix) throws RuntimeException {
        Set<String> resourceSet = this.resourceMaps.getResourceSet(t);
        Map<String, Set<String>> resourcePathMap = this.resourceMaps.getResourcePathMap(t);
        Map<String, Set<String>> reverseResourcePathMap = this.resourceMaps.getReverseResourcePathMap(t);
        ArrayList<String> localized = new ArrayList<String>();
        try {
            for (String value : values) {
                List<URI> downloadedURLs = this.resolveAndDownload(t, value, convertToUnix);
                String key = ResourceDownloader.isIvyUri(value) ? ResourceDownloader.createURI(value).getAuthority() : downloadedURLs.get(0).toString();
                HashSet<String> downloadedValues = new HashSet<String>();
                for (URI uri : downloadedURLs) {
                    String resourceValue = uri.toString();
                    downloadedValues.add(resourceValue);
                    localized.add(resourceValue);
                    if (reverseResourcePathMap.containsKey(resourceValue)) {
                        if (reverseResourcePathMap.get(resourceValue).contains(key)) continue;
                        reverseResourcePathMap.get(resourceValue).add(key);
                        continue;
                    }
                    HashSet<String> addSet = new HashSet<String>();
                    addSet.add(key);
                    reverseResourcePathMap.put(resourceValue, addSet);
                }
                resourcePathMap.put(key, downloadedValues);
            }
            t.preHook(resourceSet, localized);
        }
        catch (RuntimeException e) {
            SessionState.getConsole().printError(e.getMessage(), "\n" + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            throw e;
        }
        catch (URISyntaxException e) {
            SessionState.getConsole().printError(e.getMessage());
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            SessionState.getConsole().printError(e.getMessage());
            throw new RuntimeException(e);
        }
        SessionState.getConsole().printInfo("Added resources: " + values);
        resourceSet.addAll(localized);
        return localized;
    }

    @VisibleForTesting
    protected List<URI> resolveAndDownload(ResourceType resourceType, String value, boolean convertToUnix) throws URISyntaxException, IOException {
        List<URI> uris = this.resourceDownloader.resolveAndDownload(value, convertToUnix);
        if (ResourceDownloader.isHdfsUri(value)) {
            assert (uris.size() == 1) : "There should only be one URI localized-resource.";
            this.resourceMaps.getLocalHdfsLocationMap(resourceType).put(uris.get(0).toString(), value);
        }
        return uris;
    }

    public void delete_resources(ResourceType t, List<String> values) {
        Set<String> resources = this.resourceMaps.getResourceSet(t);
        if (resources == null || resources.isEmpty()) {
            return;
        }
        Map<String, Set<String>> resourcePathMap = this.resourceMaps.getResourcePathMap(t);
        Map<String, Set<String>> reverseResourcePathMap = this.resourceMaps.getReverseResourcePathMap(t);
        LinkedList<String> deleteList = new LinkedList<String>();
        Iterator<String> iterator = values.iterator();
        while (iterator.hasNext()) {
            String value;
            String key = value = iterator.next();
            try {
                String removedKey;
                if (ResourceDownloader.isIvyUri(value)) {
                    key = ResourceDownloader.createURI(value).getAuthority();
                } else if (ResourceDownloader.isHdfsUri(value) && (removedKey = this.removeHdfsFilesFromMapping(t, value)) != null) {
                    key = removedKey;
                }
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Invalid uri string " + value + ", " + e.getMessage());
            }
            Set<String> resourcePaths = resourcePathMap.get(key);
            if (resourcePaths == null) {
                return;
            }
            for (String resourceValue : resourcePaths) {
                reverseResourcePathMap.get(resourceValue).remove(key);
                if (!reverseResourcePathMap.get(resourceValue).isEmpty()) continue;
                deleteList.add(resourceValue);
                reverseResourcePathMap.remove(resourceValue);
            }
            resourcePathMap.remove(key);
        }
        t.postHook(resources, deleteList);
        resources.removeAll(deleteList);
    }

    public Set<String> list_resource(ResourceType t, List<String> filter) {
        Set<String> orig = this.resourceMaps.getResourceSet(t);
        if (orig == null) {
            return null;
        }
        if (filter == null) {
            return orig;
        }
        HashSet<String> fnl = new HashSet<String>();
        for (String one : orig) {
            if (!filter.contains(one)) continue;
            fnl.add(one);
        }
        return fnl;
    }

    private String removeHdfsFilesFromMapping(ResourceType t, String file) {
        String key = null;
        if (this.resourceMaps.getLocalHdfsLocationMap(t).containsValue(file)) {
            for (Map.Entry<String, String> entry : this.resourceMaps.getLocalHdfsLocationMap(t).entrySet()) {
                if (!entry.getValue().equals(file)) continue;
                key = entry.getKey();
                this.resourceMaps.getLocalHdfsLocationMap(t).remove(key);
            }
        }
        return key;
    }

    public Set<String> list_local_resource(ResourceType type) {
        HashSet<String> resources = new HashSet<String>(this.list_resource(type, null));
        Set<String> set = this.resourceMaps.getResourceSet(type);
        for (String file : set) {
            if (this.resourceMaps.getLocalHdfsLocationMap(ResourceType.FILE).containsKey(file)) {
                resources.remove(file);
            }
            if (!this.resourceMaps.getLocalHdfsLocationMap(ResourceType.JAR).containsKey(file)) continue;
            resources.remove(file);
        }
        return resources;
    }

    public Set<String> list_hdfs_resource(ResourceType type) {
        Set<String> set = this.resourceMaps.getResourceSet(type);
        HashSet<String> result = new HashSet<String>();
        for (String file : set) {
            if (this.resourceMaps.getLocalHdfsLocationMap(ResourceType.FILE).containsKey(file)) {
                result.add(this.resourceMaps.getLocalHdfsLocationMap(ResourceType.FILE).get(file));
            }
            if (!this.resourceMaps.getLocalHdfsLocationMap(ResourceType.JAR).containsKey(file)) continue;
            result.add(this.resourceMaps.getLocalHdfsLocationMap(ResourceType.JAR).get(file));
        }
        return result;
    }

    public void delete_resources(ResourceType t) {
        Set<String> resources = this.resourceMaps.getResourceSet(t);
        if (resources != null && !resources.isEmpty()) {
            this.delete_resources(t, new ArrayList<String>(resources));
            this.resourceMaps.getResourceMap().remove((Object)t);
            this.resourceMaps.getAllLocalHdfsLocationMap().remove((Object)t);
        }
    }

    public HiveAuthorizationProvider getAuthorizer() {
        this.setupAuth();
        return this.authorizer;
    }

    public void setAuthorizer(HiveAuthorizationProvider authorizer) {
        this.authorizer = authorizer;
    }

    public HiveAuthorizer getAuthorizerV2() {
        this.setupAuth();
        return this.authorizerV2;
    }

    public HiveAuthenticationProvider getAuthenticator() {
        this.setupAuth();
        return this.authenticator;
    }

    public void setAuthenticator(HiveAuthenticationProvider authenticator) {
        this.authenticator = authenticator;
    }

    public CreateTableAutomaticGrant getCreateTableGrants() {
        this.setupAuth();
        return this.createTableGrants;
    }

    public void setCreateTableGrants(CreateTableAutomaticGrant createTableGrants) {
        this.createTableGrants = createTableGrants;
    }

    public Map<String, MapRedStats> getMapRedStats() {
        return this.mapRedStats;
    }

    public void setMapRedStats(Map<String, MapRedStats> mapRedStats) {
        this.mapRedStats = mapRedStats;
    }

    public void setStackTraces(Map<String, List<List<String>>> stackTraces) {
        this.stackTraces = stackTraces;
    }

    public Map<String, List<List<String>>> getStackTraces() {
        return this.stackTraces;
    }

    public Map<String, String> getOverriddenConfigurations() {
        if (this.overriddenConfigurations == null) {
            this.overriddenConfigurations = new LinkedHashMap<String, String>();
        }
        return this.overriddenConfigurations;
    }

    public void setOverriddenConfigurations(Map<String, String> overriddenConfigurations) {
        this.overriddenConfigurations = overriddenConfigurations;
    }

    public Map<String, List<String>> getLocalMapRedErrors() {
        return this.localMapRedErrors;
    }

    public void addLocalMapRedErrors(String id, List<String> localMapRedErrors) {
        if (!this.localMapRedErrors.containsKey(id)) {
            this.localMapRedErrors.put(id, new ArrayList());
        }
        this.localMapRedErrors.get(id).addAll(localMapRedErrors);
    }

    public void setLocalMapRedErrors(Map<String, List<String>> localMapRedErrors) {
        this.localMapRedErrors = localMapRedErrors;
    }

    public String getCurrentDatabase() {
        if (this.currentDatabase == null) {
            this.currentDatabase = "default";
        }
        return this.currentDatabase;
    }

    public void setCurrentDatabase(String currentDatabase) {
        this.currentDatabase = currentDatabase;
    }

    public String getCurrentCatalog() {
        if (this.currentCatalog == null) {
            this.currentCatalog = MetaStoreUtils.getDefaultCatalog(this.getConf());
        }
        return this.currentCatalog;
    }

    public void setCurrentCatalog(String currentCatalog) {
        this.currentCatalog = currentCatalog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        for (Closeable cleanupItem : this.cleanupItems) {
            try {
                cleanupItem.close();
            }
            catch (Exception err) {
                LOG.error("Error processing SessionState cleanup item " + cleanupItem.toString(), (Throwable)err);
            }
        }
        this.registry.clear();
        if (this.txnMgr != null) {
            this.txnMgr.closeTxnManager();
        }
        JavaUtils.closeClassLoadersTo(this.sessionConf.getClassLoader(), this.parentLoader);
        File resourceDir = new File(this.getConf().getVar(HiveConf.ConfVars.DOWNLOADED_RESOURCES_DIR));
        LOG.debug("Removing resource dir " + resourceDir);
        try {
            if (resourceDir.exists()) {
                FileUtils.deleteDirectory(resourceDir);
            }
        }
        catch (IOException e) {
            LOG.info("Error removing session resource dir " + resourceDir, (Throwable)e);
        }
        finally {
            SessionState.detachSession();
        }
        try {
            if (this.tezSessionState != null) {
                TezSessionPoolManager.closeIfNotDefault(this.tezSessionState, false);
            }
        }
        catch (Exception e) {
            LOG.info("Error closing tez session", (Throwable)e);
        }
        finally {
            this.setTezSession(null);
        }
        try {
            this.closeSparkSession();
            this.registry.closeCUDFLoaders();
            this.dropSessionPaths(this.sessionConf);
            this.unCacheDataNucleusClassLoaders();
        }
        finally {
            if (this.hiveDb != null) {
                this.hiveDb.close(true);
                this.hiveDb = null;
            }
        }
        this.progressMonitor = null;
        for (Object each : this.dynamicVars.values()) {
            if (!(each instanceof Closeable)) continue;
            ((Closeable)each).close();
        }
        this.dynamicVars.clear();
    }

    private void unCacheDataNucleusClassLoaders() {
        try {
            String rawStoreImpl;
            String realStoreImpl;
            Class<?> clazz;
            boolean isLocalMetastore = HiveConfUtil.isEmbeddedMetaStore(MetastoreConf.getVar(this.sessionConf, MetastoreConf.ConfVars.THRIFT_URIS));
            if (isLocalMetastore && ObjectStore.class.isAssignableFrom(clazz = Class.forName(realStoreImpl = (rawStoreImpl = MetastoreConf.getVar(this.sessionConf, MetastoreConf.ConfVars.RAW_STORE_IMPL)).equals(CachedStore.class.getName()) ? MetastoreConf.getVar(this.sessionConf, MetastoreConf.ConfVars.CACHED_RAW_STORE_IMPL) : rawStoreImpl))) {
                PersistenceManagerProvider.clearOutPmfClassLoaderCache();
            }
        }
        catch (Exception e) {
            LOG.info("Failed to remove classloaders from DataNucleus ", (Throwable)e);
        }
    }

    public void closeSparkSession() {
        if (this.sparkSession != null) {
            try {
                SparkSessionManagerImpl.getInstance().closeSession(this.sparkSession);
            }
            catch (Exception ex) {
                LOG.error("Error closing spark session.", (Throwable)ex);
            }
            finally {
                this.sparkSession = null;
            }
        }
    }

    public AuthorizationMode getAuthorizationMode() {
        this.setupAuth();
        if (this.authorizer != null) {
            return AuthorizationMode.V1;
        }
        if (this.authorizerV2 != null) {
            return AuthorizationMode.V2;
        }
        throw new AssertionError((Object)"Authorization plugins not initialized!");
    }

    public boolean isAuthorizationModeV2() {
        return this.getAuthorizationMode() == AuthorizationMode.V2;
    }

    public static PerfLogger getPerfLogger() {
        return SessionState.getPerfLogger(false);
    }

    public static PerfLogger getPerfLogger(boolean resetPerfLogger) {
        SessionState ss = SessionState.get();
        if (ss == null) {
            return PerfLogger.getPerfLogger(null, resetPerfLogger);
        }
        return PerfLogger.getPerfLogger(ss.getConf(), resetPerfLogger);
    }

    public TezSession getTezSession() {
        return this.tezSessionState;
    }

    public void setTezSession(TezSession session) {
        if (this.tezSessionState == session) {
            return;
        }
        if (this.tezSessionState != null) {
            this.tezSessionState.unsetOwnerThread();
            this.tezSessionState.setKillQuery(null);
            this.tezSessionState = null;
        }
        this.tezSessionState = session;
        if (session != null) {
            session.setOwnerThread();
            this.tezSessionState.setKillQuery(this.getKillQuery());
        }
    }

    public String getUserName() {
        return this.userName;
    }

    public void applyAuthorizationPolicy() throws HiveException {
        this.setupAuth();
    }

    public Map<String, Map<String, Table>> getTempTables() {
        return this.tempTables;
    }

    public Map<String, TempTable> getTempPartitions() {
        return this.tempPartitions;
    }

    public Map<String, Map<String, ColumnStatisticsObj>> getTempTableColStats() {
        return this.tempTableColStats;
    }

    public String getUserIpAddress() {
        return this.userIpAddress;
    }

    public void setUserIpAddress(String userIpAddress) {
        this.userIpAddress = userIpAddress;
    }

    public SparkSession getSparkSession() {
        return this.sparkSession;
    }

    public void setSparkSession(SparkSession sparkSession) {
        this.sparkSession = sparkSession;
    }

    public void addDynamicVar(Object object) {
        this.dynamicVars.put(object.getClass(), object);
    }

    public <T> T getDynamicVar(Class<T> clazz) {
        Object value = this.dynamicVars.get(clazz);
        return value == null ? null : (T)clazz.cast(value);
    }

    public String getNextValuesTempTableSuffix() {
        return Integer.toString(this.nextValueTempTableSuffix++);
    }

    public void setupQueryCurrentTimestamp() {
        String overrideTimestampString;
        this.queryCurrentTimestamp = Instant.now();
        if (this.sessionConf.getBoolVar(HiveConf.ConfVars.HIVE_IN_TEST) && (overrideTimestampString = HiveConf.getVar((Configuration)this.sessionConf, HiveConf.ConfVars.HIVETESTCURRENTTIMESTAMP, (String)null)) != null && overrideTimestampString.length() > 0) {
            TimestampTZ zonedDateTime = TimestampTZUtil.convert(Timestamp.valueOf(overrideTimestampString), this.sessionConf.getLocalTimeZone());
            this.queryCurrentTimestamp = zonedDateTime.getZonedDateTime().toInstant();
        }
    }

    public Instant getQueryCurrentTimestamp() {
        return this.queryCurrentTimestamp;
    }

    public ResourceDownloader getResourceDownloader() {
        return this.resourceDownloader;
    }

    public void setForwardedAddresses(List<String> forwardedAddresses) {
        this.forwardedAddresses = forwardedAddresses;
    }

    public List<String> getForwardedAddresses() {
        return this.forwardedAddresses;
    }

    public String getReloadableAuxJars() {
        return StringUtils.join(this.preReloadableAuxJars, ',');
    }

    public void updateProgressedPercentage(final double percentage) {
        this.progressMonitor = new ProgressMonitor(){

            @Override
            public List<String> headers() {
                return null;
            }

            @Override
            public List<List<String>> rows() {
                return null;
            }

            @Override
            public String footerSummary() {
                return null;
            }

            @Override
            public long startTime() {
                return 0L;
            }

            @Override
            public String executionStatus() {
                return null;
            }

            @Override
            public double progressedPercentage() {
                return percentage;
            }
        };
    }

    public void updateProgressMonitor(ProgressMonitor progressMonitor) {
        this.progressMonitor = progressMonitor;
    }

    public ProgressMonitor getProgressMonitor() {
        return this.progressMonitor;
    }

    public void setHiveServer2Host(String hiveServer2HostName) {
        this.hiveServer2HostName = hiveServer2HostName;
    }

    public String getHiveServer2Host() {
        return this.hiveServer2HostName;
    }

    public void setKillQuery(KillQuery killQuery) {
        this.killQuery = killQuery;
    }

    public KillQuery getKillQuery() {
        return this.killQuery;
    }

    public void addCleanupItem(Closeable item) {
        this.cleanupItems.add(item);
    }

    public Map<String, FunctionInfo> getCurrentFunctionsInUse() {
        return this.currentFunctionsInUse;
    }

    public void setWaitingTezSession() {
        this.waitingTezSession = System.currentTimeMillis();
    }

    public void resetWaitingTezSession() {
        this.waitingTezSession = 0L;
    }

    public long getWaitingTezSession() {
        return this.waitingTezSession;
    }

    public Hive getHiveDb() throws HiveException {
        if (this.hiveDb == null) {
            this.hiveDb = Hive.createHiveForSession(this.sessionConf);
            this.hiveDb.setAllowClose(false);
        }
        return this.hiveDb;
    }

    public static enum ResourceType {
        FILE,
        JAR{

            @Override
            public void preHook(Set<String> cur, List<String> s) throws IllegalArgumentException {
                super.preHook(cur, s);
                SessionState.registerJars(s);
            }

            @Override
            public void postHook(Set<String> cur, List<String> s) {
                SessionState.unregisterJar(s);
            }
        }
        ,
        ARCHIVE;


        public void preHook(Set<String> cur, List<String> s) throws IllegalArgumentException {
            SessionState.validateFiles(s);
        }

        public void postHook(Set<String> cur, List<String> s) {
        }
    }

    public static class LogHelper {
        protected Logger LOG;
        protected boolean isSilent;

        public LogHelper(Logger LOG) {
            this(LOG, false);
        }

        public LogHelper(Logger LOG, boolean isSilent) {
            this.LOG = LOG;
            this.isSilent = isSilent;
        }

        public PrintStream getOutStream() {
            SessionState ss = SessionState.get();
            return ss != null && ss.out != null ? ss.out : System.out;
        }

        public static PrintStream getInfoStream() {
            SessionState ss = SessionState.get();
            return ss != null && ss.info != null ? ss.info : LogHelper.getErrStream();
        }

        public static PrintStream getErrStream() {
            SessionState ss = SessionState.get();
            return ss != null && ss.err != null ? ss.err : System.err;
        }

        public PrintStream getChildOutStream() {
            SessionState ss = SessionState.get();
            return ss != null && ss.childOut != null ? ss.childOut : System.out;
        }

        public PrintStream getChildErrStream() {
            SessionState ss = SessionState.get();
            return ss != null && ss.childErr != null ? ss.childErr : System.err;
        }

        public boolean getIsSilent() {
            SessionState ss = SessionState.get();
            return ss != null ? ss.getIsSilent() : this.isSilent;
        }

        public boolean getIsQtestLogging() {
            SessionState ss = SessionState.get();
            return ss != null ? ss.getIsQtestLogging() : false;
        }

        public void logInfo(String info) {
            this.logInfo(info, null);
        }

        public void logInfo(String info, String detail) {
            this.LOG.info(info + StringUtils.defaultString(detail));
        }

        public void printInfo(String info) {
            this.printInfo(info, null);
        }

        public void printInfo(String info, boolean isSilent) {
            this.printInfo(info, null, isSilent);
        }

        public void printInfo(String info, String detail) {
            this.printInfo(info, detail, this.getIsSilent());
        }

        public void printInfo(String info, String detail, boolean isSilent) {
            if (!isSilent) {
                LogHelper.getInfoStream().println(info);
            }
            this.LOG.info(info + StringUtils.defaultString(detail));
        }

        public void printError(String error) {
            this.printError(error, null);
        }

        public void printError(String error, String detail) {
            if (!this.getIsSilent() || this.getIsQtestLogging()) {
                LogHelper.getErrStream().println(error);
            }
            this.LOG.error(error + StringUtils.defaultString(detail));
        }
    }

    private static class SessionStates {
        private SessionState state;
        private HiveConf conf;

        private SessionStates() {
        }

        private void attach(SessionState state) {
            this.state = state;
            this.attach(state.getConf());
        }

        private void attach(HiveConf conf) {
            this.conf = conf;
            ClassLoader classLoader = conf.getClassLoader();
            if (classLoader != null) {
                Thread.currentThread().setContextClassLoader(classLoader);
            }
        }
    }

    public static enum AuthorizationMode {
        V1,
        V2;

    }
}

