/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.txn.compactor;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.txn.CompactionInfo;
import org.apache.hadoop.hive.ql.io.AcidDirectory;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.txn.compactor.CompactionQueryBuilder;
import org.apache.hadoop.hive.ql.txn.compactor.QueryCompactor;

final class MajorQueryCompactor
extends QueryCompactor {
    MajorQueryCompactor() {
    }

    @Override
    void runCompaction(HiveConf hiveConf, Table table, Partition partition, StorageDescriptor storageDescriptor, ValidWriteIdList writeIds, CompactionInfo compactionInfo, AcidDirectory dir) throws IOException {
        AcidUtils.setAcidOperationalProperties(hiveConf, true, AcidUtils.getAcidOperationalProperties(table.getParameters()));
        HiveConf conf = new HiveConf(hiveConf);
        conf.set(HiveConf.ConfVars.HIVE_QUOTEDID_SUPPORT.varname, "column");
        conf.set(HiveConf.ConfVars.SPLIT_GROUPING_MODE.varname, "compactor");
        String tmpPrefix = table.getDbName() + "_tmp_compactor_" + table.getTableName() + "_";
        String tmpTableName = tmpPrefix + System.currentTimeMillis();
        Path tmpTablePath = QueryCompactor.Util.getCompactionResultDir(storageDescriptor, writeIds, conf, true, false, false, null);
        List<String> createQueries = this.getCreateQueries(tmpTableName, table, tmpTablePath.toString());
        List<String> compactionQueries = this.getCompactionQueries(table, partition, tmpTableName);
        List<String> dropQueries = this.getDropQueries(tmpTableName);
        this.runCompactionQueries(conf, tmpTableName, storageDescriptor, writeIds, compactionInfo, Lists.newArrayList(tmpTablePath), createQueries, compactionQueries, dropQueries);
    }

    @Override
    protected void commitCompaction(String dest, String tmpTableName, HiveConf conf, ValidWriteIdList actualWriteIds, long compactorTxnId) throws IOException, HiveException {
    }

    private List<String> getCreateQueries(String fullName, Table t, String tmpTableLocation) {
        return Lists.newArrayList(new CompactionQueryBuilder(CompactionQueryBuilder.CompactionType.MAJOR_CRUD, CompactionQueryBuilder.Operation.CREATE, fullName).setSourceTab(t).setLocation(tmpTableLocation).build());
    }

    private List<String> getCompactionQueries(Table t, Partition p, String tmpName) {
        return Lists.newArrayList(new CompactionQueryBuilder(CompactionQueryBuilder.CompactionType.MAJOR_CRUD, CompactionQueryBuilder.Operation.INSERT, tmpName).setSourceTab(t).setSourcePartition(p).build());
    }

    private List<String> getDropQueries(String tmpTableName) {
        return Lists.newArrayList(new CompactionQueryBuilder(CompactionQueryBuilder.CompactionType.MAJOR_CRUD, CompactionQueryBuilder.Operation.DROP, tmpTableName).build());
    }
}

