/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.txn.compactor;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.hive.metastore.HiveMetaStore;
import org.apache.hadoop.hive.metastore.MetaStoreThread;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.txn.CompactionInfo;
import org.apache.hadoop.hive.metastore.txn.TxnStore;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.ql.exec.repl.util.ReplUtils;
import org.apache.hadoop.hive.ql.txn.compactor.CompactorThread;
import org.apache.thrift.TException;

public class MetaStoreCompactorThread
extends CompactorThread
implements MetaStoreThread {
    protected TxnStore txnHandler;
    protected int threadId;

    @Override
    public void setThreadId(int threadId) {
        this.threadId = threadId;
    }

    @Override
    public void init(AtomicBoolean stop) throws Exception {
        super.init(stop);
        this.txnHandler = TxnUtils.getTxnStore(this.conf);
    }

    @Override
    Table resolveTable(CompactionInfo ci) throws MetaException {
        try {
            return HiveMetaStore.HMSHandler.getMSForConf(this.conf).getTable(MetaStoreUtils.getDefaultCatalog(this.conf), ci.dbname, ci.tableName);
        }
        catch (MetaException e) {
            LOG.error("Unable to find table " + ci.getFullTableName() + ", " + e.getMessage());
            throw e;
        }
    }

    @Override
    boolean replIsCompactionDisabledForDatabase(String dbName) throws TException {
        try {
            Database database = HiveMetaStore.HMSHandler.getMSForConf(this.conf).getDatabase(MetaStoreUtils.getDefaultCatalog(this.conf), dbName);
            boolean isReplCompactDisabled = ReplUtils.isFirstIncPending(database.getParameters());
            if (isReplCompactDisabled) {
                LOG.info("Compaction is disabled for database " + dbName);
            }
            return isReplCompactDisabled;
        }
        catch (NoSuchObjectException e) {
            LOG.info("Unable to find database " + dbName);
            return true;
        }
    }

    @Override
    List<Partition> getPartitionsByNames(CompactionInfo ci) throws MetaException {
        try {
            return HiveMetaStore.HMSHandler.getMSForConf(this.conf).getPartitionsByNames(MetaStoreUtils.getDefaultCatalog(this.conf), ci.dbname, ci.tableName, Collections.singletonList(ci.partName));
        }
        catch (MetaException e) {
            LOG.error("Unable to get partitions by name for CompactionInfo=" + ci);
            throw e;
        }
        catch (NoSuchObjectException e) {
            LOG.error("Unable to get partitions by name for CompactionInfo=" + ci);
            throw new MetaException(e.toString());
        }
    }
}

