/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.txn.compactor;

import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.txn.CompactionInfo;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.txn.compactor.MajorQueryCompactor;
import org.apache.hadoop.hive.ql.txn.compactor.MinorQueryCompactor;
import org.apache.hadoop.hive.ql.txn.compactor.MmMajorQueryCompactor;
import org.apache.hadoop.hive.ql.txn.compactor.MmMinorQueryCompactor;
import org.apache.hadoop.hive.ql.txn.compactor.QueryCompactor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class QueryCompactorFactory {
    private static final Logger LOG = LoggerFactory.getLogger((String)QueryCompactorFactory.class.getName());

    private QueryCompactorFactory() {
    }

    static QueryCompactor getQueryCompactor(Table table, HiveConf configuration, CompactionInfo compactionInfo) throws HiveException {
        if (!AcidUtils.isInsertOnlyTable(table.getParameters()) && HiveConf.getBoolVar(configuration, HiveConf.ConfVars.COMPACTOR_CRUD_QUERY_BASED)) {
            if (!"tez".equalsIgnoreCase(HiveConf.getVar(configuration, HiveConf.ConfVars.HIVE_EXECUTION_ENGINE))) {
                LOG.info("Query-based compaction is only supported on tez. Falling back to MR compaction.");
                return null;
            }
            if (compactionInfo.isMajorCompaction()) {
                return new MajorQueryCompactor();
            }
            return new MinorQueryCompactor();
        }
        if (AcidUtils.isInsertOnlyTable(table.getParameters())) {
            if (!configuration.getBoolVar(HiveConf.ConfVars.HIVE_COMPACTOR_COMPACT_MM)) {
                throw new HiveException("Insert only compaction is disabled. Set hive.compactor.compact.insert.only to true to enable it.");
            }
            if (compactionInfo.isMajorCompaction()) {
                return new MmMajorQueryCompactor();
            }
            return new MmMinorQueryCompactor();
        }
        return null;
    }
}

