/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf;

import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.exec.UDFMethodResolver;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedExpressions;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastDecimalToLong;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastStringToLong;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastTimestampToLong;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.CastDoubleToLong;
import org.apache.hadoop.hive.ql.udf.TimestampCastRestrictorResolver;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritableV2;
import org.apache.hadoop.hive.serde2.lazy.LazyByte;
import org.apache.hadoop.hive.serde2.lazy.LazyUtils;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;

@VectorizedExpressions(value={CastTimestampToLong.class, CastDoubleToLong.class, CastDecimalToLong.class, CastStringToLong.class})
public class UDFToByte
extends UDF {
    private final ByteWritable byteWritable = new ByteWritable();

    @Override
    public UDFMethodResolver getResolver() {
        return new TimestampCastRestrictorResolver(super.getResolver());
    }

    public ByteWritable evaluate(NullWritable i) {
        return null;
    }

    public ByteWritable evaluate(BooleanWritable i) {
        if (i == null) {
            return null;
        }
        this.byteWritable.set(i.get() ? (byte)1 : 0);
        return this.byteWritable;
    }

    public ByteWritable evaluate(ShortWritable i) {
        if (i == null) {
            return null;
        }
        this.byteWritable.set((byte)i.get());
        return this.byteWritable;
    }

    public ByteWritable evaluate(IntWritable i) {
        if (i == null) {
            return null;
        }
        this.byteWritable.set((byte)i.get());
        return this.byteWritable;
    }

    public ByteWritable evaluate(LongWritable i) {
        if (i == null) {
            return null;
        }
        this.byteWritable.set((byte)i.get());
        return this.byteWritable;
    }

    public ByteWritable evaluate(FloatWritable i) {
        if (i == null) {
            return null;
        }
        this.byteWritable.set((byte)i.get());
        return this.byteWritable;
    }

    public ByteWritable evaluate(DoubleWritable i) {
        if (i == null) {
            return null;
        }
        this.byteWritable.set((byte)i.get());
        return this.byteWritable;
    }

    public ByteWritable evaluate(Text i) {
        if (i == null) {
            return null;
        }
        if (!LazyUtils.isNumberMaybe(i.getBytes(), 0, i.getLength())) {
            return null;
        }
        try {
            this.byteWritable.set(LazyByte.parseByte(i.getBytes(), 0, i.getLength(), 10, true));
            return this.byteWritable;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public ByteWritable evaluate(TimestampWritableV2 i) {
        if (i == null) {
            return null;
        }
        long longValue = i.getSeconds();
        byte byteValue = (byte)longValue;
        if ((long)byteValue != longValue) {
            return null;
        }
        this.byteWritable.set(byteValue);
        return this.byteWritable;
    }

    public ByteWritable evaluate(HiveDecimalWritable i) {
        if (i == null || !i.isSet() || !i.isByte()) {
            return null;
        }
        this.byteWritable.set(i.byteValue());
        return this.byteWritable;
    }
}

