/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.ptf;

import org.apache.hadoop.hive.common.type.TimestampTZ;
import org.apache.hadoop.hive.ql.plan.ptf.BoundaryDef;
import org.apache.hadoop.hive.ql.plan.ptf.OrderExpressionDef;
import org.apache.hadoop.hive.ql.udf.ptf.SingleValueBoundaryScanner;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;

class TimestampLocalTZValueBoundaryScanner
extends SingleValueBoundaryScanner {
    public TimestampLocalTZValueBoundaryScanner(BoundaryDef start, BoundaryDef end, OrderExpressionDef expressionDef, boolean nullsLast) {
        super(start, end, expressionDef, nullsLast);
    }

    @Override
    public boolean isDistanceGreater(Object v1, Object v2, int amt) {
        if (v1 != null && v2 != null) {
            long l2;
            long l1 = PrimitiveObjectInspectorUtils.getTimestampLocalTZ(v1, (PrimitiveObjectInspector)this.expressionDef.getOI(), null).getEpochSecond();
            return l1 - (l2 = PrimitiveObjectInspectorUtils.getTimestampLocalTZ(v2, (PrimitiveObjectInspector)this.expressionDef.getOI(), null).getEpochSecond()) > (long)amt;
        }
        return v1 != null || v2 != null;
    }

    @Override
    public boolean isEqual(Object v1, Object v2) {
        if (v1 != null && v2 != null) {
            TimestampTZ l1 = PrimitiveObjectInspectorUtils.getTimestampLocalTZ(v1, (PrimitiveObjectInspector)this.expressionDef.getOI(), null);
            TimestampTZ l2 = PrimitiveObjectInspectorUtils.getTimestampLocalTZ(v2, (PrimitiveObjectInspector)this.expressionDef.getOI(), null);
            return l1.equals(l2);
        }
        return v1 == null && v2 == null;
    }
}

