/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.ptf;

import com.google.common.annotations.VisibleForTesting;
import java.util.Map;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.hive.ql.exec.BoundaryCache;
import org.apache.hadoop.hive.ql.exec.PTFPartition;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ptf.BoundaryDef;
import org.apache.hadoop.hive.ql.plan.ptf.OrderDef;
import org.apache.hadoop.hive.ql.plan.ptf.WindowFrameDef;
import org.apache.hadoop.hive.ql.udf.ptf.MultiValueBoundaryScanner;
import org.apache.hadoop.hive.ql.udf.ptf.SingleValueBoundaryScanner;

public abstract class ValueBoundaryScanner {
    BoundaryDef start;
    BoundaryDef end;
    protected final boolean nullsLast;
    @VisibleForTesting
    boolean enableBinarySearch = true;

    public ValueBoundaryScanner(BoundaryDef start, BoundaryDef end, boolean nullsLast) {
        this.start = start;
        this.end = end;
        this.nullsLast = nullsLast;
    }

    public abstract Object computeValue(Object var1) throws HiveException;

    public abstract boolean isDistanceGreater(Object var1, Object var2, int var3);

    public abstract boolean isEqual(Object var1, Object var2);

    public abstract int computeStart(int var1, PTFPartition var2) throws HiveException;

    public abstract int computeEnd(int var1, PTFPartition var2) throws HiveException;

    public void handleCache(int rowIdx, PTFPartition p) throws HiveException {
        BoundaryCache cache = p.getBoundaryCache();
        if (cache == null) {
            return;
        }
        if (this.start.isUnbounded() && this.end.isUnbounded()) {
            return;
        }
        if (rowIdx == 0) {
            cache.clear();
        }
        if (cache.isComplete()) {
            return;
        }
        if (cache.isEmpty()) {
            this.fillCacheUntilEndOrFull(rowIdx, p);
            return;
        }
        if (this.start.isPreceding()) {
            if (this.start.isUnbounded()) {
                if (this.end.isPreceding()) {
                    Map.Entry<Integer, Object> maxEntry = cache.getMaxEntry();
                    if (maxEntry != null && maxEntry.getKey() <= rowIdx) {
                        cache.evictOne();
                    }
                } else {
                    this.checkIfCacheCanEvict(rowIdx, p, true);
                }
            } else {
                Map.Entry<Integer, Object> maxEntry = cache.getMaxEntry();
                if (maxEntry != null && maxEntry.getKey() <= rowIdx) {
                    cache.evictOne();
                } else if (this.end.isFollowing()) {
                    int startIdx = this.computeStart(rowIdx, p);
                    this.checkIfCacheCanEvict(startIdx - 1, p, true);
                }
            }
        }
        if (this.start.isCurrentRow()) {
            this.checkIfCacheCanEvict(rowIdx, p, false);
        }
        if (this.start.isFollowing()) {
            this.checkIfCacheCanEvict(rowIdx, p, true);
        }
        this.fillCacheUntilEndOrFull(rowIdx, p);
    }

    private void checkIfCacheCanEvict(int rowIdx, PTFPartition p, boolean willScanFwd) {
        BoundaryCache cache = p.getBoundaryCache();
        if (cache == null) {
            return;
        }
        Map.Entry floorEntry = cache.floorEntry(rowIdx);
        if (floorEntry != null && (floorEntry = cache.floorEntry(floorEntry.getKey() - 1)) != null) {
            if (willScanFwd) {
                cache.evictThisAndAllBefore(floorEntry.getKey());
            } else if ((floorEntry = cache.floorEntry(floorEntry.getKey() - 1)) != null) {
                cache.evictThisAndAllBefore(floorEntry.getKey());
            }
        }
    }

    private void fillCacheUntilEndOrFull(int rowIdx, PTFPartition p) throws HiveException {
        BoundaryCache cache = p.getBoundaryCache();
        if (cache == null || p.size() <= 0) {
            return;
        }
        Object rowVal = null;
        Map.Entry<Integer, Object> ceilingEntry = cache.getMaxEntry();
        if (ceilingEntry != null) {
            rowIdx = ceilingEntry.getKey();
            rowVal = ceilingEntry.getValue();
            ++rowIdx;
        }
        Object lastRowVal = rowVal;
        while (rowIdx < p.size() && !cache.isFull().booleanValue()) {
            rowVal = this.computeValue(p.getAt(rowIdx));
            if (!this.isEqual(rowVal, lastRowVal)) {
                cache.put(rowIdx, rowVal);
            }
            lastRowVal = rowVal;
            ++rowIdx;
        }
        if (cache.putIfNotFull(rowIdx, null).booleanValue()) {
            cache.setComplete(true);
        }
    }

    protected Pair<Integer, Object> skipOrStepBack(int r, PTFPartition p) throws HiveException {
        Object rowVal = null;
        BoundaryCache cache = p.getBoundaryCache();
        Map.Entry floorEntry = null;
        Map.Entry ceilingEntry = null;
        if (cache != null) {
            floorEntry = cache.floorEntry(r);
            ceilingEntry = cache.ceilingEntry(r);
        }
        if (floorEntry != null && ceilingEntry != null) {
            r = floorEntry.getKey() - 1;
            if ((floorEntry = cache.floorEntry(r)) != null) {
                rowVal = floorEntry.getValue();
            } else if (r >= 0) {
                rowVal = this.computeValue(p.getAt(r));
            }
        } else if (--r >= 0) {
            rowVal = this.computeValue(p.getAt(r));
        }
        return new ImmutablePair<Integer, Object>(r, rowVal);
    }

    protected Pair<Integer, Object> skipOrStepForward(int r, PTFPartition p) throws HiveException {
        Object rowVal = null;
        BoundaryCache cache = p.getBoundaryCache();
        Map.Entry floorEntry = null;
        Map.Entry ceilingEntry = null;
        if (cache != null) {
            floorEntry = cache.floorEntry(r);
            ceilingEntry = cache.ceilingEntry(r);
        }
        if (ceilingEntry != null && ((Integer)ceilingEntry.getKey()).equals(r)) {
            ceilingEntry = cache.ceilingEntry(r + 1);
        }
        if (floorEntry != null && ceilingEntry != null) {
            r = (Integer)ceilingEntry.getKey();
            rowVal = ceilingEntry.getValue();
        } else if (++r < p.size()) {
            rowVal = this.computeValue(p.getAt(r));
        }
        return new ImmutablePair<Integer, Object>(r, rowVal);
    }

    protected Object computeValueUseCache(int r, PTFPartition p) throws HiveException {
        BoundaryCache cache = p.getBoundaryCache();
        Map.Entry floorEntry = null;
        Map.Entry ceilingEntry = null;
        if (cache != null) {
            floorEntry = cache.floorEntry(r);
            ceilingEntry = cache.ceilingEntry(r);
        }
        if (ceilingEntry != null && ((Integer)ceilingEntry.getKey()).equals(r)) {
            return ceilingEntry.getValue();
        }
        if (floorEntry != null && ceilingEntry != null) {
            return floorEntry.getValue();
        }
        return this.computeValue(p.getAt(r));
    }

    public static ValueBoundaryScanner getScanner(WindowFrameDef winFrameDef, boolean nullsLast) throws HiveException {
        OrderDef orderDef = winFrameDef.getOrderDef();
        int numOrders = orderDef.getExpressions().size();
        if (numOrders != 1) {
            return new MultiValueBoundaryScanner(winFrameDef.getStart(), winFrameDef.getEnd(), orderDef, nullsLast);
        }
        return SingleValueBoundaryScanner.getScanner(winFrameDef.getStart(), winFrameDef.getEnd(), orderDef, nullsLast);
    }
}

