/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.util;

import com.google.common.annotations.VisibleForTesting;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.RetryingMetaStoreClient;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.utils.FileUtils;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hive.common.util.HiveVersionInfo;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeTool {
    private static final Logger LOG = LoggerFactory.getLogger(UpgradeTool.class);
    private static final int PARTITION_BATCH_SIZE = 10000;
    private final Options cmdLineOptions = new Options();
    @VisibleForTesting
    static HiveConf hiveConf = null;

    public static void main(String[] args) throws Exception {
        CommandLine line;
        UpgradeTool tool = new UpgradeTool();
        tool.init();
        GnuParser parser = new GnuParser();
        String outputDir = ".";
        boolean execute = false;
        try {
            line = parser.parse(tool.cmdLineOptions, args);
        }
        catch (ParseException e) {
            System.err.println("UpgradeTool: Parsing failed.  Reason: " + e.getLocalizedMessage());
            UpgradeTool.printAndExit(tool);
            return;
        }
        if (line.hasOption("help")) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("upgrade-acid", tool.cmdLineOptions);
            return;
        }
        if (line.hasOption("location")) {
            outputDir = line.getOptionValue("location");
        }
        if (line.hasOption("execute")) {
            execute = true;
        }
        LOG.info("Starting with execute=" + execute + ", location=" + outputDir);
        try {
            String hiveVer = HiveVersionInfo.getShortVersion();
            LOG.info("Using Hive Version: " + HiveVersionInfo.getVersion() + " build: " + HiveVersionInfo.getBuildVersion());
            if (!hiveVer.startsWith("3.")) {
                throw new IllegalStateException("postUpgrade w/execute requires Hive 3.x.  Actual: " + hiveVer);
            }
            tool.performUpgradeInternal(outputDir, execute);
        }
        catch (Exception ex) {
            LOG.error("UpgradeTool failed", (Throwable)ex);
            throw ex;
        }
    }

    private static void printAndExit(UpgradeTool tool) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("upgrade-acid", tool.cmdLineOptions);
        System.exit(1);
    }

    private void init() {
        try {
            this.cmdLineOptions.addOption(new Option("help", "Generates a script to execute on 3.x cluster.  This requires 3.x binaries on the classpath and hive-site.xml."));
            Option exec = new Option("execute", "Executes commands equivalent to generated scrips");
            exec.setOptionalArg(true);
            this.cmdLineOptions.addOption(exec);
            this.cmdLineOptions.addOption(new Option("location", true, "Location to write scripts to. Default is CWD."));
        }
        catch (Exception ex) {
            LOG.error("init()", (Throwable)ex);
            throw ex;
        }
    }

    private static IMetaStoreClient getHMS(HiveConf conf) {
        boolean secureMode;
        UserGroupInformation loggedInUser = null;
        try {
            loggedInUser = UserGroupInformation.getLoginUser();
        }
        catch (IOException e) {
            LOG.warn("Unable to get logged in user via UGI. err: {}", (Object)e.getMessage());
        }
        boolean bl = secureMode = loggedInUser != null && loggedInUser.hasKerberosCredentials();
        if (secureMode) {
            MetastoreConf.setBoolVar(conf, MetastoreConf.ConfVars.USE_THRIFT_SASL, true);
        }
        try {
            LOG.info("Creating metastore client for {}", (Object)"PreUpgradeTool");
            return RetryingMetaStoreClient.getProxy(conf, true);
        }
        catch (MetaException e) {
            throw new RuntimeException("Error connecting to Hive Metastore URI: " + conf.getVar(HiveConf.ConfVars.METASTOREURIS) + ". " + e.getMessage(), e);
        }
    }

    private void performUpgradeInternal(String scriptLocation, boolean execute) throws HiveException, TException, IOException {
        HiveConf conf = hiveConf != null ? hiveConf : new HiveConf();
        boolean isAcidEnabled = UpgradeTool.isAcidEnabled(conf);
        IMetaStoreClient hms = UpgradeTool.getHMS(conf);
        LOG.debug("Looking for databases");
        List<String> databases = hms.getAllDatabases();
        LOG.debug("Found " + databases.size() + " databases to process");
        ArrayList<String> convertToAcid = new ArrayList<String>();
        ArrayList<String> convertToMM = new ArrayList<String>();
        Hive db = null;
        if (execute) {
            db = Hive.get(conf);
        }
        PrintWriter pw = UpgradeTool.makeRenameFileScript(scriptLocation);
        for (String dbName : databases) {
            List<String> tables = hms.getAllTables(dbName);
            LOG.debug("found " + tables.size() + " tables in " + dbName);
            for (String tableName : tables) {
                org.apache.hadoop.hive.metastore.api.Table t = hms.getTable(dbName, tableName);
                LOG.debug("processing table " + Warehouse.getQualifiedName(t));
                if (!isAcidEnabled) continue;
                UpgradeTool.processConversion(t, convertToAcid, convertToMM, hms, db, execute, pw);
            }
        }
        pw.close();
        UpgradeTool.makeConvertTableScript(convertToAcid, convertToMM, scriptLocation);
    }

    private static void alterTable(org.apache.hadoop.hive.metastore.api.Table t, Hive db, boolean isMM) throws HiveException, InvalidOperationException {
        Table metaTable = new Table(t.deepCopy());
        metaTable.getParameters().put("transactional", "true");
        if (isMM) {
            metaTable.getParameters().put("transactional_properties", "insert_only");
        }
        EnvironmentContext ec = new EnvironmentContext();
        ec.putToProperties("DO_NOT_UPDATE_STATS", "true");
        db.alterTable(Warehouse.getQualifiedName(t), metaTable, false, ec, false);
    }

    /*
     * WARNING - void declaration
     */
    static void handleRenameFiles(org.apache.hadoop.hive.metastore.api.Table t, Path p, boolean execute, Configuration conf, boolean isBucketed, PrintWriter pw) throws IOException {
        if (isBucketed) {
            HashMap<Integer, List<Path>> deltaToFileMap = new HashMap<Integer, List<Path>>();
            FileSystem fs = FileSystem.get((Configuration)conf);
            FileUtils.RemoteIteratorWithFilter iter = new FileUtils.RemoteIteratorWithFilter((RemoteIterator<LocatedFileStatus>)fs.listFiles(p, true), FileUtils.RemoteIteratorWithFilter.HIDDEN_FILES_FULL_PATH_FILTER);
            Function<Integer, List<Path>> makeList = new Function<Integer, List<Path>>(){

                @Override
                public List<Path> apply(Integer aVoid) {
                    return new ArrayList<Path>();
                }
            };
            while (iter.hasNext()) {
                LocatedFileStatus lfs = iter.next();
                if (lfs.isDirectory()) {
                    String string = Warehouse.getQualifiedName(t) + " is bucketed and has a subdirectory: " + lfs.getPath();
                    LOG.error(string);
                    throw new IllegalStateException(string);
                }
                AcidUtils.BucketMetaData bucketMetaData = AcidUtils.BucketMetaData.parse(lfs.getPath());
                if (bucketMetaData.bucketId < 0) {
                    String msg = "Bucketed table " + Warehouse.getQualifiedName(t) + " contains file " + lfs.getPath() + " with non-standard name";
                    LOG.error(msg);
                    throw new IllegalArgumentException(msg);
                }
                if (bucketMetaData.bucketId > 4095) {
                    String msg = "Bucketed table " + Warehouse.getQualifiedName(t) + " contains file " + lfs.getPath() + " with bucketId=" + bucketMetaData.bucketId + " that is out of range";
                    LOG.error(msg);
                    throw new IllegalArgumentException(msg);
                }
                if (bucketMetaData.copyNumber <= 0) continue;
                deltaToFileMap.computeIfAbsent(bucketMetaData.copyNumber, makeList).add(lfs.getPath());
            }
            if (!deltaToFileMap.isEmpty()) {
                UpgradeTool.println(pw, "#Begin file renames for bucketed table " + Warehouse.getQualifiedName(t));
            }
            for (Map.Entry entry : deltaToFileMap.entrySet()) {
                Path deltaDir = new Path(p, AcidUtils.deltaSubdir(((Integer)entry.getKey()).intValue(), ((Integer)entry.getKey()).intValue()));
                if (execute && !fs.mkdirs(deltaDir)) {
                    String msg = "Failed to create directory " + deltaDir;
                    LOG.error(msg);
                    throw new IllegalStateException(msg);
                }
                UpgradeTool.makeDirectoryCommand(deltaDir, pw);
                for (Path file : (List)entry.getValue()) {
                    Path newFile = new Path(deltaDir, UpgradeTool.stripCopySuffix(file.getName()));
                    LOG.debug("need to rename: " + file + " to " + newFile);
                    if (fs.exists(newFile)) {
                        String msg = Warehouse.getQualifiedName(t) + ": " + newFile + " already exists?!";
                        LOG.error(msg);
                        throw new IllegalStateException(msg);
                    }
                    if (execute && !fs.rename(file, newFile)) {
                        String msg = Warehouse.getQualifiedName(t) + ": " + newFile + ": failed to rename";
                        LOG.error(msg);
                        throw new IllegalStateException(msg);
                    }
                    UpgradeTool.makeRenameCommand(file, newFile, pw);
                }
            }
            if (!deltaToFileMap.isEmpty()) {
                UpgradeTool.println(pw, "#End file renames for bucketed table " + Warehouse.getQualifiedName(t));
            }
            return;
        }
        ArrayList<RenamePair> renames = new ArrayList<RenamePair>();
        FileSystem fs = FileSystem.get((Configuration)conf);
        FileUtils.RemoteIteratorWithFilter iter = new FileUtils.RemoteIteratorWithFilter((RemoteIterator<LocatedFileStatus>)fs.listFiles(p, true), FileUtils.RemoteIteratorWithFilter.HIDDEN_FILES_FULL_PATH_FILTER);
        int numBadFileNames = 0;
        int numCopyNFiles = 0;
        boolean bl = false;
        long numBytesInPartition = UpgradeTool.getDataSize(p, conf);
        int numBuckets = UpgradeTool.guessNumBuckets(numBytesInPartition);
        while (iter.hasNext()) {
            void var11_21;
            LocatedFileStatus lfs = iter.next();
            if (lfs.isDirectory()) continue;
            AcidUtils.BucketMetaData bmd = AcidUtils.BucketMetaData.parse(lfs.getPath());
            if (bmd.bucketId < 0) {
                ++numBadFileNames;
            }
            if (bmd.copyNumber > 0) {
                ++numCopyNFiles;
            }
            void wrtieId = var11_21 / numBuckets + true;
            Path deltaDir = new Path(p, AcidUtils.deltaSubdir((long)wrtieId, (long)wrtieId));
            if (execute && !fs.mkdirs(deltaDir)) {
                String msg = "Failed to create directory " + deltaDir;
                LOG.error(msg);
                throw new IllegalStateException(msg);
            }
            UpgradeTool.makeDirectoryCommand(deltaDir, pw);
            Path newPath = new Path(deltaDir, String.format("%05d", (int)(var11_21 % numBuckets)) + "_0");
            renames.add(new RenamePair(lfs.getPath(), newPath));
            ++var11_21;
        }
        if (numBadFileNames <= 0 && numCopyNFiles <= 0) {
            return;
        }
        if (!renames.isEmpty()) {
            UpgradeTool.println(pw, "#Begin file renames for unbucketed table " + Warehouse.getQualifiedName(t));
        }
        for (RenamePair renamePair : renames) {
            LOG.debug("need to rename: " + renamePair.getOldPath() + " to " + renamePair.getNewPath());
            if (fs.exists(renamePair.getNewPath())) {
                String msg = Warehouse.getQualifiedName(t) + ": " + renamePair.getNewPath() + " already exists?!";
                LOG.error(msg);
                throw new IllegalStateException(msg);
            }
            if (execute && !fs.rename(renamePair.getOldPath(), renamePair.getNewPath())) {
                String msg = Warehouse.getQualifiedName(t) + ": " + renamePair.getNewPath() + ": failed to rename";
                LOG.error(msg);
                throw new IllegalStateException(msg);
            }
            UpgradeTool.makeRenameCommand(renamePair.getOldPath(), renamePair.getNewPath(), pw);
        }
        if (!renames.isEmpty()) {
            UpgradeTool.println(pw, "#End file renames for unbucketed table " + Warehouse.getQualifiedName(t));
        }
    }

    private static void makeRenameCommand(Path file, Path newFile, PrintWriter pw) {
        UpgradeTool.println(pw, "hadoop fs -mv " + file + " " + newFile + ";");
    }

    private static void makeDirectoryCommand(Path dir, PrintWriter pw) {
        UpgradeTool.println(pw, "hadoop fs -mkdir " + dir + ";");
    }

    private static void println(PrintWriter pw, String msg) {
        if (pw != null) {
            pw.println(msg);
        }
    }

    private static long getDataSize(Path location, Configuration conf) throws IOException {
        FileSystem fs = location.getFileSystem(conf);
        ContentSummary cs = fs.getContentSummary(location);
        return cs.getLength();
    }

    public static String stripCopySuffix(String fileName) {
        if (StringUtils.countMatches(fileName, "_") > 2) {
            return fileName.substring(0, fileName.indexOf(95, 1 + fileName.indexOf(95, 0)));
        }
        return fileName;
    }

    public static int guessNumBuckets(long partitionSizeInBytes) {
        long OneGB = 1000000000L;
        if (partitionSizeInBytes <= 1000000000L) {
            return 1;
        }
        if (partitionSizeInBytes <= 100L * OneGB) {
            return 8;
        }
        if (partitionSizeInBytes <= 1000L * OneGB) {
            return 16;
        }
        if (partitionSizeInBytes <= 10000L * OneGB) {
            return 32;
        }
        if (partitionSizeInBytes <= 100000L * OneGB) {
            return 64;
        }
        if (partitionSizeInBytes <= 1000000L * OneGB) {
            return 128;
        }
        if (partitionSizeInBytes <= 10000000L * OneGB) {
            return 256;
        }
        if (partitionSizeInBytes <= 100000000L * OneGB) {
            return 512;
        }
        if (partitionSizeInBytes <= 1000000000L * OneGB) {
            return 1024;
        }
        return 2048;
    }

    private static void processConversion(org.apache.hadoop.hive.metastore.api.Table t, List<String> convertToAcid, List<String> convertToMM, IMetaStoreClient hms, Hive db, boolean execute, PrintWriter pw) throws TException, HiveException, IOException {
        if (UpgradeTool.isFullAcidTable(t)) {
            return;
        }
        if (!TableType.MANAGED_TABLE.name().equalsIgnoreCase(t.getTableType())) {
            return;
        }
        String fullTableName = Warehouse.getQualifiedName(t);
        boolean canBeMadeAcid = UpgradeTool.canBeMadeAcid(fullTableName, t.getSd());
        if (t.getPartitionKeysSize() <= 0) {
            if (canBeMadeAcid) {
                convertToAcid.add("ALTER TABLE " + Warehouse.getQualifiedName(t) + " SET TBLPROPERTIES ('transactional'='true')");
                UpgradeTool.handleRenameFiles(t, new Path(t.getSd().getLocation()), execute, db.getConf(), t.getSd().getBucketColsSize() > 0, pw);
                if (execute) {
                    UpgradeTool.alterTable(t, db, false);
                }
            } else {
                convertToMM.add("ALTER TABLE " + Warehouse.getQualifiedName(t) + " SET TBLPROPERTIES ('transactional'='true', 'transactional_properties'='insert_only')");
                if (execute) {
                    UpgradeTool.alterTable(t, db, true);
                }
            }
        } else {
            if (!canBeMadeAcid) {
                convertToMM.add("ALTER TABLE " + Warehouse.getQualifiedName(t) + " SET TBLPROPERTIES ('transactional'='true', 'transactional_properties'='insert_only')");
                if (execute) {
                    UpgradeTool.alterTable(t, db, true);
                }
                return;
            }
            List<String> partNames = hms.listPartitionNames(t.getDbName(), t.getTableName(), (short)-1);
            int batchSize = 10000;
            int numWholeBatches = partNames.size() / batchSize;
            for (int i = 0; i < numWholeBatches; ++i) {
                List<Partition> partitionList = hms.getPartitionsByNames(t.getDbName(), t.getTableName(), partNames.subList(i * batchSize, (i + 1) * batchSize));
                for (Partition part : partitionList) {
                    UpgradeTool.handleRenameFiles(t, new Path(part.getSd().getLocation()), execute, db.getConf(), t.getSd().getBucketColsSize() > 0, pw);
                }
            }
            if (numWholeBatches * batchSize < partNames.size()) {
                List<Partition> partitionList = hms.getPartitionsByNames(t.getDbName(), t.getTableName(), partNames.subList(numWholeBatches * batchSize, partNames.size()));
                for (Partition part : partitionList) {
                    UpgradeTool.handleRenameFiles(t, new Path(part.getSd().getLocation()), execute, db.getConf(), t.getSd().getBucketColsSize() > 0, pw);
                }
            }
            convertToAcid.add("ALTER TABLE " + Warehouse.getQualifiedName(t) + " SET TBLPROPERTIES ('transactional'='true')");
            if (execute) {
                UpgradeTool.alterTable(t, db, false);
            }
        }
    }

    private static boolean canBeMadeAcid(String fullTableName, StorageDescriptor sd) {
        return UpgradeTool.isAcidInputOutputFormat(fullTableName, sd) && sd.getSortColsSize() <= 0;
    }

    private static boolean isAcidInputOutputFormat(String fullTableName, StorageDescriptor sd) {
        try {
            Class<?> outputFormatClass;
            Class<?> inputFormatClass = sd.getInputFormat() == null ? null : Class.forName(sd.getInputFormat());
            Class<?> clazz = outputFormatClass = sd.getOutputFormat() == null ? null : Class.forName(sd.getOutputFormat());
            if (inputFormatClass != null && outputFormatClass != null && Class.forName("org.apache.hadoop.hive.ql.io.AcidInputFormat").isAssignableFrom(inputFormatClass) && Class.forName("org.apache.hadoop.hive.ql.io.AcidOutputFormat").isAssignableFrom(outputFormatClass)) {
                return true;
            }
        }
        catch (ClassNotFoundException e) {
            LOG.error("Could not determine if " + fullTableName + " can be made Acid due to: " + e.getMessage(), (Throwable)e);
            return false;
        }
        return false;
    }

    private static void makeConvertTableScript(List<String> alterTableAcid, List<String> alterTableMm, String scriptLocation) throws IOException {
        Throwable throwable;
        PrintWriter pw;
        String fileName;
        if (alterTableAcid.isEmpty()) {
            LOG.info("No acid conversion is necessary");
        } else {
            fileName = "convertToAcid_" + System.currentTimeMillis() + ".sql";
            LOG.debug("Writing CRUD conversion commands to " + fileName);
            pw = UpgradeTool.createScript(alterTableAcid, fileName, scriptLocation);
            throwable = null;
            try {
                pw.println("-- These commands may be executed by Hive 3.x later");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (pw != null) {
                    if (throwable != null) {
                        try {
                            pw.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        pw.close();
                    }
                }
            }
        }
        if (alterTableMm.isEmpty()) {
            LOG.info("No managed table conversion is necessary");
        } else {
            fileName = "convertToMM_" + System.currentTimeMillis() + ".sql";
            LOG.debug("Writing managed table conversion commands to " + fileName);
            pw = UpgradeTool.createScript(alterTableMm, fileName, scriptLocation);
            throwable = null;
            try {
                pw.println("-- These commands must be executed by Hive 3.0 or later");
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (pw != null) {
                    if (throwable != null) {
                        try {
                            pw.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        pw.close();
                    }
                }
            }
        }
    }

    private static PrintWriter createScript(List<String> commands, String fileName, String scriptLocation) throws IOException {
        FileWriter fw = new FileWriter(scriptLocation + "/" + fileName);
        PrintWriter pw = new PrintWriter(fw);
        for (String cmd : commands) {
            pw.println(cmd + ";");
        }
        return pw;
    }

    private static PrintWriter makeRenameFileScript(String scriptLocation) throws IOException {
        String fileName = "normalizeFileNames_" + System.currentTimeMillis() + ".sh";
        LOG.info("Writing file renaming commands to " + fileName);
        return UpgradeTool.createScript(Collections.emptyList(), fileName, scriptLocation);
    }

    private static boolean isFullAcidTable(org.apache.hadoop.hive.metastore.api.Table t) {
        if (t.getParametersSize() <= 0) {
            return false;
        }
        String transacationalValue = t.getParameters().get("transactional");
        if (transacationalValue != null && "true".equalsIgnoreCase(transacationalValue)) {
            System.out.println("Found Acid table: " + Warehouse.getQualifiedName(t));
            return true;
        }
        return false;
    }

    private static boolean isAcidEnabled(HiveConf hiveConf) {
        String txnMgr = hiveConf.getVar(HiveConf.ConfVars.HIVE_TXN_MANAGER);
        boolean concurrency = hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_SUPPORT_CONCURRENCY);
        String dbTxnMgr = "org.apache.hadoop.hive.ql.lockmgr.DbTxnManager";
        return txnMgr.equals(dbTxnMgr) && concurrency;
    }

    private static final class RenamePair {
        private Path oldPath;
        private Path newPath;

        private RenamePair(Path old, Path newPath) {
            this.oldPath = old;
            this.newPath = newPath;
        }

        private Path getOldPath() {
            return this.oldPath;
        }

        private Path getNewPath() {
            return this.newPath;
        }
    }
}

