/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.common.util;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Objects;
import org.apache.hadoop.hive.common.type.Date;

public final class DateParser {
    private static final LoadingCache<String, Date> DATE_CACHE = CacheBuilder.newBuilder().maximumSize(3650L).build(new CacheLoader<String, Date>(){

        @Override
        public Date load(String text) throws Exception {
            return Date.valueOf(text);
        }
    });

    private DateParser() {
    }

    public static Date parseDate(String text) {
        Objects.requireNonNull(text);
        Date result = new Date();
        return DateParser.parseDate(text, result) ? result : null;
    }

    public static boolean parseDate(String text, Date result) {
        Objects.requireNonNull(text);
        Objects.requireNonNull(result);
        try {
            Date date = DATE_CACHE.get(text);
            result.setTimeInMillis(date.toEpochMilli());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

