/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.common;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.junit.Assert;
import org.junit.Test;
import org.talend.bigdata.common.Component;
import org.talend.bigdata.common.ImmutableSchemaFieldDescription;

public class ComponentTest {
    @Test
    public void testConversionsAsStringByteBuffer() {
        ByteBuffer buffer = ByteBuffer.wrap("hello".getBytes());
        String result = Component.Conversions.asString((ByteBuffer)buffer);
        Assert.assertEquals((Object)"hello", (Object)result);
    }

    @Test
    public void testConversionsAsStringBytes() {
        byte[] bytes = "world".getBytes();
        String result = Component.Conversions.asString((byte[])bytes);
        Assert.assertEquals((Object)"world", (Object)result);
    }

    @Test
    public void testSchemaFieldDescriptionParseInteger() {
        ImmutableSchemaFieldDescription desc = ImmutableSchemaFieldDescription.builder().name("intField").type("java.lang.Integer").build();
        Assert.assertEquals((Object)123, (Object)desc.parse("123"));
        Assert.assertNull((Object)desc.parse(""));
    }

    @Test
    public void testSchemaFieldDescriptionParseBigDecimal() {
        ImmutableSchemaFieldDescription desc = ImmutableSchemaFieldDescription.builder().name("decimalField").type("java.math.BigDecimal").build();
        Assert.assertEquals((Object)new BigDecimal("12.34"), (Object)desc.parse("12.34"));
    }

    @Test
    public void testSchemaFieldDescriptionParseDate() {
        ImmutableSchemaFieldDescription desc = ImmutableSchemaFieldDescription.builder().name("dateField").type("java.util.Date").pattern("dd-MM-yyyy").build();
        java.util.Date date = desc.parseDate("01-01-2020");
        Assert.assertNotNull((Object)date);
    }

    @Test
    public void testStructFieldToJavaType() {
        Assert.assertEquals(String.class, (Object)Component.SchemaFieldDescription.structFieldToJavaType((StructField)DataTypes.createStructField((String)"f", (DataType)DataTypes.StringType, (boolean)true)));
        Assert.assertEquals(Integer.class, (Object)Component.SchemaFieldDescription.structFieldToJavaType((StructField)DataTypes.createStructField((String)"f", (DataType)DataTypes.IntegerType, (boolean)true)));
        Assert.assertEquals(Long.class, (Object)Component.SchemaFieldDescription.structFieldToJavaType((StructField)DataTypes.createStructField((String)"f", (DataType)DataTypes.LongType, (boolean)true)));
        Assert.assertEquals(Double.class, (Object)Component.SchemaFieldDescription.structFieldToJavaType((StructField)DataTypes.createStructField((String)"f", (DataType)DataTypes.DoubleType, (boolean)true)));
        Assert.assertEquals(Boolean.class, (Object)Component.SchemaFieldDescription.structFieldToJavaType((StructField)DataTypes.createStructField((String)"f", (DataType)DataTypes.BooleanType, (boolean)true)));
        Assert.assertEquals(Timestamp.class, (Object)Component.SchemaFieldDescription.structFieldToJavaType((StructField)DataTypes.createStructField((String)"f", (DataType)DataTypes.TimestampType, (boolean)true)));
        Assert.assertEquals(Date.class, (Object)Component.SchemaFieldDescription.structFieldToJavaType((StructField)DataTypes.createStructField((String)"f", (DataType)DataTypes.DateType, (boolean)true)));
        Assert.assertEquals(Float.class, (Object)Component.SchemaFieldDescription.structFieldToJavaType((StructField)DataTypes.createStructField((String)"f", (DataType)DataTypes.FloatType, (boolean)true)));
        Assert.assertEquals(Short.class, (Object)Component.SchemaFieldDescription.structFieldToJavaType((StructField)DataTypes.createStructField((String)"f", (DataType)DataTypes.ShortType, (boolean)true)));
        Assert.assertEquals(Byte.class, (Object)Component.SchemaFieldDescription.structFieldToJavaType((StructField)DataTypes.createStructField((String)"f", (DataType)DataTypes.ByteType, (boolean)true)));
        Assert.assertEquals(byte[].class, (Object)Component.SchemaFieldDescription.structFieldToJavaType((StructField)DataTypes.createStructField((String)"f", (DataType)DataTypes.BinaryType, (boolean)true)));
        Assert.assertEquals(BigDecimal.class, (Object)Component.SchemaFieldDescription.structFieldToJavaType((StructField)DataTypes.createStructField((String)"f", (DataType)DataTypes.createDecimalType(), (boolean)true)));
        ArrayType arrayType = new ArrayType(DataTypes.StringType, true);
        Assert.assertEquals(List.class, (Object)Component.SchemaFieldDescription.structFieldToJavaType((StructField)DataTypes.createStructField((String)"f", (DataType)arrayType, (boolean)true)));
        MapType mapType = new MapType(DataTypes.StringType, DataTypes.IntegerType, true);
        Assert.assertEquals(Map.class, (Object)Component.SchemaFieldDescription.structFieldToJavaType((StructField)DataTypes.createStructField((String)"f", (DataType)mapType, (boolean)true)));
        StructType structType = new StructType().add("nested", DataTypes.StringType);
        Assert.assertEquals(Row.class, (Object)Component.SchemaFieldDescription.structFieldToJavaType((StructField)DataTypes.createStructField((String)"f", (DataType)structType, (boolean)true)));
    }

    @Test
    public void parseObjectTest() {
        Component.SchemaFieldDescription c = new Component.SchemaFieldDescription(){

            public String name() {
                return "";
            }

            public String type() {
                return "";
            }

            public Optional<String> comment() {
                return Optional.empty();
            }
        };
        StructField intField = DataTypes.createStructField((String)"intField", (DataType)DataTypes.IntegerType, (boolean)true);
        Assert.assertEquals((Object)123, (Object)c.parseObject((Object)"123", intField));
        StructField longField = DataTypes.createStructField((String)"longField", (DataType)DataTypes.LongType, (boolean)true);
        Assert.assertEquals((Object)123L, (Object)c.parseObject((Object)"123", longField));
        StructField doubleField = DataTypes.createStructField((String)"doubleField", (DataType)DataTypes.DoubleType, (boolean)true);
        Assert.assertEquals((Object)123.45, (Object)c.parseObject((Object)"123.45", doubleField));
        StructField boolField = DataTypes.createStructField((String)"boolField", (DataType)DataTypes.BooleanType, (boolean)true);
        Assert.assertEquals((Object)true, (Object)c.parseObject((Object)"true", boolField));
        StructField stringField = DataTypes.createStructField((String)"strField", (DataType)DataTypes.StringType, (boolean)true);
        Assert.assertEquals((Object)"abc", (Object)c.parseObject((Object)"abc", stringField));
        StructField byteField = DataTypes.createStructField((String)"byteField", (DataType)DataTypes.ByteType, (boolean)true);
        Assert.assertEquals((Object)"10", (Object)c.parseObject((Object)10, byteField));
        StructField shortField = DataTypes.createStructField((String)"shortField", (DataType)DataTypes.ShortType, (boolean)true);
        Assert.assertEquals((Object)"123", (Object)c.parseObject((Object)123, shortField));
        StructField floatField = DataTypes.createStructField((String)"floatField", (DataType)DataTypes.FloatType, (boolean)true);
        Assert.assertEquals((Object)Float.valueOf(1.5f), (Object)c.parseObject((Object)"1.5", floatField));
        StructField tsField = DataTypes.createStructField((String)"tsField", (DataType)DataTypes.TimestampType, (boolean)true);
        java.util.Date utilDate1 = new java.util.Date(1710000000000L);
        String tsResult = (String)c.parseObject((Object)utilDate1, tsField);
        Assert.assertTrue((boolean)tsResult.startsWith("2024"));
        StructField dateField = DataTypes.createStructField((String)"dateField", (DataType)DataTypes.DateType, (boolean)true);
        java.util.Date utilDate2 = new java.util.Date(1710000000000L);
        String dateResult = (String)c.parseObject((Object)utilDate2, dateField);
        Assert.assertTrue((boolean)dateResult.startsWith("2024"));
        StructField decimalField = DataTypes.createStructField((String)"decimalField", (DataType)DataTypes.createDecimalType(), (boolean)true);
        Assert.assertEquals((Object)new BigDecimal("42.5"), (Object)c.parseObject((Object)"42.5", decimalField));
        Assert.assertEquals((Object)new BigDecimal("42.5"), (Object)c.parseObject((Object)42.5, decimalField));
        Assert.assertNull((Object)c.parseObject(null, stringField));
        Assert.assertSame((Object)"hello", (Object)c.parseObject((Object)"hello", stringField));
    }
}

