/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.common;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Date;
import java.util.Objects;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.Progressable;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.serializer.KryoRegistrator;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.StructField;
import org.talend.bigdata.common.Serialization;
import org.talend.bigdata.common.testutils.DSRow13AvroRecord;
import org.talend.bigdata.common.testutils.FixedFlowInput_4;
import org.talend.bigdata.common.testutils.Row13Struct;
import org.talend.bigdata.common.testutils.TestUtils;

public interface TestData {

    public static class MyCsvLineRecordOnError
    extends SpecificRecordBase
    implements Serializable {
        private String line;
        private String inputLine;
        private String errorMessage;

        public Schema getSchema() {
            return (Schema)SchemaBuilder.record((String)"MyCsvLineRecord").fields().name("line").type().stringType().stringDefault("").name("inputLine").type().stringType().stringDefault("").name("errorMessage").type().stringType().stringDefault("").endRecord();
        }

        public Object get(int field) {
            if (field == 0) {
                return this.line == null ? "" : this.line;
            }
            if (field == 1) {
                return this.inputLine == null ? "" : this.inputLine;
            }
            if (field == 2) {
                return this.errorMessage == null ? "" : this.errorMessage;
            }
            throw new RuntimeException("No fields at position " + field);
        }

        public void put(int field, Object value) {
            if (field == 0) {
                this.line = value.toString();
            } else if (field == 1) {
                this.inputLine = value.toString();
            } else if (field == 2) {
                this.errorMessage = value.toString();
            }
        }
    }

    public static class RecordWithAllTypes
    extends SpecificRecordBase
    implements Serializable {
        public Boolean t_Boolean;
        public Byte t_Byte;
        public ByteBuffer t_byteArray;
        public Date t_Date;
        public Date t_TimeStamp;
        public Double t_Double;
        public Float t_Float;
        public BigDecimal t_BigDecimal;
        public Integer t_Integer;
        public Long t_Long;
        public Short t_Short;
        public String t_String;
        public Character t_Char;
        public Integer forRej;

        public Schema getSchema() {
            return new Schema.Parser().setValidateDefaults(false).parse("{\"type\":\"record\",\"name\":\"row2Struct\",\"namespace\":\"local_project.standalone_io_delimited_0_1\",\"fields\":[{\"name\":\"t_Boolean\",\"type\":[\"boolean\",\"null\"]},{\"name\":\"t_Byte\",\"type\":[{\"type\":\"string\",\"avro.java.string\":\"String\",\"java-class\":\"java.lang.Byte\"},\"null\"]},{\"name\":\"t_byteArray\",\"type\":[\"bytes\",\"null\"]},{\"name\":\"t_Date\",\"type\":[{\"type\":\"string\",\"avro.java.string\":\"String\",\"java-class\":\"java.util.Date\"},\"null\"]},{\"name\":\"t_TimeStamp\",\"type\":[{\"type\":\"string\",\"avro.java.string\":\"String\",\"java-class\":\"java.util.Date\"},\"null\"]},{\"name\":\"t_Double\",\"type\":[\"double\",\"null\"]},{\"name\":\"t_Float\",\"type\":[\"float\",\"null\"]},{\"name\":\"t_BigDecimal\",\"type\":[{\"type\":\"string\",\"avro.java.string\":\"String\",\"java-class\":\"java.math.BigDecimal\"},\"null\"]},{\"name\":\"t_Integer\",\"type\":[\"int\",\"null\"]},{\"name\":\"t_Long\",\"type\":[\"long\",\"null\"]},{\"name\":\"t_Short\",\"type\":[{\"type\":\"string\",\"avro.java.string\":\"String\",\"java-class\":\"java.lang.Short\"},\"null\"]},{\"name\":\"t_String\",\"type\":[{\"type\":\"string\",\"avro.java.string\":\"String\",\"java-class\":\"java.lang.String\"},\"null\"]},{\"name\":\"t_Char\",\"type\":[{\"type\":\"string\",\"avro.java.string\":\"String\",\"java-class\":\"java.lang.Character\"},\"null\"]},{\"name\":\"forRej\",\"type\":[\"int\",\"null\"]}]}");
        }

        public Object get(int field$) {
            switch (field$) {
                case 0: {
                    return this.t_Boolean;
                }
                case 1: {
                    return this.t_Byte;
                }
                case 2: {
                    return this.t_byteArray;
                }
                case 3: {
                    return this.t_Date;
                }
                case 4: {
                    return this.t_TimeStamp;
                }
                case 5: {
                    return this.t_Double;
                }
                case 6: {
                    return this.t_Float;
                }
                case 7: {
                    return this.t_BigDecimal;
                }
                case 8: {
                    return this.t_Integer;
                }
                case 9: {
                    return this.t_Long;
                }
                case 10: {
                    return this.t_Short;
                }
                case 11: {
                    return this.t_String;
                }
                case 12: {
                    return this.t_Char;
                }
                case 13: {
                    return this.forRej;
                }
            }
            throw new AvroRuntimeException("Bad index");
        }

        public void put(int field$, Object value$) {
            switch (field$) {
                case 0: {
                    this.t_Boolean = (Boolean)value$;
                    break;
                }
                case 1: {
                    this.t_Byte = (Byte)value$;
                    break;
                }
                case 2: {
                    this.t_byteArray = (ByteBuffer)value$;
                    break;
                }
                case 3: {
                    this.t_Date = (Date)value$;
                    break;
                }
                case 4: {
                    this.t_TimeStamp = (Date)value$;
                    break;
                }
                case 5: {
                    this.t_Double = (Double)value$;
                    break;
                }
                case 6: {
                    this.t_Float = (Float)value$;
                    break;
                }
                case 7: {
                    this.t_BigDecimal = (BigDecimal)value$;
                    break;
                }
                case 8: {
                    this.t_Integer = (Integer)value$;
                    break;
                }
                case 9: {
                    this.t_Long = (Long)value$;
                    break;
                }
                case 10: {
                    this.t_Short = (Short)value$;
                    break;
                }
                case 11: {
                    this.t_String = (String)value$;
                    break;
                }
                case 12: {
                    this.t_Char = (Character)value$;
                    break;
                }
                case 13: {
                    this.forRej = (Integer)value$;
                    break;
                }
                default: {
                    throw new AvroRuntimeException("Bad index");
                }
            }
        }
    }

    public static class MyFileOutputFormat
    extends FileOutputFormat<NullWritable, Record1> {
        public RecordWriter<NullWritable, Record1> getRecordWriter(FileSystem ignored, final JobConf job, String name, Progressable progress) throws IOException {
            return new RecordWriter<NullWritable, Record1>(){

                public void write(NullWritable key, Record1 value) throws IOException {
                    FileSystem.get((Configuration)job);
                }

                public void close(Reporter reporter) throws IOException {
                }
            };
        }
    }

    public static class MultiFileInputFormat
    extends FileInputFormat<NullWritable, String> {
        public RecordReader<NullWritable, String> getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
            return null;
        }
    }

    public static class EmptyStringFieldsStruct
    extends SpecificRecordBase
    implements SpecificRecord {
        public static final int serialVersionUID = 1;
        public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"EmptyStringFieldsStruct\",\"namespace\":\"eeeee.yyyy_0_1\",\"fields\":[{\"name\":\"t_id\",\"type\":[\"int\",\"null\"]},{\"name\":\"t_String\",\"type\":[{\"type\":\"string\",\"avro.java.string\":\"String\",\"java-class\":\"java.lang.String\"},\"null\"]}]}");
        public Integer t_id;
        public String t_String;

        public static Schema getClassSchema() {
            return SCHEMA$;
        }

        public Schema getSchema() {
            return SCHEMA$;
        }

        public Object get(int field$) {
            switch (field$) {
                case 0: {
                    return this.t_id;
                }
                case 1: {
                    return this.t_String;
                }
            }
            throw new AvroRuntimeException("Bad index");
        }

        public void put(int field$, Object value$) {
            switch (field$) {
                case 0: {
                    this.t_id = (Integer)value$;
                    break;
                }
                case 1: {
                    this.t_String = (String)value$;
                    break;
                }
                default: {
                    throw new AvroRuntimeException("Bad index");
                }
            }
        }

        public Integer getTId() {
            return this.t_id;
        }

        public void setTId(Integer value) {
            this.t_id = value;
        }

        public String getTString() {
            return this.t_String;
        }

        public void setTString(String value) {
            this.t_String = value;
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public static Builder newBuilder(Builder other) {
            return new Builder(other);
        }

        public static Builder newBuilder(EmptyStringFieldsStruct other) {
            return new Builder(other);
        }

        public static class Builder
        extends SpecificRecordBuilderBase<EmptyStringFieldsStruct>
        implements RecordBuilder<EmptyStringFieldsStruct> {
            private Integer t_id;
            private String t_String;

            private Builder() {
                super(SCHEMA$);
            }

            private Builder(Builder other) {
                super((SpecificRecordBuilderBase)other);
                if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.t_id)) {
                    this.t_id = (Integer)this.data().deepCopy(this.fields()[0].schema(), (Object)other.t_id);
                    this.fieldSetFlags()[0] = true;
                }
                if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.t_String)) {
                    this.t_String = (String)this.data().deepCopy(this.fields()[1].schema(), (Object)other.t_String);
                    this.fieldSetFlags()[1] = true;
                }
            }

            private Builder(EmptyStringFieldsStruct other) {
                super(SCHEMA$);
                if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.t_id)) {
                    this.t_id = (Integer)this.data().deepCopy(this.fields()[0].schema(), (Object)other.t_id);
                    this.fieldSetFlags()[0] = true;
                }
                if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.t_String)) {
                    this.t_String = (String)this.data().deepCopy(this.fields()[1].schema(), (Object)other.t_String);
                    this.fieldSetFlags()[1] = true;
                }
            }

            public Integer getTId() {
                return this.t_id;
            }

            public Builder setTId(Integer value) {
                this.validate(this.fields()[0], value);
                this.t_id = value;
                this.fieldSetFlags()[0] = true;
                return this;
            }

            public boolean hasTId() {
                return this.fieldSetFlags()[0];
            }

            public Builder clearTId() {
                this.t_id = null;
                this.fieldSetFlags()[0] = false;
                return this;
            }

            public String getTString() {
                return this.t_String;
            }

            public Builder setTString(String value) {
                this.validate(this.fields()[1], value);
                this.t_String = value;
                this.fieldSetFlags()[1] = true;
                return this;
            }

            public boolean hasTString() {
                return this.fieldSetFlags()[1];
            }

            public Builder clearTString() {
                this.t_String = null;
                this.fieldSetFlags()[1] = false;
                return this;
            }

            public EmptyStringFieldsStruct build() {
                try {
                    EmptyStringFieldsStruct record = new EmptyStringFieldsStruct();
                    record.t_id = this.fieldSetFlags()[0] ? this.t_id : (Integer)this.defaultValue(this.fields()[0]);
                    record.t_String = this.fieldSetFlags()[1] ? this.t_String : (String)this.defaultValue(this.fields()[1]);
                    return record;
                }
                catch (Exception e) {
                    throw new AvroRuntimeException((Throwable)e);
                }
            }
        }
    }

    public static class MyCsvLineRecord
    extends SpecificRecordBase
    implements Serializable {
        private String line;

        public Schema getSchema() {
            return (Schema)SchemaBuilder.record((String)"MyCsvLineRecord").fields().name("line").type().stringType().stringDefault("").endRecord();
        }

        public Object get(int field) {
            return this.line;
        }

        public void put(int field, Object value) {
            this.line = value == null ? "null" : value.toString();
        }
    }

    public static class MyJoinRecord
    extends SpecificRecordBase
    implements Serializable {
        private String id1;
        private String firstname1;
        private String lastname1;
        private String id2;
        private String firstname2;
        private String lastname2;
        private String description;
        public static final Schema SCHEMA = (Schema)((SchemaBuilder.RecordBuilder)SchemaBuilder.record((String)"record").namespace("org.talend.bigdata.core")).fields().name("id1").type().stringType().stringDefault("0").name("firstname1").type().stringType().stringDefault("").name("lastname1").type().stringType().stringDefault("").name("id2").type().stringType().stringDefault("0").name("firstname2").type().stringType().stringDefault("").name("lastname2").type().stringType().stringDefault("").name("description").type().stringType().stringDefault("").endRecord();

        public Schema getSchema() {
            return SCHEMA;
        }

        public Object get(int field) {
            switch (field) {
                case 0: {
                    return this.id1;
                }
                case 1: {
                    return this.firstname1;
                }
                case 2: {
                    return this.lastname1;
                }
                case 3: {
                    return this.id2;
                }
                case 4: {
                    return this.firstname2;
                }
                case 5: {
                    return this.lastname2;
                }
                case 6: {
                    return this.description;
                }
            }
            throw new AvroRuntimeException("No field for position " + field);
        }

        public void put(int pos, Object value) {
            switch (pos) {
                case 0: {
                    this.id1 = value.toString();
                    break;
                }
                case 1: {
                    this.firstname1 = value.toString();
                    break;
                }
                case 2: {
                    this.lastname1 = value.toString();
                    break;
                }
                case 3: {
                    this.id2 = value.toString();
                    break;
                }
                case 4: {
                    this.firstname2 = value.toString();
                    break;
                }
                case 5: {
                    this.lastname2 = value.toString();
                    break;
                }
                case 6: {
                    this.description = value.toString();
                    break;
                }
                default: {
                    throw new AvroRuntimeException("No field for position " + pos);
                }
            }
        }
    }

    public static class Record2
    extends MyDefaultRecord
    implements Serializable {
        public final Schema SCHEMA = (Schema)((SchemaBuilder.RecordBuilder)SchemaBuilder.record((String)"record2").namespace("org.talend.bigdata.core")).fields().name("id").type().stringType().stringDefault("0").name("firstname").type().stringType().stringDefault("").name("lastname").type().stringType().stringDefault("").endRecord();

        public Schema getSchema() {
            return this.SCHEMA;
        }
    }

    public static class Record1
    extends MyDefaultRecord
    implements Serializable {
        private final transient Schema SCHEMA = (Schema)((SchemaBuilder.RecordBuilder)SchemaBuilder.record((String)"record1").namespace("org.talend.bigdata.core")).fields().name("id").type().stringType().stringDefault("0").name("firstname").type().stringType().stringDefault("").name("lastname").type().stringType().stringDefault("").endRecord();

        public Schema getSchema() {
            return this.SCHEMA;
        }
    }

    public static abstract class MyDefaultRecord
    extends SpecificRecordBase
    implements Serializable {
        protected String id;
        public String firstname;
        protected String lastname;

        public Object get(int field) {
            switch (field) {
                case 0: {
                    return this.id;
                }
                case 1: {
                    return this.firstname;
                }
                case 2: {
                    return this.lastname;
                }
            }
            throw new AvroRuntimeException("No field for position " + field);
        }

        public void put(int pos, Object value) {
            switch (pos) {
                case 0: {
                    this.id = value.toString();
                    break;
                }
                case 1: {
                    this.firstname = value.toString();
                    break;
                }
                case 2: {
                    this.lastname = value.toString();
                    break;
                }
                default: {
                    throw new AvroRuntimeException("No field for position " + pos);
                }
            }
        }
    }

    public static class DATASET {
        public static Dataset<Row> buildDataFrame(Class callingClass, String datafilePath, String tempFolder) {
            Dataset rowDataset = SPARK.sparkSession().sqlContext().read().option("multiline", "true").json(Objects.requireNonNull(TestUtils.getResourceFileUrlInsideTempFolder(datafilePath, tempFolder, callingClass)).toString());
            rowDataset.show();
            return rowDataset;
        }

        public static <RECORD extends SpecificRecordBase> Dataset<RECORD> buildDataSetOfRecord(Class callingClass, String dataFilePath, String tempFolder, Serialization.Supplier<RECORD> recordSupplier, Class<RECORD> recordClass) {
            return DATASET.buildDataFrame(callingClass, dataFilePath, tempFolder).map((MapFunction & Serializable)row -> {
                SpecificRecordBase record = (SpecificRecordBase)recordSupplier.get();
                for (StructField field : row.schema().fields()) {
                    record.put(field.name(), row.getAs(field.name()));
                }
                return record;
            }, Encoders.kryo(recordClass));
        }

        public static Dataset<Record1> buildDataSetOfRecord1(Class callingClass, String tempFolder) {
            SparkSession sparkSession = SPARK.sparkSession();
            Dataset rowDataset = sparkSession.sqlContext().read().option("multiline", "true").json(Objects.requireNonNull(TestUtils.getResourceFileUrlInsideTempFolder("dataset-files/record-dataset1.json", tempFolder, callingClass).toString()));
            rowDataset.show();
            Dataset dataset = rowDataset.map((MapFunction & Serializable)row -> {
                Record1 record1 = new Record1();
                Schema recordSchema = record1.getSchema();
                Arrays.stream(row.schema().fieldNames()).forEach(name -> record1.put(recordSchema.getField(name).pos(), row.get(row.fieldIndex(name))));
                return record1;
            }, Encoders.kryo(Record1.class));
            dataset.printSchema();
            dataset.show();
            return dataset;
        }

        public static Dataset<Row> readDataset(SparkSession sparkSession, String jsonFile, String tempFolder) {
            return sparkSession.sqlContext().read().option("multiline", "true").json(Objects.requireNonNull(TestUtils.getResourceFileUrlInsideTempFolder("dataset-files/" + jsonFile, tempFolder, TestData.class)).toString());
        }

        public static Dataset<Record2> buildDataSetOfRecord2(Class callingClass, String tempFolder) {
            SparkSession sparkSession = SPARK.sparkSession();
            Dataset rowDataset = sparkSession.read().option("multiline", "true").json(Objects.requireNonNull(TestUtils.getResourceFileUrlInsideTempFolder("dataset-files/record-dataset2.json", tempFolder, callingClass)).toString());
            rowDataset.show();
            Dataset dataset = rowDataset.map((MapFunction & Serializable)row -> {
                Record2 myDefaultRecord = new Record2();
                Schema recordSchema = myDefaultRecord.getSchema();
                Arrays.stream(row.schema().fieldNames()).forEach(name -> myDefaultRecord.put(recordSchema.getField(name).pos(), row.get(row.fieldIndex(name))));
                return myDefaultRecord;
            }, Encoders.kryo(Record2.class));
            dataset.toJSON().show();
            return dataset;
        }

        public static Dataset<Row> readJsonFile(String fileName, String tempFolder) {
            return SPARK.sparkSession().read().option("multiline", "true").json(Objects.requireNonNull(TestUtils.getResourceFileUrlInsideTempFolder("dataset-files/" + fileName, tempFolder, TestData.class).toString()));
        }
    }

    public static class InetAddressSerializer
    extends Serializer<InetAddress> {
        public void write(Kryo kryo, Output output, InetAddress value) {
            output.writeInt(value.getAddress().length);
            output.writeBytes(value.getAddress());
        }

        public InetAddress read(Kryo kryo, Input input, Class<InetAddress> paramClass) {
            InetAddress inetAddress = null;
            try {
                int length = input.readInt();
                byte[] address = input.readBytes(length);
                inetAddress = InetAddress.getByAddress(address);
            }
            catch (UnknownHostException length) {
            }
            catch (KryoException e) {
                throw new RuntimeException(e);
            }
            return inetAddress;
        }
    }

    public static class TalendKryoRegistrator
    implements KryoRegistrator {
        public void registerClasses(Kryo kryo) {
            try {
                kryo.register(Class.forName("org.talend.bigdata.dataflow.keys.JoinKeyRecord"));
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            kryo.register(InetAddress.class, (Serializer)new InetAddressSerializer());
            kryo.addDefaultSerializer(InetAddress.class, (Serializer)new InetAddressSerializer());
            kryo.register(DSRow13AvroRecord.class);
            kryo.register(Row13Struct.class);
            kryo.register(FixedFlowInput_4.class);
        }
    }

    public static class SPARK {
        public static SparkSession sparkSession() {
            return SparkSession.builder().appName("default-test-app").master("local[*]").getOrCreate();
        }

        public static SparkSession sparkSession(SparkConf conf) {
            return SparkSession.builder().config(conf).appName("default-test-app").master("local[*]").getOrCreate();
        }

        public static SparkSession sparkSessionWithHive(SparkConf conf) {
            return SparkSession.builder().config(conf).appName("default-test-app").master("local[*]").enableHiveSupport().getOrCreate();
        }

        public static JobConf job() {
            return new JobConf();
        }

        public static SparkSession sparkSessionWithUTCConf(boolean isLocalTimezone) {
            SparkConf sparkConfiguration = new SparkConf(true);
            sparkConfiguration.set("spark.serializer", "org.apache.spark.serializer.KryoSerializer");
            sparkConfiguration.set("spark.kryo.registrator", TalendKryoRegistrator.class.getName());
            sparkConfiguration.set("spark.sql.session.timeZone", "UTC");
            if (isLocalTimezone) {
                sparkConfiguration.set("spark.hadoop.talendStudioTimeZone", "Europe/Paris");
            }
            sparkConfiguration.setAppName("default-test-app");
            sparkConfiguration.setMaster("local[*]");
            return SparkSession.builder().sparkContext(new JavaSparkContext(sparkConfiguration).sc()).getOrCreate();
        }
    }
}

