/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.common.input;

import java.util.Arrays;
import org.apache.avro.Schema;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.talend.bigdata.common.input.AvroRecordInstanceCreationException;
import org.talend.bigdata.common.input.FromRowToAvroRecord;

public class FromRowToAvroRecordTest {
    private FromRowToAvroRecord<MockAvroRecord> fromRowToAvroRecord;
    private Row mockRow;

    @Before
    public void setUp() {
        this.fromRowToAvroRecord = new FromRowToAvroRecord(MockAvroRecord.class, true);
        this.mockRow = (Row)Mockito.mock(Row.class);
    }

    @Test
    public void testCallWithValidRow() {
        StructField[] fields = new StructField[]{new StructField("id", DataTypes.LongType, false, null), new StructField("name", DataTypes.StringType, true, null)};
        StructType schema = new StructType(fields);
        Mockito.when((Object)this.mockRow.schema()).thenReturn((Object)schema);
        Mockito.when((Object)this.mockRow.get(0)).thenReturn((Object)100L);
        Mockito.when((Object)this.mockRow.get(1)).thenReturn((Object)"John Doe");
        Mockito.when((Object)this.mockRow.isNullAt(0)).thenReturn((Object)false);
        Mockito.when((Object)this.mockRow.isNullAt(1)).thenReturn((Object)false);
        MockAvroRecord avroRecord = (MockAvroRecord)this.fromRowToAvroRecord.call(this.mockRow);
        Assert.assertNotNull((Object)((Object)avroRecord));
        Assert.assertEquals((Object)100L, (Object)avroRecord.get(0));
        Assert.assertEquals((Object)"John Doe", (Object)avroRecord.get(1));
    }

    @Test
    public void testCallWithException() {
        FromRowToAvroRecord invalidMapper = new FromRowToAvroRecord(InvalidAvroRecord.class, true);
        Exception exception = (Exception)Assert.assertThrows(AvroRecordInstanceCreationException.class, () -> invalidMapper.call(this.mockRow));
        Assert.assertTrue((boolean)exception.getMessage().contains("Constructor threw an exception"));
    }

    public static class MockAvroRecord
    extends SpecificRecordBase {
        private static final Schema SCHEMA = Schema.createRecord((String)"MockAvroRecord", (String)"", (String)"org.test", (boolean)false);
        private final Object[] values = new Object[2];

        public Schema getSchema() {
            return SCHEMA;
        }

        public Object get(int i) {
            return this.values[i];
        }

        public void put(int i, Object v) {
            this.values[i] = v;
        }

        static {
            SCHEMA.setFields(Arrays.asList(new Schema.Field("id", Schema.create((Schema.Type)Schema.Type.LONG), null, null), new Schema.Field("name", Schema.create((Schema.Type)Schema.Type.STRING), null, null)));
        }
    }

    public static class InvalidAvroRecord
    extends SpecificRecordBase {
        private InvalidAvroRecord(String param) {
        }

        public Schema getSchema() {
            return null;
        }

        public Object get(int i) {
            return null;
        }

        public void put(int i, Object v) {
        }
    }
}

